/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicModLikeCheck;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.VmColumn;
import com.intellij.database.model.basic.VmView;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.DbmsObjectEditorFactoryKt;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbForeignKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbIndexColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbPropertyModelApplierBase;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbCompoundModelState;
import com.intellij.database.schemaEditor.model.state.DbEmbeddedObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbGenNameModelState;
import com.intellij.database.schemaEditor.model.state.DbIndirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectGrantsModelState;
import com.intellij.database.schemaEditor.model.state.DbSeqIdPropModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.model.state.DbUserGrantsModelState;
import com.intellij.database.schemaEditor.ui.DbAdvancedTextEditor;
import com.intellij.database.schemaEditor.ui.DbBoolEditor;
import com.intellij.database.schemaEditor.ui.DbCollectionEditor;
import com.intellij.database.schemaEditor.ui.DbDataTypeEditor;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEmbeddedObjectEditor;
import com.intellij.database.schemaEditor.ui.DbEnumEditor;
import com.intellij.database.schemaEditor.ui.DbForeignKeyColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbGenNameEditor;
import com.intellij.database.schemaEditor.ui.DbIndexColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbKeyColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.ui.DbReferenceEditor;
import com.intellij.database.schemaEditor.ui.DbSqlBigEditor;
import com.intellij.database.schemaEditor.ui.DbSqlExpressionEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbTextEditor;
import com.intellij.database.schemaEditor.ui.DbTextEditorBase;
import com.intellij.database.schemaEditor.ui.DbToggleableFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbUserGrantsEditor;
import com.intellij.database.types.DasType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\t\"\b\b\u0000\u0010\n*\u00020\f\"\b\b\u0001\u0010\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\u0011H\u0016J*\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0014J.\u0010\u0014\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00160\u0011H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00160\u0011H\u0004J\"\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00160\u0011H\u0016J0\u0010\u001a\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0013\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u0011H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/schemaEditor/DbmsObjectEditorFactory;", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createObjectEditor", "Lcom/intellij/database/schemaEditor/ui/DbEditor;", "E", "S", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "modelRef", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "createObjectEditorImpl", "model", "createTextEditor", "Lcom/intellij/database/schemaEditor/ui/DbTextEditorBase;", "Lcom/intellij/database/schemaEditor/model/state/DbTextModelState;", "isSqlExpression", "", "isBigSqlEditor", "createCollectionEditor", "Lcom/intellij/database/schemaEditor/ui/DbCollectionEditor;", "Lcom/intellij/database/schemaEditor/model/state/DbCollectionModelState;", "DbToggleableSeqIdEditor", "intellij.database.impl"})
public class DbmsObjectEditorFactory
implements DbObjectEditorFactory {
    @NotNull
    private final Dbms dbms;

    public DbmsObjectEditorFactory(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @Override
    @Nullable
    public <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(modelRef, (String)"modelRef");
        return this.createObjectEditorImpl(controller, modelRef);
    }

    @Nullable
    protected DbEditor<?, ?> createObjectEditorImpl(@NotNull DbEditorController controller, @NotNull DbModelRef<?, ?> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Object obj = model.getState();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getState(...)");
        Object s = obj;
        if (s instanceof DbStructureModelState) {
            return new DbStructureEditor(controller, (DbModelRef<?, DbStructureModelState>)model.castState(s));
        }
        if (s instanceof DbStructureNodeState) {
            return new DbStructureNodeEditor(controller, model.castState(s));
        }
        if (s instanceof DbEmbeddedObjectModelState) {
            return new DbEmbeddedObjectEditor(controller, model.castState(s));
        }
        if (s instanceof DbSeqIdPropModelState) {
            DbPropertyModelApplierBase pa;
            DbModelApplier<?, ?> dbModelApplier = model.getApplier();
            DbPropertyModelApplierBase dbPropertyModelApplierBase = pa = dbModelApplier instanceof DbPropertyModelApplierBase ? (DbPropertyModelApplierBase)dbModelApplier : null;
            if (pa != null && pa.getDefault() == null) {
                DbModelRef<?, ?> dbModelRef = model.castState(s);
                Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
                return new DbToggleableSeqIdEditor(controller, (DbModelRef<?, DbSeqIdPropModelState>)dbModelRef);
            }
            return new DbFormCompoundEditor(controller, model.castState(s), arg_0 -> DbmsObjectEditorFactory.createObjectEditorImpl$lambda$0(controller, arg_0));
        }
        if (s instanceof DbCompoundModelState) {
            return new DbFormCompoundEditor(controller, model.castState(s), arg_0 -> DbmsObjectEditorFactory.createObjectEditorImpl$lambda$1(controller, arg_0));
        }
        if (s instanceof DbObjectGrantsModelState) {
            DbModelRef<?, ?> dbModelRef = model.castState(s);
            Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
            return DbObjectGrantsEditor.Companion.create(controller, dbModelRef);
        }
        if (s instanceof DbUserGrantsModelState) {
            ElementIdentity elementIdentity = ElementIdentity.tryCast(model.getIdentity(), BasicGrantee.class);
            Intrinsics.checkNotNull((Object)elementIdentity);
            DbModelRef dbModelRef = model.castIdentity(elementIdentity).castState(s);
            Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
            return new DbUserGrantsEditor(controller, dbModelRef);
        }
        if (s instanceof DbCollectionModelState) {
            DbCollectionEditor<?, ?> editor2;
            DbModelRef<?, ?> dbModelRef = model.castState(s);
            Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
            DbCollectionEditor<?, ?> dbCollectionEditor = editor2 = this.createCollectionEditor(controller, dbModelRef);
            if (dbCollectionEditor != null) {
                return dbCollectionEditor;
            }
        } else {
            if (s instanceof DbIndirectReferenceModelState) {
                return DbReferenceEditor.create(controller, model.castState((DbModelState)((DbIndirectReferenceModelState)s)));
            }
            if (s instanceof DbGenNameModelState) {
                return new DbGenNameEditor(controller, model.castState(s));
            }
            if (s instanceof DbTextModelState) {
                DbModelRef<?, ?> dbModelRef = model.castState(s);
                Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
                return this.createTextEditor(controller, dbModelRef);
            }
        }
        DbmsObjectEditorFactory $this$createObjectEditorImpl_u24lambda_u242 = this;
        boolean bl = false;
        DbSingleValueModelState s2 = DbmsObjectEditorFactoryKt.access$tryCastTo(model, Boolean.class);
        if (s2 != null) {
            return new DbBoolEditor(controller, model.castState((DbModelState)s2));
        }
        DbmsObjectEditorFactory $this$createObjectEditorImpl_u24lambda_u243 = this;
        boolean bl2 = false;
        s2 = DbmsObjectEditorFactoryKt.access$tryCastTo(model, Enum.class);
        if (s2 != null) {
            return new DbEnumEditor(controller, model.castState((DbModelState)s2));
        }
        Object obj2 = model.getState();
        Intrinsics.checkNotNullExpressionValue(obj2, (String)"getState(...)");
        throw new AssertionError((Object)("Unsupported model: " + obj2.getClass().getSimpleName()));
    }

    private final DbTextEditorBase<?, ? extends DbTextModelState> createTextEditor(DbEditorController controller, DbModelRef<?, DbTextModelState> model) {
        BasicMetaType<?> type = model.getApplier().getValueType();
        if (type != null && (type.isKindOf(DataType.class) || type.isKindOf(DasType.class))) {
            return new DbDataTypeEditor(controller, model);
        }
        if (controller.getBuilder().isBigSqlEditor(controller, model)) {
            return new DbSqlBigEditor(controller, model);
        }
        if (this.isSqlExpression(model)) {
            return new DbSqlExpressionEditor(controller, model);
        }
        if (model.getModelInternalKey() == BasicModNamedElement.NAME || model.getState().isMultiline()) {
            return new DbAdvancedTextEditor(controller, model);
        }
        return new DbTextEditor(controller, model);
    }

    protected final boolean isSqlExpression(@NotNull DbModelRef<?, DbTextModelState> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        BasicMetaId basicMetaId = model.getModelInternalKey();
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaId, (String)"getModelInternalKey(...)");
        BasicMetaId key = basicMetaId;
        return key == BasicModTypedElement.DEFAULT_EXPRESSION || key == BasicModLikeCheck.PREDICATE || key == BasicModTrigger.CONDITION || key == VmColumn.EXPRESSION || key == VmView.QUERY;
    }

    @Override
    public boolean isBigSqlEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<?, DbTextModelState> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        BasicMetaId basicMetaId = model.getModelInternalKey();
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaId, (String)"getModelInternalKey(...)");
        BasicMetaId key = basicMetaId;
        return key == VmView.QUERY || key == BasicModSourceAware.SOURCE_TEXT;
    }

    @Nullable
    protected DbCollectionEditor<?, ?> createCollectionEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<?, DbCollectionModelState<?>> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        DbmsObjectEditorFactory $this$createCollectionEditor_u24lambda_u240 = this;
        boolean bl = false;
        DbModelRef<?, DbModelState> typedModel = model.castState((DbModelState)model.getState().tryCastItem(DbIndexColumnsModelApplier.IndexColumn.class));
        if (typedModel != null) {
            return new DbIndexColumnsEditor(controller, typedModel);
        }
        DbmsObjectEditorFactory $this$createCollectionEditor_u24lambda_u241 = this;
        boolean bl2 = false;
        typedModel = model.castState((DbModelState)model.getState().tryCastItem(DbForeignKeyColumnsModelApplier.FkColumn.class));
        if (typedModel != null) {
            return new DbForeignKeyColumnsEditor(controller, typedModel);
        }
        DbmsObjectEditorFactory $this$createCollectionEditor_u24lambda_u242 = this;
        boolean bl3 = false;
        typedModel = model.castState((DbModelState)model.getState().tryCastItem(DbKeyColumnsModelApplier.KeyColumn.class));
        if (typedModel != null) {
            return new DbKeyColumnsEditor(controller, typedModel);
        }
        return null;
    }

    private static final boolean createObjectEditorImpl$lambda$0(DbEditorController $controller, DbModelRef it) {
        return $controller.shouldHaveEditor(it);
    }

    private static final boolean createObjectEditorImpl$lambda$1(DbEditorController $controller, DbModelRef it) {
        return $controller.shouldHaveEditor(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/schemaEditor/DbmsObjectEditorFactory$DbToggleableSeqIdEditor;", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/ui/DbToggleableFormCompoundEditor;", "Lcom/intellij/database/schemaEditor/model/state/DbSeqIdPropModelState;", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "model", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "<init>", "(Lcom/intellij/database/schemaEditor/ui/DbEditorController;Lcom/intellij/database/schemaEditor/model/DbModelRef;)V", "setToggleState", "", "selected", "", "getToggleState", "intellij.database.impl"})
    private static final class DbToggleableSeqIdEditor<E extends BasicElement>
    extends DbToggleableFormCompoundEditor<E, DbSeqIdPropModelState> {
        public DbToggleableSeqIdEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbSeqIdPropModelState> model) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter(model, (String)"model");
            super(controller, model, arg_0 -> DbToggleableSeqIdEditor._init_$lambda$0(controller, arg_0));
        }

        @Override
        protected void setToggleState(boolean selected) {
            ((DbSeqIdPropModelState)this.getState()).setPresent(selected);
        }

        @Override
        protected boolean getToggleState() {
            return ((DbSeqIdPropModelState)this.getState()).isPresent();
        }

        private static final boolean _init_$lambda$0(DbEditorController $controller, DbModelRef it) {
            return $controller.shouldHaveEditor(it);
        }
    }
}

