/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.spring.data.jpa.SpringDateEntityUtilsKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaEntityTypeMacro
extends Macro {
    @NonNls
    public String getName() {
        return "jpaEntityTypes";
    }

    public String getPresentableName() {
        return "jpaEntityTypes()";
    }

    @Nullable
    private static Collection<PsiClass> findEntities(ExpressionContext context) {
        PsiElement offset = context.getPsiElementAtStartOffset();
        if (offset == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)offset);
        if (module == null) {
            return null;
        }
        return EntitySearch.getInstance((Project)context.getProject()).getEntities(offset.getResolveScope());
    }

    public Result calculateResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        Collection<PsiClass> psiMembers;
        if (expressions == null) {
            JpaEntityTypeMacro.$$$reportNull$$$0(0);
        }
        if ((psiMembers = JpaEntityTypeMacro.findEntities(expressionContext)) != null) {
            PsiClass member;
            PsiClass predefinedClass = JpaEntityTypeMacro.getPredefinedClass(expressionContext, psiMembers);
            PsiClass psiClass = member = predefinedClass != null ? predefinedClass : (PsiClass)psiMembers.stream().findFirst().orElse(null);
            if (member != null && member.getQualifiedName() != null) {
                return new TextResult(member.getQualifiedName());
            }
        }
        return null;
    }

    public Result calculateQuickResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        if (expressions == null) {
            JpaEntityTypeMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(expressions, expressionContext);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            JpaEntityTypeMacro.$$$reportNull$$$0(2);
        }
        Collection<PsiClass> entities = JpaEntityTypeMacro.findEntities(context);
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        PsiClass predefinedClass = JpaEntityTypeMacro.getPredefinedClass(context, entities);
        if (predefinedClass != null) {
            set.add(JpaEntityTypeMacro.createLookupElement((PsiMember)predefinedClass));
        }
        if (entities != null) {
            for (PsiMember psiMember : entities) {
                LookupElementBuilder lookupElement;
                if (psiMember == predefinedClass || (lookupElement = JpaEntityTypeMacro.createLookupElement(psiMember)) == null) continue;
                set.add(lookupElement);
            }
            return set.toArray(LookupElement.EMPTY_ARRAY);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    @Nullable
    private static LookupElementBuilder createLookupElement(PsiMember object) {
        if (!(object instanceof PsiClass)) {
            return null;
        }
        String name = object.getName();
        String qualifiedName = ((PsiClass)object).getQualifiedName();
        if (name == null || qualifiedName == null) {
            return null;
        }
        String packageName = StringUtil.substringBefore((String)qualifiedName, (String)("." + name));
        return LookupElementBuilder.create((String)qualifiedName).withPresentableText(name).withLookupString(qualifiedName).withIcon(AllIcons.Javaee.PersistenceEntity).withTypeText(packageName);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    @Nullable
    private static PsiClass getPredefinedClass(ExpressionContext expressionContext, Collection<PsiClass> psiMembers) {
        PsiClass member;
        String predefinedClassNameText;
        String matchedEntity;
        TextResult predefinedClassName = expressionContext.getVariableValue("CLASS_NAME");
        if (predefinedClassName != null && (matchedEntity = SpringDateEntityUtilsKt.findMatchedEntity(predefinedClassNameText = predefinedClassName.getText(), ContainerUtil.map(psiMembers, e -> e.getName()))) != null && (member = (PsiClass)ContainerUtil.find(psiMembers, m -> m.getName() != null && matchedEntity.equals(m.getName()))) != null) {
            return member;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/jpa/template/macro/JpaEntityTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

