/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.en;

import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

public class EnglishHybridDisambiguator
extends AbstractDisambiguator {
    private final MultiWordChunker chunker = MultiWordChunker.getInstance((String)"/en/multiwords.txt", (boolean)true, (boolean)true, (boolean)false);
    private final MultiWordChunker chunkerGlobal = MultiWordChunker.getInstance((String)"/spelling_global.txt", (boolean)true, (boolean)true, (boolean)false, (String)MultiWordChunker.tagForNotAddingTags);
    private final Disambiguator disambiguator;

    public EnglishHybridDisambiguator(Language lang) {
        this.disambiguator = new XmlRuleDisambiguator(lang, true);
        this.chunker.setIgnoreSpelling(true);
        this.chunker.setRemovePreviousTags(true);
        this.chunkerGlobal.setIgnoreSpelling(true);
    }

    public AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        return this.disambiguate(input, null);
    }

    public AnalyzedSentence disambiguate(AnalyzedSentence input, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        return this.disambiguator.disambiguate(this.chunker.disambiguate(this.chunkerGlobal.disambiguate(input, checkCanceled), checkCanceled), checkCanceled);
    }
}

