/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.JamChief;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiElement> myTarget;

    public RemoveQuickFix(SmartPsiElementPointer<PsiElement> target) {
        this.myTarget = target;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement myTargetElement;
        if (target == null) {
            RemoveQuickFix.$$$reportNull$$$0(0);
        }
        if ((myTargetElement = this.myTarget.getElement()) == null) {
            return null;
        }
        PsiElement sameElementInCopy = PsiTreeUtil.findSameElementInCopy((PsiElement)myTargetElement, (PsiFile)target);
        SmartPsiElementPointer nonPhysicalTarget = SmartPointerManager.getInstance((Project)this.myTarget.getProject()).createSmartPsiElementPointer(sameElementInCopy);
        return new RemoveQuickFix((SmartPsiElementPointer<PsiElement>)nonPhysicalTarget);
    }

    @NotNull
    public String getName() {
        String string = JpaHighlightingMessages.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription((Object)this.myTarget.getElement(), (Function)FunctionUtil.id()));
        if (string == null) {
            RemoveQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaHighlightingMessages.message("intention.family.remove.attribute", new Object[0]);
        if (string == null) {
            RemoveQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement myTargetElement;
        if (project == null) {
            RemoveQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RemoveQuickFix.$$$reportNull$$$0(4);
        }
        if ((myTargetElement = this.myTarget.getElement()) == null) {
            return;
        }
        Object target = myTargetElement instanceof AnnotationGenericValue ? ((AnnotationGenericValue)myTargetElement).getIdentifyingAnnotation() : (myTargetElement instanceof DomElement ? ((DomElement)myTargetElement).getXmlElement() : (myTargetElement instanceof JamChief ? ((JamChief)myTargetElement).getPsiElement() : myTargetElement));
        if (target == null || !target.isValid()) {
            return;
        }
        if (descriptor.getStartElement().getContainingFile() != target.getContainingFile()) {
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{target.getContainingFile()}).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> RemoveQuickFix.lambda$applyFix$0((PsiElement)target));
        } else {
            try {
                target.delete();
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(RemoveQuickFix.class).error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void lambda$applyFix$0(PsiElement target) throws RuntimeException {
        target.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/RemoveQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/RemoveQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

