/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.liquibase.common.ddl.DbMappingSettingsKt;
import com.intellij.liquibase.common.ddl.LiquibaseTypes;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0019H\u0016J1\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010&\u001a\u0004\u0018\u00010\u00192\b\u0010'\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR&\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00120\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006*"}, d2={"Lcom/intellij/liquibase/common/ddl/Db2MappingSettings;", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "liquibaseTypes", "Lcom/intellij/liquibase/common/ddl/LiquibaseTypes;", "mappingTypes", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "", "getMappingTypes", "()Ljava/util/Map;", "jdbcTypeCodeMappings", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getJdbcTypeCodeMappings", "sqlSynonymTypes", "", "getSqlSynonymTypes", "defaultValues", "getDefaultValues", "precisionChanged", "", "attributeColumnSize", "", "dbColumnSizeInt", "attributeSqlType", "dbSqlType", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "typeChanged", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attrMappedSqlType", "dbType", "oldLength", "lengthChanged", "attrSqlType", "attrColumnSize", "dbColumnSize", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Z", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nDbMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/Db2MappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1515:1\n1869#2,2:1516\n1869#2,2:1518\n1869#2,2:1520\n*S KotlinDebug\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/Db2MappingSettings\n*L\n245#1:1516,2\n246#1:1518,2\n252#1:1520,2\n*E\n"})
public final class Db2MappingSettings
implements DbMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiquibaseTypes liquibaseTypes;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> mappingTypes;
    @NotNull
    private final Map<HibernateSqlType, String> jdbcTypeCodeMappings;
    @NotNull
    private final Map<String, Collection<String>> sqlSynonymTypes;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> defaultValues;
    private static final int PRIMARY_KEY_UUID_LENGTH = 36;
    private static final int CLOB_SIZE = 0x100000;

    /*
     * WARNING - void declaration
     */
    public Db2MappingSettings(@NotNull Project project) {
        Datatypes.BasicDatatype it;
        void $this$defaultValues_u24lambda_u240;
        void it2;
        Object $this$sqlSynonymTypes_u24lambda_u240;
        void $this$mappingTypes_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.liquibaseTypes = new LiquibaseTypes(project);
        Map map = new LinkedHashMap();
        Db2MappingSettings db2MappingSettings = this;
        boolean $i$a$-run-Db2MappingSettings$mappingTypes$22 = false;
        $this$mappingTypes_u24lambda_u240.putAll(this.liquibaseTypes.DATABASE_INDEPENDENT_TYPES);
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Byte;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Byte");
        $this$mappingTypes_u24lambda_u240.put(basicDatatype, "SMALLINT");
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$mappingTypes_u24lambda_u240);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        db2MappingSettings.mappingTypes = (Map)immutableMap;
        Object object = new Pair[]{TuplesKt.to((Object)HibernateSqlType.BIT, (Object)"BOOLEAN"), TuplesKt.to((Object)HibernateSqlType.JSON, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONG32NVARCHAR, (Object)"NCLOB"), TuplesKt.to((Object)HibernateSqlType.LONGVARCHAR, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONGNVARCHAR, (Object)"NCLOB"), TuplesKt.to((Object)HibernateSqlType.NCHAR, (Object)"CHAR"), TuplesKt.to((Object)HibernateSqlType.TINYINT, (Object)"SMALLINT"), TuplesKt.to((Object)HibernateSqlType.GEOGRAPHY, (Object)"BLOB"), TuplesKt.to((Object)HibernateSqlType.GEOMETRY, (Object)"BLOB"), TuplesKt.to((Object)HibernateSqlType.VARBINARY, (Object)"BLOB"), TuplesKt.to((Object)HibernateSqlType.BINARY, (Object)"BLOB"), TuplesKt.to((Object)HibernateSqlType.POINT, (Object)"BLOB"), TuplesKt.to((Object)HibernateSqlType.INET, (Object)"BLOB")};
        this.jdbcTypeCodeMappings = MapsKt.plus(this.liquibaseTypes.getJDBC_TYPE_CODE_TYPES(), (Map)MapsKt.mapOf((Pair[])object));
        Object object2 = object = (Map)new LinkedHashMap();
        db2MappingSettings = this;
        boolean bl = false;
        $this$sqlSynonymTypes_u24lambda_u240.put("INT", CollectionsKt.listOf((Object)"SMALLINT"));
        $this$sqlSynonymTypes_u24lambda_u240.put("BIGINT", CollectionsKt.emptyList());
        Object[] $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"double precision", "FLOAT", "real", "DECFLOAT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DOUBLE", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"dec", "numeric", "DECFLOAT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DECIMAL", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"character", "NCHAR", "national char", "national character", "CHAR () FOR BIT DATA"};
        $this$sqlSynonymTypes_u24lambda_u240.put("CHAR", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"character varying", "char varying", "NVARCHAR", "CLOB", "NCLOB", "GRAPHIC", "VARGRAPHIC", "XML", "VARCHAR () FOR BIT DATA"};
        $this$sqlSynonymTypes_u24lambda_u240.put("VARCHAR", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"ROWID", "CHAR () FOR BIT DATA", "VARCHAR () FOR BIT DATA", "BINARY", "VARBINARY", "XML"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BLOB", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"DBCLOB", "XML"};
        $this$sqlSynonymTypes_u24lambda_u240.put("CLOB", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $this$sqlSynonymTypes_u24lambda_u240.put("BOOLEAN", SetsKt.setOf((Object)"SMALLINT"));
        $this$sqlSynonymTypes_u24lambda_u240.put("DATE", CollectionsKt.emptyList());
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"timestamp with time zone", "timestamp without time zone", "TIMESTAMP"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DATETIME", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $i$a$-run-Db2MappingSettings$mappingTypes$22 = new String[]{"time with time zone", "TIME WITHOUT TIME ZONE"};
        $this$sqlSynonymTypes_u24lambda_u240.put("TIME", CollectionsKt.listOf((Object[])$i$a$-run-Db2MappingSettings$mappingTypes$22));
        $this$sqlSynonymTypes_u24lambda_u240 = object;
        boolean $i$a$-let-Db2MappingSettings$sqlSynonymTypes$32 = false;
        db2MappingSettings.sqlSynonymTypes = DbMappingSettingsKt.access$createSynonymMap(project, (Map)it2);
        Map $i$a$-let-Db2MappingSettings$sqlSynonymTypes$32 = new LinkedHashMap();
        db2MappingSettings = this;
        boolean bl2 = false;
        Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.Boolean;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"Boolean");
        $this$defaultValues_u24lambda_u240.put(basicDatatype2, "false");
        Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.ByteArray;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"ByteArray");
        $this$defaultValues_u24lambda_u240.put(basicDatatype3, "''");
        Iterable $this$forEach$iv = DbMappingSettingsKt.access$getDATE_TYPES$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_date");
        }
        $this$forEach$iv = DbMappingSettingsKt.access$getDATATIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_timestamp");
        }
        Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.BigDecimal;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"BigDecimal");
        $this$defaultValues_u24lambda_u240.put(basicDatatype4, "0");
        Datatypes.BasicDatatype basicDatatype5 = Datatypes.BasicDatatype.Double;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype5, (String)"Double");
        $this$defaultValues_u24lambda_u240.put(basicDatatype5, "0");
        Datatypes.BasicDatatype basicDatatype6 = Datatypes.BasicDatatype.Integer;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype6, (String)"Integer");
        $this$defaultValues_u24lambda_u240.put(basicDatatype6, "0");
        Datatypes.BasicDatatype basicDatatype7 = Datatypes.BasicDatatype.Long;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype7, (String)"Long");
        $this$defaultValues_u24lambda_u240.put(basicDatatype7, "0");
        Datatypes.BasicDatatype basicDatatype8 = Datatypes.BasicDatatype.String;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype8, (String)"String");
        $this$defaultValues_u24lambda_u240.put(basicDatatype8, "''");
        $this$forEach$iv = DbMappingSettingsKt.access$getTIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_time");
        }
        ImmutableMap immutableMap2 = ImmutableMap.copyOf((Map)$this$defaultValues_u24lambda_u240);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"run(...)");
        db2MappingSettings.defaultValues = (Map)immutableMap2;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getMappingTypes() {
        return this.mappingTypes;
    }

    @Override
    @NotNull
    public Map<HibernateSqlType, String> getJdbcTypeCodeMappings() {
        return this.jdbcTypeCodeMappings;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        return this.sqlSynonymTypes;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public boolean precisionChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (attributeColumnSize == null) {
            Integer n = dbColumnSizeInt;
            int n2 = 5;
            if (n != null && n == n2) {
                return false;
            }
        }
        return !Intrinsics.areEqual((Object)dbColumnSizeInt, (Object)attributeColumnSize) && (dbColumnSizeInt == null || dbColumnSizeInt <= 1000 || attributeColumnSize != null && attributeColumnSize != 0);
    }

    @Override
    public boolean typeChanged(@NotNull Datatype datatype, @NotNull String attrMappedSqlType, @NotNull String dbType, int oldLength) {
        Datatype[] datatypeArray;
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        Intrinsics.checkNotNullParameter((Object)attrMappedSqlType, (String)"attrMappedSqlType");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String columnDbType = string;
        String string2 = attrMappedSqlType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String attributeType = string2;
        if ((this.isConvertibleType(columnDbType, "varchar") || this.isConvertibleType(columnDbType, "char")) && oldLength == 36 && Datatypes.BasicDatatype.UUID.isSame(datatypeArray = new Datatype[]{datatype})) {
            attributeType = "char";
        }
        if ((Intrinsics.areEqual((Object)"char", (Object)columnDbType) || Intrinsics.areEqual((Object)"nchar", (Object)columnDbType)) && (Intrinsics.areEqual((Object)"varchar", (Object)attributeType) || Intrinsics.areEqual((Object)"nvarchar", (Object)attributeType)) && oldLength > 1) {
            return false;
        }
        return !this.isConvertibleType(attributeType, columnDbType);
    }

    @Override
    public boolean lengthChanged(@NotNull String attrSqlType, @NotNull String dbSqlType, @Nullable Integer attrColumnSize, @Nullable Integer dbColumnSize) {
        Intrinsics.checkNotNullParameter((Object)attrSqlType, (String)"attrSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        boolean lengthChanged = DbMappingSettings.super.lengthChanged(attrSqlType, dbSqlType, attrColumnSize, dbColumnSize);
        if (!lengthChanged) {
            return false;
        }
        return !StringsKt.equals((String)"clob", (String)dbSqlType, (boolean)true) || !LiquibaseTypes.Companion.isClobType(attrSqlType) || dbColumnSize == null || dbColumnSize < 0x100000 || attrColumnSize != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/liquibase/common/ddl/Db2MappingSettings$Companion;", "", "<init>", "()V", "PRIMARY_KEY_UUID_LENGTH", "", "CLOB_SIZE", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

