/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 41583992415464L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(119011560 + (char)-4651, -119011560 + -((char)-1371), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(119011560 + (char)-4652, -119011560 + -((char)-15151), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 109798830264082L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.j();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-2008647750 + -27253, -2008647750 + -19026, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-2008647750 + -27254, 2008647750 + 11432, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-2008647750 + -27255, -2008647750 + -15941, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 59326772183495L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.J();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(388884690 + (char)-9531, 389015760 - (char)-2371, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(388884690 + (char)-9534, -388884690 + -((char)-4300), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(388884690 + (char)-9533, -389015760 - -((char)-2662), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(388884690 + (char)-9528, -388884690 + -((char)-14701), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(388884690 + (char)-9527, -389015760 - -((char)-4104), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(388884690 + (char)-9530, -388884690 + -((char)-17061), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(388884690 + (char)-9528, -388884690 + -((char)-14701), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(388884690 + (char)-9529, 388884690 + (char)-16709, (int)l2));
            if (!ActionTimestamp.j()) {
                SshAgentIpcService.j(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 103173648634658L;
                    n3 = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    int n2;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 90058153935483L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            n2 = SshAgentIpcService.j();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (n2 == 0) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1279636410 + 19560, -1279636410 + -22928, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19561, 1279636410 + (char)-18245, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19558, 1279636410 + (char)-23947, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1279636410 + 19560, -1279636410 + -22928, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19559, 1279636410 + (char)-22981, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (n2 == 0) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n3 = Kernel32.INSTANCE.GetLastError();
                            if (n3 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1279636410 + 19560, -1279636410 + -22928, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19588, 1279636410 + (char)-31717, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19589, -1279636410 + -25623, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19558, 1279636410 + (char)-23947, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1279636410 + 19560, -1279636410 + -22928, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1279636410 + 19564, -1279636410 + -((char)-18145), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1279636410 + 19586, -1279636410 + -27775, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 66186960861556L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1514775990 + 32191, -1514775990 + -((char)-18929), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 60659600038268L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1776915990 + 11622, -1776915990 + -3629, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u0019\u00c5=\u0086\u009e\u00c6\r\u00f0zZ\u00ba\u001a\f\u00ef\u00c6@\u0011s.\u0014L\u001d\u0097\u009b\u00d0\u00a7\u00b9Yni\u00fd\u00a8&@B>lz\u0086\u008b";
                                        var4_3 = "\u0019\u00c5=\u0086\u009e\u00c6\r\u00f0zZ\u00ba\u001a\f\u00ef\u00c6@\u0011s.\u0014L\u001d\u0097\u009b\u00d0\u00a7\u00b9Yni\u00fd\u00a8&@B>lz\u0086\u008b".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 20;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 51;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 106;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 58;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 101;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 31;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 60;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 125;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0x5A01) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 131;
                                            case 1 -> 10;
                                            case 2 -> 107;
                                            case 3 -> 144;
                                            case 4 -> 97;
                                            case 5 -> 235;
                                            case 6 -> 166;
                                            case 7 -> 156;
                                            case 8 -> 129;
                                            case 9 -> 61;
                                            case 10 -> 63;
                                            case 11 -> 157;
                                            case 12 -> 189;
                                            case 13 -> 214;
                                            case 14 -> 90;
                                            case 15 -> 44;
                                            case 16 -> 9;
                                            case 17 -> 49;
                                            case 18 -> 223;
                                            case 19 -> 110;
                                            case 20 -> 19;
                                            case 21 -> 2;
                                            case 22 -> 202;
                                            case 23 -> 183;
                                            case 24 -> 185;
                                            case 25 -> 100;
                                            case 26 -> 230;
                                            case 27 -> 28;
                                            case 28 -> 101;
                                            case 29 -> 85;
                                            case 30 -> 245;
                                            case 31 -> 108;
                                            case 32 -> 93;
                                            case 33 -> 159;
                                            case 34 -> 60;
                                            case 35 -> 43;
                                            case 36 -> 36;
                                            case 37 -> 227;
                                            case 38 -> 53;
                                            case 39 -> 162;
                                            case 40 -> 86;
                                            case 41 -> 163;
                                            case 42 -> 88;
                                            case 43 -> 7;
                                            case 44 -> 158;
                                            case 45 -> 114;
                                            case 46 -> 106;
                                            case 47 -> 213;
                                            case 48 -> 224;
                                            case 49 -> 23;
                                            case 50 -> 84;
                                            case 51 -> 229;
                                            case 52 -> 179;
                                            case 53 -> 148;
                                            case 54 -> 29;
                                            case 55 -> 39;
                                            case 56 -> 236;
                                            case 57 -> 30;
                                            case 58 -> 83;
                                            case 59 -> 22;
                                            case 60 -> 66;
                                            case 61 -> 16;
                                            case 62 -> 255;
                                            case 63 -> 211;
                                            case 64 -> 0;
                                            case 65 -> 102;
                                            case 66 -> 32;
                                            case 67 -> 25;
                                            case 68 -> 118;
                                            case 69 -> 70;
                                            case 70 -> 115;
                                            case 71 -> 234;
                                            case 72 -> 125;
                                            case 73 -> 134;
                                            case 74 -> 58;
                                            case 75 -> 57;
                                            case 76 -> 225;
                                            case 77 -> 109;
                                            case 78 -> 112;
                                            case 79 -> 98;
                                            case 80 -> 238;
                                            case 81 -> 124;
                                            case 82 -> 77;
                                            case 83 -> 27;
                                            case 84 -> 76;
                                            case 85 -> 150;
                                            case 86 -> 56;
                                            case 87 -> 52;
                                            case 88 -> 228;
                                            case 89 -> 171;
                                            case 90 -> 254;
                                            case 91 -> 153;
                                            case 92 -> 73;
                                            case 93 -> 80;
                                            case 94 -> 40;
                                            case 95 -> 72;
                                            case 96 -> 18;
                                            case 97 -> 35;
                                            case 98 -> 151;
                                            case 99 -> 152;
                                            case 100 -> 182;
                                            case 101 -> 137;
                                            case 102 -> 172;
                                            case 103 -> 196;
                                            case 104 -> 210;
                                            case 105 -> 243;
                                            case 106 -> 178;
                                            case 107 -> 188;
                                            case 108 -> 41;
                                            case 109 -> 79;
                                            case 110 -> 126;
                                            case 111 -> 117;
                                            case 112 -> 71;
                                            case 113 -> 205;
                                            case 114 -> 78;
                                            case 115 -> 212;
                                            case 116 -> 220;
                                            case 117 -> 201;
                                            case 118 -> 143;
                                            case 119 -> 251;
                                            case 120 -> 82;
                                            case 121 -> 241;
                                            case 122 -> 99;
                                            case 123 -> 194;
                                            case 124 -> 174;
                                            case 125 -> 128;
                                            case 126 -> 123;
                                            case 127 -> 217;
                                            case 128 -> 167;
                                            case 129 -> 95;
                                            case 130 -> 244;
                                            case 131 -> 14;
                                            case 132 -> 246;
                                            case 133 -> 113;
                                            case 134 -> 233;
                                            case 135 -> 26;
                                            case 136 -> 62;
                                            case 137 -> 168;
                                            case 138 -> 154;
                                            case 139 -> 45;
                                            case 140 -> 38;
                                            case 141 -> 199;
                                            case 142 -> 81;
                                            case 143 -> 198;
                                            case 144 -> 34;
                                            case 145 -> 42;
                                            case 146 -> 206;
                                            case 147 -> 75;
                                            case 148 -> 249;
                                            case 149 -> 248;
                                            case 150 -> 20;
                                            case 151 -> 3;
                                            case 152 -> 121;
                                            case 153 -> 122;
                                            case 154 -> 237;
                                            case 155 -> 59;
                                            case 156 -> 31;
                                            case 157 -> 138;
                                            case 158 -> 135;
                                            case 159 -> 94;
                                            case 160 -> 4;
                                            case 161 -> 111;
                                            case 162 -> 54;
                                            case 163 -> 193;
                                            case 164 -> 119;
                                            case 165 -> 176;
                                            case 166 -> 33;
                                            case 167 -> 6;
                                            case 168 -> 69;
                                            case 169 -> 64;
                                            case 170 -> 140;
                                            case 171 -> 68;
                                            case 172 -> 37;
                                            case 173 -> 195;
                                            case 174 -> 170;
                                            case 175 -> 132;
                                            case 176 -> 250;
                                            case 177 -> 105;
                                            case 178 -> 13;
                                            case 179 -> 104;
                                            case 180 -> 219;
                                            case 181 -> 120;
                                            case 182 -> 116;
                                            case 183 -> 209;
                                            case 184 -> 247;
                                            case 185 -> 175;
                                            case 186 -> 232;
                                            case 187 -> 197;
                                            case 188 -> 200;
                                            case 189 -> 231;
                                            case 190 -> 141;
                                            case 191 -> 149;
                                            case 192 -> 55;
                                            case 193 -> 21;
                                            case 194 -> 11;
                                            case 195 -> 15;
                                            case 196 -> 221;
                                            case 197 -> 184;
                                            case 198 -> 161;
                                            case 199 -> 226;
                                            case 200 -> 127;
                                            case 201 -> 87;
                                            case 202 -> 191;
                                            case 203 -> 208;
                                            case 204 -> 48;
                                            case 205 -> 145;
                                            case 206 -> 160;
                                            case 207 -> 165;
                                            case 208 -> 190;
                                            case 209 -> 181;
                                            case 210 -> 215;
                                            case 211 -> 239;
                                            case 212 -> 96;
                                            case 213 -> 146;
                                            case 214 -> 46;
                                            case 215 -> 24;
                                            case 216 -> 17;
                                            case 217 -> 186;
                                            case 218 -> 253;
                                            case 219 -> 222;
                                            case 220 -> 180;
                                            case 221 -> 136;
                                            case 222 -> 74;
                                            case 223 -> 133;
                                            case 224 -> 177;
                                            case 225 -> 203;
                                            case 226 -> 218;
                                            case 227 -> 50;
                                            case 228 -> 164;
                                            case 229 -> 204;
                                            case 230 -> 130;
                                            case 231 -> 67;
                                            case 232 -> 187;
                                            case 233 -> 192;
                                            case 234 -> 242;
                                            case 235 -> 155;
                                            case 236 -> 139;
                                            case 237 -> 169;
                                            case 238 -> 252;
                                            case 239 -> 91;
                                            case 240 -> 103;
                                            case 241 -> 8;
                                            case 242 -> 142;
                                            case 243 -> 12;
                                            case 244 -> 147;
                                            case 245 -> 240;
                                            case 246 -> 207;
                                            case 247 -> 1;
                                            case 248 -> 65;
                                            case 249 -> 47;
                                            case 250 -> 92;
                                            case 251 -> 173;
                                            case 252 -> 216;
                                            case 253 -> 5;
                                            case 254 -> 51;
                                            default -> 89;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (n2 != 0) break block32;
                            if (ActionTimestamp.J()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.j(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 126503533937783L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.j();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-432793140 - -11362, 432793140 - 12666, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-432793140 - -11358, 432793140 - 4361, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-432793140 - -11365, -432793140 - -3901, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-432793140 - -11362, 432793140 - 12666, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-432793140 - -11358, 432793140 - 4361, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-432793140 - -11370, -432793140 - -21360, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 106036057342806L;
                        int n3 = SshAgentIpcService.j();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1904709240 + (char)-19810, -1904709240 + -((char)-4613), (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1904709240 + (char)-19811, 1904709240 + 31263, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 20449237861575L;
                int n3 = SshAgentIpcService.J();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = n3;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(898615920 - (char)-31790, -898615920 - -32378, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(898615920 - (char)-31786, -898615920 - -((char)-24565), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(898615920 - (char)-31765, -898615920 - -((char)-31729), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(898615920 - (char)-31786, -898615920 - -((char)-24565), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(898615920 - (char)-31788, 898615920 - (char)-17955, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(898615920 - (char)-31790, -898615920 - -32378, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(898615920 - (char)-31786, -898615920 - -((char)-24565), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(898615920 - (char)-31770, 898615920 - (char)-30513, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(898615920 - (char)-31790, -898615920 - -32378, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(898615920 - (char)-31786, -898615920 - -((char)-24565), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(898615920 - (char)-31771, 898615920 - 24617, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(898615920 - (char)-31790, -898615920 - -32378, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(898615920 - (char)-31786, -898615920 - -((char)-24565), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(898615920 - (char)-31768, 898615920 - (char)-31233, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 4664626820994L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.J();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1865, -292417170 - -((char)-2591), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(292417170 - (char)-1869, -292286100 + -((char)-21874), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1850, 292286100 + (char)-16284, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1849, -292286100 + -((char)-25993), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1865, -292417170 - -((char)-2591), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(292417170 - (char)-1869, -292286100 + -((char)-21874), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1848, 292417170 - (char)-1094, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1865, -292417170 - -((char)-2591), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(292417170 - (char)-1869, -292286100 + -((char)-21874), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1847, -292417170 - -((char)-533), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1865, -292417170 - -((char)-2591), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(292417170 - (char)-1869, -292286100 + -((char)-21874), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1846, -292286100 + -((char)-18797), (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1865, -292417170 - -((char)-2591), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(292417170 - (char)-1869, -292286100 + -((char)-21874), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(292417170 - (char)-1893, -292286100 + -((char)-26877), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(292417170 - (char)-1892, 292286100 + (char)-11807, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0094\u00d3\u009c?&6I(\u0014\u00ce{\u00ef\u00cd\u00b6\u00e0\u00f4\u00e8>\u00e8\u00ac\u00ab'_\u00b5tC:\u00cf\u00be\u0006z\u0012A\u0007\u00f7p\u0018\u00d1\u00d0l\u0088D\u008d\u00a8\u0085}8\u00cb\u00c1\u00ad\u00ed\u00b6\u00a0\u008a\u00c9\u00d8]\u0005\n\u001a\u00b5\t(|\u00cd\u00ac\u001b\u0096[\u00ae?\u0005\u0010\u00e1\fyD\bn\u0096\u00c3\u00e6\u009f+xi\u0014K\u00b3'O\u00c2\u00b8Ot'\u00a6$\u00d6|Se\u0018Kd77\u0005\u0017:\u00ec\u0002X\u001eX\u0092\u0010sZ6\u00c9\u0088\u00f4\u008d\u00b1\u00f0\u00ae\u00ebt\u00043\u00cc=\t\u0015\u00af\u0014\u00cc\u00be\u008a1\u00a1\u00a3\u00af\u0010%\u00aa[\u00b1d\\\u00f8<\u00af\u00a9W\u0089t\u0091\u0080\u00d4\t}\n\u00b1s\u00c7J\u00e6\u00aaf\u0010l\u0000r\u00e4A\u00f6\\i;\u0003\u00c5\u00dc&;\u00ca\u0081?\u00aa\u0019F\u0002\u009d\u0011\u00b4\u0000*M/\u0013\u00c2a\u00c4l\u00e0\u00a4:\u00c1{\u00e4\u00a2\u00c3x\u0083\u00e44.KB[qM\u00c5\u0002\u000e\u00ab\u00d6\u00cd,\u00b1\u0084W\u00f1\u00adi\u001b,3\u00e6H\u00d2\u00ed\u009eN\u00c2u\b\u00b6\u0014\u0087\u00e6\bL\u00df\u0087\u00cf\u0017\u000ei\u00cd\fA\u00af6\u00da<\u00ce\u00e2\u00d2\u00c5<H?F\u00b4\u00be\u0088\u00f8\u00eb\u008a\u0018Z\u009a!\u00a9X\u0084\u0000\u0013f\u00e6\u0082\u00fa\u00aaq\u00db\u00e0\u0016\u0006\u0012\u00d8\r\u0016E\u007f\u00a6\u00eaDt\u0002\u00e2\u00e6\u00e0\u00a0y\t\u00a5\u00bb\u000b\u00b5be\u00aa\u0004P\u0004\u00eb\u00f2\u00af\u00b6{\u001e\u00a9g\u0013\u00d4Z\u00bbG\u00d3\u0015`\u00f1\u008e\u001fLe\u0092\u008d\n\u00e9\u00c3s\u00b5\u00f2\u0099\u001f\u00ab\u000b\u00df\u00a9=\u0091\u0081hI\u0003H\u00f2T\u009d{\u008f\u00f7\u009bA\u000bh\u001c\u0013\u00ac\u0098\u0000v\u000bW\u000b\u0010\u0015\u00b0\u0092\b~\u00fc2\u00160e\u008c\u009e\u001b\u00f5'\tz\u001c\u007fx\u00cc@)\u0097\u00e2\u00e9}e\u00f7.\u00b0\b\u008a.\u0010Y\u00e0\u001f\u00d1z\u0016\u00b2?\u00df\u0091\\\u00b8\u00b9\u009d\u0011\u00f7\u0095`\u008f<\n\u00b2\u000eQ\u00b3\u0091A\u00e7\u00ee\u0007\u00ba\nFz\u00b4J\u008f\u0007Z\u00c9>n\\'\u0084(\u00ce\u00b5\u008e\u00b69\u00e4S\u00f5\u00d7\u00f5\u00ff\u00c9@Z~\u0005Q!y\u009a\u00c7\u001b0\"\u00a4r\u0004q\u0000\u00d0\u00e63\u00dc8J\u00ad\u0081s\u0094H\u000f\u00b2\u00c0O1\u00e9x\u00ec\u00a5Ur\u000eh\u00de:3\"\"o_\u00cc\u00b3\u00c1\u00f4vSRE\u000b7\u008f\u00b6\u00f2\u00a4[\u00e3\u00d4\u001f\u00ec\u00e4G=6L\\\u001a'\u00dc\u00d3N\u00bc\u000e\u00b1|/\u00a6\u00e5\u008am\u00fbe\u00b9\b\u0011\u0012\u001f\u001b\u0092`L r\u00ef\n\u000b\u00de \u00f2#\u001do\u00d5\u00f8`\u00b0\u00c65\u0080\u00e4d\u00e0f\u00afr\nRa\u0090\u0007\u00fd\u00ef(!1\u0007\u0018\u00151\u00bc\u0007m\u00b7\u00c8^\u0098C\u00f8\u00d0\u00e5B6|k!p~.\u00c6\u00ea\u00f7)6B\u00ddi\u00e3u\u00fe\u00e0\u0012\u0080mQ5\u00c1\r\u008eF\u0088\u00ea)\u00eeC3\u00ee!\u00c5\u009f\u0010\u0017\u00c0d\u00b9R\u00dc\u00d0\b\u00b6\u009e\u00e1\u0006\u00fa\t\u00de\u001f\u00c5\u00cfC\u0012 \u00fa\u0003";
                var4_3 = "\u0094\u00d3\u009c?&6I(\u0014\u00ce{\u00ef\u00cd\u00b6\u00e0\u00f4\u00e8>\u00e8\u00ac\u00ab'_\u00b5tC:\u00cf\u00be\u0006z\u0012A\u0007\u00f7p\u0018\u00d1\u00d0l\u0088D\u008d\u00a8\u0085}8\u00cb\u00c1\u00ad\u00ed\u00b6\u00a0\u008a\u00c9\u00d8]\u0005\n\u001a\u00b5\t(|\u00cd\u00ac\u001b\u0096[\u00ae?\u0005\u0010\u00e1\fyD\bn\u0096\u00c3\u00e6\u009f+xi\u0014K\u00b3'O\u00c2\u00b8Ot'\u00a6$\u00d6|Se\u0018Kd77\u0005\u0017:\u00ec\u0002X\u001eX\u0092\u0010sZ6\u00c9\u0088\u00f4\u008d\u00b1\u00f0\u00ae\u00ebt\u00043\u00cc=\t\u0015\u00af\u0014\u00cc\u00be\u008a1\u00a1\u00a3\u00af\u0010%\u00aa[\u00b1d\\\u00f8<\u00af\u00a9W\u0089t\u0091\u0080\u00d4\t}\n\u00b1s\u00c7J\u00e6\u00aaf\u0010l\u0000r\u00e4A\u00f6\\i;\u0003\u00c5\u00dc&;\u00ca\u0081?\u00aa\u0019F\u0002\u009d\u0011\u00b4\u0000*M/\u0013\u00c2a\u00c4l\u00e0\u00a4:\u00c1{\u00e4\u00a2\u00c3x\u0083\u00e44.KB[qM\u00c5\u0002\u000e\u00ab\u00d6\u00cd,\u00b1\u0084W\u00f1\u00adi\u001b,3\u00e6H\u00d2\u00ed\u009eN\u00c2u\b\u00b6\u0014\u0087\u00e6\bL\u00df\u0087\u00cf\u0017\u000ei\u00cd\fA\u00af6\u00da<\u00ce\u00e2\u00d2\u00c5<H?F\u00b4\u00be\u0088\u00f8\u00eb\u008a\u0018Z\u009a!\u00a9X\u0084\u0000\u0013f\u00e6\u0082\u00fa\u00aaq\u00db\u00e0\u0016\u0006\u0012\u00d8\r\u0016E\u007f\u00a6\u00eaDt\u0002\u00e2\u00e6\u00e0\u00a0y\t\u00a5\u00bb\u000b\u00b5be\u00aa\u0004P\u0004\u00eb\u00f2\u00af\u00b6{\u001e\u00a9g\u0013\u00d4Z\u00bbG\u00d3\u0015`\u00f1\u008e\u001fLe\u0092\u008d\n\u00e9\u00c3s\u00b5\u00f2\u0099\u001f\u00ab\u000b\u00df\u00a9=\u0091\u0081hI\u0003H\u00f2T\u009d{\u008f\u00f7\u009bA\u000bh\u001c\u0013\u00ac\u0098\u0000v\u000bW\u000b\u0010\u0015\u00b0\u0092\b~\u00fc2\u00160e\u008c\u009e\u001b\u00f5'\tz\u001c\u007fx\u00cc@)\u0097\u00e2\u00e9}e\u00f7.\u00b0\b\u008a.\u0010Y\u00e0\u001f\u00d1z\u0016\u00b2?\u00df\u0091\\\u00b8\u00b9\u009d\u0011\u00f7\u0095`\u008f<\n\u00b2\u000eQ\u00b3\u0091A\u00e7\u00ee\u0007\u00ba\nFz\u00b4J\u008f\u0007Z\u00c9>n\\'\u0084(\u00ce\u00b5\u008e\u00b69\u00e4S\u00f5\u00d7\u00f5\u00ff\u00c9@Z~\u0005Q!y\u009a\u00c7\u001b0\"\u00a4r\u0004q\u0000\u00d0\u00e63\u00dc8J\u00ad\u0081s\u0094H\u000f\u00b2\u00c0O1\u00e9x\u00ec\u00a5Ur\u000eh\u00de:3\"\"o_\u00cc\u00b3\u00c1\u00f4vSRE\u000b7\u008f\u00b6\u00f2\u00a4[\u00e3\u00d4\u001f\u00ec\u00e4G=6L\\\u001a'\u00dc\u00d3N\u00bc\u000e\u00b1|/\u00a6\u00e5\u008am\u00fbe\u00b9\b\u0011\u0012\u001f\u001b\u0092`L r\u00ef\n\u000b\u00de \u00f2#\u001do\u00d5\u00f8`\u00b0\u00c65\u0080\u00e4d\u00e0f\u00afr\nRa\u0090\u0007\u00fd\u00ef(!1\u0007\u0018\u00151\u00bc\u0007m\u00b7\u00c8^\u0098C\u00f8\u00d0\u00e5B6|k!p~.\u00c6\u00ea\u00f7)6B\u00ddi\u00e3u\u00fe\u00e0\u0012\u0080mQ5\u00c1\r\u008eF\u0088\u00ea)\u00eeC3\u00ee!\u00c5\u009f\u0010\u0017\u00c0d\u00b9R\u00dc\u00d0\b\u00b6\u009e\u00e1\u0006\u00fa\t\u00de\u001f\u00c5\u00cfC\u0012 \u00fa\u0003".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 112;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b4\u00c5\u009c\u0088\u00daX\u00c8T\u00c5\u0007\u0086\u00b0Y\u00ec\u0091:\u00c4\u0003\u00fb\u00cd\u0088\u00f1\u001dw^\u00fb\u00f0\u0083{\u0014\u0001\u00cf\u0007J\u00ba\u0001d\u00c5=\\\u00dd,\u0018\u00beCY\u008c\u008e'9";
                    var4_3 = "\u00b4\u00c5\u009c\u0088\u00daX\u00c8T\u00c5\u0007\u0086\u00b0Y\u00ec\u0091:\u00c4\u0003\u00fb\u00cd\u0088\u00f1\u001dw^\u00fb\u00f0\u0083{\u0014\u0001\u00cf\u0007J\u00ba\u0001d\u00c5=\\\u00dd,\u0018\u00beCY\u008c\u008e'9".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 42;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 17;
                            break;
                        }
                        case 1: {
                            v15 = 88;
                            break;
                        }
                        case 2: {
                            v15 = 92;
                            break;
                        }
                        case 3: {
                            v15 = 17;
                            break;
                        }
                        case 4: {
                            v15 = 110;
                            break;
                        }
                        case 5: {
                            v15 = 37;
                            break;
                        }
                        default: {
                            v15 = 16;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x4255) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 184;
                case 1 -> 131;
                case 2 -> 14;
                case 3 -> 16;
                case 4 -> 251;
                case 5 -> 66;
                case 6 -> 197;
                case 7 -> 230;
                case 8 -> 17;
                case 9 -> 137;
                case 10 -> 45;
                case 11 -> 247;
                case 12 -> 194;
                case 13 -> 99;
                case 14 -> 43;
                case 15 -> 8;
                case 16 -> 167;
                case 17 -> 141;
                case 18 -> 139;
                case 19 -> 163;
                case 20 -> 161;
                case 21 -> 179;
                case 22 -> 212;
                case 23 -> 111;
                case 24 -> 47;
                case 25 -> 91;
                case 26 -> 240;
                case 27 -> 15;
                case 28 -> 36;
                case 29 -> 38;
                case 30 -> 193;
                case 31 -> 151;
                case 32 -> 116;
                case 33 -> 117;
                case 34 -> 128;
                case 35 -> 129;
                case 36 -> 82;
                case 37 -> 160;
                case 38 -> 166;
                case 39 -> 199;
                case 40 -> 113;
                case 41 -> 74;
                case 42 -> 164;
                case 43 -> 60;
                case 44 -> 243;
                case 45 -> 61;
                case 46 -> 255;
                case 47 -> 119;
                case 48 -> 46;
                case 49 -> 94;
                case 50 -> 135;
                case 51 -> 88;
                case 52 -> 102;
                case 53 -> 154;
                case 54 -> 27;
                case 55 -> 208;
                case 56 -> 158;
                case 57 -> 236;
                case 58 -> 132;
                case 59 -> 121;
                case 60 -> 130;
                case 61 -> 96;
                case 62 -> 226;
                case 63 -> 249;
                case 64 -> 31;
                case 65 -> 32;
                case 66 -> 222;
                case 67 -> 7;
                case 68 -> 241;
                case 69 -> 44;
                case 70 -> 181;
                case 71 -> 152;
                case 72 -> 153;
                case 73 -> 2;
                case 74 -> 65;
                case 75 -> 229;
                case 76 -> 188;
                case 77 -> 55;
                case 78 -> 79;
                case 79 -> 252;
                case 80 -> 52;
                case 81 -> 207;
                case 82 -> 223;
                case 83 -> 239;
                case 84 -> 5;
                case 85 -> 70;
                case 86 -> 206;
                case 87 -> 110;
                case 88 -> 180;
                case 89 -> 228;
                case 90 -> 87;
                case 91 -> 148;
                case 92 -> 33;
                case 93 -> 168;
                case 94 -> 9;
                case 95 -> 18;
                case 96 -> 173;
                case 97 -> 57;
                case 98 -> 1;
                case 99 -> 189;
                case 100 -> 56;
                case 101 -> 100;
                case 102 -> 39;
                case 103 -> 238;
                case 104 -> 162;
                case 105 -> 78;
                case 106 -> 157;
                case 107 -> 114;
                case 108 -> 92;
                case 109 -> 159;
                case 110 -> 133;
                case 111 -> 75;
                case 112 -> 245;
                case 113 -> 211;
                case 114 -> 11;
                case 115 -> 227;
                case 116 -> 12;
                case 117 -> 165;
                case 118 -> 86;
                case 119 -> 35;
                case 120 -> 234;
                case 121 -> 185;
                case 122 -> 0;
                case 123 -> 253;
                case 124 -> 155;
                case 125 -> 186;
                case 126 -> 172;
                case 127 -> 84;
                case 128 -> 41;
                case 129 -> 69;
                case 130 -> 73;
                case 131 -> 93;
                case 132 -> 156;
                case 133 -> 112;
                case 134 -> 171;
                case 135 -> 203;
                case 136 -> 34;
                case 137 -> 30;
                case 138 -> 19;
                case 139 -> 187;
                case 140 -> 10;
                case 141 -> 77;
                case 142 -> 190;
                case 143 -> 54;
                case 144 -> 72;
                case 145 -> 85;
                case 146 -> 138;
                case 147 -> 26;
                case 148 -> 97;
                case 149 -> 50;
                case 150 -> 126;
                case 151 -> 3;
                case 152 -> 24;
                case 153 -> 80;
                case 154 -> 107;
                case 155 -> 13;
                case 156 -> 202;
                case 157 -> 225;
                case 158 -> 20;
                case 159 -> 237;
                case 160 -> 58;
                case 161 -> 217;
                case 162 -> 136;
                case 163 -> 115;
                case 164 -> 220;
                case 165 -> 134;
                case 166 -> 183;
                case 167 -> 213;
                case 168 -> 59;
                case 169 -> 182;
                case 170 -> 89;
                case 171 -> 95;
                case 172 -> 142;
                case 173 -> 209;
                case 174 -> 146;
                case 175 -> 201;
                case 176 -> 108;
                case 177 -> 143;
                case 178 -> 40;
                case 179 -> 83;
                case 180 -> 246;
                case 181 -> 120;
                case 182 -> 175;
                case 183 -> 235;
                case 184 -> 104;
                case 185 -> 178;
                case 186 -> 123;
                case 187 -> 28;
                case 188 -> 64;
                case 189 -> 62;
                case 190 -> 145;
                case 191 -> 214;
                case 192 -> 205;
                case 193 -> 242;
                case 194 -> 51;
                case 195 -> 37;
                case 196 -> 196;
                case 197 -> 192;
                case 198 -> 195;
                case 199 -> 103;
                case 200 -> 248;
                case 201 -> 68;
                case 202 -> 101;
                case 203 -> 29;
                case 204 -> 219;
                case 205 -> 118;
                case 206 -> 98;
                case 207 -> 67;
                case 208 -> 204;
                case 209 -> 147;
                case 210 -> 49;
                case 211 -> 125;
                case 212 -> 176;
                case 213 -> 191;
                case 214 -> 63;
                case 215 -> 21;
                case 216 -> 53;
                case 217 -> 170;
                case 218 -> 210;
                case 219 -> 48;
                case 220 -> 81;
                case 221 -> 231;
                case 222 -> 244;
                case 223 -> 42;
                case 224 -> 144;
                case 225 -> 216;
                case 226 -> 233;
                case 227 -> 71;
                case 228 -> 6;
                case 229 -> 124;
                case 230 -> 4;
                case 231 -> 215;
                case 232 -> 254;
                case 233 -> 150;
                case 234 -> 198;
                case 235 -> 106;
                case 236 -> 224;
                case 237 -> 122;
                case 238 -> 169;
                case 239 -> 221;
                case 240 -> 105;
                case 241 -> 149;
                case 242 -> 90;
                case 243 -> 177;
                case 244 -> 232;
                case 245 -> 22;
                case 246 -> 127;
                case 247 -> 23;
                case 248 -> 25;
                case 249 -> 218;
                case 250 -> 140;
                case 251 -> 76;
                case 252 -> 200;
                case 253 -> 174;
                case 254 -> 250;
                default -> 109;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 113414445646185L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1539155010 + (char)-5971, -1539155010 + -((char)-3388), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 123954718849833L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.j();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1962642180 + (char)-5206, -1962642180 + -((char)-12777), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1962642180 + (char)-5207, 1962642180 + (char)-8180, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1962642180 + (char)-5208, 1962642180 + (char)-7846, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00fa\u008c.\u008f\u0013\u0019\u00eaA\u0010\u0003)\u00e0\u009ap\u0000\u007f; 6\u00fd\u0019\u0018\u0086\u0081I";
                    var4_3 = "\u00fa\u008c.\u008f\u0013\u0019\u00eaA\u0010\u0003)\u00e0\u009ap\u0000\u007f; 6\u00fd\u0019\u0018\u0086\u0081I".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 39;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0000Y\u00f3\u00b7Z5M\u00ceM)_\u00cd\u0000\u00ab:\u001d\u00ae>\u0007\n\u00e5\u00d0'#\u00b4\u001b14\u00bap\u00c3\u00bb7\u009e\u00ca\u00d3\u00f2\u00d6z\u00fb'\u009bjO\u00c7\u00db\u0005\u00db8\u000f\u00ce\u0094\u009d\u0015\u0081\n\u00bd\u00b7%";
                        var4_3 = "\u0000Y\u00f3\u00b7Z5M\u00ceM)_\u00cd\u0000\u00ab:\u001d\u00ae>\u0007\n\u00e5\u00d0'#\u00b4\u001b14\u00bap\u00c3\u00bb7\u009e\u00ca\u00d3\u00f2\u00d6z\u00fb'\u009bjO\u00c7\u00db\u0005\u00db8\u000f\u00ce\u0094\u009d\u0015\u0081\n\u00bd\u00b7%".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 72;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 45;
                                break;
                            }
                            case 1: {
                                v15 = 84;
                                break;
                            }
                            case 2: {
                                v15 = 25;
                                break;
                            }
                            case 3: {
                                v15 = 118;
                                break;
                            }
                            case 4: {
                                v15 = 24;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 102;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4D86) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 57;
                    case 1 -> 71;
                    case 2 -> 239;
                    case 3 -> 41;
                    case 4 -> 197;
                    case 5 -> 25;
                    case 6 -> 193;
                    case 7 -> 9;
                    case 8 -> 115;
                    case 9 -> 94;
                    case 10 -> 174;
                    case 11 -> 228;
                    case 12 -> 124;
                    case 13 -> 113;
                    case 14 -> 219;
                    case 15 -> 79;
                    case 16 -> 202;
                    case 17 -> 254;
                    case 18 -> 20;
                    case 19 -> 127;
                    case 20 -> 216;
                    case 21 -> 97;
                    case 22 -> 49;
                    case 23 -> 93;
                    case 24 -> 63;
                    case 25 -> 24;
                    case 26 -> 118;
                    case 27 -> 59;
                    case 28 -> 136;
                    case 29 -> 214;
                    case 30 -> 4;
                    case 31 -> 167;
                    case 32 -> 178;
                    case 33 -> 175;
                    case 34 -> 45;
                    case 35 -> 248;
                    case 36 -> 203;
                    case 37 -> 208;
                    case 38 -> 40;
                    case 39 -> 156;
                    case 40 -> 101;
                    case 41 -> 236;
                    case 42 -> 131;
                    case 43 -> 85;
                    case 44 -> 51;
                    case 45 -> 26;
                    case 46 -> 241;
                    case 47 -> 11;
                    case 48 -> 39;
                    case 49 -> 172;
                    case 50 -> 100;
                    case 51 -> 50;
                    case 52 -> 16;
                    case 53 -> 242;
                    case 54 -> 53;
                    case 55 -> 84;
                    case 56 -> 60;
                    case 57 -> 206;
                    case 58 -> 126;
                    case 59 -> 225;
                    case 60 -> 147;
                    case 61 -> 38;
                    case 62 -> 224;
                    case 63 -> 194;
                    case 64 -> 70;
                    case 65 -> 233;
                    case 66 -> 217;
                    case 67 -> 184;
                    case 68 -> 5;
                    case 69 -> 30;
                    case 70 -> 162;
                    case 71 -> 195;
                    case 72 -> 243;
                    case 73 -> 190;
                    case 74 -> 179;
                    case 75 -> 28;
                    case 76 -> 22;
                    case 77 -> 252;
                    case 78 -> 146;
                    case 79 -> 44;
                    case 80 -> 119;
                    case 81 -> 145;
                    case 82 -> 111;
                    case 83 -> 150;
                    case 84 -> 107;
                    case 85 -> 148;
                    case 86 -> 31;
                    case 87 -> 159;
                    case 88 -> 153;
                    case 89 -> 67;
                    case 90 -> 151;
                    case 91 -> 110;
                    case 92 -> 130;
                    case 93 -> 187;
                    case 94 -> 69;
                    case 95 -> 17;
                    case 96 -> 246;
                    case 97 -> 43;
                    case 98 -> 133;
                    case 99 -> 47;
                    case 100 -> 64;
                    case 101 -> 36;
                    case 102 -> 221;
                    case 103 -> 196;
                    case 104 -> 35;
                    case 105 -> 204;
                    case 106 -> 138;
                    case 107 -> 122;
                    case 108 -> 211;
                    case 109 -> 168;
                    case 110 -> 114;
                    case 111 -> 212;
                    case 112 -> 149;
                    case 113 -> 98;
                    case 114 -> 205;
                    case 115 -> 15;
                    case 116 -> 209;
                    case 117 -> 105;
                    case 118 -> 238;
                    case 119 -> 226;
                    case 120 -> 90;
                    case 121 -> 65;
                    case 122 -> 99;
                    case 123 -> 143;
                    case 124 -> 229;
                    case 125 -> 244;
                    case 126 -> 249;
                    case 127 -> 8;
                    case 128 -> 154;
                    case 129 -> 62;
                    case 130 -> 55;
                    case 131 -> 33;
                    case 132 -> 250;
                    case 133 -> 164;
                    case 134 -> 29;
                    case 135 -> 188;
                    case 136 -> 157;
                    case 137 -> 34;
                    case 138 -> 120;
                    case 139 -> 160;
                    case 140 -> 128;
                    case 141 -> 165;
                    case 142 -> 14;
                    case 143 -> 152;
                    case 144 -> 139;
                    case 145 -> 89;
                    case 146 -> 125;
                    case 147 -> 78;
                    case 148 -> 253;
                    case 149 -> 72;
                    case 150 -> 185;
                    case 151 -> 2;
                    case 152 -> 218;
                    case 153 -> 230;
                    case 154 -> 76;
                    case 155 -> 6;
                    case 156 -> 46;
                    case 157 -> 173;
                    case 158 -> 13;
                    case 159 -> 169;
                    case 160 -> 82;
                    case 161 -> 27;
                    case 162 -> 87;
                    case 163 -> 177;
                    case 164 -> 222;
                    case 165 -> 91;
                    case 166 -> 117;
                    case 167 -> 66;
                    case 168 -> 235;
                    case 169 -> 251;
                    case 170 -> 180;
                    case 171 -> 183;
                    case 172 -> 56;
                    case 173 -> 80;
                    case 174 -> 227;
                    case 175 -> 42;
                    case 176 -> 140;
                    case 177 -> 199;
                    case 178 -> 234;
                    case 179 -> 104;
                    case 180 -> 186;
                    case 181 -> 21;
                    case 182 -> 102;
                    case 183 -> 137;
                    case 184 -> 163;
                    case 185 -> 23;
                    case 186 -> 247;
                    case 187 -> 81;
                    case 188 -> 232;
                    case 189 -> 129;
                    case 190 -> 166;
                    case 191 -> 141;
                    case 192 -> 77;
                    case 193 -> 215;
                    case 194 -> 240;
                    case 195 -> 223;
                    case 196 -> 207;
                    case 197 -> 158;
                    case 198 -> 68;
                    case 199 -> 132;
                    case 200 -> 181;
                    case 201 -> 237;
                    case 202 -> 32;
                    case 203 -> 96;
                    case 204 -> 255;
                    case 205 -> 245;
                    case 206 -> 75;
                    case 207 -> 10;
                    case 208 -> 170;
                    case 209 -> 116;
                    case 210 -> 86;
                    case 211 -> 108;
                    case 212 -> 0;
                    case 213 -> 198;
                    case 214 -> 210;
                    case 215 -> 201;
                    case 216 -> 171;
                    case 217 -> 12;
                    case 218 -> 48;
                    case 219 -> 74;
                    case 220 -> 134;
                    case 221 -> 142;
                    case 222 -> 176;
                    case 223 -> 135;
                    case 224 -> 231;
                    case 225 -> 83;
                    case 226 -> 7;
                    case 227 -> 200;
                    case 228 -> 73;
                    case 229 -> 144;
                    case 230 -> 52;
                    case 231 -> 189;
                    case 232 -> 3;
                    case 233 -> 106;
                    case 234 -> 161;
                    case 235 -> 182;
                    case 236 -> 220;
                    case 237 -> 92;
                    case 238 -> 37;
                    case 239 -> 123;
                    case 240 -> 19;
                    case 241 -> 121;
                    case 242 -> 1;
                    case 243 -> 88;
                    case 244 -> 155;
                    case 245 -> 213;
                    case 246 -> 58;
                    case 247 -> 109;
                    case 248 -> 103;
                    case 249 -> 95;
                    case 250 -> 54;
                    case 251 -> 61;
                    case 252 -> 191;
                    case 253 -> 112;
                    case 254 -> 18;
                    default -> 192;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 50977486437940L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = ">)U#]p?g\t9#F)\u00102\"{e";
                    var5_4 = ">)U#]p?g\t9#F)\u00102\"{e".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 100;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 49;
                                    break;
                                }
                                case 1: {
                                    v11 = 40;
                                    break;
                                }
                                case 2: {
                                    v11 = 67;
                                    break;
                                }
                                case 3: {
                                    v11 = 41;
                                    break;
                                }
                                case 4: {
                                    v11 = 92;
                                    break;
                                }
                                case 5: {
                                    v11 = 120;
                                    break;
                                }
                                default: {
                                    v11 = 104;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 54716131884422L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "xY\u007f\u0017p\u007ft\u0004~Gs\r\nrXx\r|}lXYq\trXx\r|}lTS\ru^e\u0000vpvTTb\nwy";
                    var5_4 = "xY\u007f\u0017p\u007ft\u0004~Gs\r\nrXx\r|}lXYq\trXx\r|}lTS\ru^e\u0000vpvTTb\nwy".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = " \t+B\"\"-\u0006 \t+B.(";
                        var5_4 = " \t+B\"\"-\u0006 \t+B.(".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 51;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 80;
                                break;
                            }
                            case 1: {
                                v15 = 86;
                                break;
                            }
                            case 2: {
                                v15 = 119;
                                break;
                            }
                            case 3: {
                                v15 = 2;
                                break;
                            }
                            case 4: {
                                v15 = 120;
                                break;
                            }
                            case 5: {
                                v15 = 127;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 98921226113020L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-460579980 + -((char)-14709), -460579980 + -((char)-25095), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 25217330001974L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00f5\u00db\u008cy\u00ea\u0003dI\n\u0005\u0018\u0003\u0017\u00a6z\r\u00dd\u00b0\u0099\u009a^C\u00f0\u00c4\u001a(\u0081\u00a9\u00a7\u0010]\u00cfN\u009e\u009bVc[\u00a1_\u0015\n\u00d3\u0085R+\u0005\u0085\u00a4\u00a4R\f3\u00a3\u00faq\u00ee\u00a9\u001c\u0015\u0006\u0012\t\u00e8\u00e9\u00aa\u00a8Q\u0091fJWb\t5[?nq?r]z\u00d8\u00e4BO#N\u0090Pr\u008ez\u00c8\u00ee\u00df\u0082\u00a6\u00c6-\u0080\u0015\u00ed";
                    var4_3 = "\u00f5\u00db\u008cy\u00ea\u0003dI\n\u0005\u0018\u0003\u0017\u00a6z\r\u00dd\u00b0\u0099\u009a^C\u00f0\u00c4\u001a(\u0081\u00a9\u00a7\u0010]\u00cfN\u009e\u009bVc[\u00a1_\u0015\n\u00d3\u0085R+\u0005\u0085\u00a4\u00a4R\f3\u00a3\u00faq\u00ee\u00a9\u001c\u0015\u0006\u0012\t\u00e8\u00e9\u00aa\u00a8Q\u0091fJWb\t5[?nq?r]z\u00d8\u00e4BO#N\u0090Pr\u008ez\u00c8\u00ee\u00df\u0082\u00a6\u00c6-\u0080\u0015\u00ed".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = ".G7\u0098\u00a3\u0081s\u00b6\u00b4\u00f5\u00a0Hr\u00daq\u00d7L\u0081\u00135\u00d8\u00c9AP\u00c0Y\u00a8\u00b1Z^\u0016g7\u00b2X%\u00c182@j9'\u00e7i\u00abG\u00fe;\u0081M=\u0005v\u00f0\u0083\u00ebe\u008e\u00d5}\u00e7;\u00b6\u00b1k\u00a5o&X\u00b3\u00c8\u0004=\u00825\u00e5\u00cdm\u0006\u00c8\u00d3\u00b0\u00e9'?B\u001dm\u0012,<\u00d8";
                        var4_3 = ".G7\u0098\u00a3\u0081s\u00b6\u00b4\u00f5\u00a0Hr\u00daq\u00d7L\u0081\u00135\u00d8\u00c9AP\u00c0Y\u00a8\u00b1Z^\u0016g7\u00b2X%\u00c182@j9'\u00e7i\u00abG\u00fe;\u0081M=\u0005v\u00f0\u0083\u00ebe\u008e\u00d5}\u00e7;\u00b6\u00b1k\u00a5o&X\u00b3\u00c8\u0004=\u00825\u00e5\u00cdm\u0006\u00c8\u00d3\u00b0\u00e9'?B\u001dm\u0012,<\u00d8".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 115;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 104;
                                break;
                            }
                            case 1: {
                                v15 = 87;
                                break;
                            }
                            case 2: {
                                v15 = 29;
                                break;
                            }
                            case 3: {
                                v15 = 7;
                                break;
                            }
                            case 4: {
                                v15 = 111;
                                break;
                            }
                            case 5: {
                                v15 = 124;
                                break;
                            }
                            default: {
                                v15 = 32;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5B15) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 223;
                    case 1 -> 193;
                    case 2 -> 159;
                    case 3 -> 182;
                    case 4 -> 85;
                    case 5 -> 170;
                    case 6 -> 38;
                    case 7 -> 101;
                    case 8 -> 143;
                    case 9 -> 113;
                    case 10 -> 221;
                    case 11 -> 43;
                    case 12 -> 169;
                    case 13 -> 16;
                    case 14 -> 76;
                    case 15 -> 185;
                    case 16 -> 219;
                    case 17 -> 174;
                    case 18 -> 15;
                    case 19 -> 109;
                    case 20 -> 13;
                    case 21 -> 3;
                    case 22 -> 59;
                    case 23 -> 129;
                    case 24 -> 231;
                    case 25 -> 144;
                    case 26 -> 98;
                    case 27 -> 67;
                    case 28 -> 60;
                    case 29 -> 252;
                    case 30 -> 105;
                    case 31 -> 168;
                    case 32 -> 173;
                    case 33 -> 209;
                    case 34 -> 189;
                    case 35 -> 36;
                    case 36 -> 123;
                    case 37 -> 183;
                    case 38 -> 202;
                    case 39 -> 240;
                    case 40 -> 180;
                    case 41 -> 1;
                    case 42 -> 157;
                    case 43 -> 23;
                    case 44 -> 120;
                    case 45 -> 7;
                    case 46 -> 58;
                    case 47 -> 222;
                    case 48 -> 31;
                    case 49 -> 80;
                    case 50 -> 250;
                    case 51 -> 40;
                    case 52 -> 200;
                    case 53 -> 249;
                    case 54 -> 135;
                    case 55 -> 127;
                    case 56 -> 11;
                    case 57 -> 246;
                    case 58 -> 64;
                    case 59 -> 42;
                    case 60 -> 153;
                    case 61 -> 177;
                    case 62 -> 82;
                    case 63 -> 119;
                    case 64 -> 68;
                    case 65 -> 152;
                    case 66 -> 196;
                    case 67 -> 149;
                    case 68 -> 92;
                    case 69 -> 72;
                    case 70 -> 121;
                    case 71 -> 21;
                    case 72 -> 179;
                    case 73 -> 57;
                    case 74 -> 47;
                    case 75 -> 194;
                    case 76 -> 86;
                    case 77 -> 238;
                    case 78 -> 48;
                    case 79 -> 205;
                    case 80 -> 30;
                    case 81 -> 247;
                    case 82 -> 130;
                    case 83 -> 90;
                    case 84 -> 83;
                    case 85 -> 97;
                    case 86 -> 89;
                    case 87 -> 12;
                    case 88 -> 52;
                    case 89 -> 220;
                    case 90 -> 71;
                    case 91 -> 10;
                    case 92 -> 207;
                    case 93 -> 84;
                    case 94 -> 4;
                    case 95 -> 163;
                    case 96 -> 77;
                    case 97 -> 93;
                    case 98 -> 229;
                    case 99 -> 78;
                    case 100 -> 34;
                    case 101 -> 145;
                    case 102 -> 206;
                    case 103 -> 103;
                    case 104 -> 8;
                    case 105 -> 35;
                    case 106 -> 79;
                    case 107 -> 204;
                    case 108 -> 45;
                    case 109 -> 6;
                    case 110 -> 132;
                    case 111 -> 236;
                    case 112 -> 245;
                    case 113 -> 62;
                    case 114 -> 46;
                    case 115 -> 110;
                    case 116 -> 74;
                    case 117 -> 56;
                    case 118 -> 0;
                    case 119 -> 133;
                    case 120 -> 199;
                    case 121 -> 142;
                    case 122 -> 66;
                    case 123 -> 128;
                    case 124 -> 215;
                    case 125 -> 104;
                    case 126 -> 99;
                    case 127 -> 134;
                    case 128 -> 175;
                    case 129 -> 19;
                    case 130 -> 96;
                    case 131 -> 106;
                    case 132 -> 117;
                    case 133 -> 186;
                    case 134 -> 138;
                    case 135 -> 253;
                    case 136 -> 88;
                    case 137 -> 198;
                    case 138 -> 234;
                    case 139 -> 191;
                    case 140 -> 124;
                    case 141 -> 70;
                    case 142 -> 32;
                    case 143 -> 237;
                    case 144 -> 25;
                    case 145 -> 51;
                    case 146 -> 91;
                    case 147 -> 122;
                    case 148 -> 217;
                    case 149 -> 178;
                    case 150 -> 17;
                    case 151 -> 20;
                    case 152 -> 18;
                    case 153 -> 53;
                    case 154 -> 95;
                    case 155 -> 161;
                    case 156 -> 228;
                    case 157 -> 69;
                    case 158 -> 115;
                    case 159 -> 166;
                    case 160 -> 167;
                    case 161 -> 139;
                    case 162 -> 203;
                    case 163 -> 230;
                    case 164 -> 242;
                    case 165 -> 190;
                    case 166 -> 49;
                    case 167 -> 244;
                    case 168 -> 41;
                    case 169 -> 27;
                    case 170 -> 184;
                    case 171 -> 118;
                    case 172 -> 63;
                    case 173 -> 254;
                    case 174 -> 114;
                    case 175 -> 192;
                    case 176 -> 44;
                    case 177 -> 116;
                    case 178 -> 9;
                    case 179 -> 81;
                    case 180 -> 111;
                    case 181 -> 73;
                    case 182 -> 171;
                    case 183 -> 126;
                    case 184 -> 232;
                    case 185 -> 233;
                    case 186 -> 154;
                    case 187 -> 164;
                    case 188 -> 22;
                    case 189 -> 24;
                    case 190 -> 212;
                    case 191 -> 155;
                    case 192 -> 150;
                    case 193 -> 107;
                    case 194 -> 2;
                    case 195 -> 188;
                    case 196 -> 125;
                    case 197 -> 140;
                    case 198 -> 137;
                    case 199 -> 181;
                    case 200 -> 160;
                    case 201 -> 87;
                    case 202 -> 151;
                    case 203 -> 197;
                    case 204 -> 241;
                    case 205 -> 131;
                    case 206 -> 162;
                    case 207 -> 251;
                    case 208 -> 208;
                    case 209 -> 14;
                    case 210 -> 29;
                    case 211 -> 61;
                    case 212 -> 248;
                    case 213 -> 33;
                    case 214 -> 225;
                    case 215 -> 50;
                    case 216 -> 213;
                    case 217 -> 156;
                    case 218 -> 147;
                    case 219 -> 226;
                    case 220 -> 75;
                    case 221 -> 211;
                    case 222 -> 39;
                    case 223 -> 201;
                    case 224 -> 65;
                    case 225 -> 136;
                    case 226 -> 235;
                    case 227 -> 146;
                    case 228 -> 158;
                    case 229 -> 26;
                    case 230 -> 28;
                    case 231 -> 239;
                    case 232 -> 37;
                    case 233 -> 100;
                    case 234 -> 112;
                    case 235 -> 165;
                    case 236 -> 224;
                    case 237 -> 218;
                    case 238 -> 94;
                    case 239 -> 214;
                    case 240 -> 227;
                    case 241 -> 195;
                    case 242 -> 55;
                    case 243 -> 148;
                    case 244 -> 108;
                    case 245 -> 187;
                    case 246 -> 54;
                    case 247 -> 172;
                    case 248 -> 255;
                    case 249 -> 5;
                    case 250 -> 141;
                    case 251 -> 216;
                    case 252 -> 176;
                    case 253 -> 102;
                    case 254 -> 243;
                    default -> 210;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 86965952012967L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1454221650 - 15725, -1454221650 - -29529, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 121961327036682L;
                    int n3 = SshAgentIpcService.J();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1435740780 - (char)-21981, -1435740780 - -14428, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 104432897387796L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00f6\u00e1\u00e1\u00ca\u0000\u0003 \u00b6m";
                var4_3 = "\u00f6\u00e1\u00e1\u00ca\u0000\u0003 \u00b6m".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 101;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 36;
                                break;
                            }
                            case 1: {
                                v11 = 61;
                                break;
                            }
                            case 2: {
                                v11 = 90;
                                break;
                            }
                            case 3: {
                                v11 = 125;
                                break;
                            }
                            case 4: {
                                v11 = 3;
                                break;
                            }
                            case 5: {
                                v11 = 25;
                                break;
                            }
                            default: {
                                v11 = 84;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x942) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 113;
                    case 1 -> 236;
                    case 2 -> 51;
                    case 3 -> 112;
                    case 4 -> 48;
                    case 5 -> 98;
                    case 6 -> 151;
                    case 7 -> 99;
                    case 8 -> 59;
                    case 9 -> 179;
                    case 10 -> 239;
                    case 11 -> 14;
                    case 12 -> 116;
                    case 13 -> 186;
                    case 14 -> 188;
                    case 15 -> 175;
                    case 16 -> 159;
                    case 17 -> 109;
                    case 18 -> 21;
                    case 19 -> 117;
                    case 20 -> 227;
                    case 21 -> 6;
                    case 22 -> 224;
                    case 23 -> 174;
                    case 24 -> 167;
                    case 25 -> 235;
                    case 26 -> 76;
                    case 27 -> 124;
                    case 28 -> 211;
                    case 29 -> 73;
                    case 30 -> 93;
                    case 31 -> 121;
                    case 32 -> 221;
                    case 33 -> 216;
                    case 34 -> 225;
                    case 35 -> 142;
                    case 36 -> 114;
                    case 37 -> 248;
                    case 38 -> 41;
                    case 39 -> 205;
                    case 40 -> 136;
                    case 41 -> 108;
                    case 42 -> 91;
                    case 43 -> 49;
                    case 44 -> 145;
                    case 45 -> 35;
                    case 46 -> 138;
                    case 47 -> 37;
                    case 48 -> 177;
                    case 49 -> 46;
                    case 50 -> 1;
                    case 51 -> 190;
                    case 52 -> 84;
                    case 53 -> 157;
                    case 54 -> 128;
                    case 55 -> 126;
                    case 56 -> 193;
                    case 57 -> 40;
                    case 58 -> 148;
                    case 59 -> 81;
                    case 60 -> 219;
                    case 61 -> 47;
                    case 62 -> 0;
                    case 63 -> 105;
                    case 64 -> 67;
                    case 65 -> 220;
                    case 66 -> 170;
                    case 67 -> 95;
                    case 68 -> 212;
                    case 69 -> 146;
                    case 70 -> 131;
                    case 71 -> 27;
                    case 72 -> 68;
                    case 73 -> 199;
                    case 74 -> 160;
                    case 75 -> 69;
                    case 76 -> 15;
                    case 77 -> 111;
                    case 78 -> 201;
                    case 79 -> 173;
                    case 80 -> 78;
                    case 81 -> 82;
                    case 82 -> 185;
                    case 83 -> 233;
                    case 84 -> 62;
                    case 85 -> 36;
                    case 86 -> 253;
                    case 87 -> 237;
                    case 88 -> 44;
                    case 89 -> 243;
                    case 90 -> 42;
                    case 91 -> 144;
                    case 92 -> 103;
                    case 93 -> 134;
                    case 94 -> 74;
                    case 95 -> 66;
                    case 96 -> 5;
                    case 97 -> 232;
                    case 98 -> 19;
                    case 99 -> 149;
                    case 100 -> 9;
                    case 101 -> 213;
                    case 102 -> 208;
                    case 103 -> 196;
                    case 104 -> 64;
                    case 105 -> 166;
                    case 106 -> 155;
                    case 107 -> 180;
                    case 108 -> 17;
                    case 109 -> 118;
                    case 110 -> 2;
                    case 111 -> 244;
                    case 112 -> 50;
                    case 113 -> 158;
                    case 114 -> 43;
                    case 115 -> 24;
                    case 116 -> 57;
                    case 117 -> 130;
                    case 118 -> 97;
                    case 119 -> 187;
                    case 120 -> 107;
                    case 121 -> 90;
                    case 122 -> 52;
                    case 123 -> 251;
                    case 124 -> 150;
                    case 125 -> 154;
                    case 126 -> 45;
                    case 127 -> 250;
                    case 128 -> 195;
                    case 129 -> 77;
                    case 130 -> 255;
                    case 131 -> 165;
                    case 132 -> 198;
                    case 133 -> 168;
                    case 134 -> 94;
                    case 135 -> 11;
                    case 136 -> 206;
                    case 137 -> 242;
                    case 138 -> 127;
                    case 139 -> 254;
                    case 140 -> 139;
                    case 141 -> 63;
                    case 142 -> 214;
                    case 143 -> 18;
                    case 144 -> 87;
                    case 145 -> 169;
                    case 146 -> 101;
                    case 147 -> 172;
                    case 148 -> 143;
                    case 149 -> 184;
                    case 150 -> 132;
                    case 151 -> 29;
                    case 152 -> 56;
                    case 153 -> 119;
                    case 154 -> 16;
                    case 155 -> 61;
                    case 156 -> 218;
                    case 157 -> 60;
                    case 158 -> 141;
                    case 159 -> 245;
                    case 160 -> 38;
                    case 161 -> 192;
                    case 162 -> 156;
                    case 163 -> 10;
                    case 164 -> 163;
                    case 165 -> 191;
                    case 166 -> 183;
                    case 167 -> 210;
                    case 168 -> 171;
                    case 169 -> 100;
                    case 170 -> 71;
                    case 171 -> 96;
                    case 172 -> 178;
                    case 173 -> 123;
                    case 174 -> 246;
                    case 175 -> 4;
                    case 176 -> 182;
                    case 177 -> 194;
                    case 178 -> 234;
                    case 179 -> 13;
                    case 180 -> 189;
                    case 181 -> 133;
                    case 182 -> 89;
                    case 183 -> 202;
                    case 184 -> 161;
                    case 185 -> 164;
                    case 186 -> 162;
                    case 187 -> 120;
                    case 188 -> 92;
                    case 189 -> 75;
                    case 190 -> 197;
                    case 191 -> 85;
                    case 192 -> 79;
                    case 193 -> 204;
                    case 194 -> 7;
                    case 195 -> 110;
                    case 196 -> 12;
                    case 197 -> 238;
                    case 198 -> 240;
                    case 199 -> 8;
                    case 200 -> 83;
                    case 201 -> 26;
                    case 202 -> 54;
                    case 203 -> 217;
                    case 204 -> 32;
                    case 205 -> 135;
                    case 206 -> 137;
                    case 207 -> 222;
                    case 208 -> 20;
                    case 209 -> 223;
                    case 210 -> 200;
                    case 211 -> 215;
                    case 212 -> 209;
                    case 213 -> 25;
                    case 214 -> 102;
                    case 215 -> 122;
                    case 216 -> 53;
                    case 217 -> 226;
                    case 218 -> 247;
                    case 219 -> 129;
                    case 220 -> 203;
                    case 221 -> 58;
                    case 222 -> 231;
                    case 223 -> 104;
                    case 224 -> 39;
                    case 225 -> 80;
                    case 226 -> 55;
                    case 227 -> 23;
                    case 228 -> 153;
                    case 229 -> 176;
                    case 230 -> 70;
                    case 231 -> 30;
                    case 232 -> 207;
                    case 233 -> 125;
                    case 234 -> 34;
                    case 235 -> 152;
                    case 236 -> 3;
                    case 237 -> 252;
                    case 238 -> 147;
                    case 239 -> 140;
                    case 240 -> 31;
                    case 241 -> 33;
                    case 242 -> 86;
                    case 243 -> 65;
                    case 244 -> 28;
                    case 245 -> 241;
                    case 246 -> 88;
                    case 247 -> 181;
                    case 248 -> 230;
                    case 249 -> 228;
                    case 250 -> 249;
                    case 251 -> 22;
                    case 252 -> 106;
                    case 253 -> 115;
                    case 254 -> 72;
                    default -> 229;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

