/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsTestFunctionTransformer;", "", "<init>", "()V", "generateTestFunctionCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "testFunctionContainers", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsTestFunctionTransformer$TestFunctionContainer;", "TestFunctionContainer", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsTestFunctionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTestFunctionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsTestFunctionTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,72:1\n1#2:73\n1504#3:74\n1534#3,3:75\n1537#3,3:85\n382#4,7:78\n*S KotlinDebug\n*F\n+ 1 JsTestFunctionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsTestFunctionTransformer\n*L\n19#1:74\n19#1:75,3\n19#1:85,3\n19#1:78,7\n*E\n"})
public final class JsTestFunctionTransformer {
    @NotNull
    public static final JsTestFunctionTransformer INSTANCE = new JsTestFunctionTransformer();

    private JsTestFunctionTransformer() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsInvocation generateTestFunctionCall(@NotNull List<TestFunctionContainer> testFunctionContainers) {
        void $this$groupByTo$iv$iv;
        JsName jsName;
        Object it2;
        JsFunction testFun;
        block8: {
            Intrinsics.checkNotNullParameter(testFunctionContainers, "testFunctionContainers");
            if (testFunctionContainers.isEmpty()) {
                return null;
            }
            JsBlock testFunBody = new JsBlock();
            testFun = new JsFunction(JsGenerationContextKt.getEmptyScope(), testFunBody, "root test fun");
            for (Object it2 : (Iterable)testFunctionContainers) {
                boolean bl = false;
                jsName = ((TestFunctionContainer)it2).getSuiteFunctionName();
                if (jsName == null) {
                    continue;
                }
                break block8;
            }
            jsName = null;
        }
        if (jsName == null) {
            throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
        }
        JsNameRef jsNameRef = jsName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
        JsNameRef suiteFunRef = jsNameRef;
        Iterable $this$groupBy$iv = testFunctionContainers;
        boolean $i$f$groupBy = false;
        it2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it3;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            TestFunctionContainer it4 = (TestFunctionContainer)element$iv$iv;
            boolean $i$a$-groupBy-JsTestFunctionTransformer$generateTestFunctionCall$tests$32 = false;
            String key$iv$iv = it4.getPackageFqn();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            TestFunctionContainer $i$a$-groupBy-JsTestFunctionTransformer$generateTestFunctionCall$tests$32 = (TestFunctionContainer)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(new JsInvocation((JsExpression)it3.getTestFunctionName().makeRef(), new JsExpression[0]).makeStmt());
        }
        Map tests = destination$iv$iv;
        for (Map.Entry entry : tests.entrySet()) {
            String pkg = (String)entry.getKey();
            List testCalls = (List)entry.getValue();
            JsFunction pkgTestFun = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(), "test fun for " + pkg);
            List<JsStatement> list = pkgTestFun.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            CollectionsKt.addAll((Collection)list, testCalls);
            List<JsStatement> list2 = testFun.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
            Collection collection = list2;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsStringLiteral(pkg), new JsBooleanLiteral(false), pkgTestFun};
            collection.add(new JsInvocation((JsExpression)suiteFunRef, jsExpressionArray).makeStmt());
        }
        return new JsInvocation((JsExpression)testFun, new JsExpression[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsTestFunctionTransformer$TestFunctionContainer;", "", "packageFqn", "", "testFunctionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "suiteFunctionName", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/js/backend/ast/JsName;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getPackageFqn", "()Ljava/lang/String;", "getTestFunctionName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getSuiteFunctionName", "backend.js"})
    public static final class TestFunctionContainer {
        @NotNull
        private final String packageFqn;
        @NotNull
        private final JsName testFunctionName;
        @NotNull
        private final JsName suiteFunctionName;

        public TestFunctionContainer(@NotNull String packageFqn, @NotNull JsName testFunctionName, @NotNull JsName suiteFunctionName) {
            Intrinsics.checkNotNullParameter(packageFqn, "packageFqn");
            Intrinsics.checkNotNullParameter(testFunctionName, "testFunctionName");
            Intrinsics.checkNotNullParameter(suiteFunctionName, "suiteFunctionName");
            this.packageFqn = packageFqn;
            this.testFunctionName = testFunctionName;
            this.suiteFunctionName = suiteFunctionName;
        }

        @NotNull
        public final String getPackageFqn() {
            return this.packageFqn;
        }

        @NotNull
        public final JsName getTestFunctionName() {
            return this.testFunctionName;
        }

        @NotNull
        public final JsName getSuiteFunctionName() {
            return this.suiteFunctionName;
        }
    }
}

