/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor;

import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.KtorUrlMapping;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010 \u00a8\u0006."}, d2={"Lcom/intellij/ktor/KtorUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "urlMapping", "Lcom/intellij/ktor/KtorUrlMapping;", "authorities", "", "Lcom/intellij/microservices/url/Authority;", "<init>", "(Lcom/intellij/ktor/KtorUrlMapping;Ljava/util/List;)V", "getUrlMapping", "()Lcom/intellij/ktor/KtorUrlMapping;", "getAuthorities", "()Ljava/util/List;", "schemes", "", "getSchemes", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "methods", "", "getMethods", "()Ljava/util/Set;", "source", "getSource", "()Ljava/lang/String;", "documentationPsiElement", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "contentTypes", "getContentTypes", "intellij.ktor"})
public final class KtorUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final KtorUrlMapping urlMapping;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Set<String> methods;

    public KtorUrlTargetInfo(@NotNull KtorUrlMapping urlMapping, @NotNull List<? extends Authority> authorities) {
        Intrinsics.checkNotNullParameter((Object)urlMapping, (String)"urlMapping");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.urlMapping = urlMapping;
        this.authorities = authorities;
        this.schemes = this.urlMapping.getRequestMethod().getSchemes();
        this.path = this.urlMapping.getUrlPath();
        Icon icon = KtorStarterIcons.Ktor;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ktor");
        this.icon = icon;
        this.methods = SetsKt.setOf((Object)this.urlMapping.getMethod());
    }

    public /* synthetic */ KtorUrlTargetInfo(KtorUrlMapping ktorUrlMapping, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(ktorUrlMapping, list);
    }

    @NotNull
    public final KtorUrlMapping getUrlMapping() {
        return this.urlMapping;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.urlMapping.getNavigationTarget();
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @NotNull
    public Set<String> getMethods() {
        return this.methods;
    }

    @NotNull
    public String getSource() {
        return UastUrlAttributeUtils.getUastDeclaringLocation((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        return this.urlMapping.getNavigationTarget();
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Set<String> getContentTypes() {
        return this.urlMapping.getContentTypes();
    }
}

