/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.model.BuildTargetState;

public final class JpsLoaderContext {
    private static final Logger LOG = Logger.getInstance(JpsLoaderContext.class);
    private final String commitId;
    private final int totalExpectedDownloads;
    private final JpsNettyClient nettyClient;
    private final CanceledStatus canceledStatus;
    private final Map<String, Map<String, BuildTargetState>> commitSourcesState;
    private final Map<String, Map<String, BuildTargetState>> currentSourcesState;

    private JpsLoaderContext(int totalExpectedDownloads, @NotNull CanceledStatus canceledStatus, @NotNull String commitId, @NotNull JpsNettyClient nettyClient, @NotNull Map<String, Map<String, BuildTargetState>> commitSourcesState, @Nullable Map<String, Map<String, BuildTargetState>> currentSourcesState) {
        if (canceledStatus == null) {
            JpsLoaderContext.$$$reportNull$$$0(0);
        }
        if (commitId == null) {
            JpsLoaderContext.$$$reportNull$$$0(1);
        }
        if (nettyClient == null) {
            JpsLoaderContext.$$$reportNull$$$0(2);
        }
        if (commitSourcesState == null) {
            JpsLoaderContext.$$$reportNull$$$0(3);
        }
        this.commitId = commitId;
        this.nettyClient = nettyClient;
        this.canceledStatus = canceledStatus;
        this.commitSourcesState = commitSourcesState;
        this.currentSourcesState = currentSourcesState;
        this.totalExpectedDownloads = totalExpectedDownloads;
    }

    @NotNull
    public String getCommitId() {
        String string = this.commitId;
        if (string == null) {
            JpsLoaderContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void sendDescriptionStatusMessage(@NotNull String message) {
        if (message == null) {
            JpsLoaderContext.$$$reportNull$$$0(5);
        }
        this.nettyClient.sendDescriptionStatusMessage(message);
    }

    @NotNull
    public JpsNettyClient getNettyClient() {
        JpsNettyClient jpsNettyClient = this.nettyClient;
        if (jpsNettyClient == null) {
            JpsLoaderContext.$$$reportNull$$$0(6);
        }
        return jpsNettyClient;
    }

    @NotNull
    public Map<String, Map<String, BuildTargetState>> getCommitSourcesState() {
        Map<String, Map<String, BuildTargetState>> map = this.commitSourcesState;
        if (map == null) {
            JpsLoaderContext.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Nullable
    public Map<String, Map<String, BuildTargetState>> getCurrentSourcesState() {
        return this.currentSourcesState;
    }

    public int getTotalExpectedDownloads() {
        return this.totalExpectedDownloads;
    }

    public void checkCanceled() throws ProcessCanceledException {
        if (this.canceledStatus.isCanceled()) {
            LOG.info("JPS Caches download process canceled");
            throw new ProcessCanceledException();
        }
    }

    public static JpsLoaderContext createNewContext(int totalExpectedDownloads, @NotNull CanceledStatus canceledStatus, @NotNull String commitId, @NotNull JpsNettyClient nettyClient, @NotNull Map<String, Map<String, BuildTargetState>> commitSourcesState, @Nullable Map<String, Map<String, BuildTargetState>> currentSourcesState) {
        if (canceledStatus == null) {
            JpsLoaderContext.$$$reportNull$$$0(8);
        }
        if (commitId == null) {
            JpsLoaderContext.$$$reportNull$$$0(9);
        }
        if (nettyClient == null) {
            JpsLoaderContext.$$$reportNull$$$0(10);
        }
        if (commitSourcesState == null) {
            JpsLoaderContext.$$$reportNull$$$0(11);
        }
        return new JpsLoaderContext(totalExpectedDownloads, canceledStatus, commitId, nettyClient, commitSourcesState, currentSourcesState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceledStatus";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nettyClient";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitSourcesState";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cache/model/JpsLoaderContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cache/model/JpsLoaderContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNettyClient";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitSourcesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendDescriptionStatusMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNewContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

