/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JacksonUtil;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterExecuteResultOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNbFormatHelpersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.tables.JupyterTableOutputDataKey;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableText;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001aA\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014\u001a \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"getTableDataText", "Lcom/intellij/scientific/tables/api/DSTableText;", "tableDataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getTableOutputDataKey", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "executionCount", "", "isLastForCell", "", "type", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/Integer;ZLcom/intellij/scientific/tables/api/DSTableDataType;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "createTableOutputDataKey", "text", "(Lcom/intellij/scientific/tables/api/DSTableText;Lcom/intellij/scientific/tables/api/DSTableDataType;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Integer;Z)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "detectIsDynamic", "intellij.jupyter.tables"})
public final class ExtractingKt {
    @Nullable
    public static final DSTableText getTableDataText(@NotNull DSTableDataType tableDataType, @NotNull ObjectNode dataObject) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)tableDataType, (String)"tableDataType");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        switch (WhenMappings.$EnumSwitchMapping$0[tableDataType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                pair = TuplesKt.to((Object)MimeType.TEXT_HTML.getMimeType(), (Object)MimeType.TEXT_PLAIN.getMimeType());
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                pair = TuplesKt.to((Object)MimeType.TEXT_PLAIN.getMimeType(), (Object)MimeType.TEXT_PLAIN.getMimeType());
                break;
            }
            case 13: {
                pair = TuplesKt.to((Object)"text", (Object)"text");
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        String primaryKey = (String)pair2.component1();
        String plainKey = (String)pair2.component2();
        String string = JacksonUtil.INSTANCE.keyAsText(dataObject, primaryKey);
        if (string == null) {
            return null;
        }
        String primaryData = string;
        String string2 = JacksonUtil.INSTANCE.keyAsText(dataObject, plainKey);
        if (string2 == null) {
            string2 = "";
        }
        String plainTextData = string2;
        return new DSTableText(primaryData, plainTextData);
    }

    @Nullable
    public static final NotebookOutputDataKey getTableOutputDataKey(@NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer, @NotNull ObjectNode dataObject, @Nullable Integer executionCount, boolean isLastForCell, @Nullable DSTableDataType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        if (type == null) {
            return null;
        }
        DSTableText dSTableText = ExtractingKt.getTableDataText(type, dataObject);
        if (dSTableText == null) {
            return null;
        }
        DSTableText text = dSTableText;
        return ExtractingKt.createTableOutputDataKey(text, type, editor, cellPointer, executionCount, isLastForCell);
    }

    @Nullable
    public static final NotebookOutputDataKey createTableOutputDataKey(@NotNull DSTableText text, @NotNull DSTableDataType type, @NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer, @Nullable Integer executionCount, boolean isLastForCell) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        boolean isDynamic = ExtractingKt.detectIsDynamic(editor, cellPointer, isLastForCell);
        return new JupyterTableOutputDataKey(text, executionCount, type, interval2.getOrdinal(), isDynamic);
    }

    private static final boolean detectIsDynamic(Editor editor, NotebookIntervalPointer cellPointer, boolean isLastForCell) {
        if (!isLastForCell) {
            return false;
        }
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor);
        if (jupyterNotebook == null || (jupyterNotebook = JupyterNbFormatHelpersKt.getCellByPointer((JupyterNotebook)jupyterNotebook, (NotebookIntervalPointer)cellPointer)) == null) {
            return false;
        }
        JupyterNotebook jupyterCell = jupyterNotebook;
        Object object = jupyterCell.getOutputs();
        if (object == null || (object = object.getOutputs()) == null || (object = (JupyterOutput)CollectionsKt.lastOrNull((List)object)) == null) {
            return false;
        }
        Object tableOutput = object;
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (backedNotebookVirtualFile == null) {
            return false;
        }
        BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
        JupyterExecutionManager executionManager = JupyterExecutionManager.Companion.getInstance(project2, notebookVirtualFile);
        boolean hasSession = executionManager.hasSession();
        if (!hasSession) {
            return false;
        }
        ProgressStatus progressStatus = executionManager.getExecutionState().getProgressStatus(cellPointer);
        Object[] objectArray = new ProgressStatus[]{ProgressStatus.STOPPED_OK, ProgressStatus.RUNNING};
        if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)progressStatus)) {
            return false;
        }
        return tableOutput instanceof JupyterExecuteResultOutput;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DSTableDataType.values().length];
            try {
                nArray[DSTableDataType.PANDAS_DATA_FRAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.GENERIC_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.POLARS_DATA_FRAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.POLARS_SERIES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.PANDAS_SERIES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NUMPY_ARRAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NUMPY_RECARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.EAGER_TENSOR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.RESOURCE_VARIABLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.SPARSE_TENSOR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.TORCH_TENSOR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.HF_DATASET.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.PYSPARK_TABLE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.EXTERNAL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.KOTLIN_DATAFRAME.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NOT_ANY.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

