/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class DependencyConflictId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public DependencyConflictId(@NotNull String groupId, @NotNull String artifactId, @Nullable String type, @Nullable String classifier) {
        if (groupId == null) {
            DependencyConflictId.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            DependencyConflictId.$$$reportNull$$$0(1);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = StringUtil.isEmpty((String)type) ? "jar" : type;
        this.classifier = classifier;
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenDomDependency dep) {
        String groupId;
        if (dep == null) {
            DependencyConflictId.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(groupId = dep.getGroupId().getStringValue()))) {
            return null;
        }
        String artifactId = dep.getArtifactId().getStringValue();
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, dep.getType().getStringValue(), dep.getClassifier().getStringValue());
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenArtifact dep) {
        if (dep == null) {
            DependencyConflictId.$$$reportNull$$$0(3);
        }
        return DependencyConflictId.create(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
    }

    @Nullable
    public static DependencyConflictId create(String groupId, String artifactId, String type, String classifier) {
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, type, classifier);
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.type;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyConflictId)) {
            return false;
        }
        DependencyConflictId id = (DependencyConflictId)o;
        if (!this.artifactId.equals(id.artifactId)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(id.classifier) : id.classifier != null) {
            return false;
        }
        if (!this.groupId.equals(id.groupId)) {
            return false;
        }
        return this.type.equals(id.type);
    }

    public int hashCode() {
        int result2 = this.groupId.hashCode();
        result2 = 31 * result2 + this.artifactId.hashCode();
        result2 = 31 * result2 + this.type.hashCode();
        result2 = 31 * result2 + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/DependencyConflictId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/DependencyConflictId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

