/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.constants.RestAnnotations;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class RestImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Collection<String> myImplicitClassAnnotations = Arrays.asList(RestAnnotations.APPLICATION_PATH.javax(), RestAnnotations.APPLICATION_PATH.jakarta(), RestAnnotations.PROVIDER.javax(), RestAnnotations.PROVIDER.jakarta());
    private static final Collection<String> myImplicitWriteAnnotations = Arrays.asList(RestAnnotations.CONTEXT.javax(), RestAnnotations.PATH_PARAM.javax(), RestAnnotations.CONTEXT.jakarta(), RestAnnotations.PATH_PARAM.jakarta());
    private static final Collection<String> myImplicitReadAnnotations = Arrays.asList(RestAnnotations.PATH.javax(), RestAnnotations.GET.javax(), RestAnnotations.PUT.javax(), RestAnnotations.DELETE.javax(), RestAnnotations.POST.javax(), RestAnnotations.HEAD.javax(), RestAnnotations.PATCH.javax(), RestAnnotations.OPTIONS.javax(), RestAnnotations.PATH.jakarta(), RestAnnotations.GET.jakarta(), RestAnnotations.PUT.jakarta(), RestAnnotations.DELETE.jakarta(), RestAnnotations.POST.jakarta(), RestAnnotations.HEAD.jakarta(), RestAnnotations.PATCH.jakarta(), RestAnnotations.OPTIONS.jakarta());

    RestImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            RestImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (RestImplicitUsageProvider.isAnnotated((PsiMember)psiClass, myImplicitClassAnnotations)) {
                return true;
            }
            if (RestImplicitUsageProvider.canBeResourceClass(psiClass) && (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RestAnnotations.PATH.javax(), (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RestAnnotations.PATH.jakarta(), (int)1))) {
                return true;
            }
        }
        return this.isImplicitRead(element) || this.isImplicitWrite(element);
    }

    private static boolean canBeResourceClass(PsiClass element) {
        return !element.isAnnotationType() && !element.isEnum() && !element.isRecord() && !element.isInterface();
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            RestImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiMember)) {
            return false;
        }
        if (RestImplicitUsageProvider.isAnnotated((PsiMember)element, myImplicitReadAnnotations)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        if (!RestImplicitUsageProvider.hasRestLibrary(module)) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiMember)element), Collections.singletonList(RestAnnotations.HTTP_METHOD.fqn(module)));
    }

    private static boolean hasRestLibrary(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)RestAnnotations.PATH.javax()) || JavaLibraryUtil.hasLibraryClass((Module)module, (String)RestAnnotations.PATH.jakarta());
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            RestImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return element instanceof PsiMember && RestImplicitUsageProvider.isAnnotated((PsiMember)element, myImplicitWriteAnnotations);
    }

    public static boolean isAnnotated(PsiMember member, Collection<String> strings) {
        if (strings.isEmpty()) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)member, strings, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/ws/rest/providers/RestImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

