import React from 'react';
import { Href, Markdown } from '../../components';
import { ServerHelpers } from '../../helpers';
export var Security = function (_a) {
    var _b = _a.security, security = _b === void 0 ? [] : _b, _c = _a.protocol, protocol = _c === void 0 ? '' : _c, _d = _a.header, header = _d === void 0 ? 'Security' : _d;
    var renderedSecurities;
    if (!(security === null || security === void 0 ? void 0 : security.length)) {
        if (protocol === 'kafka' || protocol === 'kafka-secure') {
            renderedSecurities = (React.createElement(SecurityItem, { protocol: protocol, securitySchema: null }));
        }
    }
    else {
        var securities = Object.values(security)
            .map(function (requirements) { return requirements.all(); })
            .flat()
            .map(function (requirement) {
            var def = requirement.scheme();
            var requiredScopes = requirement.scopes();
            if (!def) {
                return null;
            }
            return (React.createElement(SecurityItem, { protocol: protocol, securitySchema: def, requiredScopes: requiredScopes, key: def.type() }));
        })
            .filter(Boolean);
        renderedSecurities = (React.createElement("ul", null, securities.map(function (s, idx) { return (React.createElement("li", { className: "mt-2", key: idx }, s)); })));
    }
    if (!renderedSecurities) {
        return null;
    }
    return (React.createElement("div", { className: "text-sm mt-4" },
        React.createElement("h5", { className: "text-gray-800" },
            header,
            ":"),
        renderedSecurities));
};
function collectSecuritySchemas(securitySchema, requiredScopes) {
    if (requiredScopes === void 0) { requiredScopes = []; }
    var schemas = [];
    if (securitySchema) {
        if (securitySchema.name()) {
            schemas.push(React.createElement("span", null,
                "Name: ",
                securitySchema.name()));
        }
        if (securitySchema.in()) {
            schemas.push(React.createElement("span", null,
                "In: ",
                securitySchema.in()));
        }
        if (securitySchema.scheme()) {
            schemas.push(React.createElement("span", null,
                "Scheme: ",
                securitySchema.scheme()));
        }
        if (securitySchema.bearerFormat()) {
            schemas.push(React.createElement("span", null,
                "Bearer format: ",
                securitySchema.bearerFormat()));
        }
        if (securitySchema.openIdConnectUrl()) {
            schemas.push(React.createElement(Href, { href: securitySchema.openIdConnectUrl(), className: "underline" }, "Connect URL"));
        }
        if (requiredScopes.length) {
            schemas.push(React.createElement("span", null,
                "Required scopes: ",
                requiredScopes.join(', ')));
        }
    }
    return schemas;
}
var SecurityItem = function (_a) {
    var securitySchema = _a.securitySchema, protocol = _a.protocol, requiredScopes = _a.requiredScopes;
    var schemas = collectSecuritySchemas(securitySchema, requiredScopes);
    var renderedKafkaSecurity;
    if (['kafka', 'kafka-secure'].includes(protocol)) {
        var _b = ServerHelpers.getKafkaSecurity(protocol, securitySchema), securityProtocol = _b.securityProtocol, saslMechanism = _b.saslMechanism;
        renderedKafkaSecurity = (React.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded" },
            securityProtocol && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "security.protocol:"),
                React.createElement("strong", { className: "inline-block no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, securityProtocol))),
            saslMechanism && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "sasl.mechanism:"),
                React.createElement("strong", { className: "inline-block no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, saslMechanism)))));
    }
    var flows = securitySchema === null || securitySchema === void 0 ? void 0 : securitySchema.flows();
    var unwrappedFlows = {};
    if (flows === null || flows === void 0 ? void 0 : flows.hasImplicit()) {
        unwrappedFlows.implicit = flows.implicit();
    }
    if (flows === null || flows === void 0 ? void 0 : flows.hasAuthorizationCode()) {
        unwrappedFlows.authorizationCode = flows.authorizationCode();
    }
    if (flows === null || flows === void 0 ? void 0 : flows.hasClientCredentials()) {
        unwrappedFlows.clientCredentials = flows.clientCredentials();
    }
    if (flows === null || flows === void 0 ? void 0 : flows.hasPassword()) {
        unwrappedFlows.password = flows.password();
    }
    var renderedFlows = Object.entries(unwrappedFlows).map(function (_a) {
        var flowName = _a[0], flow = _a[1];
        var authorizationUrl = flow.authorizationUrl();
        var tokenUrl = flow.tokenUrl();
        var refreshUrl = flow.refreshUrl();
        var scopes = flow.scopes();
        return (React.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded", key: flowName },
            React.createElement("div", null,
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "Flow:"),
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, ServerHelpers.flowName(flowName))),
            authorizationUrl && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "Auth URL:"),
                React.createElement(Href, { href: authorizationUrl, className: "underline" }, authorizationUrl))),
            tokenUrl && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "Token URL:"),
                React.createElement(Href, { href: tokenUrl, className: "underline" }, tokenUrl))),
            refreshUrl && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "Refresh URL:"),
                React.createElement(Href, { href: refreshUrl, className: "underline" }, refreshUrl))),
            scopes && (React.createElement("div", { className: "mt-1" },
                React.createElement("strong", { className: "text-xs text-gray-600 mt-1 mr-1 uppercase" }, "Scopes:"),
                React.createElement("ul", { className: "inline-block" }, scopes &&
                    Object.entries(scopes).map(function (_a) {
                        var scopeName = _a[0], scopeDesc = _a[1];
                        return (React.createElement("li", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1", title: scopeDesc, key: scopeName }, scopeName));
                    }))))));
    });
    return (React.createElement("div", null,
        securitySchema && schemas && (React.createElement("div", null,
            React.createElement("span", null,
                ServerHelpers.securityType(securitySchema.type()),
                schemas.length > 0 && (React.createElement("ul", { className: "inline-block ml-2" }, schemas.map(function (schema, idx) { return (React.createElement("li", { className: "inline-block font-bold no-underline bg-blue-400 text-white text-xs uppercase rounded px-2 py-0 ml-1", key: idx }, schema)); })))))),
        (securitySchema === null || securitySchema === void 0 ? void 0 : securitySchema.hasDescription()) && (React.createElement("div", null,
            React.createElement(Markdown, null, securitySchema.description()))),
        renderedFlows && renderedFlows.length > 0 && (React.createElement("ul", { className: "my-2" },
            React.createElement("li", null, renderedFlows))),
        renderedKafkaSecurity && React.createElement("div", null, renderedKafkaSecurity)));
};
//# sourceMappingURL=Security.js.map