/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.InlineClassArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.lower.VarargLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "externalVarargs", "", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "getExternalVarargs", "()Ljava/util/Set;", "setExternalVarargs", "(Ljava/util/Set;)V", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "getArgumentFromSingleSegment", "segment", "arrayInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nVarargLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n1807#2,3:261\n*S KotlinDebug\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer\n*L\n129#1:261,3\n*E\n"})
final class VarargTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private Set<IrVararg> externalVarargs;

    public VarargTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.externalVarargs = new LinkedHashSet();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Set<IrVararg> getExternalVarargs() {
        return this.externalVarargs;
    }

    public final void setExternalVarargs(@NotNull Set<IrVararg> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.externalVarargs = set;
    }

    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
        List currentList = new ArrayList();
        List segments2 = new ArrayList();
        InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(this.context, expression2.getVarargElementType(), expression2.getType());
        for (IrVarargElement e : expression2.getElements()) {
            IrVarargElement irVarargElement = e;
            if (irVarargElement instanceof IrSpreadElement) {
                if (!((Collection)currentList).isEmpty()) {
                    segments2.add(arrayInfo.toPrimitiveArrayLiteral(currentList, expression2.getStartOffset(), expression2.getEndOffset()));
                    currentList.clear();
                }
                segments2.add(arrayInfo.unboxElementIfNeeded(((IrSpreadElement)e).getExpression()));
                continue;
            }
            if (!(irVarargElement instanceof IrExpression)) continue;
            currentList.add(arrayInfo.unboxElementIfNeeded((IrExpression)e));
        }
        if (!((Collection)currentList).isEmpty()) {
            segments2.add(arrayInfo.toPrimitiveArrayLiteral(currentList, expression2.getStartOffset(), expression2.getEndOffset()));
            currentList.clear();
        }
        if (segments2.isEmpty()) {
            InlineClassArrayInfo $this$visitVararg_u24lambda_u240 = arrayInfo;
            boolean bl = false;
            return $this$visitVararg_u24lambda_u240.boxArrayIfNeeded($this$visitVararg_u24lambda_u240.toPrimitiveArrayLiteral(CollectionsKt.emptyList(), expression2.getStartOffset(), expression2.getEndOffset()));
        }
        if (segments2.size() == 1) {
            IrExpression segment = (IrExpression)CollectionsKt.first((List)segments2);
            IrExpression argument = this.getArgumentFromSingleSegment(expression2, segment, arrayInfo);
            return arrayInfo.boxArrayIfNeeded(argument);
        }
        IrExpression arrayLiteral = VarargLoweringKt.access$toArrayLiteral(segments2, this.context, (IrType)IrSimpleTypeImplKt.IrSimpleTypeImpl((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (boolean)false, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList()), this.context.getIrBuiltIns().getAnyType(), expression2.getStartOffset(), expression2.getEndOffset());
        IrSimpleFunctionSymbol concatFun = CollectionsKt.contains((Iterable)this.context.getIrBuiltIns().getPrimitiveArraysToPrimitiveTypes().keySet(), (Object)IrTypesKt.getClassifierOrNull((IrType)arrayInfo.getPrimitiveArrayType())) ? this.context.getSymbols().getPrimitiveArrayConcat() : this.context.getSymbols().getArrayConcat();
        IrCallImpl $this$visitVararg_u24lambda_u241 = irCallImpl = BuildersKt.IrCallImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)arrayInfo.getPrimitiveArrayType(), (IrSimpleFunctionSymbol)concatFun, (int)0, null, null, (int)96, null);
        boolean bl = false;
        $this$visitVararg_u24lambda_u241.getArguments().set(0, (Object)arrayLiteral);
        IrCallImpl res2 = irCallImpl;
        return arrayInfo.boxArrayIfNeeded((IrExpression)res2);
    }

    private final IrExpression getArgumentFromSingleSegment(IrVararg expression2, IrExpression segment, InlineClassArrayInfo arrayInfo) {
        IrExpression irExpression;
        IrCallImpl irCallImpl;
        boolean bl;
        block6: {
            if (this.externalVarargs.contains(expression2)) {
                this.externalVarargs.remove(expression2);
                return segment;
            }
            Iterable $this$any$iv = expression2.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                irCallImpl = $this$any$iv.iterator();
                while (irCallImpl.hasNext()) {
                    Object element$iv = irCallImpl.next();
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            IrType elementType = arrayInfo.getPrimitiveElementType();
            IrSimpleFunctionSymbol copyFunction = IrTypePredicatesKt.isChar((IrType)elementType) || IrTypePredicatesKt.isBoolean((IrType)elementType) || IrTypePredicatesKt.isLong((IrType)elementType) ? this.context.getSymbols().getTaggedArrayCopy() : this.context.getSymbols().getJsArraySlice();
            IrCallImpl $this$getArgumentFromSingleSegment_u24lambda_u241 = irCallImpl = BuildersKt.IrCallImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)arrayInfo.getPrimitiveArrayType(), (IrSimpleFunctionSymbol)copyFunction, (int)1, null, null, (int)96, null);
            boolean bl3 = false;
            $this$getArgumentFromSingleSegment_u24lambda_u241.getTypeArguments().set(0, arrayInfo.getPrimitiveArrayType());
            $this$getArgumentFromSingleSegment_u24lambda_u241.getArguments().set(0, (Object)segment);
            irExpression = (IrExpression)irCallImpl;
        } else {
            irExpression = segment;
        }
        return irExpression;
    }

    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid((IrElement)expression2);
        if (((IrFunctionSymbol)expression2.getSymbol()).getOwner().isExternal()) {
            for (IrValueParameter parameter : ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getParameters()) {
                if (parameter.getVarargElementType() == null) continue;
                IrExpression irExpression = expression2.getArguments().get(parameter);
                if ((irExpression instanceof IrVararg ? (IrVararg)irExpression : null) != null) {
                    IrVararg it;
                    it = it;
                    boolean bl = false;
                    this.externalVarargs.add(it);
                }
            }
        }
        for (Pair pair : IrUtilsKt.getAllArgumentsWithIr((IrMemberAccessExpression)((IrMemberAccessExpression)expression2))) {
            InlineClassArrayInfo arrayInfo;
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrExpression argument = (IrExpression)pair.component2();
            IrType varargElementType = parameter.getVarargElementType();
            if (argument != null || varargElementType == null) continue;
            InlineClassArrayInfo $this$visitFunctionAccess_u24lambda_u241 = arrayInfo = new InlineClassArrayInfo(this.context, varargElementType, parameter.getType());
            boolean bl = false;
            IrExpression emptyArray = $this$visitFunctionAccess_u24lambda_u241.boxArrayIfNeeded($this$visitFunctionAccess_u24lambda_u241.toPrimitiveArrayLiteral(CollectionsKt.emptyList(), -1, -1));
            expression2.getArguments().set(parameter, emptyArray);
        }
        return (IrExpression)expression2;
    }
}

