/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehavior;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.actions.ShortcutsKt;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rdserver.actions.BackendDelegatingActionIdsProvider;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/actions/DefaultBackendDelegatingActionIdsProvider;", "Lcom/jetbrains/rdserver/actions/BackendDelegatingActionIdsProvider;", "<init>", "()V", "getConditionallyWhiteListedIds", "", "", "Lcom/jetbrains/rd/actions/AccessRequirements;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "getActionIds", "", "getAccessRequirements", "actionId", "getCallStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "isBlackListed", "", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "isWhiteListed", "getDuplicatedActionIds", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nDefaultBackendDelegatingActionIdsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBackendDelegatingActionIdsProvider.kt\ncom/jetbrains/rdserver/actions/DefaultBackendDelegatingActionIdsProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1186:1\n540#2:1187\n525#2,6:1188\n296#3,2:1194\n1807#3,3:1196\n1807#3,3:1199\n67#4,4:1202\n67#4,4:1206\n13#4:1211\n1#5:1210\n*S KotlinDebug\n*F\n+ 1 DefaultBackendDelegatingActionIdsProvider.kt\ncom/jetbrains/rdserver/actions/DefaultBackendDelegatingActionIdsProvider\n*L\n1083#1:1187\n1083#1:1188,6\n1105#1:1194,2\n1142#1:1196,3\n1143#1:1199,3\n1150#1:1202,4\n1152#1:1206,4\n35#1:1211\n*E\n"})
public final class DefaultBackendDelegatingActionIdsProvider
implements BackendDelegatingActionIdsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> blackListByWords = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> blackListByInterface = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> whiteListByInterface = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> actionChangedFrontendToBackend = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> actionChangedBackendToFrontend = new LinkedHashMap();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AccessRequirements.Listed BUILD_ACCESS;
    @NotNull
    private static final AccessRequirements.Listed WRITE_ACCESS;
    @NotNull
    private static final AccessRequirements.Listed READ_ACCESS;
    @NotNull
    private static final AccessRequirements.Listed RUN_ACCESS;
    @NotNull
    private static final Map<String, ActionCallStrategyKind> ACTION_TO_STRATEGY;
    @Language(value="devkit-action-id")
    @NotNull
    private static final Map<String, AccessRequirements.Listed> EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS;
    @Language(value="devkit-action-id")
    @NotNull
    private static final Map<String, AccessRequirements> ACTION_IDS;
    @Language(value="devkit-action-id")
    @NotNull
    private static final Set<String> BLACK_LISTED_ACTION_IDS;
    @NotNull
    private static final Set<String> BLACK_LISTED_SUBSTRINGS;
    @Language(value="devkit-action-id")
    @NotNull
    private static final Map<String, AccessRequirements.Listed> DEBUGGER_WHITE_LISTED_IDS;
    private static final KeyStroke ENTER_KEY_STROKE;
    @NotNull
    private static final KeyboardShortcut ENTER_SHORTCUT;
    @NotNull
    private static final Map<Shortcut, String> BLACK_LISTED_SHORTCUTS;
    @NotNull
    private static final Set<String> WERE_BLACK_LISTED_BY_WORD_SHOULD_BE;
    @NotNull
    private static final Set<String> WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE;
    @NotNull
    private static final Set<String> WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_PREFIXES;
    @NotNull
    private static final Set<String> WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_BY_PACKAGE_PREFIXES;

    private final Map<String, AccessRequirements> getConditionallyWhiteListedIds(ClientAppSession session) {
        if (BackendDebuggerHost.Companion.useLuxDebugger(session)) {
            return DEBUGGER_WHITE_LISTED_IDS;
        }
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getActionIds(@NotNull ClientAppSession session) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map<String, ActionCallStrategyKind> map2 = ACTION_TO_STRATEGY;
        Set set = SetsKt.plus(ACTION_IDS.keySet(), (Iterable)this.getConditionallyWhiteListedIds(session).keySet());
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(it.getValue() == ActionCallStrategyKind.Backend || it.getValue() == ActionCallStrategyKind.BackendWhenAvailableByHint)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return SetsKt.plus((Set)set, (Iterable)destination$iv$iv.keySet());
    }

    @Override
    @Nullable
    public AccessRequirements getAccessRequirements(@NotNull String actionId, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        AccessRequirements accessRequirements = ACTION_IDS.get(actionId);
        if (accessRequirements == null && (accessRequirements = this.getConditionallyWhiteListedIds(session).get(actionId)) == null) {
            accessRequirements = (AccessRequirements)EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS.get(actionId);
        }
        return accessRequirements;
    }

    @Override
    @Nullable
    public ActionCallStrategyKind getCallStrategy(@NotNull String actionId, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ActionCallStrategyKind callStrategyKind = ACTION_TO_STRATEGY.get(actionId);
        if (callStrategyKind != null) {
            return callStrategyKind;
        }
        if (EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS.containsKey(actionId)) {
            return ActionCallStrategyKind.FrontendFirst;
        }
        return null;
    }

    @Override
    public boolean isBlackListed(@NotNull String actionId, @NotNull ClientAppSession session) {
        boolean blackListed;
        Object v0;
        boolean inExplicitBlackList;
        block24: {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            inExplicitBlackList = BLACK_LISTED_ACTION_IDS.contains(actionId);
            Iterable $this$firstOrNull$iv = BLACK_LISTED_SUBSTRINGS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)actionId, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block24;
            }
            v0 = null;
        }
        String substringThatBlacklisted = v0;
        boolean hasBlackListedSubstring = substringThatBlacklisted != null;
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (anAction == null) {
            return false;
        }
        AnAction action = anAction;
        ActionRemoteBehavior actionRemoteBehavior = ActionRemoteBehaviorSpecification.Companion.getActionDeclaredBehavior(action);
        boolean blackListedByInterface = switch (actionRemoteBehavior == null ? -1 : WhenMappings.$EnumSwitchMapping$0[actionRemoteBehavior.ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            default -> false;
        };
        boolean bl = blackListed = inExplicitBlackList || blackListedByInterface;
        if (logger.isTraceEnabled()) {
            boolean whiteListedByInterface;
            if (hasBlackListedSubstring && !blackListedByInterface) {
                actionChangedFrontendToBackend.put(actionId, substringThatBlacklisted);
            }
            if (!hasBlackListedSubstring && blackListedByInterface) {
                actionChangedBackendToFrontend.put(actionId, substringThatBlacklisted);
            }
            boolean bl2 = whiteListedByInterface = ActionRemoteBehaviorSpecification.Companion.getActionDeclaredBehavior(action) == ActionRemoteBehavior.BackendOnly;
            if (blackListedByInterface) {
                blackListByInterface.put(actionId, substringThatBlacklisted);
            }
            if (whiteListedByInterface) {
                whiteListByInterface.put(actionId, substringThatBlacklisted);
            }
            if (!(!hasBlackListedSubstring || blackListedByInterface || whiteListedByInterface || WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE.contains(actionId) || WERE_BLACK_LISTED_BY_WORD_SHOULD_BE.contains(actionId))) {
                String it;
                boolean bl3;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block25: {
                    $this$any$iv = WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_PREFIXES;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith((String)actionId, (String)it, (boolean)true)) continue;
                            bl3 = true;
                            break block25;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) {
                    boolean bl5;
                    block26: {
                        $this$any$iv = WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_BY_PACKAGE_PREFIXES;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl6 = false;
                                String string = action.getClass().getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                if (!StringsKt.startsWith((String)string, (String)it, (boolean)true)) continue;
                                bl5 = true;
                                break block26;
                            }
                            bl5 = false;
                        }
                    }
                    if (!(bl5 || DEBUGGER_WHITE_LISTED_IDS.containsKey(actionId) || ACTION_IDS.containsKey(actionId) || EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS.containsKey(actionId))) {
                        blackListByWords.put(actionId, substringThatBlacklisted);
                    }
                }
            }
            if (blackListed) {
                Logger logger;
                Logger $this$trace$iv = DefaultBackendDelegatingActionIdsProvider.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl7 = false;
                    logger.trace("Action " + actionId + " is blacklisted: inExplicitBlackList=" + inExplicitBlackList + ", hasBlackListedSubstring=" + hasBlackListedSubstring + ", substring=" + substringThatBlacklisted);
                }
                if (ActionManager.getInstance().isGroup(actionId)) {
                    $this$trace$iv = DefaultBackendDelegatingActionIdsProvider.logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl8 = false;
                        logger.trace("Action " + actionId + " is a group and blacklisted. Consider enabling this group on backend.");
                    }
                }
            }
        }
        return blackListed;
    }

    @Override
    public boolean isBlackListed(@NotNull String actionId, @NotNull Shortcut shortcut, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (ShortcutsKt.isUpperLetter((Shortcut)shortcut) || ShortcutsKt.isSingleFirstLetter((Shortcut)shortcut)) {
            return true;
        }
        String string = BLACK_LISTED_SHORTCUTS.get(shortcut);
        if (string == null) {
            return false;
        }
        String allowedActionId = string;
        return !Intrinsics.areEqual((Object)actionId, (Object)allowedActionId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isWhiteListed(@NotNull String actionId, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (ACTION_IDS.keySet().contains(actionId)) return true;
        if (this.getConditionallyWhiteListedIds(session).keySet().contains(actionId)) return true;
        ActionCallStrategyKind it = ACTION_TO_STRATEGY.get(actionId);
        boolean bl = false;
        if (it == ActionCallStrategyKind.Backend) return true;
        if (it == ActionCallStrategyKind.BackendWhenAvailableByHint) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (this.getDuplicatedActionIds(session).contains(actionId)) return true;
        if (!EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS.containsKey(actionId)) return false;
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getDuplicatedActionIds(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (PluginManagerCore.isRunningFromSources()) {
            return CollectionsKt.listOf((Object)"ShowLog");
        }
        return CollectionsKt.emptyList();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultBackendDelegatingActionIdsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DefaultBackendDelegatingActionIdsProvider.logger = logger;
        Object[] objectArray = new AccessLevelMarker[]{FileAccessLevel.FullAccess, RunAccessLevel.FullAccess};
        BUILD_ACCESS = AccessRequirements.Companion.of((AccessLevelMarker[])objectArray);
        objectArray = new AccessLevelMarker[]{FileAccessLevel.FullAccess};
        WRITE_ACCESS = AccessRequirements.Companion.of((AccessLevelMarker[])objectArray);
        objectArray = new AccessLevelMarker[]{FileAccessLevel.Readonly};
        READ_ACCESS = AccessRequirements.Companion.of((AccessLevelMarker[])objectArray);
        objectArray = new AccessLevelMarker[]{RunAccessLevel.FullAccess};
        RUN_ACCESS = AccessRequirements.Companion.of((AccessLevelMarker[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"EditorEscape", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"NextTemplateVariable", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"PreviousTemplateVariable", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"EditorEnter", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"EditorChooseLookupItem", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"EditorChooseLookupItemReplace", (Object)ActionCallStrategyKind.FrontendFirst), TuplesKt.to((Object)"EditorChooseLookupItemCompleteStatement", (Object)ActionCallStrategyKind.FrontendFirst)};
        ACTION_TO_STRATEGY = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"EditorPaste", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorPasteSimple", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDelete", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDeleteToWordStart", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDeleteToWordEnd", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDeleteLine", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorEnter", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorStartNewLine", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorSplitLine", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorTextStart", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorTextEnd", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorForwardParagraph", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorBackwardParagraph", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorForwardParagraphWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorBackwardParagraphWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorTextStartWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorTextEndWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorLineStart", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorLineEnd", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorLineStartWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorLineEndWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorBackSpace", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorLeftWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorRightWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorUpWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorDownWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorSwapSelectionBoundaries", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorUp", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorLeft", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorDown", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorRight", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorNextWord", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorPreviousWord", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorNextWordWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorPreviousWordWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorTab", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorJoinLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorToggleCase", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorStartNewLineBefore", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorIndentSelection", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorUnindentSelection", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MoveLineUp", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MoveLineDown", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDuplicate", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorDuplicateLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorSortLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorReverseLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorEscape", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorChooseLookupItem", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorChooseLookupItemReplace", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorChooseLookupItemCompleteStatement", (Object)WRITE_ACCESS)};
        EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"$Undo", (Object)WRITE_ACCESS), TuplesKt.to((Object)"$Redo", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorSelectWord", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorUnSelectWord", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorToggleStickySelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorEscape", (Object)READ_ACCESS), TuplesKt.to((Object)"MoveStatementUp", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MoveStatementDown", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorCompleteStatement", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MoveElementLeft", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MoveElementRight", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorCodeBlockStart", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorCodeBlockEnd", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorCodeBlockStartWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorCodeBlockEndWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"CommentByBlockComment", (Object)WRITE_ACCESS), TuplesKt.to((Object)"CommentByLineComment", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ParameterInfo", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorCut", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EditorCopy", (Object)READ_ACCESS), TuplesKt.to((Object)"$Cut", (Object)WRITE_ACCESS), TuplesKt.to((Object)"$Copy", (Object)READ_ACCESS), TuplesKt.to((Object)"$Paste", (Object)WRITE_ACCESS), TuplesKt.to((Object)"CompileDirty", (Object)BUILD_ACCESS), TuplesKt.to((Object)"Build", (Object)BUILD_ACCESS), TuplesKt.to((Object)"MoreRunToolbarActions", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.ToolWindow.TopToolbar", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.ToolWindow.TopToolbar3", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.ToolWindow.TopToolbar3.Extra", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.Frames.Tree.Popup", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.Variables.Tree.Popup", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.Watches.Tree.Popup", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.ValueGroup", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.ViewAsGroup", (Object)RUN_ACCESS), TuplesKt.to((Object)"DebuggingActionsGroup", (Object)RUN_ACCESS), TuplesKt.to((Object)"RunClass", (Object)RUN_ACCESS), TuplesKt.to((Object)"DebugClass", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.PopFrame", (Object)RUN_ACCESS), TuplesKt.to((Object)"StepIntoMyCode", (Object)RUN_ACCESS), TuplesKt.to((Object)"StreamTracerAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.CallTracer", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.StepOutOfBlock", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.ForceEarlyReturn", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.ThrowException", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.CustomizeThreadsView", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.AddSteppingFilter", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.AsyncStacks", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.NewCustomField", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.ViewText", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.ShowTypes", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.MuteRenderers", (Object)RUN_ACCESS), TuplesKt.to((Object)"ShowFullyQualifiedTypeNamesSettingAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"ShowHexValueForIntegersSettingAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"RawNodeForDebuggerBrowsableValuesSettingAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"ShowCompilerGeneratedMembersAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"ShowTypeVariables", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.PinToTop", (Object)RUN_ACCESS), TuplesKt.to((Object)"SetDataBreakpoint", (Object)RUN_ACCESS), TuplesKt.to((Object)"RiderDebuggerDisableMethodToInvokeAction", (Object)RUN_ACCESS), TuplesKt.to((Object)"DumpThreads", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExportToEclipse", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExportToHTML", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"LocalHistory.PutLabel", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"LocalHistory.ShowHistory", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"LocalHistory.ShowSelectionHistory", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"NewJavaDiagram", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"NewModulesDiagram", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Print", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"AssociateWithFileType", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ToggleReadOnlyAttribute", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"RecentChanges", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"TogglePresentationAssistantAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"EditorToggleShowBreadcrumbs", (Object)READ_ACCESS), TuplesKt.to((Object)"SaveDocument", (Object)WRITE_ACCESS), TuplesKt.to((Object)"SaveAll", (Object)WRITE_ACCESS), TuplesKt.to((Object)"OptimizeImports", (Object)WRITE_ACCESS), TuplesKt.to((Object)"AutoIndentLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EmacsStyleIndent", (Object)WRITE_ACCESS), TuplesKt.to((Object)"GotoDeclaration", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoTypeDeclaration", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoSuperMethod", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoImplementation", (Object)READ_ACCESS), TuplesKt.to((Object)"FindUsages", (Object)READ_ACCESS), TuplesKt.to((Object)"ShowUsages", (Object)READ_ACCESS), TuplesKt.to((Object)"EditorMatchBrace", (Object)READ_ACCESS), TuplesKt.to((Object)"QuickImplementations", (Object)READ_ACCESS), TuplesKt.to((Object)"UsageGrouping.FileStructure", (Object)READ_ACCESS), TuplesKt.to((Object)"DelegateMethods", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ImplementMethods", (Object)WRITE_ACCESS), TuplesKt.to((Object)"OverrideMethods", (Object)WRITE_ACCESS), TuplesKt.to((Object)"InspectCode", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CodeCleanup", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"RunInspection", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ViewOfflineInspection", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"InferNullity", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"DupLocate", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"SliceBackward", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"SliceForward", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowPackageDeps", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowBackwardPackageDeps", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowModulesDependencies", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowPackageCycles", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"DSM.Analyze", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Unscramble", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"SaveAsTemplate", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowReformatFileDialog", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Generate", (Object)WRITE_ACCESS), TuplesKt.to((Object)"SurroundWith", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MethodDown", (Object)WRITE_ACCESS), TuplesKt.to((Object)"MethodUp", (Object)WRITE_ACCESS), TuplesKt.to((Object)"CodeCompletion", (Object)WRITE_ACCESS), TuplesKt.to((Object)"SmartTypeCompletion", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ClassNameCompletion", (Object)WRITE_ACCESS), TuplesKt.to((Object)"RenameElement", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ChangeSignature", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ConvertToInstanceMethod", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CopyElement", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"EncapsulateFields", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExtractClass", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExtractInterface", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExtractSuperclass", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Generify", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"InheritanceToDelegation", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Inline", (Object)WRITE_ACCESS), TuplesKt.to((Object)"IntroduceFunctionalParameter", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"IntroduceParameterObject", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"IntroduceVariable", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"InvertBoolean", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"MakeStatic", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"MembersPullUp", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"MemberPushDown", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"MethodDuplicates", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Move", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"NewMigration", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"RenameFile", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ReplaceMethodWithMethodObject", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"SafeDelete", (Object)WRITE_ACCESS), TuplesKt.to((Object)"TurnRefsToSuper", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.httpClient.actions.ConvertCurlToHttpRequestAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.space.actions.SpaceLoginAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.space.actions.SpaceLogoutAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.space.vcs.clone.SpaceCloneAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.space.vcs.share.SpaceShareProjectAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.jetbrains.php.composer.ComposerInitSupportAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.jetbrains.php.framework.FrameworkRunConsoleAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.jetbrains.plugins.remotesdk.console.RunSshConsoleAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"com.intellij.restructuredtext.python.sphinx.RunSphinxQuickStartAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ComposerSelfUpdateAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"context.load", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"context.save", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"context.clear", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CreateSetupPy", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"DBGPProxy.Init", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"DBGPProxy.Stop", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"GenerateJavadoc", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Groovy.Console", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"HTTPClient.NewRequestInToolMenuAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"JShell.Console", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Markdown.ImportFromDocx", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"PsiViewer", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"PsiViewerForContext", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"tasks.configure.servers", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"tasks.create.changelist", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"tasks.edit", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"tasks.goto", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"tasks.switch", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"WebDeployment.BrowseServers", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"WebDeployment.Options", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"WebServicesPlugin.GenerateJAXBSchemasFromJava", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"WebServicesPlugin.GenerateWsdlFromJava", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"WebServicesPlugin.MonitorSoapMessages", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"XdebugAnalyzeProfilerSnapshotAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectViewPopupMenu", (Object)READ_ACCESS), TuplesKt.to((Object)"SolutionViewContextMenu", (Object)READ_ACCESS), TuplesKt.to((Object)"NewGroup", (Object)WRITE_ACCESS), TuplesKt.to((Object)"NewModuleInGroup", (Object)WRITE_ACCESS), TuplesKt.to((Object)"NewElement", (Object)WRITE_ACCESS), TuplesKt.to((Object)"CompareTwoFiles", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowUmlDiagram", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ShowUmlDiagramPopup", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"UML.ShowChanges", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"TypeHierarchy", (Object)READ_ACCESS), TuplesKt.to((Object)"HighlightUsagesInFile", (Object)READ_ACCESS), TuplesKt.to((Object)"CopyReference", (Object)READ_ACCESS), TuplesKt.to((Object)"ContextRun", (Object)RUN_ACCESS), TuplesKt.to((Object)"ContextDebug", (Object)RUN_ACCESS), TuplesKt.to((Object)"RerunFailedTests", (Object)RUN_ACCESS), TuplesKt.to((Object)"Rerun", (Object)RUN_ACCESS), TuplesKt.to((Object)"Annotate", (Object)READ_ACCESS), TuplesKt.to((Object)"ChooseRunConfiguration", (Object)RUN_ACCESS), TuplesKt.to((Object)"ChooseDebugConfiguration", (Object)RUN_ACCESS), TuplesKt.to((Object)"Git.Branches", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Clone", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Configure.Remotes", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.CreateNewBranch", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Merge", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Pull", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Rebase", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Reset", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Stash", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Tag", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Unstash", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Fetch", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Git.Add", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Github.Create.Gist", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Github.Share", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Vcs.Push", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Vcs.RollbackChangedLines", (Object)WRITE_ACCESS), TuplesKt.to((Object)"Vcs.ShowDiffChangedLines", (Object)READ_ACCESS), TuplesKt.to((Object)"Vcs.UpdateProject", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Vcs.ShowHistoryForBlock", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Vcs.ShowTabbedFileHistory", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"Vcs.QuickListPopupAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CheckinFiles", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CheckinProject", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"CompareClipboardWithSelection", (Object)READ_ACCESS), TuplesKt.to((Object)"Compare.SameVersion", (Object)READ_ACCESS), TuplesKt.to((Object)"Diff.ShowDiff", (Object)READ_ACCESS), TuplesKt.to((Object)"ChangesView.ApplyPatch", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ChangesView.CreatePatch", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ChangesView.GroupBy", (Object)READ_ACCESS), TuplesKt.to((Object)"ChangesView.GroupBy.Directory", (Object)READ_ACCESS), TuplesKt.to((Object)"ChangesView.GroupBy.Module", (Object)READ_ACCESS), TuplesKt.to((Object)"ChangesView.GroupBy.Repository", (Object)READ_ACCESS), TuplesKt.to((Object)"ChangesView.Revert", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ChangesView.Shelve", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"EditSource", (Object)READ_ACCESS), TuplesKt.to((Object)"BackendBeControlsDSLShowCase", (Object)READ_ACCESS), TuplesKt.to((Object)"com.intellij.space.vcs.actions.SpaceMainToolBarAction", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ExternalSystem.ProjectRefreshActionGroup", (Object)RUN_ACCESS), TuplesKt.to((Object)"ToggleBookmark", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark0", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark1", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark2", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark3", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark4", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark5", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark6", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark7", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark8", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmark9", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkA", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkB", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkC", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkD", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkE", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkF", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkG", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkH", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkI", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkJ", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkK", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkL", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkM", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkN", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkO", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkP", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkQ", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkR", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkS", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkT", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkU", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkV", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkW", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkX", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkY", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ToggleBookmarkZ", (Object)WRITE_ACCESS), TuplesKt.to((Object)"DeleteMnemonicFromBookmark", (Object)WRITE_ACCESS), TuplesKt.to((Object)"GotoBookmark0", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark1", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark2", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark3", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark4", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark5", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark6", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark7", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark8", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmark9", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkA", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkB", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkC", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkD", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkE", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkF", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkG", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkH", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkI", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkJ", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkK", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkL", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkM", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkN", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkO", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkP", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkQ", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkR", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkS", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkT", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkU", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkV", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkW", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkX", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkY", (Object)READ_ACCESS), TuplesKt.to((Object)"GotoBookmarkZ", (Object)READ_ACCESS), TuplesKt.to((Object)"ToggleRenderedDocPresentationForAll", (Object)READ_ACCESS), TuplesKt.to((Object)"DocCommentGutterIconContextMenu", (Object)READ_ACCESS), TuplesKt.to((Object)"ToggleRenderedDocPresentation", (Object)READ_ACCESS), TuplesKt.to((Object)"TodoViewGroupByGroup", (Object)READ_ACCESS), TuplesKt.to((Object)"TodoViewGroupByShowModules", (Object)READ_ACCESS), TuplesKt.to((Object)"TodoViewGroupByShowPackages", (Object)READ_ACCESS), TuplesKt.to((Object)"TodoViewGroupByFlattenPackage", (Object)READ_ACCESS), TuplesKt.to((Object)"CallInlineCompletionAction", (Object)WRITE_ACCESS), TuplesKt.to((Object)"CallMultiLineCompletionAction", (Object)WRITE_ACCESS), TuplesKt.to((Object)"ShowTips", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ViewInplaceComments", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowModules", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowMembers", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowExcludedFiles", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowVisibilityIcons", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowLibraryContents", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ShowScratchesAndConsoles", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.FlattenModules", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.FlattenPackages", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.HideEmptyMiddlePackages", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.AbbreviatePackageNames", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.CompactDirectories", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.ManualOrder", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.SortByName", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.SortByType", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.SortByTimeDescending", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.SortByTimeAscending", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"ProjectView.FoldersAlwaysOnTop", (Object)AccessRequirements.Owner.INSTANCE), TuplesKt.to((Object)"QuickEvaluateExpression", (Object)RUN_ACCESS), TuplesKt.to((Object)"FrontendMarkObjectAction", (Object)RUN_ACCESS)};
        ACTION_IDS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"CodeWithMeUsersAction", "CWMHostShowPopupAction", "EditorToggleColumnMode", "Exit", "GotoAction", "GotoClass", "GotoFile", "GotoLine", "GotoSymbol", "QuickDocCopy", "QuickJavaDoc", "RunConfiguration", "RedesignedRunConfigurationSelector", "StopWithDropDown", "RunToolbarMainActionGroup", "RunToolbarMainActionsGroup", "RunToolbarActionsGroup", "RunToolbarSlotContextMenuGroup", "SearchEverywhere", "SettingsEntryPoint", "Switcher", "ToggleLineBreakpoint", "CacheRecovery", "CleanupEventLog", "ExternalToolsGroup", "GenerateFromTestCreatorsGroup", "MacrosGroup", "NewFromTemplate", "ServiceViewItemPopupGroup", "ServiceViewItemToolbarGroup", "UpdateEventsSchemeAction", "Internal", "FindInPath", "ReplaceInPath", "FindSelectionInPath", "EditorPageUp", "EditorPageDown", "EditorScrollDown", "EditorScrollUp", "EditorLookupDown", "EditorLookupUp", "EditorMoveToPageBottom", "EditorMoveToPageTop", "HostCodeWithMeMainGroup", "CopyJoinLinkAction", "CurrentLeadUnfollowAction", "OpenCallWindowAction", "EnableVoiceCallAction", "EscUnfollowUserAction", "ForceOthersToFollowAction", "GetJoinLinkAction", "JoinCallAction", "ShowPermissionsAction", "ShutdownCodeWithMe", "SingleUserFollowAction", "SingleJumpToCursorAction", "Find", "Replace", "FindNext", "FindPrevious", "SelectAllOccurrences", "SelectNextOccurrence", "UnselectPreviousOccurrence", "FindWordAtCaret", "FindPrevWordAtCaret", "$SelectAll", "EditMacros", "PlaybackLastMacro", "PlaySavedMacrosAction", "StartStopMacroRecording", "ChangeCodeStyleScheme", "ChangeColorScheme", "ChangeInspectionProfile", "ChangeKeymap", "ChangeLaf", "ChangeView", "CompareClipboardWithSelection", "CustomizeUI", "EditorSetContentBasedBidiTextDirection", "EditorSetLtrBidiTextDirection", "EditorSetRtlBidiTextDirection", "RecentChangedFiles", "RecentFiles", "RecentLocations", "QuickChangeScheme", "ViewMembersInNavigationBar", "ViewNavigationBar", "ViewToolBar", "Back", "Forward", "Coverage", "DlvRewindAction", "GenerateCoverageReport", "GoCoreDumpAction", "GoReplayTraceAction", "ImportTestsFromFile", "ManageTargets", "PhpValidateWebServer", "Profiler", "SetNextStatement", "StopBackgroundProcesses", "liveedit.UpdateRunningApplication", "WindowMenu", "RestoreDefaultLayout", "StoreDefaultLayout", "About", "CaptureCPUUsageData", "CaptureMemorySnapShot", "CheckForUpdate", "CollectZippedLogs", "CollectTroubleshootingInformation", "DeleteOldAppDirs", "EditCustomProperties", "EditCustomVmOptions", "OnlineDocAction", "ProductivityGuide", "Register", "ReportProblem", "SendFeedback", "TechnicalSupport", "WhatsNewAction", "Console.TableResult.ColumnVisibility", "SplitChooser.SplitCenter", "QuickPreview", "BraceOrQuoteOut", "ExpandLiveTemplateByTab", "GuiDesigner.IncreaseIndent", "NextParameter", "SearchEverywhere.NextTab", "SearchEverywhere.CompleteCommand", "SplitChooser.NextWindow", "PrevParameter", "Graph.ActualSize", "GuiDesigner.CreateListener", "RunToolbarWidgetAction", "NewUiRunWidget", "ShowExecutionPoint", "StepOver", "StepInto", "SmartStepInto", "ForceStepInto", "StepOut", "TouchBarDebug.StepButtons", "TouchBarDebug.ForceStepButtons", "RunToCursor", "ForceRunToCursor", "EvaluateExpression", "Resume", "Pause", "ViewBreakpoints", "XDebugger.MuteBreakpoints", "Debugger.AddToWatch", "XDebugger.NewWatch", "XDebugger.RemoveWatch", "XDebugger.EditWatch", "XDebugger.CopyWatch", "XDebugger.SetValue", "XDebugger.CopyValue", "QuickEvaluateExpression"};
        BLACK_LISTED_ACTION_IDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"Break", "Close", "CodeWithMe", "CWM", "Collapse", "Config", "Expand", "Fold", "Help", "Hide", "List-", "NavBar-", "PopupMenu-", "Tree-", "Maximize", "Minimize", "Open", "Reopen", "Performance", "performance", "Problems", "Pin", "Unpin", "Resize", "Select", "select", "Show", "Split", "Unsplit", "Search", "Step", "Stretch", "Tab", "Toggle", "Welcome", "Window", "Zoom"};
        BLACK_LISTED_SUBSTRINGS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"StepOver", (Object)RUN_ACCESS), TuplesKt.to((Object)"StepInto", (Object)RUN_ACCESS), TuplesKt.to((Object)"SmartStepInto", (Object)RUN_ACCESS), TuplesKt.to((Object)"ForceStepInto", (Object)RUN_ACCESS), TuplesKt.to((Object)"StepOut", (Object)RUN_ACCESS), TuplesKt.to((Object)"TouchBarDebug.StepButtons", (Object)RUN_ACCESS), TuplesKt.to((Object)"TouchBarDebug.ForceStepButtons", (Object)RUN_ACCESS), TuplesKt.to((Object)"RunToCursor", (Object)RUN_ACCESS), TuplesKt.to((Object)"ForceRunToCursor", (Object)RUN_ACCESS), TuplesKt.to((Object)"Resume", (Object)RUN_ACCESS), TuplesKt.to((Object)"Pause", (Object)RUN_ACCESS), TuplesKt.to((Object)"XDebugger.MuteBreakpoints", (Object)RUN_ACCESS), TuplesKt.to((Object)"ViewBreakpoints", (Object)READ_ACCESS), TuplesKt.to((Object)"ShowExecutionPoint", (Object)READ_ACCESS), TuplesKt.to((Object)"XDebugger.RemoveWatch", (Object)WRITE_ACCESS), TuplesKt.to((Object)"XDebugger.EditWatch", (Object)WRITE_ACCESS), TuplesKt.to((Object)"EvaluateExpression", (Object)RUN_ACCESS), TuplesKt.to((Object)"Debugger.AddToWatch", (Object)WRITE_ACCESS), TuplesKt.to((Object)"XDebugger.NewWatch", (Object)WRITE_ACCESS), TuplesKt.to((Object)"XDebugger.CopyWatch", (Object)WRITE_ACCESS), TuplesKt.to((Object)"XDebugger.SetValue", (Object)WRITE_ACCESS), TuplesKt.to((Object)"XDebugger.CopyValue", (Object)WRITE_ACCESS)};
        DEBUGGER_WHITE_LISTED_IDS = MapsKt.mapOf((Pair[])objectArray);
        ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0);
        ENTER_SHORTCUT = new KeyboardShortcut(ENTER_KEY_STROKE, null);
        BLACK_LISTED_SHORTCUTS = MapsKt.mapOf((Pair)TuplesKt.to((Object)ENTER_SHORTCUT, (Object)"EditorEnter"));
        objectArray = new String[]{"CWMTelephonyGroup", "CWMShowPopupActionGroup", "CloseEditorsGroup", "ActivateToolWindowActions", "CodeWithMe", "CodeWithMeGroup", "CodeWithMeHeaderMenuAdditionalGroup", "CodeWithMeHeaderMenuGroup", "CodeWithMeMainGroup", "CodeWithMeMainMenuGroup", "CodeWithMeNavbarGroup", "CodeWithMeTabActionGroup", "CodeWithMeToolbarGroup", "CodeWithMeToolbarGroupNewUi", "CodeWithMeUsersGroup", "HostCWMManageLicenseGroup", "HostCodeWithMeMainGroup", "HostCodeWithMeSubMenuGroup", "ExpandAllToLevel", "ExpandToLevel", "FoldingGroup", "UIToggleActions", "TouchBarEditorSearch", "TouchBarEditorSearch_ctrl", "ToggleFullScreenGroup", "TextEditorWithPreview.SplitGroup", "TableActions", "TabsActions", "WindowMenu", "InspectionToolWindow.TreePopup", "WelcomeScreen.ChangeProjectIcon", "WelcomeScreen.Configure", "WelcomeScreen.Configure.ProjectStructure", "WelcomeScreen.CopyProjectPath", "WelcomeScreen.CreateNewProject", "WelcomeScreen.DevelopPlugins", "WelcomeScreen.Documentation", "WelcomeScreen.Documentation.IDEA", "WelcomeScreen.EditGroup", "WelcomeScreen.KeymapGroup", "WelcomeScreen.LearnIdeHelp", "WelcomeScreen.MoveToGroup", "WelcomeScreen.NewGroup", "WelcomeScreen.OpenDirectoryProject", "WelcomeScreen.OpenProject", "WelcomeScreen.OpenSelected", "WelcomeScreen.Options", "WelcomeScreen.Plugins", "WelcomeScreen.QuickStart", "WelcomeScreen.QuickStart.EmptyState", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart.Platform", "WelcomeScreen.QuickStart.ProjectsState", "WelcomeScreen.RemoveSelected", "WelcomeScreen.RevealIn", "WelcomeScreen.Settings", "WelcomeScreenRecentProjectActionGroup"};
        WERE_BLACK_LISTED_BY_WORD_SHOULD_BE = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"$SearchWeb", "$SelectAll", "ShowCommitOptionsAction", "ChangesView.ShowCommitOptions", "ChangesView.ToggleCommitUi", "ChangesView.ViewOptions.ShowRelatedFiles", "Charts.ShowChartSettings", "Charts.ShowSeriesSettings", "ChooseActiveBuildConfiguration", "CloudConfigAction", "CloudConfigActionGroup", "CloudConfigDisableAction", "CloudConfigPluginsAction", "CloudConfigSelfSettingsAction", "CloudConfigSilentlyAction", "CloudConfigUpdateApi", "ComposerConfigGroup", "ConfigureEventsSchemeFileAction", "ConvertToWindowsLineSeparators", "ExternalSystemView.RunConfigurationMenu", "ExtractMethodToolWindow.TreePopup", "ResetWindowsDefenderNotification", "ServersToolWindowToolbar", "LanguageSpecificFoldingGroup", "popup@ExpandableBookmarkContextMenu", "ShowTipsAction", "ConfigureSpecificationSourcesGroup", "ConvertIndentsToTabs", "FileOpenGroup", "OpenFileAction", "ShowDemoLuxWindow", "BookmarkOpenTabs", "BookmarkOpenTabsGroup", "Bookmarks.Toggle", "Bookmarks.ToolWindow.GearActions", "Bookmarks.ToolWindow.PopupMenu", "Bookmarks.ToolWindow.TitleActions", "BookmarksView.OpenInPreviewTab", "BookmarksView.ShowPreview", "JavaeeRunToolWindowToolbar", "ShowUsageFeatures", "OpenFileAction", "OpenModuleSettings", "ShowReformatFileDialog", "ShowSettingsAndFindUsages", "ShowSettingsWithAddedPattern", "ShowSiblingsAction", "Terminal.OpenInTerminal", "TestSearchContributors", "OpenInBrowserEditorContextBarGroupAction", "LightEditOpenFileInProject", "FileChooser.LightEditGotoOpenedFile", "ShowSiblings", "OpenInBrowser", "PluginManagerFiltersConfigureResetTrustDebugAction", "PluginManagerFiltersConfigureTrustOnlyJetBrainsDebugAction"};
        WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"AIAssistant.", "CIDR.Debugger.", "ChangesView.", "CloudConfig", "ChangesView.", "Console.TableResult.", "DSM.", "DS.", "Git", "Github.", "Gradle.", "Graph.", "GuiDesigner.", "HTTPClient.", "Images.", "Jdbc.", "Jpa.", "Jupyter", "Kubernetes.", "LocalChangesView.", "Markdown.", "Maven.", "MemoryView.", "Notebook", "Package", "Perforce.", "ProblemsView.", "ProjectView.", "PyProfile.", "Qodana.", "RESTClient.", "RemoteHostView.", "RemoteServers.", "Scratch.", "ServiceView.", "Session.", "ShowBeans", "Spring", "Subversion.", "SwEditor", "TableResult.", "UML.", "Vcs", "WebDeployment.", "WebInspector.", "com.intellij.analysis.pwa.", "com.intellij.space.vcs.", "com.jetbrains.php.", "hg4idea.", "lineprofiler.", "org.intellij.plugins.markdown.", "org.jetbrains.plugins.ruby.", "org.jetbrains.security.toolwindow.", "sql.", "CommitView.", "Console.", "Database.", "DatabaseView.", "Diagram.", "DevKit.", "Docker.", "Documentation.", "ExternalSystem.", "Faces.", "GitLab.", "GoOpen", "JavaScript", "Ktor", "Profiler.", "Kotlin", "Playwright.", "XPathView.", "WebServicesPlugin.", "Svn.", "SelectKotlin", "PyProfiler.", "PublishGroup.", "Php"};
        WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_PREFIXES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"org.jetbrains.kotlin.", "com.intellij.swagger.", "com.intellij.json.", "com.intellij.aqua.", "com.jetbrains.php.", "com.goide.", "com.intellij.microservices.", "com.intellij.sisyphus.", "com.jetbrains.python.", "com.intellij.database.", "com.intellij.lang.javascript.", "com.intellij.javascript.", "org.editorconfig.", "org.jetbrains.plugins.ruby", "com.intellij.javaee", "com.intellij.internal.statistic.devkit", "com.intellij.jpa.", "com.intellij.lang.properties.", "com.intellij.settingsSync.", "com.intellij.ide.bookmark.", "com.intellij.psi.css.", "com.intellij.ide.license.", "com.intellij.profiler.", "com.intellij.compiler.", "com.intellij.openapi.fileChooser.", "com.intellij.diff.", "com.intellij.openapi.vcs.", "com.intellij.execution.testDiscovery.", "org.jetbrains.kotlinx.", "com.intellij.refactoring.", "org.jetbrains.plugins.javaFX.", "com.jetbrains.plugins.webDeployment.", "com.intellij.testIntegration.", "com.intellij.htmltools."};
        WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_BY_PACKAGE_PREFIXES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001f\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010!\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\"\u0012\u0004\u0012\u00020\u00140\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00060\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/rdserver/actions/DefaultBackendDelegatingActionIdsProvider$Companion;", "", "<init>", "()V", "blackListByWords", "", "", "getBlackListByWords", "()Ljava/util/Map;", "blackListByInterface", "getBlackListByInterface", "whiteListByInterface", "getWhiteListByInterface", "actionChangedFrontendToBackend", "getActionChangedFrontendToBackend", "actionChangedBackendToFrontend", "getActionChangedBackendToFrontend", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "BUILD_ACCESS", "Lcom/jetbrains/rd/actions/AccessRequirements$Listed;", "WRITE_ACCESS", "READ_ACCESS", "RUN_ACCESS", "ACTION_TO_STRATEGY", "", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "EDITOR_ACTION_WITH_IMMEDIATE_RESULT_IDS", "ACTION_IDS", "Lcom/jetbrains/rd/actions/AccessRequirements;", "BLACK_LISTED_ACTION_IDS", "", "BLACK_LISTED_SUBSTRINGS", "DEBUGGER_WHITE_LISTED_IDS", "Lorg/jetbrains/annotations/NonNls;", "ENTER_KEY_STROKE", "Ljavax/swing/KeyStroke;", "kotlin.jvm.PlatformType", "ENTER_SHORTCUT", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "BLACK_LISTED_SHORTCUTS", "Lcom/intellij/openapi/actionSystem/Shortcut;", "WERE_BLACK_LISTED_BY_WORD_SHOULD_BE", "WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE", "WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_PREFIXES", "WERE_BLACK_LISTED_BY_WORD_BUT_NOT_TO_BE_BY_PACKAGE_PREFIXES", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getBlackListByWords() {
            return blackListByWords;
        }

        @NotNull
        public final Map<String, String> getBlackListByInterface() {
            return blackListByInterface;
        }

        @NotNull
        public final Map<String, String> getWhiteListByInterface() {
            return whiteListByInterface;
        }

        @NotNull
        public final Map<String, String> getActionChangedFrontendToBackend() {
            return actionChangedFrontendToBackend;
        }

        @NotNull
        public final Map<String, String> getActionChangedBackendToFrontend() {
            return actionChangedBackendToFrontend;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionRemoteBehavior.values().length];
            try {
                nArray[ActionRemoteBehavior.FrontendOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionRemoteBehavior.Disabled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

