/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DocumentTimestampModel;
import com.jetbrains.rd.ide.model.RangeMarkerTimestampModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/RangeMarkerTimestampModel;", "range", "Lcom/intellij/openapi/util/TextRange;", "allowInnerModifications", "", "documentTimestampModel", "Lcom/jetbrains/rd/ide/model/DocumentTimestampModel;", "<init>", "(Lcom/intellij/openapi/util/TextRange;ZLcom/jetbrains/rd/ide/model/DocumentTimestampModel;)V", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nRangeMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeMarkers.kt\ncom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n13#2:97\n*S KotlinDebug\n*F\n+ 1 RangeMarkers.kt\ncom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp\n*L\n32#1:97\n*E\n"})
public final class RangeMarkerTimestamp
extends UpgradableTimestamp<RangeMarkerTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ActionTimestampKey<RangeMarkerTimestamp, RangeMarkerTimestampModel> NAME = new ActionTimestampKey("DOCUMENT_RANGE");
    @NotNull
    private static final Logger LOG;

    public RangeMarkerTimestamp(@NotNull TextRange range, boolean allowInnerModifications, @NotNull DocumentTimestampModel documentTimestampModel) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)documentTimestampModel, (String)"documentTimestampModel");
        super(NAME, (UpgradableActionTimestampModel)new RangeMarkerTimestampModel(ProtocolConversionsKt.toRdTextRange(range), allowInnerModifications, documentTimestampModel));
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        DocumentTimestampModel documentTimestampModel = ((RangeMarkerTimestampModel)this.getModel()).getDocument();
        RdDocumentId documentId = documentTimestampModel.getDocumentId();
        ProjectTimestamp projectTimestamp = actualSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        if (projectTimestamp == null || (projectTimestamp = projectTimestamp.getData()) == null) {
            return new TimestampUpgradeResult.Failure("No Project");
        }
        ProjectTimestamp project = projectTimestamp;
        BackendDocumentHost documentHost = BackendDocumentHost.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        DocumentSynchronizer documentSynchronizer = documentHost.tryGetSynchronizer(documentId);
        if (documentSynchronizer == null) {
            return new TimestampUpgradeResult.Failure("No Document Synchronizer");
        }
        DocumentSynchronizer synchronizer = documentSynchronizer;
        IDocumentRangeShifter shifter = synchronizer.createRangeShifter();
        TextRange repairedRange = shifter.shiftRange((AbstractDocumentVersion)documentTimestampModel.getVersion(), ProtocolConversionsKt.toTextRange(((RangeMarkerTimestampModel)this.getModel()).getRange()), ((RangeMarkerTimestampModel)this.getModel()).getAllowInnerModifications(), false, false);
        if (repairedRange == null) {
            return new TimestampUpgradeResult.RetryRequest("Range was changed beyond recovering");
        }
        RangeMarkerTimestamp rangeMarkerTimestamp = Companion.create(synchronizer, repairedRange, ((RangeMarkerTimestampModel)this.getModel()).getAllowInnerModifications());
        return new TimestampUpgradeResult.Success(rangeMarkerTimestamp);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RangeMarkerTimestamp.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp$Companion;", "", "<init>", "()V", "NAME", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;", "Lcom/jetbrains/rd/ide/model/RangeMarkerTimestampModel;", "getNAME", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "create", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "range", "Lcom/intellij/openapi/util/TextRange;", "allowInnerModifications", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<RangeMarkerTimestamp, RangeMarkerTimestampModel> getNAME() {
            return NAME;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final RangeMarkerTimestamp create(@NotNull DocumentSynchronizer documentSynchronizer, @NotNull TextRange range, boolean allowInnerModifications) {
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            RdDocumentId rdDocumentId = documentSynchronizer.getDocumentId();
            AbstractDocumentVersion abstractDocumentVersion = documentSynchronizer.getVersion();
            Intrinsics.checkNotNull((Object)abstractDocumentVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentVersion");
            DocumentTimestampModel newDocumentTimestamp = new DocumentTimestampModel(rdDocumentId, (RdDocumentVersion)abstractDocumentVersion);
            return new RangeMarkerTimestamp(range, allowInnerModifications, newDocumentTimestamp);
        }

        public static /* synthetic */ RangeMarkerTimestamp create$default(Companion companion, DocumentSynchronizer documentSynchronizer, TextRange textRange, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.create(documentSynchronizer, textRange, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

