/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.model.ExecutionStackModelBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.debugger.ExecutionStackUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010!\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdserver/debugger/ClientStackContainer;", "Lcom/intellij/xdebugger/frame/XSuspendContext$XExecutionStackContainer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "process", "Lcom/intellij/xdebugger/XDebugProcess;", "task", "Lcom/jetbrains/rd/framework/impl/RdTask;", "", "Lcom/jetbrains/rd/ide/model/ExecutionStackModelBase;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/xdebugger/XDebugProcess;Lcom/jetbrains/rd/framework/impl/RdTask;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getProcess", "()Lcom/intellij/xdebugger/XDebugProcess;", "getTask", "()Lcom/jetbrains/rd/framework/impl/RdTask;", "executionStackModels", "", "isObsolete", "", "errorOccurred", "", "errorMessage", "", "addExecutionStack", "executionStacks", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "last", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nClientStackContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientStackContainer.kt\ncom/jetbrains/rdserver/debugger/ClientStackContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1661#2,3:47\n*S KotlinDebug\n*F\n+ 1 ClientStackContainer.kt\ncom/jetbrains/rdserver/debugger/ClientStackContainer\n*L\n36#1:47,3\n*E\n"})
public final class ClientStackContainer
implements XSuspendContext.XExecutionStackContainer {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final XDebugProcess process;
    @NotNull
    private final RdTask<List<ExecutionStackModelBase>> task;
    @NotNull
    private final List<ExecutionStackModelBase> executionStackModels;

    public ClientStackContainer(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull XDebugProcess process2, @NotNull RdTask<List<ExecutionStackModelBase>> task2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.lifetime = lifetime;
        this.session = session;
        this.process = process2;
        this.task = task2;
        this.executionStackModels = new ArrayList();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final XDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final RdTask<List<ExecutionStackModelBase>> getTask() {
        return this.task;
    }

    public boolean isObsolete() {
        return RLifetimeKt.isNotAlive((Lifetime)this.lifetime);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        ClientId.Companion.withClientId(this.session.getClientId(), () -> ClientStackContainer.errorOccurred$lambda$0(this, errorMessage));
    }

    public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
        Intrinsics.checkNotNullParameter(executionStacks, (String)"executionStacks");
        ApplicationKt.getApplication().invokeLater(() -> ClientStackContainer.addExecutionStack$lambda$0(executionStacks, this, last));
    }

    private static final Unit errorOccurred$lambda$0(ClientStackContainer this$0, String $errorMessage) {
        this$0.task.getResult().set((Object)new RdTaskResult.Fault((Throwable)new Exception($errorMessage)));
        return Unit.INSTANCE;
    }

    private static final Unit addExecutionStack$lambda$0$1(ClientStackContainer this$0) {
        this$0.task.set(this$0.executionStackModels);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addExecutionStack$lambda$0(List $executionStacks, ClientStackContainer this$0, boolean $last) {
        void $this$mapTo$iv;
        Iterable iterable = $executionStacks;
        Collection destination$iv = this$0.executionStackModels;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void xStack;
            XExecutionStack xExecutionStack = (XExecutionStack)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(ExecutionStackUtilsKt.createExecutionStackModel((XExecutionStack)xStack, this$0.session, this$0.process));
        }
        if ($last) {
            ClientId.Companion.withClientId(this$0.session.getClientId(), () -> ClientStackContainer.addExecutionStack$lambda$0$1(this$0));
        }
    }
}

