/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.codeWithMe.model.FullValueEvaluator;
import com.jetbrains.codeWithMe.model.FullValueStartEvalCallResult;
import com.jetbrains.codeWithMe.model.ValueModel;
import com.jetbrains.codeWithMe.model.ValuePropertiesModel;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.model.ValuePresentationPart;
import com.jetbrains.rd.ide.model.ValuePresentationPartKind;
import com.jetbrains.rd.ide.model.ValuePropertiesModelBase;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.debugger.BackendValueMarkersManager;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ2\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010\"\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rdserver/debugger/ClientValueNode;", "Lcom/intellij/xdebugger/frame/XValueNode;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "xValue", "Lcom/intellij/xdebugger/frame/XValue;", "process", "Lcom/intellij/xdebugger/XDebugProcess;", "property", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Lcom/jetbrains/rd/ide/model/ValuePropertiesModelBase;", "model", "Lcom/jetbrains/codeWithMe/model/ValueModel;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/xdebugger/frame/XValue;Lcom/intellij/xdebugger/XDebugProcess;Lcom/jetbrains/rd/util/reactive/IOptProperty;Lcom/jetbrains/codeWithMe/model/ValueModel;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getXValue", "()Lcom/intellij/xdebugger/frame/XValue;", "getProcess", "()Lcom/intellij/xdebugger/XDebugProcess;", "getProperty", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "finishTask", "", "icon", "Ljavax/swing/Icon;", "type", "", "value", "", "Lcom/jetbrains/rd/ide/model/ValuePresentationPart;", "hasChildren", "", "setPresentation", "presentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "setFullValueEvaluator", "fullValueEvaluator", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "intellij.platform.backend.split"})
final class ClientValueNode
implements XValueNode {
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final XValue xValue;
    @NotNull
    private final XDebugProcess process;
    @NotNull
    private final IOptProperty<ValuePropertiesModelBase> property;
    @NotNull
    private final ValueModel model;

    public ClientValueNode(@NotNull ClientProjectSession session, @NotNull XValue xValue, @NotNull XDebugProcess process2, @NotNull IOptProperty<ValuePropertiesModelBase> property, @NotNull ValueModel model2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)xValue, (String)"xValue");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.session = session;
        this.xValue = xValue;
        this.process = process2;
        this.property = property;
        this.model = model2;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final XValue getXValue() {
        return this.xValue;
    }

    @NotNull
    public final XDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final IOptProperty<ValuePropertiesModelBase> getProperty() {
        return this.property;
    }

    private final void finishTask(Icon icon2, String type, List<ValuePresentationPart> value, boolean hasChildren) {
        BackendValueMarkersManager markersManager = BackendValueMarkersManager.Companion.getInstance(this.session);
        Integer marker = markersManager.getMarker(this.process, this.xValue);
        boolean canMark = markersManager.canMark(this.process, this.xValue);
        Icon icon3 = icon2;
        Object object = icon3 != null ? UtilKt.toModel((Icon)icon3) : null;
        String string = type;
        if (string == null) {
            string = "";
        }
        ValuePropertiesModel propertiesModel = new ValuePropertiesModel(object, marker, canMark, string, value, hasChildren);
        ClientId.Companion.withClientId(this.session.getClientId(), () -> ClientValueNode.finishTask$lambda$0(this, propertiesModel));
    }

    public void setPresentation(@Nullable Icon icon2, @Nullable String type, @NotNull String value, boolean hasChildren) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.finishTask(icon2, type, CollectionsKt.listOf((Object)new ValuePresentationPart(value, ValuePresentationPartKind.Default)), hasChildren);
    }

    public void setPresentation(@Nullable Icon icon2, @NotNull XValuePresentation presentation, boolean hasChildren) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        List valueList = new ArrayList();
        presentation.renderValue(new XValuePresentation.XValueTextRenderer(valueList){
            final /* synthetic */ List<ValuePresentationPart> $valueList;
            {
                this.$valueList = $valueList;
            }

            public void renderValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$valueList.add(new ValuePresentationPart(value, ValuePresentationPartKind.Default));
            }

            public void renderStringValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$valueList.add(new ValuePresentationPart(value, ValuePresentationPartKind.String));
            }

            public void renderNumericValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$valueList.add(new ValuePresentationPart(value, ValuePresentationPartKind.Numerical));
            }

            public void renderKeywordValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$valueList.add(new ValuePresentationPart(value, ValuePresentationPartKind.Keyword));
            }

            public void renderComment(String comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                this.$valueList.add(new ValuePresentationPart(comment, ValuePresentationPartKind.Comment));
            }

            public void renderSpecialSymbol(String symbol) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                this.$valueList.add(new ValuePresentationPart(symbol, ValuePresentationPartKind.SpecialSymbol));
            }

            public void renderError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$valueList.add(new ValuePresentationPart(error, ValuePresentationPartKind.Error));
            }

            public void renderValue(String value, TextAttributesKey key) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                this.renderValue(value);
            }

            public void renderStringValue(String value, String additionalSpecialCharsToHighlight, int maxLength) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.renderStringValue(value);
            }
        });
        this.finishTask(icon2, presentation.getType(), valueList, hasChildren);
    }

    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
        FullValueEvaluator fullValueEvaluator2;
        Intrinsics.checkNotNullParameter((Object)fullValueEvaluator, (String)"fullValueEvaluator");
        String string = fullValueEvaluator.getLinkText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLinkText(...)");
        FullValueEvaluator $this$setFullValueEvaluator_u24lambda_u240 = fullValueEvaluator2 = new FullValueEvaluator(string, fullValueEvaluator.isShowValuePopup());
        boolean bl = false;
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)$this$setFullValueEvaluator_u24lambda_u240.getStartEvaluation()), null, null, (arg_0, arg_1) -> ClientValueNode.setFullValueEvaluator$lambda$0$0(fullValueEvaluator, arg_0, arg_1), (int)3, null);
        FullValueEvaluator evaluator2 = fullValueEvaluator2;
        ClientId.Companion.withClientId(this.session.getClientId(), () -> ClientValueNode.setFullValueEvaluator$lambda$1(this, evaluator2));
    }

    private static final void finishTask$lambda$0$0(ClientValueNode this$0, ValuePropertiesModel $propertiesModel) {
        this$0.property.set((Object)$propertiesModel);
    }

    private static final Unit finishTask$lambda$0(ClientValueNode this$0, ValuePropertiesModel $propertiesModel) {
        ApplicationKt.getApplication().invokeLater(() -> ClientValueNode.finishTask$lambda$0$0(this$0, $propertiesModel));
        return Unit.INSTANCE;
    }

    private static final RdTask setFullValueEvaluator$lambda$0$0(XFullValueEvaluator $fullValueEvaluator, Lifetime lifetime, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        RdTask resultTask = new RdTask();
        XFullValueEvaluator.XFullValueEvaluationCallback proxyEvaluationCallback2 = new XFullValueEvaluator.XFullValueEvaluationCallback((RdTask<FullValueStartEvalCallResult>)resultTask){
            final /* synthetic */ RdTask<FullValueStartEvalCallResult> $resultTask;
            {
                this.$resultTask = $resultTask;
            }

            public void errorOccurred(String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.$resultTask.set((Object)new FullValueStartEvalCallResult(null, errorMessage));
            }

            public void evaluated(String fullValue, Font font) {
                Intrinsics.checkNotNullParameter((Object)fullValue, (String)"fullValue");
                this.$resultTask.set((Object)new FullValueStartEvalCallResult(fullValue, null));
            }
        };
        $fullValueEvaluator.startEvaluation(proxyEvaluationCallback2);
        return resultTask;
    }

    private static final void setFullValueEvaluator$lambda$1$0(ClientValueNode this$0, FullValueEvaluator $evaluator) {
        this$0.model.getFullValueEvaluator().set((Object)$evaluator);
    }

    private static final Unit setFullValueEvaluator$lambda$1(ClientValueNode this$0, FullValueEvaluator $evaluator) {
        ApplicationKt.getApplication().invokeLater(() -> ClientValueNode.setFullValueEvaluator$lambda$1$0(this$0, $evaluator));
        return Unit.INSTANCE;
    }
}

