/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors.tabs;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImplKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.codeWithMe.model.EditorTabsModel;
import com.jetbrains.codeWithMe.model.EditorTabsModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.RdProjectScope;
import com.jetbrains.codeWithMe.model.TabsColorInfo;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import com.jetbrains.rdserver.projectView.ProjectScopeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager;", "Lcom/jetbrains/rdserver/editors/BackendEditorHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Helper", "intellij.platform.backend.split"})
final class BackendEditorTabsManager
implements BackendEditorHostListener {
    @Override
    public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ClientProjectSession clientProjectSession = projectSession;
        if (clientProjectSession == null) {
            return;
        }
        Helper helper = Helper.Companion.getInstance(clientProjectSession);
        lifetime.bracketOrThrow(() -> BackendEditorTabsManager.editorBound$lambda$0(helper, textControlId, editor), () -> BackendEditorTabsManager.editorBound$lambda$1(helper, textControlId));
    }

    private static final Unit editorBound$lambda$0(Helper $helper, TextControlId $textControlId, Editor $editor) {
        $helper.add($textControlId.getDocumentId(), $editor);
        return Unit.INSTANCE;
    }

    private static final Unit editorBound$lambda$1(Helper $helper, TextControlId $textControlId) {
        $helper.remove($textControlId.getDocumentId());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper;", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "map", "", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper$Data;", "add", "", "documentId", "editor", "Lcom/intellij/openapi/editor/Editor;", "remove", "updateInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tabsColorInfo", "Lcom/jetbrains/codeWithMe/model/TabsColorInfo;", "Companion", "Data", "intellij.platform.backend.split"})
    public static final class Helper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClientProjectSession session;
        @NotNull
        private final Map<RdDocumentId, Data> map;

        public Helper(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
            this.map = new LinkedHashMap();
        }

        public final void add(@NotNull RdDocumentId documentId, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Data data = this.map.get(documentId);
            if (data != null) {
                Data data2 = data;
                int n = data2.getCount();
                data2.setCount(n + 1);
                return;
            }
            data = new Data(new LifetimeDefinition(), 1);
            CollectionExKt.addUnique(this.map, (Lifetime)((Lifetime)data.getDef()), (Object)documentId, (Object)data);
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile file2 = virtualFile;
            EditorTabsModel model2 = EditorTabsModel_GeneratedKt.getEditorTabsModel((Solution)RemoteSessionKt.getProtocolModel(this.session));
            RdProjectScope scope = ProjectScopeUtils.INSTANCE.getScope(this.session.getProject(), file2);
            TabsColorInfo tabsColorInfo = new TabsColorInfo(scope);
            this.updateInfo(this.session, file2, tabsColorInfo);
            CollectionExKt.addUnique((Map)((Map)model2.getActiveTabsColorInfo()), (Lifetime)((Lifetime)data.getDef()), (Object)documentId, (Object)tabsColorInfo);
            FileStatusManager.getInstance((Project)this.session.getProject()).addFileStatusListener(new FileStatusListener(this, file2, tabsColorInfo){
                final /* synthetic */ Helper this$0;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ TabsColorInfo $tabsColorInfo;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$tabsColorInfo = $tabsColorInfo;
                }

                public void fileStatusesChanged() {
                    Helper.access$updateInfo(this.this$0, Helper.access$getSession$p(this.this$0), this.$file, this.$tabsColorInfo);
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)data.getDef()), null, (int)1, null));
        }

        public final void remove(@NotNull RdDocumentId documentId) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Data data = this.map.get(documentId);
            Intrinsics.checkNotNull((Object)data);
            Data data2 = data;
            data2.setCount(data2.getCount() + -1);
            if (data2.getCount() == 0) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)data2.getDef(), (boolean)false, (int)1, null);
            }
        }

        private final void updateInfo(ClientProjectSession session, VirtualFile file2, TabsColorInfo tabsColorInfo) {
            ColorKey colorKey = FileEditorManagerImplKt.getForegroundColorForFile((Project)session.getProject(), (VirtualFile)file2);
            ColorKeyModel colorKey2 = colorKey != null ? ColorHostKt.toModel((ColorKey)colorKey) : null;
            tabsColorInfo.getForegroundColor().set((Object)colorKey2);
        }

        public static final /* synthetic */ void access$updateInfo(Helper $this, ClientProjectSession session, VirtualFile file2, TabsColorInfo tabsColorInfo) {
            $this.updateInfo(session, file2, tabsColorInfo);
        }

        public static final /* synthetic */ ClientProjectSession access$getSession$p(Helper $this) {
            return $this.session;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.backend.split"})
        @SourceDebugExtension(value={"SMAP\nBackendEditorTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorTabsManager.kt\ncom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,86:1\n30#2,2:87\n*S KotlinDebug\n*F\n+ 1 BackendEditorTabsManager.kt\ncom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper$Companion\n*L\n42#1:87,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Helper getInstance(@NotNull ClientProjectSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                ComponentManager $this$service$iv = (ComponentManager)session;
                boolean $i$f$service = false;
                Class<Helper> serviceClass$iv = Helper.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (Helper)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/editors/tabs/BackendEditorTabsManager$Helper$Data;", "", "def", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "count", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;I)V", "getDef", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getCount", "()I", "setCount", "(I)V", "intellij.platform.backend.split"})
        private static final class Data {
            @NotNull
            private final LifetimeDefinition def;
            private int count;

            public Data(@NotNull LifetimeDefinition def, int count) {
                Intrinsics.checkNotNullParameter((Object)def, (String)"def");
                this.def = def;
                this.count = count;
            }

            @NotNull
            public final LifetimeDefinition getDef() {
                return this.def;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }
        }
    }
}

