/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.execution;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.execution.configurations.BackendRunConfigurationsHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00108T@TX\u0094\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/execution/BackendRunManager;", "Lcom/intellij/execution/impl/RunManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "sharedStreamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/configurationStore/StreamProvider;)V", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getModelIfCreated", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationsModel;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "value", "", "selectedConfigurationId", "getSelectedConfigurationId", "()Ljava/lang/String;", "setSelectedConfigurationId", "(Ljava/lang/String;)V", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendRunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunManager.kt\ncom/jetbrains/rdserver/execution/BackendRunManager\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,53:1\n23#2:54\n*S KotlinDebug\n*F\n+ 1 BackendRunManager.kt\ncom/jetbrains/rdserver/execution/BackendRunManager\n*L\n22#1:54\n*E\n"})
public final class BackendRunManager
extends RunManagerImpl {
    @NonInjectable
    public BackendRunManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @Nullable StreamProvider sharedStreamProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope, sharedStreamProvider);
    }

    public /* synthetic */ BackendRunManager(Project project, CoroutineScope coroutineScope, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            streamProvider = null;
        }
        this(project, coroutineScope, streamProvider);
    }

    public BackendRunManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(project, coroutineScope, null);
    }

    private final CodeWithMeRunConfigurationsModel getModelIfCreated(ClientProjectSession session) {
        ClientSession $this$service$iv = (ClientSession)session;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BackendRunConfigurationsHost.class);
        if (object == null) {
            throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
        }
        BackendRunConfigurationsHost host = (BackendRunConfigurationsHost)((Object)object);
        return host.getCachedModel();
    }

    @Nullable
    protected String getSelectedConfigurationId() {
        ClientProjectSession session = ClientSessionsManager.Companion.getProjectSession(this.getProject(), ClientId.Companion.getCurrent());
        if (session == null || session.isLocal()) {
            return super.getSelectedConfigurationId();
        }
        CodeWithMeRunConfigurationsModel codeWithMeRunConfigurationsModel = this.getModelIfCreated(session);
        if (codeWithMeRunConfigurationsModel == null) {
            return super.getSelectedConfigurationId();
        }
        CodeWithMeRunConfigurationsModel configurationModel = codeWithMeRunConfigurationsModel;
        if (!Intrinsics.areEqual((Object)RemoteSessionKt.getProtocolModel(session).isLoaded().getValueOrNull(), (Object)true)) {
            return super.getSelectedConfigurationId();
        }
        return (String)configurationModel.getClientCurrentConfiguration().getValue();
    }

    protected void setSelectedConfigurationId(@Nullable String value) {
        ClientProjectSession session = ClientSessionsManager.Companion.getProjectSession(this.getProject(), ClientId.Companion.getCurrent());
        if (session == null || session.isLocal()) {
            super.setSelectedConfigurationId(value);
            return;
        }
        CodeWithMeRunConfigurationsModel configurationModel = this.getModelIfCreated(session);
        CodeWithMeRunConfigurationsModel codeWithMeRunConfigurationsModel = configurationModel;
        if (codeWithMeRunConfigurationsModel != null && (codeWithMeRunConfigurationsModel = codeWithMeRunConfigurationsModel.getClientCurrentConfiguration()) != null) {
            codeWithMeRunConfigurationsModel.set((Object)value);
        }
        if (configurationModel == null || session.isController()) {
            super.setSelectedConfigurationId(value);
        }
    }
}

