/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.fileEditors;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.EditorCompositeListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import com.jetbrains.ide.model.uiautomation.BeAbstractText;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdate;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdateType;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.lux.util.UtilKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001@B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001aH\u0016J(\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0016J \u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0016J(\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0016J \u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0016J \u0010,\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J(\u00100\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002J(\u00104\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u00102\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002J(\u00105\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u00106\u001a\u0002072\u0006\u0010\n\u001a\u0002082\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0018\u0010:\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010;\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020\u001fH\u0002J\b\u0010>\u001a\u00020!H\u0002J\r\u0010=\u001a\u00020!H\u0000\u00a2\u0006\u0002\b?R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/rdserver/fileEditors/BackendFileEditorSynchronizer;", "Lcom/intellij/openapi/fileEditor/impl/EditorCompositeListener;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "fileEditorId", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "fileEditorModel", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/jetbrains/rd/ide/model/RdFileEditorId;Lcom/jetbrains/rd/ide/model/FileEditorModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getFileEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "getFileEditorId", "()Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "topMapping", "Ljava/util/LinkedHashMap;", "Ljavax/swing/JComponent;", "Lcom/jetbrains/rdserver/fileEditors/BackendFileEditorSynchronizer$ComponentInfo;", "bottomMapping", "updateIdentity", "", "updatesQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "topBottomComponentUpdates", "", "Lcom/jetbrains/rd/ide/model/TopBottomComponentUpdate;", "displayNameChanged", "", "editor", "name", "topComponentAdded", "index", "", "component", "container", "topComponentRemoved", "bottomComponentAdded", "bottomComponentRemoved", "componentAdded", "isTop", "", "componentRemoved", "addComponent", "isReadOnly", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "addOrUpdateContainer", "sendComponentAddedUpdate", "beControl", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "updateLuxContainer", "removeComponent", "sendComponentRemovedUpdate", "scheduleUpdate", "update", "sendUpdates", "update$intellij_platform_backend_split", "ComponentInfo", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendFileEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendFileEditorSynchronizer.kt\ncom/jetbrains/rdserver/fileEditors/BackendFileEditorSynchronizer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1342#2,2:215\n37#3,2:217\n1915#4,2:219\n1915#4,2:221\n*S KotlinDebug\n*F\n+ 1 BackendFileEditorSynchronizer.kt\ncom/jetbrains/rdserver/fileEditors/BackendFileEditorSynchronizer\n*L\n113#1:215,2\n190#1:217,2\n53#1:219,2\n54#1:221,2\n*E\n"})
public final class BackendFileEditorSynchronizer
implements EditorCompositeListener {
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final FileEditor fileEditor;
    @NotNull
    private final RdFileEditorId fileEditorId;
    @NotNull
    private final FileEditorModel fileEditorModel;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final LinkedHashMap<JComponent, ComponentInfo> topMapping;
    @NotNull
    private final LinkedHashMap<JComponent, ComponentInfo> bottomMapping;
    @NotNull
    private final String updateIdentity;
    @NotNull
    private final MergingUpdateQueue updatesQueue;
    @NotNull
    private final List<TopBottomComponentUpdate> topBottomComponentUpdates;

    public BackendFileEditorSynchronizer(@NotNull ClientProjectSession session, @NotNull FileEditor fileEditor, @NotNull RdFileEditorId fileEditorId, @NotNull FileEditorModel fileEditorModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)fileEditorId, (String)"fileEditorId");
        Intrinsics.checkNotNullParameter((Object)fileEditorModel, (String)"fileEditorModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.session = session;
        this.fileEditor = fileEditor;
        this.fileEditorId = fileEditorId;
        this.fileEditorModel = fileEditorModel;
        this.lifetime = lifetime;
        this.topMapping = new LinkedHashMap();
        this.bottomMapping = new LinkedHashMap();
        this.updateIdentity = "TopBottomComponentUpdate";
        this.updatesQueue = new MergingUpdateQueue("BackendFileEditorSynchronizer top/bottom component updates", 0, true, null, null, null, false, 112, null);
        this.topBottomComponentUpdates = new ArrayList();
        IOptProperty iOptProperty = this.fileEditorModel.getName();
        String string = this.fileEditor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        iOptProperty.set((Object)string);
        this.lifetime.onTerminationIfAlive(() -> BackendFileEditorSynchronizer._init_$lambda$0(this));
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final FileEditor getFileEditor() {
        return this.fileEditor;
    }

    @NotNull
    public final RdFileEditorId getFileEditorId() {
        return this.fileEditorId;
    }

    public void displayNameChanged(@NotNull FileEditor editor, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)editor, (Object)this.fileEditor)) {
            return;
        }
        this.fileEditorModel.getName().set((Object)name);
    }

    public void topComponentAdded(@NotNull FileEditor editor, int index, @NotNull JComponent component, @NotNull JComponent container) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!Intrinsics.areEqual((Object)editor, (Object)this.fileEditor)) {
            return;
        }
        this.componentAdded(component, container, true);
    }

    public void topComponentRemoved(@NotNull FileEditor editor, @NotNull JComponent component, @NotNull JComponent container) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!Intrinsics.areEqual((Object)editor, (Object)this.fileEditor)) {
            return;
        }
        this.componentRemoved(component, container, true);
    }

    public void bottomComponentAdded(@NotNull FileEditor editor, int index, @NotNull JComponent component, @NotNull JComponent container) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!Intrinsics.areEqual((Object)editor, (Object)this.fileEditor)) {
            return;
        }
        this.componentAdded(component, container, false);
    }

    public void bottomComponentRemoved(@NotNull FileEditor editor, @NotNull JComponent component, @NotNull JComponent container) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!Intrinsics.areEqual((Object)editor, (Object)this.fileEditor)) {
            return;
        }
        this.componentRemoved(component, container, false);
    }

    private final void componentAdded(JComponent component, JComponent container, boolean isTop) {
        boolean isReadOnly = !ClientPermissionManager.Companion.getInstance(this.session).hasFileWriteAccess();
        TrackOptions trackOptions = new TrackOptions(this.session.getAppSession(), false, null, null, !isReadOnly, null, null, null, false, null, null, 2030, null);
        if (Registry.Companion.is("remoteDev.editor.toolbar.lux.container") && UtilKt.isDirectTransferAvailable(this.session.getAppSession())) {
            this.addOrUpdateContainer(component, container, trackOptions, isTop);
        } else {
            this.addComponent(component, isReadOnly, trackOptions, isTop);
        }
    }

    private final void componentRemoved(JComponent component, JComponent container, boolean isTop) {
        if (UtilKt.isUnderDirectTransfer(container)) {
            this.updateLuxContainer(container);
        } else {
            this.removeComponent(component, isTop);
        }
    }

    private final void addComponent(JComponent component, boolean isReadOnly, TrackOptions trackOptions, boolean isTop) {
        BeControl control;
        if (component instanceof BreadcrumbsXmlWrapper) {
            return;
        }
        UIUtil.setFosterParent((JComponent)component, (Component)this.fileEditor.getComponent());
        LifetimeDefinition componentLifetime = this.lifetime.createNested();
        BeControl beControl = ConverterRegistryKt.toDirectTransferModel$default(component, trackOptions, (Lifetime)componentLifetime, null, false, null, false, 60, null);
        if (beControl == null) {
            beControl = control = ConverterRegistryKt.toBeModel(component, trackOptions, (Lifetime)componentLifetime);
        }
        if (isReadOnly) {
            Sequence $this$forEach$iv = BeGetterExtensionsKt.descendants$default((BeControl)control, null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BeControl it = (BeControl)element$iv;
                boolean bl = false;
                if (it instanceof BeAbstractText) continue;
                it.getEnabled().set((Object)false);
                it.getTooltip().set((Object)SplitBackendBundle.INSTANCE.message("permission.editor.panel.actions.disabled", new Object[0]));
            }
        }
        this.sendComponentAddedUpdate(component, control, componentLifetime, isTop);
    }

    private final void addOrUpdateContainer(JComponent component, JComponent container, TrackOptions trackOptions, boolean isTop) {
        JPanel jPanel;
        if (component instanceof BreadcrumbsXmlWrapper) {
            container.remove(((BreadcrumbsXmlWrapper)component).getParent());
        }
        if (UtilKt.isUnderDirectTransfer(container)) {
            this.updateLuxContainer(container);
            return;
        }
        LifetimeDefinition containerLifetime = this.lifetime.createNested();
        JPanel $this$addOrUpdateContainer_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$addOrUpdateContainer_u24lambda_u240.add((Component)container, "Center");
        UIUtil.setFosterParent((JComponent)$this$addOrUpdateContainer_u24lambda_u240, (Component)this.fileEditor.getComponent());
        JPanel fakeParent = jPanel;
        BeControl beControl = ConverterRegistryKt.toDirectTransferModel$default(fakeParent, trackOptions, (Lifetime)containerLifetime, null, false, null, false, 60, null);
        if (beControl == null) {
            throw new IllegalStateException("Cannot luxify editor toolbar container".toString());
        }
        BeControl control = beControl;
        this.sendComponentAddedUpdate(container, control, containerLifetime, isTop);
    }

    private final void sendComponentAddedUpdate(JComponent component, BeControl beControl, LifetimeDefinition lifetime, boolean isTop) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String componentId = string;
        TopBottomComponentUpdate update2 = new TopBottomComponentUpdate(TopBottomComponentUpdateType.ADD, componentId, beControl, isTop);
        this.scheduleUpdate(update2);
        LinkedHashMap<JComponent, ComponentInfo> storage = isTop ? this.topMapping : this.bottomMapping;
        ((Map)storage).put(component, new ComponentInfo(componentId, lifetime));
    }

    private final void updateLuxContainer(JComponent container) {
        block0: {
            Container container2 = container.getParent();
            if (container2 == null) break block0;
            container2.setPreferredSize(container.getPreferredSize());
        }
    }

    private final void removeComponent(JComponent component, boolean isTop) {
        if (component instanceof BreadcrumbsXmlWrapper) {
            return;
        }
        Container container = component.getParent();
        if (container != null) {
            container.remove(component);
        }
        this.sendComponentRemovedUpdate(component, isTop);
    }

    private final void sendComponentRemovedUpdate(JComponent component, boolean isTop) {
        LinkedHashMap<JComponent, ComponentInfo> storage = isTop ? this.topMapping : this.bottomMapping;
        ComponentInfo componentInfo = (ComponentInfo)storage.remove(component);
        if (componentInfo == null) {
            return;
        }
        ComponentInfo componentInfo2 = componentInfo;
        TopBottomComponentUpdate update2 = new TopBottomComponentUpdate(TopBottomComponentUpdateType.REMOVE, componentInfo2.getId(), null, isTop);
        this.scheduleUpdate(update2);
        LifetimeDefinition.terminate$default((LifetimeDefinition)componentInfo2.getLifetime(), (boolean)false, (int)1, null);
    }

    private final void scheduleUpdate(TopBottomComponentUpdate update2) {
        this.topBottomComponentUpdates.add(update2);
        this.updatesQueue.queue(Update.Companion.create((Object)this.updateIdentity, this::sendUpdates));
    }

    private final void sendUpdates() {
        if (!((Collection)this.topBottomComponentUpdates).isEmpty()) {
            Collection $this$toTypedArray$iv = this.topBottomComponentUpdates;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.fileEditorModel.getTopBottomComponentsUpdates().set((Object)thisCollection$iv.toArray(new TopBottomComponentUpdate[0]));
            this.topBottomComponentUpdates.clear();
        }
    }

    public final void update$intellij_platform_backend_split() {
        JComponent component;
        JComponent component2;
        Set<JComponent> set = this.topMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List topComponents = CollectionsKt.toList((Iterable)set);
        for (Object e : topComponents) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            component2 = (JComponent)e;
            this.componentRemoved(component2, component2, true);
        }
        for (Object e : topComponents) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            component2 = (JComponent)e;
            this.componentAdded(component2, component2, true);
        }
        Set<JComponent> set2 = this.bottomMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        List bottom = CollectionsKt.toList((Iterable)set2);
        for (Object e : bottom) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            component = (JComponent)e;
            this.componentRemoved(component, component, false);
        }
        for (Object e : bottom) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            component = (JComponent)e;
            this.componentAdded(component, component, false);
        }
    }

    private static final Unit _init_$lambda$0(BackendFileEditorSynchronizer this$0) {
        JComponent it;
        Set<JComponent> set = this$0.topMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.removeComponent(it, true);
        }
        Set<JComponent> set2 = this$0.bottomMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        $this$forEach$iv = CollectionsKt.toList((Iterable)set2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.removeComponent(it, false);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/fileEditors/BackendFileEditorSynchronizer$ComponentInfo;", "", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getId", "()Ljava/lang/String;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.backend.split"})
    private static final class ComponentInfo {
        @NotNull
        private final String id;
        @NotNull
        private final LifetimeDefinition lifetime;

        public ComponentInfo(@NotNull String id, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.id = id;
            this.lifetime = lifetime;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetime;
        }

        @NotNull
        public final ComponentInfo copy(@NotNull String id, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return new ComponentInfo(id, lifetime);
        }

        public static /* synthetic */ ComponentInfo copy$default(ComponentInfo componentInfo, String string, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                string = componentInfo.id;
            }
            if ((n & 2) != 0) {
                lifetimeDefinition = componentInfo.lifetime;
            }
            return componentInfo.copy(string, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "ComponentInfo(id=" + this.id + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.lifetime.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo componentInfo = (ComponentInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)componentInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetime, (Object)componentInfo.lifetime);
        }
    }
}

