/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.graphics;

import com.intellij.ui.icons.HiDPIImage;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/lux/awt/graphics/LuxVolatileImage;", "Ljava/awt/image/VolatileImage;", "configuration", "Ljava/awt/GraphicsConfiguration;", "width", "", "height", "transparency", "<init>", "(Ljava/awt/GraphicsConfiguration;III)V", "image", "Ljava/awt/image/BufferedImage;", "cachedSnapshot", "getWidth", "observer", "Ljava/awt/image/ImageObserver;", "getHeight", "getProperty", "", "name", "", "getCapabilities", "Ljava/awt/ImageCapabilities;", "gc", "getSnapshot", "createGraphics", "Ljava/awt/Graphics2D;", "validate", "contentsLost", "", "flush", "", "intellij.platform.backend.split"})
public final class LuxVolatileImage
extends VolatileImage {
    @NotNull
    private final GraphicsConfiguration configuration;
    private final int width;
    private final int height;
    @Nullable
    private BufferedImage image;
    @Nullable
    private BufferedImage cachedSnapshot;

    public LuxVolatileImage(@NotNull GraphicsConfiguration configuration, int width, int height, int transparency) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.width = width;
        this.height = height;
        this.transparency = transparency;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getWidth(@Nullable ImageObserver observer) {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getHeight(@Nullable ImageObserver observer) {
        return this.height;
    }

    @Override
    @Nullable
    public Object getProperty(@Nullable String name, @Nullable ImageObserver observer) {
        return null;
    }

    @Override
    @NotNull
    public ImageCapabilities getCapabilities() {
        return new ImageCapabilities(false);
    }

    @Override
    @NotNull
    public ImageCapabilities getCapabilities(@Nullable GraphicsConfiguration gc) {
        return new ImageCapabilities(false);
    }

    @Override
    @NotNull
    public BufferedImage getSnapshot() {
        if (this.cachedSnapshot == null) {
            HiDPIImage result = new HiDPIImage(this.configuration, this.width, this.height, 2);
            BufferedImage bufferedImage = this.image;
            if (bufferedImage != null) {
                bufferedImage.copyData(result.getRaster());
            }
            this.cachedSnapshot = (BufferedImage)result;
        }
        BufferedImage bufferedImage = this.cachedSnapshot;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage;
    }

    @Override
    @NotNull
    public Graphics2D createGraphics() {
        this.cachedSnapshot = null;
        if (this.image == null) {
            this.image = (BufferedImage)new HiDPIImage(this.configuration, this.width, this.height, 2);
        }
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        return graphics2D;
    }

    @Override
    public int validate(@Nullable GraphicsConfiguration gc) {
        if (!Intrinsics.areEqual((Object)gc, (Object)this.configuration)) {
            return 2;
        }
        if (this.image == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean contentsLost() {
        return this.image == null;
    }

    @Override
    public void flush() {
        this.image = null;
        this.cachedSnapshot = null;
    }
}

