/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.pipe;

import com.jetbrains.rd.ide.model.LxCopyAreaCommand;
import com.jetbrains.rd.ide.model.LxDrawCommand;
import com.jetbrains.rd.ide.model.LxDrawShapeCommand;
import com.jetbrains.rd.ide.model.LxFillShapeCommand;
import com.jetbrains.rd.ide.model.LxRect;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rdserver.lux.adapter.LuxGraphicsAdapter;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J0\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J@\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J0\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J@\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J(\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J(\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J0\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J@\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J0\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J@\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J(\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0016J@\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006-\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/lux/awt/pipe/LuxDrawPipe;", "", "adapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter;", "getAdapter", "()Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter;", "drawLine", "", "lg", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphics2D;", "x1", "", "y1", "x2", "y2", "drawRect", "x", "y", "width", "height", "drawRoundRect", "arcWidth", "arcHeight", "drawOval", "drawArc", "startAngle", "arcAngle", "drawPolyline", "xPoints", "", "yPoints", "nPoints", "drawPolygon", "fillRect", "fillRoundRect", "fillOval", "fillArc", "fillPolygon", "draw", "s", "Ljava/awt/Shape;", "fill", "copyArea", "dx", "dy", "intellij.platform.backend.split"})
public interface LuxDrawPipe {
    @NotNull
    public LuxGraphicsAdapter getAdapter();

    default public void drawLine(@NotNull LuxGraphics2D lg, int x1, int y1, int x2, int y2) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.draw(lg, new Line2D.Double(x1, y1, x2, y2));
    }

    default public void drawRect(@NotNull LuxGraphics2D lg, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.draw(lg, new Rectangle(x, y, width, height));
    }

    default public void drawRoundRect(@NotNull LuxGraphics2D lg, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.draw(lg, new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    default public void drawOval(@NotNull LuxGraphics2D lg, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.draw(lg, new Ellipse2D.Double(x, y, width, height));
    }

    default public void drawArc(@NotNull LuxGraphics2D lg, int x, int y, int width, int height, int startAngle, int arcAngle) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.draw(lg, new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    default public void drawPolyline(@NotNull LuxGraphics2D lg, @NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        if (nPoints <= 1) {
            return;
        }
        Path2D.Double line = new Path2D.Double();
        line.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            line.lineTo(xPoints[i], yPoints[i]);
        }
        this.draw(lg, line);
    }

    default public void drawPolygon(@NotNull LuxGraphics2D lg, @NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.draw(lg, new Polygon(xPoints, yPoints, nPoints));
    }

    default public void fillRect(@NotNull LuxGraphics2D lg, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.fill(lg, new Rectangle2D.Double(x, y, width, height));
    }

    default public void fillRoundRect(@NotNull LuxGraphics2D lg, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.fill(lg, new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    default public void fillOval(@NotNull LuxGraphics2D lg, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.fill(lg, new Ellipse2D.Double(x, y, width, height));
    }

    default public void fillArc(@NotNull LuxGraphics2D lg, int x, int y, int width, int height, int startAngle, int arcAngle) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.fill(lg, new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    default public void fillPolygon(@NotNull LuxGraphics2D lg, @NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.fill(lg, new Polygon(xPoints, yPoints, nPoints));
    }

    default public void draw(@NotNull LuxGraphics2D lg, @NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.getAdapter().queue(lg, (LxDrawCommand)new LxDrawShapeCommand(UtilKt.toLx((Shape)s, (Stroke)lg.getStroke())));
    }

    default public void fill(@NotNull LuxGraphics2D lg, @NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.getAdapter().queue(lg, (LxDrawCommand)new LxFillShapeCommand(UtilKt.toLx((Shape)s, (Stroke)lg.getStroke())));
    }

    default public void copyArea(@NotNull LuxGraphics2D lg, int x, int y, int width, int height, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        this.getAdapter().queue(lg, (LxDrawCommand)new LxCopyAreaCommand(new LxRect(x, y, width, height), dx, dy));
    }
}

