/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.util;

import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.codeWithMe.model.RemoteGraphicsConfigurationModel;
import com.jetbrains.codeWithMe.model.RemoteGraphicsDeviceModel;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.LuxLayoutSource;
import com.jetbrains.rd.ide.model.LxAffineTransform;
import com.jetbrains.rd.ide.model.LxRect;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxPanelAdapter;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphicsConfiguration;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphicsDevice;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.lux.util.BeneluxViewProvider;
import com.jetbrains.rdserver.lux.util.RenderingContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0005\u001aj\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\n\u0010\u0015\u001a\u00020\u0018*\u00020\u0019\u001a\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\n\u001a\u0004\u0018\u00010\u001d\u001a\u0010\u0010\u001e\u001a\u00020\u001c2\b\u0010\n\u001a\u0004\u0018\u00010\u001f\u00a8\u0006 "}, d2={"isDirectTransferAvailable", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "isUnderDirectTransfer", "Ljava/awt/Component;", "createDirectTransferComponent", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "component", "dataContextComponent", "explicitOwner", "Ljava/awt/Window;", "trackVisibility", "useDialogHost", "layoutSource", "Lcom/jetbrains/rd/ide/model/LuxLayoutSource;", "focusableOnFrontend", "preRenderInfo", "Lcom/jetbrains/rdserver/lux/util/RenderingContext;", "fromModel", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphicsDevice;", "Lcom/jetbrains/codeWithMe/model/RemoteGraphicsDeviceModel;", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphicsConfiguration;", "Lcom/jetbrains/codeWithMe/model/RemoteGraphicsConfigurationModel;", "collectHierarchy", "", "", "Ljava/awt/Container;", "getCreationStack", "Ljavax/swing/JComponent;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/jetbrains/rdserver/lux/util/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class UtilKt {
    public static final boolean isDirectTransferAvailable(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return session.isController();
    }

    public static final boolean isUnderDirectTransfer(@NotNull Component $this$isUnderDirectTransfer) {
        LuxComponentAdapter luxAdapter;
        Intrinsics.checkNotNullParameter((Object)$this$isUnderDirectTransfer, (String)"<this>");
        Window window = SwingUtilities.windowForComponent($this$isUnderDirectTransfer);
        if (window == null) {
            return false;
        }
        Window window2 = window;
        LuxComponentAdapter luxComponentAdapter = luxAdapter = LuxHostService.Companion.getInstance().getAdapterByWindow(window2);
        return luxComponentAdapter != null ? luxComponentAdapter.isBound() : false;
    }

    @NotNull
    public static final BeControl createDirectTransferComponent(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull Component component, @Nullable Component dataContextComponent, @Nullable Window explicitOwner, boolean trackVisibility, boolean useDialogHost, @NotNull LuxLayoutSource layoutSource, boolean focusableOnFrontend, @Nullable RenderingContext preRenderInfo) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)layoutSource, (String)"layoutSource");
        boolean bl = UtilKt.isDirectTransferAvailable(session);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UtilKt$createDirectTransferComponent$22 = false;
            String $i$a$-assert-UtilKt$createDirectTransferComponent$22 = "No direct transfer available";
            throw new AssertionError((Object)$i$a$-assert-UtilKt$createDirectTransferComponent$22);
        }
        LuxHostService luxService = LuxHostService.Companion.getInstance();
        LuxPanelAdapter luxAdapter = luxService.luxifyComponent(lifetime, component, dataContextComponent, explicitOwner, trackVisibility, useDialogHost, layoutSource, focusableOnFrontend, preRenderInfo);
        PropertyChangeListener listener2 = arg_0 -> UtilKt.createDirectTransferComponent$lambda$1(luxAdapter, arg_0);
        component.addPropertyChangeListener(listener2);
        lifetime.onTermination(() -> UtilKt.createDirectTransferComponent$lambda$2(component, listener2));
        return (BeControl)BeneluxViewProvider.Companion.createView(lifetime, session, component, luxAdapter);
    }

    public static /* synthetic */ BeControl createDirectTransferComponent$default(Lifetime lifetime, ClientAppSession clientAppSession, Component component, Component component2, Window window, boolean bl, boolean bl2, LuxLayoutSource luxLayoutSource, boolean bl3, RenderingContext renderingContext, int n, Object object) {
        if ((n & 8) != 0) {
            component2 = null;
        }
        if ((n & 0x10) != 0) {
            window = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            luxLayoutSource = LuxLayoutSource.Frontend;
        }
        if ((n & 0x100) != 0) {
            bl3 = true;
        }
        if ((n & 0x200) != 0) {
            renderingContext = null;
        }
        return UtilKt.createDirectTransferComponent(lifetime, clientAppSession, component, component2, window, bl, bl2, luxLayoutSource, bl3, renderingContext);
    }

    @NotNull
    public static final LuxGraphicsDevice fromModel(@NotNull RemoteGraphicsDeviceModel $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        return new LuxGraphicsDevice($this$fromModel.getIdString(), $this$fromModel.getConfigurations(), $this$fromModel.getDefaultConfigurationIndex());
    }

    @NotNull
    public static final LuxGraphicsConfiguration fromModel(@NotNull RemoteGraphicsConfigurationModel $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        return new LuxGraphicsConfiguration($this$fromModel.getDeviceId(), com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.fromLx((LxRect)$this$fromModel.getBounds()), com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.fromLx((LxAffineTransform)$this$fromModel.getDefaultTransform()), com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.fromLx((LxAffineTransform)$this$fromModel.getNormalizingTransform()));
    }

    @NotNull
    public static final List<String> collectHierarchy(@Nullable Container component) {
        List list = UIUtil.uiParents((Component)component, (boolean)true).map(arg_0 -> UtilKt.collectHierarchy$lambda$1(UtilKt::collectHierarchy$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public static final String getCreationStack(@Nullable JComponent component) {
        Object object;
        if (component == null) {
            return "";
        }
        Object dslProp = component.getClientProperty(DslComponentPropertyInternal.CREATION_STACKTRACE);
        Throwable defaultProp = (Throwable)ClientProperty.get((Component)component, (Key)UiInspectorUtil.ADDED_AT_STACKTRACE);
        Object object2 = dslProp;
        if (object2 == null) {
            object2 = defaultProp;
        }
        Throwable throwable = (object = object2) instanceof Throwable ? (Throwable)object : null;
        if (throwable == null) {
            return "No stacktrace available" + System.lineSeparator() + "To get creation stacktrace, enable \"UI inspector hierarchy trace (On host)\" using relevant action";
        }
        Throwable throwable2 = throwable;
        String string = ExceptionUtil.getThrowableText((Throwable)throwable2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getThrowableText(...)");
        return string;
    }

    private static final void createDirectTransferComponent$lambda$1(LuxPanelAdapter $luxAdapter, PropertyChangeEvent it) {
        block14: {
            if (it.getNewValue() == null) {
                return;
            }
            String string = it.getPropertyName();
            if (string == null) break block14;
            int n = -1;
            switch (string.hashCode()) {
                case 1008217391: {
                    if (string.equals("minimumSize")) {
                        n = 1;
                    }
                    break;
                }
                case -608552926: {
                    if (string.equals("preferredSize")) {
                        n = 2;
                    }
                    break;
                }
                case 1685649985: {
                    if (string.equals("maximumSize")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Object object = it.getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Dimension");
                    $luxAdapter.setMinimumSize((Dimension)object);
                    break;
                }
                case 3: {
                    Object object = it.getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Dimension");
                    $luxAdapter.setMaximumSize((Dimension)object);
                    break;
                }
                case 2: {
                    Object object = it.getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Dimension");
                    $luxAdapter.setPreferredSize((Dimension)object);
                }
            }
        }
    }

    private static final Unit createDirectTransferComponent$lambda$2(Component $component, PropertyChangeListener $listener) {
        $component.removePropertyChangeListener($listener);
        return Unit.INSTANCE;
    }

    private static final String collectHierarchy$lambda$0(Component it) {
        return it.getClass().getSimpleName();
    }

    private static final String collectHierarchy$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

