/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortAttributes;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortAttributesProvider;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortPickingStrategy;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.GlobalPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortForwardingResult;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortPresentation;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortAttributes;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortAttributesProvider;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortPickingStrategy;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortImpl;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortsFilter;
import com.jetbrains.rdserver.portForwarding.internal.GlobalPortForwardingManagerImpl;
import com.jetbrains.rdserver.portForwarding.internal.PerClientPortForwardingManagerImpl;
import com.jetbrains.rdserver.portForwarding.internal.PortForwardingManagerImpl;
import com.jetbrains.rdserver.portForwarding.internal.PortPresentationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpReversedForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.UrlExposureConfigurationImpl;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 I2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001IB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000eH\u0002JG\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00120 \u00a2\u0006\u0002\b\"H\u0017JU\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010&\u001a\u00020'2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00120 \u00a2\u0006\u0002\b\"H\u0097@\u00a2\u0006\u0002\u0010(J?\u0010)\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00120 \u00a2\u0006\u0002\b\"H\u0016J(\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010-\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u00100\u001a\u0004\u0018\u00010\u000bH\u0016J$\u00101\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000103H\u0016J(\u00105\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\n\b\u0001\u00106\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u00107\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u00108\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010:\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000bH\u0016J\u0018\u0010<\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020>H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\u000e2\u0006\u0010E\u001a\u00020\u000eH\u0002J \u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010?\u001a\n A*\u0004\u0018\u00010@0@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006J"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/PerClientPortForwardingManagerImpl;", "Lcom/jetbrains/rdserver/portForwarding/internal/PortForwardingManagerImpl;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PerClientPortForwardingManager;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPortListener;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lkotlinx/coroutines/CoroutineScope;)V", "name", "", "getPorts", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "directionType", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortDirectionType;", "inheritPortFromGlobalManager", "", "port", "createConfiguration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;", "forwardPort", "hostPortNumber", "", "portType", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "labels", "", "clientPortAttributes", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ClientPortAttributes;", "init", "Lkotlin/Function1;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;", "Lkotlin/ExtensionFunctionType;", "tryForwardPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortForwardingResult;", "portNumber", "serverSocketPortAttributes", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortAttributes;", "(ILcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortDirectionType;Ljava/util/Set;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortAttributes;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exposePort", "exposedUrl", "nameChanged", "oldName", "newName", "descriptionChanged", "oldDescription", "newDescription", "iconChanged", "oldIcon", "Ljavax/swing/Icon;", "newIcon", "tooltipChanged", "oldTooltip", "newTooltip", "becameReadOnly", "reason", "exposedUrlChanged", "newUrl", "stateChanged", "newState", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortState;", "perClientPortListeners", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PerClientPortListener;", "kotlin.jvm.PlatformType", "getPerClientPortListeners", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PerClientPortListener;", "getClientPortForAppPort", "forwardedPort", "definePerClientConfiguration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration$TcpForwarding;", "direction", "Companion", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPerClientPortForwardingManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerClientPortForwardingManagerImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/PerClientPortForwardingManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n60#2,5:321\n60#2,5:327\n13#2:332\n1#3:326\n*S KotlinDebug\n*F\n+ 1 PerClientPortForwardingManagerImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/PerClientPortForwardingManagerImpl\n*L\n295#1:321,5\n306#1:327,5\n43#1:332\n*E\n"})
public final class PerClientPortForwardingManagerImpl
extends PortForwardingManagerImpl
implements PerClientPortForwardingManager,
ForwardedPortListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String name;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ExtensionPointName<ClientPortAttributesProvider> DEPRECATED_EP;
    @NotNull
    private static final ExtensionPointName<ServerSocketPortAttributesProvider> EP;

    public PerClientPortForwardingManagerImpl(@NotNull ClientAppSession session, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.session = session;
        this.coroutineScope = coroutineScope;
        this.name = "Port Forwarding for Client (id: " + this.session.getClientId().getValue() + ")";
        SourceExKt.flowInto((ISource)((ISource)GlobalPortForwardingManagerImpl.Companion.getInstance().getPortForwardingEnabled()), (Lifetime)this.getServiceLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)this.getPortForwardingEnabled()));
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this).subscribe(GlobalPortListener.Companion.getTOPIC(), (Object)new GlobalPortListener(){

            public void portAdded(ForwardedPort port) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                logger.info(name + " Add port forwarding for port: <" + port.getTargetPortNumber() + ">");
                this.inheritPortFromGlobalManager(port);
            }

            public void portRemoved(ForwardedPort port) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                this.removePort(clientPort);
                logger.info(name + " Port is removed from forwarding: <" + port.getTargetPortNumber() + ">");
            }

            /*
             * WARNING - void declaration
             */
            public void nameChanged(ForwardedPort port, @Nls String oldName, @Nls String newName) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                if (Intrinsics.areEqual((Object)clientPort.getPresentation().getName(), (Object)oldName)) {
                    void $this$debug_u24default$iv;
                    Logger logger = logger;
                    PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_9 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var10_9.debug(perClientPortForwardingManagerImpl.name + " Port forwarding name has been changed for port <" + port.getTargetPortNumber() + ">: <" + oldName + "> -> <" + newName + ">", t$iv);
                    }
                    clientPort.getPresentation().setName(newName);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void descriptionChanged(ForwardedPort port, @Nls String oldDescription, @Nls String newDescription) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                if (Intrinsics.areEqual((Object)clientPort.getPresentation().getDescription(), (Object)oldDescription)) {
                    void $this$debug_u24default$iv;
                    Logger logger = logger;
                    PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_9 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var10_9.debug(perClientPortForwardingManagerImpl.name + " Port forwarding description has been changed for port <" + port.getTargetPortNumber() + ">: <" + oldDescription + "> -> <" + newDescription + ">", t$iv);
                    }
                    clientPort.getPresentation().setDescription(newDescription);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void iconChanged(ForwardedPort port, Icon oldIcon, Icon newIcon) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                if (Intrinsics.areEqual((Object)clientPort.getPresentation().getIcon(), (Object)oldIcon)) {
                    void $this$debug_u24default$iv;
                    Logger logger = logger;
                    PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_9 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var10_9.debug(perClientPortForwardingManagerImpl.name + " Port forwarding icon has been changed for port <" + port.getTargetPortNumber() + ">", t$iv);
                    }
                    clientPort.getPresentation().setIcon(newIcon);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void tooltipChanged(ForwardedPort port, @NlsContexts.Tooltip String oldTooltip, @NlsContexts.Tooltip String newTooltip) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                if (Intrinsics.areEqual((Object)clientPort.getPresentation().getTooltip(), (Object)oldTooltip)) {
                    void $this$debug_u24default$iv;
                    Logger logger = logger;
                    PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_9 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var10_9.debug(perClientPortForwardingManagerImpl.name + " Port forwarding tooltip has been changed for port <" + port.getTargetPortNumber() + ">: <" + oldTooltip + "> -> <" + newTooltip + ">", t$iv);
                    }
                    clientPort.getPresentation().setTooltip(newTooltip);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void becameReadOnly(ForwardedPort port, @Nls String reason) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                if (!clientPort.getPresentation().isReadOnly()) {
                    void $this$debug_u24default$iv;
                    Logger logger = logger;
                    PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var9_8 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var9_8.debug(perClientPortForwardingManagerImpl.name + " Port forwarding set readonly state for port <" + port.getTargetPortNumber() + ">: " + reason, t$iv);
                    }
                    clientPort.getPresentation().makeReadOnly(reason);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void exposedUrlChanged(ForwardedPort port, String newUrl) {
                void $this$debug_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                ForwardedPort forwardedPort = this.getClientPortForAppPort(port);
                if (forwardedPort == null) {
                    return;
                }
                ForwardedPort clientPort = forwardedPort;
                PortConfiguration portConfiguration = clientPort.getConfiguration();
                Intrinsics.checkNotNull((Object)portConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.portForwarding.internal.configuration.UrlExposureConfigurationImpl");
                UrlExposureConfigurationImpl configuration = (UrlExposureConfigurationImpl)portConfiguration;
                Logger logger = logger;
                PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var10_9 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var10_9.debug(perClientPortForwardingManagerImpl.name + " Port forwarding exposed URL has been changed for port <" + port.getTargetPortNumber() + ">: " + newUrl, t$iv);
                }
                configuration.setExposedUrl(newUrl);
            }
        });
        this.getForwardedPorts$intellij_platform_backend_split().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> PerClientPortForwardingManagerImpl._init_$lambda$0(this, arg_0, arg_1, arg_2));
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PerClientPortForwardingManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = GlobalPortForwardingManagerImpl.Companion.getInstance().getPorts();
                        PerClientPortForwardingManagerImpl perClientPortForwardingManagerImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ForwardedPort globalForwardedPort = (ForwardedPort)element$iv;
                            boolean bl = false;
                            perClientPortForwardingManagerImpl.inheritPortFromGlobalManager(globalForwardedPort);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public List<ForwardedPort> getPorts(@NotNull PortDirectionType directionType) {
        Intrinsics.checkNotNullParameter((Object)directionType, (String)"directionType");
        return ForwardedPortsFilter.INSTANCE.filterPortsByDirection((List)this.getForwardedPorts$intellij_platform_backend_split(), directionType);
    }

    private final void inheritPortFromGlobalManager(ForwardedPort port) {
        try {
            PortConfiguration configuration = this.createConfiguration(port);
            PortPresentationImpl presentation = new PortPresentationImpl(port.getPresentation());
            PortForwardingResult createResult = this.createDirectPort(port.getTargetPortNumber(), configuration, presentation, port.getLabels());
            if (createResult instanceof PortForwardingResult.Error) {
                logger.warn("Error inheriting port from global port forwarding manager: " + ((PortForwardingResult.Error)createResult).getMessage());
            }
        }
        catch (Throwable e) {
            logger.warn("Undefined error on forwarding port from global port forwarding manager", e);
        }
    }

    private final PortConfiguration createConfiguration(ForwardedPort port) {
        PortConfiguration portConfiguration;
        PortConfiguration parentConfiguration = port.getConfiguration();
        if (parentConfiguration instanceof PortConfiguration.GlobalTcpForwarding) {
            ServerSocketPortAttributes serverSocketPortAttributes;
            List list = DEPRECATED_EP.getPoint().getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensionList(...)");
            ClientPortAttributesProvider clientPortAttributesProvider = (ClientPortAttributesProvider)CollectionsKt.firstOrNull((List)list);
            if (clientPortAttributesProvider != null && (clientPortAttributesProvider = clientPortAttributesProvider.getAttributes(this.session, port)) != null) {
                ClientPortAttributesProvider attributes = clientPortAttributesProvider;
                boolean bl = false;
                serverSocketPortAttributes = new ServerSocketPortAttributes(attributes.getPreferredPortNumber(), PortForwardingUtilsKt.toServerSocketPortPickingStrategy((ClientPortPickingStrategy)attributes.getStrategy()));
            } else {
                serverSocketPortAttributes = null;
            }
            ServerSocketPortAttributes clientPortAttributes = serverSocketPortAttributes;
            List list2 = EP.getPoint().getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
            ServerSocketPortAttributesProvider serverSocketPortAttributesProvider = (ServerSocketPortAttributesProvider)CollectionsKt.firstOrNull((List)list2);
            ServerSocketPortAttributes serverSocketPortAttributes2 = serverSocketPortAttributesProvider != null ? serverSocketPortAttributesProvider.getAttributes(this.session, port) : null;
            PortType portType = ((PortConfiguration.GlobalTcpForwarding)parentConfiguration).getType();
            ServerSocketPortAttributes serverSocketPortAttributes3 = serverSocketPortAttributes2;
            if (serverSocketPortAttributes3 == null && (serverSocketPortAttributes3 = clientPortAttributes) == null) {
                serverSocketPortAttributes3 = new ServerSocketPortAttributes(port.getTargetPortNumber(), ServerSocketPortPickingStrategy.REASSIGN_WHEN_BUSY);
            }
            portConfiguration = (PortConfiguration)new PerClientTcpForwardingConfigurationImpl(portType, serverSocketPortAttributes3);
        } else if (parentConfiguration instanceof PortConfiguration.UrlExposure) {
            portConfiguration = (PortConfiguration)new UrlExposureConfigurationImpl(((PortConfiguration.UrlExposure)parentConfiguration).getExposedUrl());
        } else {
            throw new IllegalStateException(("Unexpected port configuration " + parentConfiguration.getClass()).toString());
        }
        return portConfiguration;
    }

    @Deprecated(message="Scheduled for removal in 2025.1", replaceWith=@ReplaceWith(expression="com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager.tryForwardPort", imports={"com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortAttributes"}))
    @NotNull
    public ForwardedPort forwardPort(int hostPortNumber, @NotNull PortType portType, @NotNull Set<String> labels, @NotNull ClientPortAttributes clientPortAttributes, @NotNull Function1<? super PortPresentation, Unit> init2) {
        Intrinsics.checkNotNullParameter((Object)portType, (String)"portType");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)clientPortAttributes, (String)"clientPortAttributes");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        PortConfiguration.TcpForwarding configuration = this.definePerClientConfiguration(PortDirectionType.DIRECT, portType, PortForwardingUtilsKt.toServerSocketPortAttributes((ClientPortAttributes)clientPortAttributes));
        Set set = CollectionsKt.toSet((Iterable)labels);
        PortConfiguration portConfiguration = (PortConfiguration)configuration;
        PortPresentationImpl portPresentationImpl = new PortPresentationImpl(null, null, null, null, false, null, 63, null);
        init2.invoke((Object)portPresentationImpl);
        return this.createPort(hostPortNumber, set, portConfiguration, portPresentationImpl);
    }

    @Deprecated(message="API is planned to be moved to Platform soon. Please see RDCT-1406 for details.")
    @Nullable
    public Object tryForwardPort(int portNumber, @NotNull PortType portType, @NotNull PortDirectionType directionType, @NotNull Set<String> labels, @NotNull ServerSocketPortAttributes serverSocketPortAttributes, @NotNull Function1<? super PortPresentation, Unit> init2, @NotNull Continuation<? super PortForwardingResult> $completion) {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        return BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PortForwardingResult>, Object>(this, directionType, portType, serverSocketPortAttributes, init2, portNumber, labels, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ PerClientPortForwardingManagerImpl this$0;
            final /* synthetic */ PortDirectionType $directionType;
            final /* synthetic */ PortType $portType;
            final /* synthetic */ ServerSocketPortAttributes $serverSocketPortAttributes;
            final /* synthetic */ Function1<PortPresentation, Unit> $init;
            final /* synthetic */ int $portNumber;
            final /* synthetic */ Set<String> $labels;
            {
                this.this$0 = $receiver;
                this.$directionType = $directionType;
                this.$portType = $portType;
                this.$serverSocketPortAttributes = $serverSocketPortAttributes;
                this.$init = $init;
                this.$portNumber = $portNumber;
                this.$labels = $labels;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        configuration = PerClientPortForwardingManagerImpl.access$definePerClientConfiguration(this.this$0, this.$directionType, this.$portType, this.$serverSocketPortAttributes);
                        var4_5 = new PortPresentationImpl(null, null, null, null, false, null, 63, null);
                        this.$init.invoke((Object)var4_5);
                        presentation = var4_5;
                        switch (tryForwardPort.WhenMappings.$EnumSwitchMapping$0[this.$directionType.ordinal()]) {
                            case 1: {
                                v0 = this.this$0.createDirectPort(this.$portNumber, (PortConfiguration)configuration, presentation, this.$labels);
                                return v0;
                            }
                            case 2: {
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)configuration);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)presentation);
                                this.label = 1;
                                v1 = this.this$0.createReversePort(this.$portNumber, (PortConfiguration)configuration, presentation, this.$labels, (Continuation<? super PortForwardingResult>)((Continuation)this));
                                if (v1 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl29
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 1: {
                        presentation = (PortPresentationImpl)this.L$1;
                        configuration = (PortConfiguration.TcpForwarding)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        v0 = (PortForwardingResult)v1;
                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PortForwardingResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public ForwardedPort exposePort(int hostPortNumber, @NotNull String exposedUrl, @NotNull Set<String> labels, @NotNull Function1<? super PortPresentation, Unit> init2) {
        Intrinsics.checkNotNullParameter((Object)exposedUrl, (String)"exposedUrl");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        UrlExposureConfigurationImpl configuration = new UrlExposureConfigurationImpl(exposedUrl);
        Set set = CollectionsKt.toSet((Iterable)labels);
        PortConfiguration portConfiguration = (PortConfiguration)configuration;
        PortPresentationImpl portPresentationImpl = new PortPresentationImpl(null, null, null, null, false, null, 63, null);
        init2.invoke((Object)portPresentationImpl);
        return this.createPort(hostPortNumber, set, portConfiguration, portPresentationImpl);
    }

    public void nameChanged(@NotNull ForwardedPort port, @Nls @Nullable String oldName, @Nls @Nullable String newName) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.getPerClientPortListeners().nameChanged(this.session, port, oldName, newName);
    }

    public void descriptionChanged(@NotNull ForwardedPort port, @Nls @Nullable String oldDescription, @Nls @Nullable String newDescription) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.getPerClientPortListeners().descriptionChanged(this.session, port, oldDescription, newDescription);
    }

    public void iconChanged(@NotNull ForwardedPort port, @Nullable Icon oldIcon, @Nullable Icon newIcon) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.getPerClientPortListeners().iconChanged(this.session, port, oldIcon, newIcon);
    }

    public void tooltipChanged(@NotNull ForwardedPort port, @NlsContexts.Tooltip @Nullable String oldTooltip, @NlsContexts.Tooltip @Nullable String newTooltip) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.getPerClientPortListeners().tooltipChanged(this.session, port, oldTooltip, newTooltip);
    }

    public void becameReadOnly(@NotNull ForwardedPort port, @Nls @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.getPerClientPortListeners().becameReadOnly(this.session, port, reason);
    }

    public void exposedUrlChanged(@NotNull ForwardedPort port, @NotNull String newUrl) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
        this.getPerClientPortListeners().exposedUrlChanged(this.session, port, newUrl);
    }

    public void stateChanged(@NotNull ForwardedPort port, @NotNull ServerSocketPortState newState) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.getPerClientPortListeners().stateChanged(this.session, port, newState);
    }

    private final PerClientPortListener getPerClientPortListeners() {
        return (PerClientPortListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(PerClientPortListener.Companion.getTOPIC());
    }

    /*
     * Unable to fully structure code
     */
    private final ForwardedPort getClientPortForAppPort(ForwardedPort forwardedPort) {
        block9: {
            block10: {
                block7: {
                    block8: {
                        block6: {
                            $this$debug_u24default$iv = PerClientPortForwardingManagerImpl.logger;
                            t$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var11_6 = $this$debug_u24default$iv;
                                $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$1 = false;
                                var11_6.debug("Get client port for forwarded host port: <" + forwardedPort.getTargetPortNumber() + ">", t$iv);
                            }
                            configuration = forwardedPort.getConfiguration();
                            if (!(configuration instanceof PortConfiguration.GlobalTcpForwarding)) break block8;
                            $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$1 = (Iterable)this.getForwardedPorts$intellij_platform_backend_split();
                            for (T var7_13 : $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$1) {
                                it = (ForwardedPortImpl)var7_13;
                                $i$a$-find-PerClientPortForwardingManagerImpl$getClientPortForAppPort$clientPort$1 = false;
                                if (!(it.getTargetPortNumber() == forwardedPort.getTargetPortNumber())) continue;
                                v0 = var7_13;
                                break block6;
                            }
                            v0 = null;
                        }
                        v1 = v0;
                        break block9;
                    }
                    if (!(configuration instanceof PortConfiguration.UrlExposure)) break block10;
                    $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$1 = (Iterable)this.getForwardedPorts$intellij_platform_backend_split();
                    for (T var7_13 : $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$1) {
                        it = (ForwardedPortImpl)var7_13;
                        $i$a$-find-PerClientPortForwardingManagerImpl$getClientPortForAppPort$clientPort$2 = false;
                        if (it.getTargetPortNumber() != forwardedPort.getTargetPortNumber()) ** GOTO lbl-1000
                        var10_16 = it.getConfiguration();
                        v2 = var10_16 instanceof PortConfiguration.UrlExposure != false ? (PortConfiguration.UrlExposure)var10_16 : null;
                        if (Intrinsics.areEqual((Object)((PortConfiguration.UrlExposure)configuration).getExposedUrl(), (Object)(v2 != null ? v2.getExposedUrl() : null))) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var7_13;
                        break block7;
                    }
                    v4 = null;
                }
                v1 = v4;
                break block9;
            }
            v1 = null;
        }
        clientPort = v1;
        $this$debug_u24default$iv = PerClientPortForwardingManagerImpl.logger;
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            var11_6 = $this$debug_u24default$iv;
            $i$a$-debug$default-PerClientPortForwardingManagerImpl$getClientPortForAppPort$2 = false;
            var11_6.debug("Client port that is forwarded to host port <" + forwardedPort.getTargetPortNumber() + ">: " + clientPort, t$iv);
        }
        return clientPort;
    }

    private final PortConfiguration.TcpForwarding definePerClientConfiguration(PortDirectionType direction, PortType portType, ServerSocketPortAttributes serverSocketPortAttributes) {
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> (PortConfiguration.TcpForwarding)new PerClientTcpForwardingConfigurationImpl(portType, serverSocketPortAttributes);
            case 2 -> (PortConfiguration.TcpForwarding)new PerClientTcpReversedForwardingConfigurationImpl(portType, serverSocketPortAttributes);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit lambda$0$0(PerClientPortForwardingManagerImpl this$0, ForwardedPortImpl $port) {
        logger.info(this$0.name + " Lifetime has been terminated for port <" + $port.getTargetPortNumber() + ">. Remove port from forwarding.");
        this$0.getPerClientPortListeners().portRemoved(this$0.session, (ForwardedPort)$port);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(PerClientPortForwardingManagerImpl this$0, Lifetime portLifetime, int n, ForwardedPortImpl port) {
        Intrinsics.checkNotNullParameter((Object)portLifetime, (String)"portLifetime");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        portLifetime.onTermination(() -> PerClientPortForwardingManagerImpl.lambda$0$0(this$0, port));
        logger.info(this$0.name + " Add new forwarded port: <" + port.getTargetPortNumber() + ">");
        port.addPortListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)portLifetime, null, (int)1, null), this$0);
        this$0.getPerClientPortListeners().portAdded(this$0.session, (ForwardedPort)port);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ PortConfiguration.TcpForwarding access$definePerClientConfiguration(PerClientPortForwardingManagerImpl $this, PortDirectionType direction, PortType portType, ServerSocketPortAttributes serverSocketPortAttributes) {
        return $this.definePerClientConfiguration(direction, portType, serverSocketPortAttributes);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerClientPortForwardingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PerClientPortForwardingManagerImpl.logger = logger;
        DEPRECATED_EP = ExtensionPointName.Companion.create("com.intellij.portForwarding.clientAttributesProvider");
        EP = ExtensionPointName.Companion.create("com.intellij.portForwarding.serverSocketAttributesProvider");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/PerClientPortForwardingManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEPRECATED_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ClientPortAttributesProvider;", "getDEPRECATED_EP$annotations", "EP", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortAttributesProvider;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Scheduled for removal in 2025.1")
        private static /* synthetic */ void getDEPRECATED_EP$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortDirectionType.values().length];
            try {
                nArray[PortDirectionType.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortDirectionType.REVERSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

