/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.codeWithMe.model.PortForwardingModel_GeneratedKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortAlreadyForwardedException;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortForwardingResult;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortPresentation;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.portForwarding.PortForwardingConfiguration;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortImpl;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortValidator;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortsFilter;
import com.jetbrains.rdserver.portForwarding.internal.PortForwardingManagerImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpReversedForwardingConfigurationImpl;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0005J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0004J6\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0084@\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0017J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010%\u001a\u00020\u0017H\u0017J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$H\u0017J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010&\u001a\u00020\u0014H\u0017J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010*\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010-\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010/\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u00100R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/PortForwardingManagerImpl;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortForwardingManager;", "<init>", "()V", "portForwardingEnabled", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getPortForwardingEnabled", "()Lcom/jetbrains/rd/util/reactive/Property;", "mutableForwardedPortsList", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl;", "forwardedPorts", "Lcom/jetbrains/rd/util/reactive/IViewableList;", "getForwardedPorts$intellij_platform_backend_split", "()Lcom/jetbrains/rd/util/reactive/IViewableList;", "createPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "portNumber", "", "labels", "", "", "configuration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;", "presentation", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;", "createDirectPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortForwardingResult;", "createReversePort", "(ILcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isPortForwardingEnabled", "removePort", "port", "getPorts", "", "label", "hostPortNumber", "assertPortForwardingEnabled", "", "getMoniker", "checkPort", "isPerClient", "assertPortNumber", "assertPortNumberInRange", "assertPortNotForwarded", "isForwardingConfirmed", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nPortForwardingManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingManagerImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/PortForwardingManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n60#2,5:247\n13#2:256\n777#3:252\n873#3,2:253\n1#4:255\n*S KotlinDebug\n*F\n+ 1 PortForwardingManagerImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/PortForwardingManagerImpl\n*L\n136#1:247,5\n27#1:256\n147#1:252\n147#1:253,2\n*E\n"})
public abstract class PortForwardingManagerImpl
extends LifetimedService
implements PortForwardingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Property<Boolean> portForwardingEnabled = new Property((Object)false);
    @NotNull
    private final ViewableList<ForwardedPortImpl> mutableForwardedPortsList = new ViewableList(null, 1, null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public final Property<Boolean> getPortForwardingEnabled() {
        return this.portForwardingEnabled;
    }

    @NotNull
    public final IViewableList<ForwardedPortImpl> getForwardedPorts$intellij_platform_backend_split() {
        return (IViewableList)this.mutableForwardedPortsList;
    }

    @Deprecated(message="Please use tryCreatePort() method instead.")
    @NotNull
    protected final ForwardedPort createPort(int portNumber, @NotNull Set<String> labels, @NotNull PortConfiguration configuration, @NotNull PortPresentation presentation) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        PortForwardingResult createPortResult = this.createDirectPort(portNumber, configuration, presentation, labels);
        if (!(createPortResult instanceof PortForwardingResult.Success)) {
            Intrinsics.checkNotNull((Object)createPortResult, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.codeWithMe.portForwarding.PortForwardingResult.Error");
            PortForwardingResult.Error errorResult = (PortForwardingResult.Error)createPortResult;
            if (errorResult instanceof PortForwardingResult.PortAlreadyForwarded) {
                List<ForwardedPort> forwardedPort = PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)configuration) ? ForwardedPortsFilter.INSTANCE.filterFrontendForwardedPorts((List)this.getForwardedPorts$intellij_platform_backend_split(), portNumber) : ForwardedPortsFilter.INSTANCE.filterBackendForwardedPorts((List)this.getForwardedPorts$intellij_platform_backend_split(), portNumber);
                throw new PortAlreadyForwardedException(((PortForwardingResult.Error)createPortResult).getMessage(), (ForwardedPort)CollectionsKt.single(forwardedPort));
            }
            throw new IllegalStateException(((PortForwardingResult.Error)createPortResult).getMessage().toString());
        }
        return ((PortForwardingResult.Success)createPortResult).getPort();
    }

    @NotNull
    protected final PortForwardingResult createDirectPort(int portNumber, @NotNull PortConfiguration configuration, @NotNull PortPresentation presentation, @NotNull Set<String> labels) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        ThreadingAssertions.assertEventDispatchThread();
        this.assertPortForwardingEnabled();
        ForwardedPortImpl forwardedPort = ForwardedPortImpl.Companion.create(portNumber, labels, configuration, presentation);
        PortForwardingResult validationResult = ForwardedPortValidator.INSTANCE.validatePort(CollectionsKt.toList((Iterable)((Iterable)this.getForwardedPorts$intellij_platform_backend_split())), forwardedPort);
        if (validationResult != null) {
            return validationResult;
        }
        logger.info("Create direct forwarded port: <" + portNumber + ">, configuration: " + forwardedPort.getConfiguration().getClass().getSimpleName() + ", moniker: " + this.getMoniker(configuration) + ", labels: " + labels);
        this.mutableForwardedPortsList.add((Object)forwardedPort);
        logger.info("Direct port is created: <" + portNumber + ">");
        return (PortForwardingResult)new PortForwardingResult.Success((ForwardedPort)forwardedPort);
    }

    public static /* synthetic */ PortForwardingResult createDirectPort$default(PortForwardingManagerImpl portForwardingManagerImpl, int n, PortConfiguration portConfiguration, PortPresentation portPresentation, Set set, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createDirectPort");
        }
        if ((n2 & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return portForwardingManagerImpl.createDirectPort(n, portConfiguration, portPresentation, set);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object createReversePort(int portNumber, @NotNull PortConfiguration configuration, @NotNull PortPresentation presentation, @NotNull Set<String> labels, @NotNull Continuation<? super PortForwardingResult> $completion) {
        if (!($completion instanceof createReversePort.1)) ** GOTO lbl-1000
        var9_6 = $completion;
        if ((var9_6.label & -2147483648) != 0) {
            var9_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ PortForwardingManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createReversePort(0, null, null, null, (Continuation<? super PortForwardingResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ThreadingAssertions.assertEventDispatchThread();
                this.assertPortForwardingEnabled();
                forwardedPort = ForwardedPortImpl.Companion.create(portNumber, labels, configuration, presentation);
                validationResult = ForwardedPortValidator.INSTANCE.validatePort(CollectionsKt.toList((Iterable)((Iterable)this.getForwardedPorts$intellij_platform_backend_split())), forwardedPort);
                if (validationResult != null) {
                    return validationResult;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configuration);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)presentation);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)labels);
                $continuation.L$3 = forwardedPort;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)validationResult);
                $continuation.I$0 = portNumber;
                $continuation.label = 1;
                v0 = this.isForwardingConfirmed(portNumber, (Continuation<? super Boolean>)$continuation);
                if (v0 == var10_8) {
                    return var10_8;
                }
                ** GOTO lbl38
            }
            case 1: {
                portNumber = $continuation.I$0;
                validationResult = (PortForwardingResult)$continuation.L$4;
                forwardedPort = (ForwardedPortImpl)$continuation.L$3;
                labels = (Set)$continuation.L$2;
                presentation = (PortPresentation)$continuation.L$1;
                configuration = (PortConfiguration)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return new PortForwardingResult.DeclinedByUsers(portNumber);
                }
                this.mutableForwardedPortsList.add((Object)forwardedPort);
                PortForwardingManagerImpl.logger.info("Reverse port is created: <" + portNumber + ">");
                return new PortForwardingResult.Success((ForwardedPort)forwardedPort);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object createReversePort$default(PortForwardingManagerImpl portForwardingManagerImpl, int n, PortConfiguration portConfiguration, PortPresentation portPresentation, Set set, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createReversePort");
        }
        if ((n2 & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return portForwardingManagerImpl.createReversePort(n, portConfiguration, portPresentation, set, (Continuation<? super PortForwardingResult>)continuation);
    }

    public boolean isPortForwardingEnabled() {
        return (Boolean)this.portForwardingEnabled.getValue();
    }

    @RequiresEdt
    public boolean removePort(@NotNull ForwardedPort port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        logger.info("Remove host port from forwarding: <" + port.getTargetPortNumber() + ">");
        if (!CollectionsKt.contains((Iterable)((Iterable)this.mutableForwardedPortsList), (Object)port)) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Ignore port <" + port.getTargetPortNumber() + "> removing. Port is not forwarded.", t$iv);
            }
            return false;
        }
        ((ForwardedPortImpl)port).setValid$intellij_platform_backend_split(false);
        return this.mutableForwardedPortsList.remove((Object)port);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public List<ForwardedPort> getPorts(@NotNull String label) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Iterable $this$filter$iv = (Iterable)this.mutableForwardedPortsList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPortImpl it = (ForwardedPortImpl)element$iv$iv;
            boolean bl = false;
            if (!it.getLabels().contains(label)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @RequiresEdt
    @NotNull
    public List<ForwardedPort> getPorts() {
        return CollectionsKt.toList((Iterable)((Iterable)this.mutableForwardedPortsList));
    }

    @Deprecated(message="Please use getPorts() method instead or consider using methods from one of the dedicated interfaces: [GlobalPortForwardingManager] or [PerClientPortForwardingManager].")
    @RequiresEdt
    @NotNull
    public List<ForwardedPort> getPorts(int hostPortNumber) {
        return ForwardedPortsFilter.INSTANCE.filterForwardedPortsByTargetPortNumber((List)this.getForwardedPorts$intellij_platform_backend_split(), PortDirectionType.DIRECT, hostPortNumber);
    }

    private final void assertPortForwardingEnabled() {
        if (!this.isPortForwardingEnabled()) {
            boolean bl = false;
            String string = "Port Forwarding is disabled";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String getMoniker(PortConfiguration configuration) {
        String string;
        PortConfiguration portConfiguration = configuration;
        if (portConfiguration instanceof PortConfiguration.UrlExposure) {
            string = ((PortConfiguration.UrlExposure)configuration).getExposedUrl();
        } else if (portConfiguration instanceof PortConfiguration.TcpForwarding) {
            string = ((PortConfiguration.TcpForwarding)configuration).getType().toString();
        } else {
            throw new IllegalStateException(("Unknown port type " + configuration.getClass()).toString());
        }
        return string;
    }

    private final void checkPort(ForwardedPort port, boolean isPerClient) {
        IntRange intRange = PortForwardingConfiguration.INSTANCE.getValidPortsRange();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = port.getTargetPortNumber();
        if (!(n <= n3 ? n3 <= n2 : false)) {
            throw new IllegalStateException(("port " + port.getTargetPortNumber() + " is not in a valid range").toString());
        }
        PortConfiguration configuration = port.getConfiguration();
        if (PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)configuration) && !isPerClient) {
            this.assertPortNotForwarded(port.getTargetPortNumber());
        } else if (configuration instanceof PerClientTcpForwardingConfigurationImpl && isPerClient) {
            this.assertPortNumber(((PerClientTcpForwardingConfigurationImpl)configuration).getAttributes().getPreferredPortNumber());
            this.assertPortNotForwarded(port.getTargetPortNumber());
        } else if (configuration instanceof PerClientTcpReversedForwardingConfigurationImpl && isPerClient) {
            this.assertPortNumber(((PerClientTcpReversedForwardingConfigurationImpl)configuration).getAttributes().getPreferredPortNumber());
            this.assertPortNotForwarded(port.getTargetPortNumber());
        } else if (!PortConfigurationKt.isExposedPort((PortConfiguration)configuration)) {
            throw new IllegalStateException(("Unexpected port type " + configuration.getClass().getName()).toString());
        }
    }

    private final void assertPortNumber(int portNumber) {
        IntRange intRange = PortForwardingConfiguration.INSTANCE.getValidPortsRange();
        int n = intRange.getFirst();
        if (!(portNumber <= intRange.getLast() ? n <= portNumber : false)) {
            boolean bl = false;
            String string = "Port validation error. Port number is out of valid range [1..65535]: <" + portNumber + ">";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void assertPortNumberInRange(int portNumber) {
        IntRange intRange = PortForwardingConfiguration.INSTANCE.getValidPortsRange();
        int n = intRange.getFirst();
        if (!(portNumber <= intRange.getLast() ? n <= portNumber : false)) {
            boolean bl = false;
            String string = "Port validation error. Port number is out of valid range " + PortForwardingConfiguration.INSTANCE.getValidPortsRange() + " <" + portNumber + ">";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void assertPortNotForwarded(int portNumber) {
        List<ForwardedPort> alreadyForwardedPorts = ForwardedPortsFilter.INSTANCE.filterBackendForwardedPorts((List)this.getForwardedPorts$intellij_platform_backend_split(), portNumber);
        if (!((Collection)alreadyForwardedPorts).isEmpty()) {
            throw new PortAlreadyForwardedException("Port validation error. Port <" + portNumber + "> is already forwarded", (ForwardedPort)CollectionsKt.first(alreadyForwardedPorts));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object isForwardingConfirmed(int portNumber, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isForwardingConfirmed.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PortForwardingManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PortForwardingManagerImpl.access$isForwardingConfirmed(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = UtilKt.getControllerSessionOrNull(ApplicationKt.getApplication());
                if (v0 == null) {
                    throw new IllegalStateException(("Unable to confirm reverse forwarding for port: <" + portNumber + ">").toString());
                }
                session = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.I$0 = portNumber;
                $continuation.label = 1;
                v1 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(session))).getAskReverseForwardingConfirmation()), (Object)Boxing.boxInt((int)portNumber), null, (Continuation)$continuation, (int)2, null);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                portNumber = $continuation.I$0;
                session = (ClientAppSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                PortForwardingManagerImpl.logger.info("Is forwarding for port: <" + portNumber + "> is confirmed by a user: " + ((isConfirmed = ((Boolean)v1).booleanValue()) != false));
                return Boxing.boxBoolean((boolean)(isConfirmed != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$isForwardingConfirmed(PortForwardingManagerImpl $this, int portNumber, Continuation $completion) {
        return $this.isForwardingConfirmed(portNumber, (Continuation<? super Boolean>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PortForwardingManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingManagerImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/PortForwardingManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

