/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.screenForwarding.xpra;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.rd.platform.codeWithMe.screenForwarding.ScreenForwardingCommonUtilKt;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingHostSettings;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingUtilKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"xpraOutLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "startXpraServer", "Lcom/intellij/execution/process/KillableProcessHandler;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "freeDisplay", "", "availablePort", "waitForClient", "", "intellij.platform.backend.split"})
public final class XpraUtilKt {
    @NotNull
    private static final Logger xpraOutLogger;

    @NotNull
    public static final KillableProcessHandler startXpraServer(@NotNull ProgressIndicator progressIndicator, int freeDisplay, int availablePort, boolean waitForClient) {
        String[] stringArray;
        String string;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        try {
            string = ScreenForwardingCommonUtilKt.getEffectiveXpraExecutablePath();
        }
        catch (Throwable t) {
            throw new CantRunException(t.getLocalizedMessage(), t);
        }
        String xpraPath = string;
        String[] t = new String[]{xpraPath};
        GeneralCommandLine cmd = new GeneralCommandLine(t);
        cmd.withEnvironment(MapsKt.mapOf((Pair)TuplesKt.to((Object)"XPRA_NOTTY", (Object)"0")));
        File socketsDir = new File(PathManager.getTempPath(), ".xpra");
        String[] stringArray2 = new String[]{"start", ":" + freeDisplay, "--bind-tcp=0.0.0.0:" + availablePort, "--daemon=no", "--opengl=no", "--use-display=no", "--speaker=off", "--microphone=off", "--splash=no", "--socket-dirs=" + socketsDir.getAbsolutePath(), "--html=on"};
        cmd.withParameters(stringArray2);
        ScreenForwardingHostSettings hostSettings = ScreenForwardingHostSettings.Companion.getInstance();
        if (hostSettings.getUseXvfb() && PathEnvironmentVariableUtil.isOnPath((String)"Xvfb")) {
            stringArray = new String[]{"--xvfb=Xvfb"};
            cmd.withParameters(stringArray);
        }
        if (!StringsKt.isBlank((CharSequence)hostSettings.getXpraHtmlServerCustomLocation())) {
            stringArray = new String[]{"--html=" + hostSettings.getXpraHtmlServerCustomLocation()};
            v0 = cmd.withParameters(stringArray);
        } else {
            stringArray = new String[]{"--html=on"};
            v0 = cmd.withParameters(stringArray);
        }
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.starting.xpra", new Object[0]));
        return ScreenForwardingUtilKt.startProcessAndWaitForInitializationOutput(cmd, "xpra is ready", 10000, xpraOutLogger);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding.xpra.xpraOUT");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        xpraOutLogger = logger;
    }
}

