/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.settings.fileBasedSync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentReloadingKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.ide.settings.fileBasedSync.FileBasedSettingsSyncListProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.rd.platform.codeWithMe.settings.fileBasedSync.BackupHelper;
import com.jetbrains.rd.platform.codeWithMe.settings.fileBasedSync.SettingsFileUpdate;
import com.jetbrains.rdserver.settings.fileBasedSync.BackendFileBasedSettingsSyncService;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\n\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u0004\u0018\u00010\tJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "_settingsFileList", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "settingsFileList", "getSettingsFileList", "()Ljava/util/List;", "_settingsFileUpdates", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/jetbrains/rd/platform/codeWithMe/settings/fileBasedSync/SettingsFileUpdate;", "settingsFileUpdates", "Lkotlinx/coroutines/flow/SharedFlow;", "getSettingsFileUpdates", "()Lkotlinx/coroutines/flow/SharedFlow;", "onInitialSyncCompleted", "", "hasInitialSyncCompletedBefore", "", "getOptionsDirectoryPath", "onSettingsFileWritten", "file", "content", "", "onSettingsFileDeleted", "readSettingsFile", "writeSettingsFile", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSettingsFile", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSettingsBackup", "collectSettingsFileList", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendFileBasedSettingsSyncService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendFileBasedSettingsSyncService.kt\ncom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ExtensionPointUtil.kt\ncom/intellij/openapi/externalSystem/autolink/ExtensionPointUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n67#2,4:196\n67#2,4:200\n67#2,4:204\n13#2:222\n29#3:208\n13#3,2:220\n1642#4,10:209\n1915#4:219\n1916#4:224\n1652#4:225\n1#5:223\n*S KotlinDebug\n*F\n+ 1 BackendFileBasedSettingsSyncService.kt\ncom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService\n*L\n124#1:196,4\n145#1:200,4\n167#1:204,4\n191#1:222\n191#1:208\n191#1:220,2\n191#1:209,10\n191#1:219\n191#1:224\n191#1:225\n191#1:223\n*E\n"})
public final class BackendFileBasedSettingsSyncService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private AtomicReference<List<String>> _settingsFileList;
    @NotNull
    private final MutableSharedFlow<SettingsFileUpdate> _settingsFileUpdates;
    @NotNull
    private final SharedFlow<SettingsFileUpdate> settingsFileUpdates;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String KEY_INITIAL_SYNC_COMPLETED_BEFORE = "rdct.settings.file.based.sync.initialSyncCompletedBefore";

    public BackendFileBasedSettingsSyncService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this._settingsFileList = new AtomicReference<List<String>>(this.collectSettingsFileList());
        this._settingsFileUpdates = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.settingsFileUpdates = FlowKt.asSharedFlow(this._settingsFileUpdates);
        FileBasedSettingsSyncListProvider.Companion.getEP_NAME().getPoint().addChangeListener(this.coroutineScope, () -> BackendFileBasedSettingsSyncService._init_$lambda$0(this));
    }

    @NotNull
    public final List<String> getSettingsFileList() {
        List<String> list = this._settingsFileList.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        return list;
    }

    @NotNull
    public final SharedFlow<SettingsFileUpdate> getSettingsFileUpdates() {
        return this.settingsFileUpdates;
    }

    public final void onInitialSyncCompleted() {
        PropertiesComponent.getInstance().setValue(KEY_INITIAL_SYNC_COMPLETED_BEFORE, true);
    }

    public final boolean hasInitialSyncCompletedBefore() {
        return PropertiesComponent.getInstance().getBoolean(KEY_INITIAL_SYNC_COMPLETED_BEFORE);
    }

    @NotNull
    public final String getOptionsDirectoryPath() {
        return ((Object)PathManager.getOptionsDir()).toString();
    }

    public final void onSettingsFileWritten(@NotNull String file2, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this._settingsFileList.get().contains(file2)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file2, content, null){
                int label;
                final /* synthetic */ BackendFileBasedSettingsSyncService this$0;
                final /* synthetic */ String $file;
                final /* synthetic */ byte[] $content;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$content = $content;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BackendFileBasedSettingsSyncService.access$get_settingsFileUpdates$p(this.this$0).emit((Object)new SettingsFileUpdate.Written(this.$file, this.$content), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void onSettingsFileDeleted(@NotNull String file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this._settingsFileList.get().contains(file2)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file2, null){
                int label;
                final /* synthetic */ BackendFileBasedSettingsSyncService this$0;
                final /* synthetic */ String $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BackendFileBasedSettingsSyncService.access$get_settingsFileUpdates$p(this.this$0).emit((Object)new SettingsFileUpdate.Deleted(this.$file), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    public final byte[] readSettingsFile(@NotNull String file2) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read settings file: " + file2);
        }
        try {
            byte[] byArray2;
            Path path = PathManager.getOptionsDir().resolve(file2);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                byte[] byArray3 = Files.readAllBytes(path);
                byArray2 = byArray3;
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
            } else {
                byArray2 = new byte[]{};
            }
            byArray = byArray2;
        }
        catch (Exception e) {
            LOG.error("Failed to read settings file: " + file2, (Throwable)e);
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object writeSettingsFile(@NotNull String file, @NotNull byte[] content, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeSettingsFile.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BackendFileBasedSettingsSyncService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeSettingsFile(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = BackendFileBasedSettingsSyncService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var8_11 = $this$trace$iv;
                    $i$a$-trace-BackendFileBasedSettingsSyncService$writeSettingsFile$2 = false;
                    var8_11.trace("Write settings file: " + file + " " + content.length + " bytes");
                }
                v0 = PathManager.getOptionsDir().resolve(file);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
                var4_7 = PathKt.safeOutputStream((Path)v0);
                $i$f$trace = null;
                try {
                    it = (OutputStream)var4_7;
                    $i$a$-use-BackendFileBasedSettingsSyncService$writeSettingsFile$3 = false;
                    it.write(content);
                    var6_13 = Unit.INSTANCE;
                }
                catch (Throwable var7_15) {
                    $i$f$trace = var7_15;
                    throw var7_15;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var4_7, (Throwable)$i$f$trace);
                }
                $i$f$trace = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)ApplicationKt.getApplication()));
                v1 = $i$f$trace instanceof ComponentStoreImpl != false ? (ComponentStoreImpl)$i$f$trace : null;
                if (v1 == null) return Unit.INSTANCE;
                $continuation.L$0 = file;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)content);
                $continuation.label = 1;
                v2 = ComponentReloadingKt.reloadComponents$default((ComponentStoreImpl)v1, (Collection)CollectionsKt.listOf((Object)file), (Collection)CollectionsKt.emptyList(), null, (boolean)false, (Continuation)$continuation, (int)12, null);
                if (v2 != var11_6) return Unit.INSTANCE;
                return var11_6;
            }
            case 1: {
                content = (byte[])$continuation.L$1;
                file = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                return Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            LoggerKt.rethrowControlFlowException((Throwable)e);
            BackendFileBasedSettingsSyncService.LOG.error("Failed to write settings file and reload component: " + file, (Throwable)e);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object deleteSettingsFile(@NotNull String file, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof deleteSettingsFile.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BackendFileBasedSettingsSyncService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteSettingsFile(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = BackendFileBasedSettingsSyncService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var6_10 = $this$trace$iv;
                    $i$a$-trace-BackendFileBasedSettingsSyncService$deleteSettingsFile$2 = false;
                    var6_10.trace("Delete settings file: " + file);
                }
                v0 = PathManager.getOptionsDir().resolve(file);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
                if (!Files.deleteIfExists(v0)) return Unit.INSTANCE;
                var4_9 = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)ApplicationKt.getApplication()));
                v1 = var4_9 instanceof ComponentStoreImpl != false ? (ComponentStoreImpl)var4_9 : null;
                if (v1 == null) return Unit.INSTANCE;
                $continuation.L$0 = file;
                $continuation.label = 1;
                v2 = ComponentReloadingKt.reloadComponents$default((ComponentStoreImpl)v1, (Collection)CollectionsKt.listOf((Object)file), (Collection)CollectionsKt.emptyList(), null, (boolean)false, (Continuation)$continuation, (int)12, null);
                if (v2 != var9_5) return Unit.INSTANCE;
                return var9_5;
            }
            case 1: {
                file = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                return Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            LoggerKt.rethrowControlFlowException((Throwable)e);
            BackendFileBasedSettingsSyncService.LOG.error("Failed to delete settings file and reload component: " + file, (Throwable)e);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final String createSettingsBackup() {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        return BackupHelper.INSTANCE.createSettingsBackup(path, LOG);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectSettingsFileList() {
        void $this$mapNotNullTo$iv$iv$iv;
        ExtensionPointName $this$mapExtensionSafe$iv = FileBasedSettingsSyncListProvider.Companion.getEP_NAME();
        boolean $i$f$mapExtensionSafe = false;
        Iterable $this$mapNotNull$iv$iv = $this$mapExtensionSafe$iv.getExtensionList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv$iv;
            Object object;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it$iv = element$iv$iv$iv;
            boolean bl2 = false;
            Object $this$runExtensionSafe$iv$iv = it$iv;
            boolean $i$f$runExtensionSafe = false;
            Object t = $this$runExtensionSafe$iv$iv;
            try {
                FileBasedSettingsSyncListProvider it = (FileBasedSettingsSyncListProvider)t;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)it.getSettingsFileList());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ExtensionPointImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            if (LoggerKt.getOrLogException((Object)object, (Logger)logger) == null) continue;
            boolean bl4 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv$iv));
    }

    private static final void _init_$lambda$0(BackendFileBasedSettingsSyncService this$0) {
        this$0._settingsFileList.set(this$0.collectSettingsFileList());
    }

    @JvmStatic
    @NotNull
    public static final BackendFileBasedSettingsSyncService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ MutableSharedFlow access$get_settingsFileUpdates$p(BackendFileBasedSettingsSyncService $this) {
        return $this._settingsFileUpdates;
    }

    static {
        Logger logger = Logger.getInstance(BackendFileBasedSettingsSyncService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "KEY_INITIAL_SYNC_COMPLETED_BEFORE", "", "getInstance", "Lcom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendFileBasedSettingsSyncService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendFileBasedSettingsSyncService.kt\ncom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,195:1\n42#2,3:196\n*S KotlinDebug\n*F\n+ 1 BackendFileBasedSettingsSyncService.kt\ncom/jetbrains/rdserver/settings/fileBasedSync/BackendFileBasedSettingsSyncService$Companion\n*L\n42#1:196,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BackendFileBasedSettingsSyncService getInstance() {
            boolean $i$f$service = false;
            Class<BackendFileBasedSettingsSyncService> serviceClass$iv = BackendFileBasedSettingsSyncService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (BackendFileBasedSettingsSyncService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

