/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManager;
import com.intellij.platform.split.connection.protocol.transport.SocketStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapper;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapperImpl;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreatorImpl;
import com.intellij.platform.split.connection.protocol.transport.tls.TlsData;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.jetbrains.rd.platform.codeWithMe.util.NetUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.connection.certificate.ServerTrustManager;
import com.jetbrains.rdserver.portForwarding.utils.LsofInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.RdServerDirectConnectionsListener;
import com.jetbrains.rdserver.startup.RdServerPort;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0002JD\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001aJ4\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u001c\u0010\u001d\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001eH\u0082@\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lcom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener;", "", "<init>", "()V", "startListener", "Lkotlin/Pair;", "Ljava/net/InetAddress;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "connectionManager", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "address", "port", "Lcom/jetbrains/rdserver/startup/RdServerPort;", "autoAcceptConnection", "", "acceptAnySession", "bindSocketWithRandomPort", "Ljava/nio/channels/ServerSocketChannel;", "startPort", "bindSocketWithProvidedPort", "startRdServer", "logBindDiagnostic", "", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryWithCancellation", "T", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nRdServerDirectConnectionsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdServerDirectConnectionsListener.kt\ncom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,306:1\n1915#2,2:307\n108#3,2:309\n27#3:311\n87#3,2:312\n28#3,2:314\n108#3,2:316\n27#3:318\n87#3,2:319\n28#3,3:321\n98#3:324\n90#3,6:325\n30#3:331\n98#3:332\n90#3,6:333\n*S KotlinDebug\n*F\n+ 1 RdServerDirectConnectionsListener.kt\ncom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener\n*L\n274#1:307,2\n142#1:309,2\n142#1:311\n142#1:312,2\n142#1:314,2\n148#1:316,2\n148#1:318\n148#1:319,2\n148#1:321,3\n148#1:324\n148#1:325,6\n142#1:331\n142#1:332\n142#1:333,6\n*E\n"})
public final class RdServerDirectConnectionsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final Pair<InetAddress, Integer> startListener(@NotNull Lifetime lifetime, @NotNull RdServerConnectionManager connectionManager, @Nullable InetAddress address, @NotNull RdServerPort port, boolean autoAcceptConnection, boolean acceptAnySession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        InetAddress inetAddress = address;
        if (inetAddress == null) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        InetAddress addressToBind = inetAddress;
        Intrinsics.checkNotNull((Object)addressToBind);
        return this.startRdServer(lifetime, port, connectionManager, autoAcceptConnection, acceptAnySession, addressToBind);
    }

    public static /* synthetic */ Pair startListener$default(RdServerDirectConnectionsListener rdServerDirectConnectionsListener, Lifetime lifetime, RdServerConnectionManager rdServerConnectionManager, InetAddress inetAddress, RdServerPort rdServerPort, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            inetAddress = null;
        }
        if ((n & 8) != 0) {
            rdServerPort = RdServerPort.FirstAvailable.Default.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return rdServerDirectConnectionsListener.startListener(lifetime, rdServerConnectionManager, inetAddress, rdServerPort, bl, bl2);
    }

    private final ServerSocketChannel bindSocketWithRandomPort(InetAddress address, int startPort) {
        int attempts = 5;
        int attempt = 1;
        while (true) {
            int firstAvailablePort = NetUtil.findFirstAvailablePort$default((NetUtil)NetUtil.INSTANCE, (InetAddress)address, (int)startPort, (int)0, (int)4, null);
            LOG.info("Trying to listen on port " + firstAvailablePort);
            try {
                return this.bindSocketWithProvidedPort(address, firstAvailablePort);
            }
            catch (BindException e) {
                LOG.info("Binding a socket to port " + firstAvailablePort + " failed. Attempt " + attempt + " of " + attempts);
                if (attempt == attempts) {
                    throw e;
                }
                if (attempt != attempts) {
                    ++attempt;
                    continue;
                }
                throw new IllegalStateException("Failed to bind socket to a random port".toString());
            }
            break;
        }
    }

    private final ServerSocketChannel bindSocketWithProvidedPort(InetAddress address, int port) {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        InetSocketAddress bindAddress = new InetSocketAddress(address, port);
        try {
            serverSocketChannel.bind(bindAddress);
        }
        catch (BindException e) {
            serverSocketChannel.close();
            CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, bindAddress, null){
                int label;
                final /* synthetic */ RdServerDirectConnectionsListener this$0;
                final /* synthetic */ InetSocketAddress $bindAddress;
                {
                    this.this$0 = $receiver;
                    this.$bindAddress = $bindAddress;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RdServerDirectConnectionsListener.access$logBindDiagnostic(this.this$0, this.$bindAddress, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            throw e;
        }
        Intrinsics.checkNotNull((Object)serverSocketChannel);
        return serverSocketChannel;
    }

    private final Pair<InetAddress, Integer> startRdServer(Lifetime lifetime, RdServerPort port, RdServerConnectionManager connectionManager, boolean autoAcceptConnection, boolean acceptAnySession, InetAddress address) {
        ServerSocketChannel serverSocketChannel;
        RdServerPort rdServerPort = port;
        if (rdServerPort instanceof RdServerPort.FirstAvailable) {
            int startPort = ((RdServerPort.FirstAvailable)port).getStartPort();
            LOG.info("Preparing to listen for connections on random port starting from " + startPort);
            serverSocketChannel = this.bindSocketWithRandomPort(address, startPort);
        } else if (rdServerPort instanceof RdServerPort.Fixed) {
            LOG.info("Preparing to listen for connections on port " + ((RdServerPort.Fixed)port).getPort());
            serverSocketChannel = this.bindSocketWithProvidedPort(address, ((RdServerPort.Fixed)port).getPort());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ServerSocketChannel serverSocketChannel2 = serverSocketChannel;
        SocketAddress socketAddress = serverSocketChannel2.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress localSocketAddress = (InetSocketAddress)socketAddress;
        int localPort = localSocketAddress.getPort();
        lifetime.onTermination(() -> RdServerDirectConnectionsListener.startRdServer$lambda$0(serverSocketChannel2));
        LOG.info("Created listening socket on " + localSocketAddress.getHostString() + ":" + localPort);
        Thread listeningThread2 = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"RdServer", (int)0, () -> RdServerDirectConnectionsListener.startRdServer$lambda$1(localPort, lifetime, serverSocketChannel2, autoAcceptConnection, acceptAnySession, connectionManager), (int)21, null);
        lifetime.onTermination(() -> RdServerDirectConnectionsListener.startRdServer$lambda$2(listeningThread2));
        return new Pair((Object)address, (Object)localPort);
    }

    /*
     * Unable to fully structure code
     */
    private final Object logBindDiagnostic(InetSocketAddress address, Continuation<? super Unit> $completion) {
        if (!($completion instanceof logBindDiagnostic.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ RdServerDirectConnectionsListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RdServerDirectConnectionsListener.access$logBindDiagnostic(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                port = address.getPort();
                if (!SystemInfo.isLinux) {
                    RdServerDirectConnectionsListener.LOG.info("Not running linux, can't diagnose ports on current OS yet");
                    return Unit.INSTANCE;
                }
                if (port <= 0) {
                    RdServerDirectConnectionsListener.LOG.warn("Can't a diagnose a port number " + port);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)address);
                $continuation.I$0 = port;
                $continuation.label = 1;
                v0 = this.tryWithCancellation((Function1<? super Continuation<? super T>, ? extends Object>)((Function1)new Function1<Continuation<? super List<? extends Integer>>, Object>(port, null){
                    int label;
                    final /* synthetic */ int $port;
                    {
                        this.$port = $port;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = LsofInfoUtil.INSTANCE.getPidsUsingPort(this.$port, (Continuation<? super List<Integer>>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super List<Integer>> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super T>)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                port = $continuation.I$0;
                address = (InetSocketAddress)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                if ((pids = (List)v0) == null) {
                    RdServerDirectConnectionsListener.LOG.warn("Failed to get pids for port " + port + ", no further diagnostic can be done");
                    return Unit.INSTANCE;
                }
                if (pids.isEmpty()) {
                    RdServerDirectConnectionsListener.LOG.warn("No pids found LISTENING on port " + port);
                    return Unit.INSTANCE;
                }
                RdServerDirectConnectionsListener.LOG.info("Found the following pids LISTENING on port " + port + ": " + CollectionsKt.joinToString$default((Iterable)pids, null, null, null, (int)0, null, null, (int)63, null));
                $this$forEach$iv = pids;
                $i$f$forEach = 0;
                var7_10 = $this$forEach$iv.iterator();
lbl41:
                // 3 sources

                while (var7_10.hasNext()) {
                    element$iv = var7_10.next();
                    pid = ((Number)element$iv).intValue();
                    $i$a$-forEach-RdServerDirectConnectionsListener$logBindDiagnostic$2 = 0;
                    RdServerDirectConnectionsListener.LOG.warn(port + " is being LISTENED by pid " + pid + ", trying to dump command line");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)address);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pids);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$3 = var7_10;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.I$0 = port;
                    $continuation.I$1 = $i$f$forEach;
                    $continuation.I$2 = pid;
                    $continuation.I$3 = $i$a$-forEach-RdServerDirectConnectionsListener$logBindDiagnostic$2;
                    $continuation.label = 2;
                    v1 = this.tryWithCancellation((Function1<? super Continuation<? super T>, ? extends Object>)((Function1)new Function1<Continuation<? super String>, Object>(pid, null){
                        int label;
                        final /* synthetic */ int $pid;
                        {
                            this.$pid = $pid;
                            super(1, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return ProcessInfoUtil.Companion.getForCurrentOs().get(this.$pid).getCommandLine();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super String> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation<? super T>)$continuation);
                    if (v1 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl73
                }
                break;
            }
            case 2: {
                $i$a$-forEach-RdServerDirectConnectionsListener$logBindDiagnostic$2 = $continuation.I$3;
                pid = $continuation.I$2;
                $i$f$forEach = $continuation.I$1;
                port = $continuation.I$0;
                element$iv = $continuation.L$4;
                var7_10 = (Iterator<T>)$continuation.L$3;
                $this$forEach$iv = (Iterable)$continuation.L$2;
                pids = (List)$continuation.L$1;
                address = (InetSocketAddress)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl73:
                // 2 sources

                if ((commandLine = (String)v1) != null) ** GOTO lbl76
                RdServerDirectConnectionsListener.LOG.warn("Failed to get commandline for pid " + pid);
                ** GOTO lbl41
lbl76:
                // 1 sources

                RdServerDirectConnectionsListener.LOG.warn(port + " is being LISTENED by pid " + pid + ", commandLine=" + commandLine);
                ** GOTO lbl41
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final <T> Object tryWithCancellation(Function1<? super Continuation<? super T>, ? extends Object> action, Continuation<? super T> $completion) {
        if (!($completion instanceof tryWithCancellation.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RdServerDirectConnectionsListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RdServerDirectConnectionsListener.access$tryWithCancellation(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)action);
                $continuation.label = 1;
                v0 = action.invoke($continuation);
                ** if (v0 != var8_5) goto lbl19
lbl18:
                // 1 sources

                return var8_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                action = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var3_6 = v0;
                }
                catch (Throwable e) {
                    var5_8 = e;
                    if (var5_8 instanceof ControlFlowException) {
                        throw e;
                    }
                    if (var5_8 instanceof CancellationException) {
                        throw e;
                    }
                    RdServerDirectConnectionsListener.LOG.warn(e);
                    var3_6 = null;
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean startRdServer$lambda$1$0$0$0$0(RdServerConnectionManager $connectionManager, String sessionId) {
        return $connectionManager.isSessionAccepted(sessionId);
    }

    private static final SelfSignedCertificate.SelfSignedCertificateData startRdServer$lambda$1$0$0$0$1(RdServerConnectionManager $connectionManager) {
        return (SelfSignedCertificate.SelfSignedCertificateData)$connectionManager.getHostCertificate().getValue();
    }

    private static final TransportWrapper startRdServer$lambda$1$0$0$0(String $id, SocketChannel $socketChannel, boolean $acceptAnySession, RdServerConnectionManager $connectionManager, Lifetime transportLifetime, LifetimeDefinition streamTransportLifetime) {
        Intrinsics.checkNotNullParameter((Object)transportLifetime, (String)"transportLifetime");
        Intrinsics.checkNotNullParameter((Object)streamTransportLifetime, (String)"streamTransportLifetime");
        Lifetime lifetime = (Lifetime)streamTransportLifetime;
        Intrinsics.checkNotNull((Object)$socketChannel);
        SocketStreamTransport transport = new SocketStreamTransport(lifetime, $id, $socketChannel);
        ServerTrustManager serverTrustManager = new ServerTrustManager($acceptAnySession, (Function1<? super String, Boolean>)((Function1)arg_0 -> RdServerDirectConnectionsListener.startRdServer$lambda$1$0$0$0$0($connectionManager, arg_0)));
        TlsData tlsData = new TlsData(true, (RemoteTrustManager)serverTrustManager, () -> RdServerDirectConnectionsListener.startRdServer$lambda$1$0$0$0$1($connectionManager), null, 8, null);
        return (TransportWrapper)new TransportWrapperImpl(transportLifetime, streamTransportLifetime, $id, tlsData, true, (StreamTransport)transport);
    }

    private static final Unit startRdServer$lambda$0(ServerSocketChannel $serverSocketChannel) {
        $serverSocketChannel.close();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit startRdServer$lambda$1(int $localPort, Lifetime $lifetime, ServerSocketChannel $serverSocketChannel, boolean $autoAcceptConnection, boolean $acceptAnySession, RdServerConnectionManager $connectionManager) {
        void $this$spanWithExplicitStart$iv;
        LOG.info("Waiting for connections on port " + $localPort);
        IJTracer iJTracer = TelemetryManager.Companion.getTracer(RdctScopesKt.RDCT);
        String spanName$iv = "rdct.host.NewConnection.socket.listening";
        boolean $i$f$spanWithExplicitStart = false;
        $this$spanWithExplicitStart$iv.spanBuilder(spanName$iv + ": started").startSpan().end();
        SpanBuilder spanBuilder = $this$spanWithExplicitStart$iv.spanBuilder(spanName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Unit unit;
            Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it$iv = span$iv$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                while (RLifetimeKt.isAlive((Lifetime)$lifetime) && $serverSocketChannel.isOpen()) {
                    try {
                        Span $this$useWithoutActiveScope$iv$iv$iv2;
                        SpanBuilder $this$use$iv$iv2;
                        void $this$spanWithExplicitStart$iv2;
                        SocketChannel socketChannel = $serverSocketChannel.accept();
                        socketChannel.socket().setTcpNoDelay(true);
                        IJTracer iJTracer2 = TelemetryManager.Companion.getTracer(RdctScopesKt.RDCT);
                        String spanName$iv2 = "rdct.host.NewConnection.socket.accept";
                        boolean $i$f$spanWithExplicitStart2 = false;
                        $this$spanWithExplicitStart$iv2.spanBuilder(spanName$iv2 + ": started").startSpan().end();
                        Intrinsics.checkNotNullExpressionValue((Object)$this$spanWithExplicitStart$iv2.spanBuilder(spanName$iv2), (String)"spanBuilder(...)");
                        boolean $i$f$use2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$use$iv$iv2.startSpan(), (String)"startSpan(...)");
                        boolean $i$f$useWithoutActiveScope2 = false;
                        try {
                            Job job2;
                            Span span$iv$iv2 = $this$useWithoutActiveScope$iv$iv$iv2;
                            $i$a$-useWithoutActiveScope-TraceKt$use$1$iv$iv = false;
                            AutoCloseable autoCloseable2 = (AutoCloseable)span$iv$iv2.makeCurrent();
                            Throwable throwable2 = null;
                            try {
                                Scope it$iv$iv2 = (Scope)autoCloseable2;
                                $i$a$-use-TraceKt$use$1$1$iv$iv = false;
                                Span it$iv2 = span$iv$iv2;
                                $i$a$-use-TraceKt$spanWithExplicitStart$1$iv = false;
                                boolean bl5 = false;
                                String id = "Tcp:" + socketChannel.getRemoteAddress();
                                LOG.info("Accepted connection from: " + socketChannel.getRemoteAddress() + ", id: " + id);
                                TransportType transportType = TransportType.DirectTcp;
                                TransportCreatorImpl creator = new TransportCreatorImpl(id, transportType, (arg_0, arg_1) -> RdServerDirectConnectionsListener.startRdServer$lambda$1$0$0$0(id, socketChannel, $acceptAnySession, $connectionManager, arg_0, arg_1));
                                if ($autoAcceptConnection) {
                                    LOG.info("Auto-accepting connection from socket transport");
                                }
                                if ($acceptAnySession) {
                                    LOG.info("Auto-accepting any session");
                                }
                                job2 = LifetimeCoroutineUtilKt.launch$default((Lifetime)$lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($lifetime, transportType, id, $connectionManager, $autoAcceptConnection, creator, null){
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    Object L$4;
                                    Object L$5;
                                    Object L$6;
                                    Object L$7;
                                    Object L$8;
                                    Object L$9;
                                    Object L$10;
                                    Object L$11;
                                    Object L$12;
                                    boolean Z$0;
                                    int I$0;
                                    int I$1;
                                    int I$2;
                                    int I$3;
                                    int I$4;
                                    int I$5;
                                    int I$6;
                                    int label;
                                    final /* synthetic */ Lifetime $lifetime;
                                    final /* synthetic */ TransportType $transportType;
                                    final /* synthetic */ String $id;
                                    final /* synthetic */ RdServerConnectionManager $connectionManager;
                                    final /* synthetic */ boolean $autoAcceptConnection;
                                    final /* synthetic */ TransportCreatorImpl $creator;
                                    {
                                        this.$lifetime = $lifetime;
                                        this.$transportType = $transportType;
                                        this.$id = $id;
                                        this.$connectionManager = $connectionManager;
                                        this.$autoAcceptConnection = $autoAcceptConnection;
                                        this.$creator = $creator;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Exception decompiling
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        /*
                                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                         * 
                                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredWhile.dump(StructuredWhile.java:37)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                         *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                                         *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                         */
                                        throw new IllegalStateException("Decompilation failed");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            Job job3 = job2;
                        }
                        catch (CancellationException e$iv$iv$iv) {
                            throw e$iv$iv$iv;
                        }
                        catch (Throwable e$iv$iv$iv) {
                            $this$useWithoutActiveScope$iv$iv$iv2.setStatus(StatusCode.ERROR);
                            throw e$iv$iv$iv;
                        }
                        finally {
                            $this$useWithoutActiveScope$iv$iv$iv2.end();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    catch (AsynchronousCloseException asynchronousCloseException) {
                        break;
                    }
                    catch (Throwable t) {
                        LOG.warn("Error accepting connection at port " + $localPort + ": " + t.getMessage(), t);
                    }
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit2 = unit;
        }
        catch (CancellationException e$iv$iv$iv) {
            throw e$iv$iv$iv;
        }
        catch (Throwable e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv$iv.end();
        }
        LOG.info("Listening on rd connections on port " + $localPort + " is closed");
        return Unit.INSTANCE;
    }

    private static final Unit startRdServer$lambda$2(Thread $listeningThread) {
        $listeningThread.interrupt();
        $listeningThread.join(500L);
        if ($listeningThread.isAlive()) {
            LOG.warn("Listening thread is still alive");
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$logBindDiagnostic(RdServerDirectConnectionsListener $this, InetSocketAddress address, Continuation $completion) {
        return $this.logBindDiagnostic(address, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$tryWithCancellation(RdServerDirectConnectionsListener $this, Function1 action, Continuation $completion) {
        return $this.tryWithCancellation(action, $completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(RdServerDirectConnectionsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nRdServerDirectConnectionsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdServerDirectConnectionsListener.kt\ncom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,306:1\n42#2,3:307\n*S KotlinDebug\n*F\n+ 1 RdServerDirectConnectionsListener.kt\ncom/jetbrains/rdserver/startup/RdServerDirectConnectionsListener$Companion\n*L\n41#1:307,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RdServerDirectConnectionsListener getInstance() {
            boolean $i$f$service = false;
            Class<RdServerDirectConnectionsListener> serviceClass$iv = RdServerDirectConnectionsListener.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RdServerDirectConnectionsListener)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

