/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.RdConstants;
import com.jetbrains.rd.platform.util.CertificateExKt;
import com.jetbrains.rdserver.startup.SecureClientDataKt;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/jetbrains/rdserver/startup/SecureClientData;", "", "certificates", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/util/List;)V", "connectionSessionId", "", "getConnectionSessionId", "()Ljava/lang/String;", "userName", "getUserName", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "clientAnonymizedInstallId", "getClientAnonymizedInstallId", "clientFingerprint", "getClientFingerprint", "singleUseToken", "getSingleUseToken", "issuedOn", "Ljava/util/Date;", "getIssuedOn", "()Ljava/util/Date;", "sanitizeString", "s", "sanitizeUserVisibleString", "getComponent", "Lorg/bouncycastle/asn1/x500/X500Name;", "identifier", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nSecureClientData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureClientData.kt\ncom/jetbrains/rdserver/startup/SecureClientData\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n60#2,5:78\n1#3:83\n10574#4:84\n11007#4,5:85\n1586#5:90\n1661#5,3:91\n*S KotlinDebug\n*F\n+ 1 SecureClientData.kt\ncom/jetbrains/rdserver/startup/SecureClientData\n*L\n32#1:78,5\n74#1:84\n74#1:85,5\n75#1:90\n75#1:91,3\n*E\n"})
public final class SecureClientData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String connectionSessionId;
    @NotNull
    private final String userName;
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final String clientAnonymizedInstallId;
    @NotNull
    private final String clientFingerprint;
    @Nullable
    private final String singleUseToken;
    @NotNull
    private final Date issuedOn;
    @NotNull
    private static final Regex notAllowedCharactersRegex = new Regex("[^a-zA-Z0-9\\-_:\\s.,/+]");

    /*
     * WARNING - void declaration
     */
    public SecureClientData(@NotNull List<? extends X509Certificate> certificates) {
        String string;
        X500Name connectionData;
        X509Certificate permanentCertificate;
        block22: {
            block21: {
                String string2;
                block20: {
                    block19: {
                        String it;
                        String string3;
                        Object object;
                        block18: {
                            block17: {
                                String string4;
                                Pair pair;
                                Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
                                Logger $this$debug_u24default$iv = SecureClientDataKt.access$getLogger$p();
                                Throwable t$iv = null;
                                boolean $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    object = $this$debug_u24default$iv;
                                    boolean bl = false;
                                    object.debug("Create secure client data", t$iv);
                                }
                                if (!(certificates.size() == 2)) {
                                    boolean $i$a$-require-SecureClientData$32 = false;
                                    String $i$a$-require-SecureClientData$32 = "Exactly two certificates must be in guest certification chain, but got " + certificates.size() + ": " + CollectionsKt.joinToString$default((Iterable)certificates, null, null, null, (int)0, null, SecureClientData::lambda$1$0, (int)31, null);
                                    throw new IllegalArgumentException($i$a$-require-SecureClientData$32.toString());
                                }
                                if (Intrinsics.areEqual((Object)certificates.get(0).getSubjectX500Principal(), (Object)certificates.get(1).getIssuerX500Principal())) {
                                    pair = TuplesKt.to((Object)certificates.get(1), (Object)certificates.get(0));
                                } else if (Intrinsics.areEqual((Object)certificates.get(0).getIssuerX500Principal(), (Object)certificates.get(1).getSubjectX500Principal())) {
                                    pair = TuplesKt.to((Object)certificates.get(0), (Object)certificates.get(1));
                                } else {
                                    throw new IllegalStateException("Certificates in guest certification chain look unrelated".toString());
                                }
                                Pair pair2 = pair;
                                X509Certificate sessionCertificate = (X509Certificate)pair2.component1();
                                permanentCertificate = (X509Certificate)pair2.component2();
                                connectionData = X500Name.getInstance((Object)sessionCertificate.getSubjectX500Principal().getEncoded());
                                Date date = sessionCertificate.getNotBefore();
                                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getNotBefore(...)");
                                this.issuedOn = date;
                                SecureClientData secureClientData = this;
                                Intrinsics.checkNotNull((Object)connectionData);
                                ASN1ObjectIdentifier aSN1ObjectIdentifier = BCStyle.SERIALNUMBER;
                                Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"SERIALNUMBER");
                                String string5 = this.getComponent(connectionData, aSN1ObjectIdentifier);
                                if (string5 != null) {
                                    void it2;
                                    String string6 = string5;
                                    object = secureClientData;
                                    boolean bl = false;
                                    string4 = this.sanitizeString((String)it2);
                                    secureClientData = object;
                                } else {
                                    string4 = null;
                                }
                                secureClientData.connectionSessionId = string4;
                                SecureClientData secureClientData2 = this;
                                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = BCStyle.CN;
                                Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier2, (String)"CN");
                                string3 = this.getComponent(connectionData, aSN1ObjectIdentifier2);
                                if (string3 == null) break block17;
                                String bl = string3;
                                object = secureClientData2;
                                boolean bl2 = false;
                                String string7 = this.sanitizeUserVisibleString(it);
                                secureClientData2 = object;
                                string3 = string7;
                                if (string7 != null) break block18;
                            }
                            throw new IllegalStateException("There is no UserName in certificate".toString());
                        }
                        secureClientData2.userName = string3;
                        SecureClientData secureClientData = this;
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = BCStyle.T;
                        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"T");
                        string2 = this.getComponent(connectionData, aSN1ObjectIdentifier);
                        if (string2 == null) break block19;
                        it = string2;
                        object = secureClientData;
                        boolean bl = false;
                        String string8 = this.sanitizeString(it);
                        secureClientData = object;
                        string2 = string8;
                        if (string8 != null) break block20;
                    }
                    throw new IllegalStateException("There is no clientAnonymizedInstallId in certificate".toString());
                }
                secureClientData.clientAnonymizedInstallId = string2;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = BCStyle.UNIQUE_IDENTIFIER;
                Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"UNIQUE_IDENTIFIER");
                string = this.getComponent(connectionData, aSN1ObjectIdentifier);
                if (string == null) break block21;
                String it = string;
                boolean bl = false;
                String string9 = this.sanitizeString(it);
                string = string9;
                if (string9 != null) break block22;
            }
            throw new IllegalStateException("There is no ClientId in certificate".toString());
        }
        String clientIdValue = string;
        this.clientId = new ClientId(clientIdValue);
        this.clientFingerprint = CertificateExKt.getSha3Fingerprint((Certificate)permanentCertificate);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = BCStyle.PSEUDONYM;
        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"PSEUDONYM");
        this.singleUseToken = this.getComponent(connectionData, aSN1ObjectIdentifier);
    }

    @Nullable
    public final String getConnectionSessionId() {
        return this.connectionSessionId;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getClientAnonymizedInstallId() {
        return this.clientAnonymizedInstallId;
    }

    @NotNull
    public final String getClientFingerprint() {
        return this.clientFingerprint;
    }

    @Nullable
    public final String getSingleUseToken() {
        return this.singleUseToken;
    }

    @NotNull
    public final Date getIssuedOn() {
        return this.issuedOn;
    }

    private final String sanitizeString(String s) {
        CharSequence charSequence = s;
        Regex regex = notAllowedCharactersRegex;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    private final String sanitizeUserVisibleString(String s) {
        CharSequence charSequence = s;
        Regex regex = RdConstants.INSTANCE.getNotAllowedNameCharactersRegex();
        String string = "_";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    private final String getComponent(X500Name $this$getComponent, ASN1ObjectIdentifier identifier) {
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        RDN[] rDNArray = $this$getComponent.getRDNs(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)rDNArray, (String)"getRDNs(...)");
        Object[] $this$flatMap$iv = rDNArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (AttributeTypeAndValue element$iv$iv : $this$flatMapTo$iv$iv) {
            RDN it = (RDN)element$iv$iv;
            boolean bl = false;
            AttributeTypeAndValue[] attributeTypeAndValueArray = it.getTypesAndValues();
            Intrinsics.checkNotNullExpressionValue((Object)attributeTypeAndValueArray, (String)"getTypesAndValues(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])attributeTypeAndValueArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttributeTypeAndValue element$iv$iv;
            element$iv$iv = (AttributeTypeAndValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IETFUtils.valueToString((ASN1Encodable)it.getValue()));
        }
        return (String)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    private static final CharSequence lambda$1$0(X509Certificate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getSubjectX500Principal().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/startup/SecureClientData$Companion;", "", "<init>", "()V", "notAllowedCharactersRegex", "Lkotlin/text/Regex;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

