/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeGrid;
import com.jetbrains.ide.model.uiautomation.BeSpacer;
import com.jetbrains.ide.model.uiautomation.BeTab;
import com.jetbrains.ide.model.uiautomation.BeToolWindow;
import com.jetbrains.ide.model.uiautomation.BeToolWindowState;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.ToolWindowComponentId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslLayouterKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslMiscKt;
import com.jetbrains.rd.ui.bedsl.dsl.VerticalGridBuilder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.lux.util.RenderingContext;
import com.jetbrains.rdserver.lux.util.UtilKt;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowHostKt;
import com.jetbrains.rdserver.toolWindow.LazyTabContentHolder;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u000bH\u0002J\f\u0010)\u001a\u00020**\u00020\u0005H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/rdserver/toolWindow/LazyTabContentHolder;", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "content", "Lcom/intellij/ui/content/Content;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "beToolWindow", "Lcom/jetbrains/ide/model/uiautomation/BeToolWindow;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "isDirectTransfer", "", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/wm/ToolWindow;Lcom/jetbrains/ide/model/uiautomation/BeToolWindow;Lcom/jetbrains/rd/util/lifetime/Lifetime;ZLcom/jetbrains/rdserver/ui/converters/TrackOptions;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getContent", "()Lcom/intellij/ui/content/Content;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "getBeToolWindow", "()Lcom/jetbrains/ide/model/uiautomation/BeToolWindow;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "()Z", "getTrackOptions", "()Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "beControl", "Lcom/jetbrains/ide/model/uiautomation/BeGrid;", "getBeControl", "()Lcom/jetbrains/ide/model/uiautomation/BeGrid;", "isActive", "Lcom/jetbrains/rd/util/reactive/Property;", "createBeContent", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "active", "beControlLifetime", "debugDisplayName", "", "swapOutProjectedContent", "", "placeholderControl", "Ljavax/swing/JComponent;", "registerListeners", "tab", "Lcom/jetbrains/ide/model/uiautomation/BeTab;", "trackOwnRenderingContext", "storeRenderingContext", "component", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendToolWindowHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/LazyTabContentHolder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1090:1\n67#2,4:1091\n67#2,4:1095\n67#2,4:1099\n67#2,4:1103\n60#2,5:1107\n13#2:1112\n*S KotlinDebug\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/LazyTabContentHolder\n*L\n871#1:1091,4\n944#1:1095,4\n950#1:1099,4\n954#1:1103,4\n843#1:1107,5\n835#1:1112\n*E\n"})
final class LazyTabContentHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final Content content;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final BeToolWindow beToolWindow;
    @NotNull
    private final Lifetime lifetime;
    private final boolean isDirectTransfer;
    @NotNull
    private final TrackOptions trackOptions;
    @NotNull
    private final BeGrid beControl;
    @NotNull
    private final Property<Boolean> isActive;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String TRACE_INFO_KEY = "LazyTabContentHolder.trace.info";

    public LazyTabContentHolder(@NotNull ClientProjectSession session, @NotNull Content content, @NotNull ToolWindow toolWindow, @NotNull BeToolWindow beToolWindow, @NotNull Lifetime lifetime, boolean isDirectTransfer, @NotNull TrackOptions trackOptions) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)beToolWindow, (String)"beToolWindow");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        this.session = session;
        this.content = content;
        this.toolWindow = toolWindow;
        this.beToolWindow = beToolWindow;
        this.lifetime = lifetime;
        this.isDirectTransfer = isDirectTransfer;
        this.trackOptions = trackOptions;
        this.beControl = BeDslLayouterKt.verticalGrid$default(null, LazyTabContentHolder::beControl$lambda$0, (int)1, null);
        this.isActive = new Property((Object)false);
        this.isActive.view(this.lifetime, (arg_0, arg_1) -> LazyTabContentHolder._init_$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final Content getContent() {
        return this.content;
    }

    @NotNull
    public final ToolWindow getToolWindow() {
        return this.toolWindow;
    }

    @NotNull
    public final BeToolWindow getBeToolWindow() {
        return this.beToolWindow;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final boolean isDirectTransfer() {
        return this.isDirectTransfer;
    }

    @NotNull
    public final TrackOptions getTrackOptions() {
        return this.trackOptions;
    }

    @NotNull
    public final BeGrid getBeControl() {
        return this.beControl;
    }

    private final BeControl createBeContent(boolean active, Lifetime beControlLifetime) {
        if (!active) {
            BeSpacer beSpacer;
            BeSpacer $this$createBeContent_u24lambda_u240 = beSpacer = BeDslMiscKt.spacer();
            boolean bl = false;
            $this$createBeContent_u24lambda_u240.getFocusable().set((Object)true);
            return (BeControl)beSpacer;
        }
        if (this.isDirectTransfer) {
            JComponent jComponent = this.content.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent contentComponent = jComponent;
            Object object = contentComponent.getClientProperty(TRACE_INFO_KEY);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                logger.error("Content of " + this.debugDisplayName(this.content) + " is lux-ified already by " + it);
            }
            JLabel replacedLabel = new JLabel(SplitBackendBundle.INSTANCE.message("toolwindow.component.is.projected.label", new Object[0]));
            this.swapOutProjectedContent(beControlLifetime, replacedLabel);
            JComponent jComponent2 = this.toolWindow.getContentManager().getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
            JComponent realControlForDataContext = jComponent2;
            Window parentWindow = SwingUtilities.getWindowAncestor(realControlForDataContext);
            RenderingContext renderingContext = BackendToolWindowHostKt.access$getRenderingContext(this.toolWindow);
            BeControl control = UtilKt.createDirectTransferComponent$default(beControlLifetime, this.session.getAppSession(), contentComponent, realControlForDataContext, parentWindow, false, false, null, false, renderingContext, 480, null);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Toolwindow content " + this.debugDisplayName(this.content) + " got lux " + control + ", recovered rendering context: " + renderingContext);
            }
            this.trackOwnRenderingContext(beControlLifetime);
            beControlLifetime.bracketIfAlive(() -> LazyTabContentHolder.createBeContent$lambda$3(contentComponent, this), () -> LazyTabContentHolder.createBeContent$lambda$4(contentComponent));
            return control;
        }
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RdProjectId rdProjectId = ProjectUtilKt.getRdProjectId((Project)project);
        String string = this.toolWindow.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ToolWindowComponentId parentId = new ToolWindowComponentId(rdProjectId, string);
        return BackendToolWindowHostKt.createContentBeControl(this.content, TrackOptions.mutate$default(this.trackOptions, null, false, (ComponentId)parentId, 3, null), beControlLifetime);
    }

    private final String debugDisplayName(Content $this$debugDisplayName) {
        return $this$debugDisplayName.getToolwindowTitle() + "/" + $this$debugDisplayName.getTabName() + "/" + $this$debugDisplayName.getDisplayName();
    }

    private final void swapOutProjectedContent(Lifetime beControlLifetime, JComponent placeholderControl) {
        this.content.putUserData(Content.REPLACEMENT_COMPONENT, (Object)placeholderControl);
        beControlLifetime.onTermination(() -> LazyTabContentHolder.swapOutProjectedContent$lambda$0(this, placeholderControl));
    }

    public final void registerListeners(@NotNull BeTab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        SourceExKt.flowInto((ISource)((ISource)this.beToolWindow.getState()), (Lifetime)this.lifetime, (IMutablePropertyBase)((IMutablePropertyBase)this.isActive), arg_0 -> LazyTabContentHolder.registerListeners$lambda$0(this, tab, arg_0));
        SourceExKt.flowInto((ISource)((ISource)this.beToolWindow.getContent().getSelectedIndex()), (Lifetime)this.lifetime, (IMutablePropertyBase)((IMutablePropertyBase)this.isActive), arg_0 -> LazyTabContentHolder.registerListeners$lambda$1(this, tab, arg_0));
        SourceExKt.flowInto((ISource)((ISource)this.beToolWindow.getContent().getTabs()), (Lifetime)this.lifetime, (IMutablePropertyBase)((IMutablePropertyBase)this.isActive), arg_0 -> LazyTabContentHolder.registerListeners$lambda$2(this, tab, arg_0));
        this.isActive.set((Object)LazyTabContentHolder.registerListeners$isContentVisible(this, tab));
        PropertyChangeListener listener2 = arg_0 -> LazyTabContentHolder.registerListeners$lambda$3(this, arg_0);
        this.content.addPropertyChangeListener(listener2);
        this.lifetime.onTermination(() -> LazyTabContentHolder.registerListeners$lambda$4(this, listener2));
    }

    private final void trackOwnRenderingContext(Lifetime lifetime) {
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        JComponent jComponent = this.content.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent contentComponent = jComponent;
        ContentManagerListener listener2 = new ContentManagerListener(this, contentComponent){
            final /* synthetic */ LazyTabContentHolder this$0;
            final /* synthetic */ JComponent $contentComponent;
            {
                this.this$0 = $receiver;
                this.$contentComponent = $contentComponent;
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LazyTabContentHolder.access$storeRenderingContext(this.this$0, this.$contentComponent);
            }
        };
        contentManager2.addContentManagerListener(listener2);
        lifetime.onTermination(() -> LazyTabContentHolder.trackOwnRenderingContext$lambda$0(contentManager2, listener2, this, contentComponent));
    }

    /*
     * WARNING - void declaration
     */
    private final void storeRenderingContext(JComponent component) {
        if (this.beToolWindow.getState().getValueOrNull() == BeToolWindowState.Hidden) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Tool window is hidden, clearing rendering context for " + this.content);
            }
            BackendToolWindowHostKt.access$setRenderingContext(this.toolWindow, null);
        } else {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (graphicsConfiguration == null) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Couldn't store rendering context, not displayable: " + this.content);
                }
            } else {
                RenderingContext renderingContext;
                RenderingContext $i$f$trace = renderingContext = new RenderingContext(component.getWidth(), component.getHeight(), graphicsConfiguration);
                ToolWindow toolWindow = this.toolWindow;
                boolean bl = false;
                Logger $this$trace$iv = logger;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void $this$storeRenderingContext_u24lambda_u242;
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Storing " + (RenderingContext)$this$storeRenderingContext_u24lambda_u242 + " for " + this.content);
                }
                BackendToolWindowHostKt.access$setRenderingContext(toolWindow, renderingContext);
            }
        }
    }

    private static final Unit beControl$lambda$0(VerticalGridBuilder $this$verticalGrid) {
        Intrinsics.checkNotNullParameter((Object)$this$verticalGrid, (String)"$this$verticalGrid");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(LazyTabContentHolder this$0, Lifetime beControlLifetime, boolean active) {
        Intrinsics.checkNotNullParameter((Object)beControlLifetime, (String)"beControlLifetime");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this$0.content + " became " + (active ? "" : "in") + "active", t$iv);
        }
        BeDslLayouterKt.setElement$default((BeGrid)this$0.beControl, (BeControl)this$0.createBeContent(active, beControlLifetime), null, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createBeContent$lambda$3(JComponent $contentComponent, LazyTabContentHolder this$0) {
        $contentComponent.putClientProperty(TRACE_INFO_KEY, this$0.debugDisplayName(this$0.content));
        return Unit.INSTANCE;
    }

    private static final Unit createBeContent$lambda$4(JComponent $contentComponent) {
        $contentComponent.putClientProperty(TRACE_INFO_KEY, null);
        return Unit.INSTANCE;
    }

    private static final Unit swapOutProjectedContent$lambda$0(LazyTabContentHolder this$0, JComponent $placeholderControl) {
        if (Intrinsics.areEqual((Object)this$0.content.getUserData(Content.REPLACEMENT_COMPONENT), (Object)$placeholderControl)) {
            this$0.content.putUserData(Content.REPLACEMENT_COMPONENT, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean registerListeners$isContentVisible(LazyTabContentHolder this$0, BeTab $tab) {
        boolean isWindowShown = InterfacesKt.valueOrDefault((IOptProperty)this$0.beToolWindow.getState(), (Object)BeToolWindowState.Hidden) != BeToolWindowState.Hidden;
        int selectedIndex = ((Number)InterfacesKt.valueOrDefault((IOptProperty)this$0.beToolWindow.getContent().getSelectedIndex(), (Object)0)).intValue();
        boolean isTabSelected = Intrinsics.areEqual((Object)CollectionsKt.getOrNull((List)((List)this$0.beToolWindow.getContent().getTabs()), (int)selectedIndex), (Object)$tab);
        return isWindowShown && isTabSelected;
    }

    private static final boolean registerListeners$lambda$0(LazyTabContentHolder this$0, BeTab $tab, BeToolWindowState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LazyTabContentHolder.registerListeners$isContentVisible(this$0, $tab);
    }

    private static final boolean registerListeners$lambda$1(LazyTabContentHolder this$0, BeTab $tab, int it) {
        return LazyTabContentHolder.registerListeners$isContentVisible(this$0, $tab);
    }

    private static final boolean registerListeners$lambda$2(LazyTabContentHolder this$0, BeTab $tab, IViewableList.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LazyTabContentHolder.registerListeners$isContentVisible(this$0, $tab);
    }

    private static final void registerListeners$lambda$3(LazyTabContentHolder this$0, PropertyChangeEvent e) {
        if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"component") && ((Boolean)this$0.isActive.getValue()).booleanValue()) {
            this$0.isActive.set((Object)false);
            this$0.isActive.set((Object)true);
        }
    }

    private static final Unit registerListeners$lambda$4(LazyTabContentHolder this$0, PropertyChangeListener $listener) {
        this$0.content.removePropertyChangeListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit trackOwnRenderingContext$lambda$0(ContentManager $contentManager, trackOwnRenderingContext.listener.1 $listener, LazyTabContentHolder this$0, JComponent $contentComponent) {
        $contentManager.removeContentManagerListener((ContentManagerListener)$listener);
        this$0.storeRenderingContext($contentComponent);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$storeRenderingContext(LazyTabContentHolder $this, JComponent component) {
        $this.storeRenderingContext(component);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LazyTabContentHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LazyTabContentHolder.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/toolWindow/LazyTabContentHolder$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "TRACE_INFO_KEY", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

