/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.ui.messages.MessagesServiceImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.ui.feelLuckUi.BackendFeelLuckyUiHelper;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0091\u0001\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0016\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdserver/ui/BackendMessagesService;", "Lcom/intellij/ui/messages/MessagesServiceImpl;", "<init>", "()V", "showMessageDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "focusedOptionIndex", "icon", "Ljavax/swing/Icon;", "doNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "alwaysUseIdeaUI", "", "helpId", "invocationPlace", "exitActionTypes", "Lcom/intellij/openapi/ui/ExitActionType;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;IILjavax/swing/Icon;Lcom/intellij/openapi/ui/DoNotAskOption;ZLjava/lang/String;Ljava/lang/String;[Lcom/intellij/openapi/ui/ExitActionType;)I", "Companion", "DialogType", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMessagesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMessagesService.kt\ncom/jetbrains/rdserver/ui/BackendMessagesService\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n13#2:72\n13#3:73\n*S KotlinDebug\n*F\n+ 1 BackendMessagesService.kt\ncom/jetbrains/rdserver/ui/BackendMessagesService\n*L\n19#1:72\n19#1:73\n*E\n"})
public final class BackendMessagesService
extends MessagesServiceImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public int showMessageDialog(@Nullable Project project, @Nullable Component parentComponent, @Nullable String message, @Nullable String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DoNotAskOption doNotAskOption, boolean alwaysUseIdeaUI, @Nullable String helpId, @Nullable String invocationPlace, @NotNull ExitActionType[] exitActionTypes) {
        DialogType type;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)exitActionTypes, (String)"exitActionTypes");
        ClientAppSession session = ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
        if (session.isOwner()) {
            return super.showMessageDialog(project, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, alwaysUseIdeaUI, helpId, invocationPlace, exitActionTypes);
        }
        logger.info("Not showing a modal dialog to a remote client; Title: " + title + "; Message: " + message + "; Options: " + ArraysKt.joinToString$default((Object[])options, null, null, null, (int)0, null, null, (int)63, null));
        List list = ArraysKt.toList((Object[])options);
        if (Intrinsics.areEqual((Object)list, (Object)CollectionsKt.listOf((Object)CommonBundle.getOkButtonText()))) {
            v0 = DialogType.OK;
        } else {
            Object[] objectArray = new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()};
            if (Intrinsics.areEqual((Object)list, (Object)CollectionsKt.listOf((Object[])objectArray))) {
                v0 = DialogType.OK_CANCEL;
            } else {
                objectArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
                if (Intrinsics.areEqual((Object)list, (Object)CollectionsKt.listOf((Object[])objectArray))) {
                    v0 = DialogType.YES_NO;
                } else {
                    objectArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), CommonBundle.getCancelButtonText()};
                    v0 = type = Intrinsics.areEqual((Object)list, (Object)CollectionsKt.listOf((Object[])objectArray)) ? DialogType.YES_NO_CANCEL : DialogType.OK_CANCEL;
                }
            }
        }
        if (type == DialogType.OK) {
            return 0;
        }
        BackendFeelLuckyUiHelper luckyUiHelper = BackendFeelLuckyUiHelper.Companion.getInstance(session);
        if (luckyUiHelper.mayUseDefaultValueInMessageBox(title)) {
            return defaultOptionIndex;
        }
        return type == DialogType.YES_NO_CANCEL || type == DialogType.OK_CANCEL ? -1 : 1;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendMessagesService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendMessagesService.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/ui/BackendMessagesService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/ui/BackendMessagesService$DialogType;", "", "<init>", "(Ljava/lang/String;I)V", "OK", "OK_CANCEL", "YES_NO", "YES_NO_CANCEL", "intellij.platform.backend.split"})
    private static final class DialogType
    extends Enum<DialogType> {
        public static final /* enum */ DialogType OK = new DialogType();
        public static final /* enum */ DialogType OK_CANCEL = new DialogType();
        public static final /* enum */ DialogType YES_NO = new DialogType();
        public static final /* enum */ DialogType YES_NO_CANCEL = new DialogType();
        private static final /* synthetic */ DialogType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DialogType[] values() {
            return (DialogType[])$VALUES.clone();
        }

        public static DialogType valueOf(String value) {
            return Enum.valueOf(DialogType.class, value);
        }

        @NotNull
        public static EnumEntries<DialogType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dialogTypeArray = new DialogType[]{DialogType.OK, DialogType.OK_CANCEL, DialogType.YES_NO, DialogType.YES_NO_CANCEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

