/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorFoldingSynchronizer;", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "from", "Lcom/intellij/openapi/editor/ex/EditorEx;", "to", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getTo", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "map", "", "Lcom/intellij/openapi/editor/FoldRegion;", "toAddOrUpdate", "", "toRemove", "onFoldRegionStateChange", "", "region", "beforeFoldRegionRemoved", "onFoldProcessingEnd", "add", "update", "copied", "addOrUpdate", "remove", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEditorComponentImplConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorFoldingSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n1915#2,2:400\n1915#2,2:402\n1915#2,2:404\n*S KotlinDebug\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorFoldingSynchronizer\n*L\n334#1:400,2\n352#1:402,2\n353#1:404,2\n*E\n"})
final class EditorFoldingSynchronizer
implements FoldingListener {
    @NotNull
    private final EditorEx to;
    @NotNull
    private final Map<FoldRegion, FoldRegion> map;
    @NotNull
    private final Set<FoldRegion> toAddOrUpdate;
    @NotNull
    private final Set<FoldRegion> toRemove;

    public EditorFoldingSynchronizer(@NotNull EditorEx from, @NotNull EditorEx to, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.to = to;
        this.map = new LinkedHashMap();
        this.toAddOrUpdate = new LinkedHashSet();
        this.toRemove = new LinkedHashSet();
        from.getFoldingModel().addListener((FoldingListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        List list = from.getFoldingModel().getRegionsOverlappingWith(0, from.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
        List existingFoldings = list;
        this.to.getFoldingModel().runBatchFoldingOperation(() -> EditorFoldingSynchronizer._init_$lambda$0(existingFoldings, this));
    }

    @NotNull
    public final EditorEx getTo() {
        return this.to;
    }

    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.toAddOrUpdate.add(region);
    }

    public void beforeFoldRegionRemoved(@NotNull FoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.toAddOrUpdate.remove(region);
        this.toRemove.add(region);
    }

    public void onFoldProcessingEnd() {
        this.to.getFoldingModel().runBatchFoldingOperation(() -> EditorFoldingSynchronizer.onFoldProcessingEnd$lambda$0(this));
    }

    private final void add(FoldRegion region) {
        FoldRegion foldRegion = this.to.getFoldingModel().addFoldRegion(region.getStartOffset(), region.getEndOffset(), region.getPlaceholderText());
        if (foldRegion == null) {
            return;
        }
        FoldRegion copy = foldRegion;
        copy.setExpanded(region.isExpanded());
        this.map.put(region, copy);
    }

    private final void update(FoldRegion copied, FoldRegion region) {
        copied.setExpanded(region.isExpanded());
        copied.setPlaceholderText(region.getPlaceholderText());
    }

    private final void addOrUpdate(FoldRegion region) {
        FoldRegion copied = this.map.get(region);
        if (copied == null) {
            this.add(region);
        } else {
            this.update(copied, region);
        }
    }

    private final void remove(FoldRegion region) {
        block0: {
            FoldRegion foldRegion = this.map.remove(region);
            if (foldRegion == null) break block0;
            foldRegion.dispose();
        }
    }

    private static final void _init_$lambda$0(List $existingFoldings, EditorFoldingSynchronizer this$0) {
        Iterable $this$forEach$iv = $existingFoldings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it = (FoldRegion)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onFoldProcessingEnd$lambda$0(EditorFoldingSynchronizer this$0) {
        try {
            FoldRegion it;
            Iterable $this$forEach$iv = this$0.toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FoldRegion)element$iv;
                boolean bl = false;
                this$0.remove(it);
            }
            $this$forEach$iv = this$0.toAddOrUpdate;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FoldRegion)element$iv;
                boolean bl = false;
                this$0.addOrUpdate(it);
            }
        }
        finally {
            this$0.toRemove.clear();
            this$0.toAddOrUpdate.clear();
        }
    }
}

