/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters.toTreeGrid;

import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBViewport;
import com.jetbrains.ide.model.uiautomation.BeColumnDefinition;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeShowBorders;
import com.jetbrains.ide.model.uiautomation.BeSizingType;
import com.jetbrains.ide.model.uiautomation.BeTreeConfiguration;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.ide.model.uiautomation.BeTreeGridLine;
import com.jetbrains.ide.model.uiautomation.BeTreeSelection;
import com.jetbrains.ide.model.uiautomation.BeUnitSize;
import com.jetbrains.ide.model.uiautomation.ChildOffsetSize;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import com.jetbrains.rdserver.ui.converters.toTreeGrid.JListConverterKt;
import com.jetbrains.rdserver.ui.converters.toTreeGrid.MyListModelListener;
import com.jetbrains.rdserver.ui.converters.utils.ComponentPropertiesTrackerUtil;
import com.jetbrains.rdserver.ui.converters.utils.TreeGridConverterUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/ui/converters/toTreeGrid/JListConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Ljavax/swing/JList;", "", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.platform.backend.split"})
public final class JListConverter
implements RdConverter<JList<Object>> {
    @Override
    @NotNull
    public BeControl convert(@NotNull JList<Object> component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        ListModel<Object> model2;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ListModel<Object> listModel = model2 = component.getModel();
        int modelRows = listModel != null ? listModel.getSize() : 0;
        int visibleRows = component.getVisibleRowCount();
        Boolean forceVisibleRowCount = (Boolean)ClientProperty.get((Component)component, (Key)JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY);
        if (forceVisibleRowCount == null || !forceVisibleRowCount.booleanValue() && visibleRows > 0) {
            visibleRows = Math.min(modelRows, visibleRows);
        }
        List list = CollectionsKt.listOf((Object)new BeColumnDefinition("", new BeUnitSize(BeSizingType.Fill, 0, 2, null), null, false, 12, null));
        ListSelectionModel listSelectionModel = component.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"getSelectionModel(...)");
        BeTreeSelection beTreeSelection = TreeGridConverterUtil.INSTANCE.toBeSelectionModel(listSelectionModel);
        ChildOffsetSize childOffsetSize = ChildOffsetSize.DEFAULT;
        int n = visibleRows;
        BeShowBorders beShowBorders = BeShowBorders.None;
        BeTreeConfiguration beTreeConfiguration = new BeTreeConfiguration(list, beTreeSelection, false, childOffsetSize, true, false, beShowBorders, false, null, false, null, n, null, 6016, null);
        BeTreeGridLine root = new BeTreeGridLine(CollectionsKt.emptyList());
        BeTreeGrid table = new BeTreeGrid(root, beTreeConfiguration);
        UpdateFlag selectionUpdate = new UpdateFlag();
        JListConverterKt.access$reloadList(table, component, selectionUpdate, trackOptions, lifetime);
        ListSelectionListener selectionListener = arg_0 -> JListConverter.convert$lambda$0(selectionUpdate, component, table, arg_0);
        MyListModelListener listModelListener = new MyListModelListener(lifetime, table, component, selectionUpdate, trackOptions);
        ComponentPropertiesTrackerUtil.INSTANCE.trackComponentNamedProperty(component, "model", trackOptions, lifetime, (Function1<Object, Unit>)((Function1)arg_0 -> JListConverter.convert$lambda$1(table, component, selectionUpdate, trackOptions, lifetime, arg_0)));
        lifetime.bracketIfAlive(() -> JListConverter.convert$lambda$2(component, selectionListener, listModelListener), () -> JListConverter.convert$lambda$3(component, selectionListener, listModelListener));
        table.getVisible().set((Object)(component.isVisible() ? ControlVisibility.Visible : ControlVisibility.Collapsed));
        return (BeControl)table;
    }

    private static final Unit convert$lambda$0$0(JList $component, BeTreeGrid $table) {
        int n = $component.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            IMutableViewableList children = $table.getFakeRoot().getChildren();
            boolean bl2 = bl = ((Collection)children).size() > i;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            BeTreeGridLine line = (BeTreeGridLine)children.get(i);
            line.isSelected().set((Object)$component.isSelectedIndex(i));
        }
        return Unit.INSTANCE;
    }

    private static final void convert$lambda$0(UpdateFlag $selectionUpdate, JList $component, BeTreeGrid $table, ListSelectionEvent it) {
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)$selectionUpdate, () -> JListConverter.convert$lambda$0$0($component, $table));
    }

    private static final Unit convert$lambda$1(BeTreeGrid $table, JList $component, UpdateFlag $selectionUpdate, TrackOptions $trackOptions, Lifetime $lifetime, Object newValue) {
        if (newValue instanceof List) {
            JListConverterKt.access$reloadList($table, $component, $selectionUpdate, $trackOptions, $lifetime);
        }
        return Unit.INSTANCE;
    }

    private static final Unit convert$lambda$2(JList $component, ListSelectionListener $selectionListener, MyListModelListener $listModelListener) {
        $component.addListSelectionListener($selectionListener);
        $component.getModel().addListDataListener($listModelListener);
        return Unit.INSTANCE;
    }

    private static final Unit convert$lambda$3(JList $component, ListSelectionListener $selectionListener, MyListModelListener $listModelListener) {
        $component.removeListSelectionListener($selectionListener);
        $component.getModel().removeListDataListener($listModelListener);
        return Unit.INSTANCE;
    }
}

