/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.interceptors;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.awt.AnchoredPoint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.BackendRenderedPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.ui.BackendClientComponentHost;
import com.jetbrains.rdserver.ui.popup.BackendBeAbstractPopup;
import com.jetbrains.rdserver.ui.popup.BeListPopupImpl;
import com.jetbrains.rdserver.ui.popup.settings.BeChildPopupBehavior;
import com.jetbrains.rdserver.ui.popup.settings.BeWizardPopupContentProvider;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0016\u0010\f\u001a\u00020\b*\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/ui/interceptors/BackendPopupInterceptor;", "Lcom/intellij/ui/UiInterceptors$PersistentUiInterceptor;", "Lcom/intellij/ui/popup/AbstractPopup;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "doIntercept", "", "component", "relativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "show", "Lcom/jetbrains/rdserver/ui/popup/BackendBeAbstractPopup;", "getScreenPoint", "Ljava/awt/Point;", "point", "tryCreatePopup", "shouldIntercept", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendPopupInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPopupInterceptor.kt\ncom/jetbrains/rdserver/ui/interceptors/BackendPopupInterceptor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n23#2:121\n1#3:122\n*S KotlinDebug\n*F\n+ 1 BackendPopupInterceptor.kt\ncom/jetbrains/rdserver/ui/interceptors/BackendPopupInterceptor\n*L\n51#1:121\n*E\n"})
public final class BackendPopupInterceptor
extends UiInterceptors.PersistentUiInterceptor<AbstractPopup> {
    @NotNull
    private final ClientAppSession session;

    public BackendPopupInterceptor(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(AbstractPopup.class);
        this.session = session;
    }

    protected void doIntercept(@NotNull AbstractPopup component, @Nullable RelativePoint relativePoint) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        BackendBeAbstractPopup popup = this.tryCreatePopup(component);
        if (popup != null) {
            this.show(popup, relativePoint);
        } else if (relativePoint != null) {
            Point point = this.getScreenPoint(relativePoint);
            component.showInScreenCoordinates(relativePoint.getComponent(), point);
        }
    }

    private final void show(BackendBeAbstractPopup $this$show, RelativePoint relativePoint) {
        if (relativePoint == null) {
            $this$show.show$intellij_platform_backend_split(null);
        } else {
            $this$show.show(relativePoint);
        }
    }

    private final Point getScreenPoint(RelativePoint point) {
        Point point2;
        Component component = point.getOriginalComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getOriginalComponent(...)");
        Component originalComponent = component;
        Point point3 = point.getScreenPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"getScreenPoint(...)");
        Point screenPoint = point3;
        BackendClientComponentHost clientComponentHost = BackendClientComponentHost.Companion.getInstance();
        Pair<Component, Rectangle> pair = clientComponentHost.getAnchorComponentAndScreenBounds(originalComponent);
        if (pair == null) {
            BackendPopupInterceptor $this$getScreenPoint_u24lambda_u240 = this;
            boolean bl = false;
            BackendPopupInterceptor $this$thisLogger$iv = $this$getScreenPoint_u24lambda_u240;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BackendPopupInterceptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("BackendClientComponentHost is expected to return non null value", new Throwable());
            return new Point(0, 0);
        }
        Pair<Component, Rectangle> pair2 = pair;
        Component hostComponent = (Component)pair2.component1();
        Rectangle clientBounds = (Rectangle)pair2.component2();
        if (point instanceof AnchoredPoint) {
            AnchoredPoint.Anchor $this$getScreenPoint_u24lambda_u241 = ((AnchoredPoint)point).getAnchor();
            boolean bl = false;
            point2 = $this$getScreenPoint_u24lambda_u241.getPointOnRectangle(clientBounds);
        } else {
            point2 = clientBounds.getLocation();
        }
        Point clientScreenPosition = point2;
        Point hostScreenPosition = new Point();
        SwingUtilities.convertPointToScreen(hostScreenPosition, hostComponent);
        int dx = clientScreenPosition.x - hostScreenPosition.x;
        int dy = clientScreenPosition.y - hostScreenPosition.y;
        screenPoint.translate(dx, dy);
        return screenPoint;
    }

    private final BackendBeAbstractPopup tryCreatePopup(AbstractPopup component) {
        BeListPopupImpl beListPopupImpl;
        if (component instanceof ComboBoxPopup) {
            return null;
        }
        if (component instanceof PopupFactoryImpl.ActionGroupPopup && !Intrinsics.areEqual(component.getClass(), PopupFactoryImpl.ActionGroupPopup.class)) {
            return null;
        }
        ListPopupImpl listPopupImpl = component instanceof ListPopupImpl ? (ListPopupImpl)component : null;
        if (listPopupImpl == null) {
            return null;
        }
        ListPopupImpl listPopup = listPopupImpl;
        if (listPopup.getParent() != null) {
            return null;
        }
        BeWizardPopupContentProvider menuSettings = new BeWizardPopupContentProvider(this.session, (ListPopup)listPopup, BeChildPopupBehavior.ShowOnButtonClick);
        ((ListPopupImpl)component).setSize(((ListPopupImpl)component).getContent().getPreferredSize());
        component.notifyListeners();
        BeListPopupImpl $this$tryCreatePopup_u24lambda_u240 = beListPopupImpl = new BeListPopupImpl(this.session, (ListPopup)listPopup, menuSettings);
        boolean bl = false;
        $this$tryCreatePopup_u24lambda_u240.getSettings().setFocusable(listPopup.shouldRequestFocus());
        return beListPopupImpl;
    }

    public boolean shouldIntercept(@NotNull AbstractPopup component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!Intrinsics.areEqual((Object)ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()), (Object)this.session)) {
            return false;
        }
        if (component instanceof BackendRenderedPopup) {
            return false;
        }
        if (component instanceof ComboBoxPopup) {
            return false;
        }
        if (component instanceof PopupFactoryImpl.ActionGroupPopup && !Intrinsics.areEqual(component.getClass(), PopupFactoryImpl.ActionGroupPopup.class)) {
            return false;
        }
        if (!(component instanceof ListPopupImpl)) {
            return false;
        }
        return ((ListPopupImpl)component).getParent() == null;
    }

    public boolean shouldIntercept(@NotNull AbstractPopup component, @Nullable RelativePoint relativePoint) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.shouldIntercept(component)) {
            return true;
        }
        if (relativePoint != null && Intrinsics.areEqual((Object)ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()), (Object)this.session)) {
            BackendClientComponentHost clientComponentHost;
            Component component2 = relativePoint.getOriginalComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getOriginalComponent(...)");
            Component originalComponent = component2;
            BackendClientComponentHost backendClientComponentHost = clientComponentHost = BackendClientComponentHost.Companion.getInstanceIfCreated();
            return (backendClientComponentHost != null ? backendClientComponentHost.getAnchorComponentAndScreenBounds(originalComponent) : null) != null;
        }
        return false;
    }
}

