/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.java;

import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.util.ChronoUtil;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.EscapeUtilsKt;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.javadoc.PsiDocTagImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.javadoc.PsiMarkdownCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.LiteralExpressionTokenizer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaTextExtractor
extends TextExtractor {
    private static final TokenSet EXCLUDED = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_COMMENT_START, JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS, JavaDocTokenType.DOC_COMMENT_END, JavaDocElementType.DOC_PARAMETER_REF, JavaDocElementType.DOC_REFERENCE_HOLDER});
    private static final TextContentBuilder javadocBuilder = TextContentBuilder.FromPsi.withUnknown(e -> e instanceof PsiInlineDocTag).excluding(e -> EXCLUDED.contains(PsiUtilCore.getElementType((PsiElement)e))).removingIndents(" \t").removingLineSuffixes(" \t");

    @NotNull
    public List<TextContent> buildTextContents(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            JavaTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            JavaTextExtractor.$$$reportNull$$$0(1);
        }
        if (allowedDomains.contains(TextContent.TextDomain.DOCUMENTATION)) {
            PsiDocTagImpl tag;
            if (root instanceof PsiDocComment) {
                List list = HtmlUtilsKt.excludeHtml((TextContent)javadocBuilder.excluding(e -> e instanceof PsiDocTagImpl).withUnknown(e -> e instanceof PsiMarkdownCodeBlock).build(root, TextContent.TextDomain.DOCUMENTATION));
                if (list == null) {
                    JavaTextExtractor.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (root instanceof PsiDocTagImpl && !(tag = (PsiDocTagImpl)root).getName().equals("author")) {
                List list = HtmlUtilsKt.excludeHtml((TextContent)javadocBuilder.build(root, TextContent.TextDomain.DOCUMENTATION));
                if (list == null) {
                    JavaTextExtractor.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        if (root instanceof PsiCommentImpl && allowedDomains.contains(TextContent.TextDomain.COMMENTS)) {
            if (root.getTextLength() == 2) {
                List<TextContent> list = List.of();
                if (list == null) {
                    JavaTextExtractor.$$$reportNull$$$0(4);
                }
                return list;
            }
            List roots = PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)root, e -> ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(PsiUtilCore.getElementType((PsiElement)e)));
            List list = ContainerUtil.createMaybeSingletonList((Object)TextContent.joinWithWhitespace((char)'\n', (List)ContainerUtil.mapNotNull((Collection)roots, c -> TextContentBuilder.FromPsi.removingIndents(" \t*/").removingLineSuffixes(" \t").build(c, TextContent.TextDomain.COMMENTS))));
            if (list == null) {
                JavaTextExtractor.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (root instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)root;
            if (allowedDomains.contains(TextContent.TextDomain.LITERALS) && literalExpression.getValue() instanceof String) {
                if (JavaTextExtractor.shouldBeIgnored(literalExpression)) {
                    List<TextContent> list = List.of();
                    if (list == null) {
                        JavaTextExtractor.$$$reportNull$$$0(6);
                    }
                    return list;
                }
                TextContent content = TextContentBuilder.FromPsi.build(root, TextContent.TextDomain.LITERALS);
                int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literalExpression);
                if (indent >= 0 && indent < 1000 && content != null) {
                    if (indent > 0) {
                        content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)Pattern.compile("(?<=\n)\\s{" + indent + "}"), (CharSequence)content), TextContent.Exclusion::exclude));
                    }
                    content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)Pattern.compile("\\\\\n"), (CharSequence)content), TextContent.Exclusion::exclude));
                    List list = ContainerUtil.createMaybeSingletonList((Object)content.trimWhitespace());
                    if (list == null) {
                        JavaTextExtractor.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                if (indent == -1 && content != null) {
                    content = EscapeUtilsKt.replaceBackslashEscapes((TextContent)content);
                }
                List list = ContainerUtil.createMaybeSingletonList((Object)content);
                if (list == null) {
                    JavaTextExtractor.$$$reportNull$$$0(8);
                }
                return list;
            }
        }
        List<TextContent> list = List.of();
        if (list == null) {
            JavaTextExtractor.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean shouldBeIgnored(@NotNull PsiLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JavaTextExtractor.$$$reportNull$$$0(10);
        }
        return ChronoUtil.isPatternForDateFormat((PsiLiteralExpression)literalExpression) || SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)literalExpression) || LiteralExpressionTokenizer.shouldBeIgnored((PsiLiteralExpression)literalExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/language/java/JavaTextExtractor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/language/java/JavaTextExtractor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

