/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.compose;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeCheckingBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeKeyCheckBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeSkipGroupLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeTraceEventStartLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.BaseLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class ComposeUtils {
    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createBranchFilters() {
        void var0;
        ArrayList<CoverageFilter> result = new ArrayList<CoverageFilter>();
        result.add(new ComposeCheckingBranchFilter());
        result.add(new ComposeKeyCheckBranchFilter());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createLineFilters() {
        void var0;
        ArrayList<BaseLineFilter> result = new ArrayList<BaseLineFilter>();
        result.add(new ComposeSkipGroupLineFilter());
        result.add(new ComposeTraceEventStartLineFilter());
        return var0;
    }

    static boolean isComposeMethod(InstrumentationData data) {
        String string;
        if (!KotlinUtils.isKotlinClass(data)) {
            return false;
        }
        string = ((InstrumentationData)((Object)string)).getMethodDesc();
        return ComposeUtils.isComposeMethod(string);
    }

    static boolean isComposeMethod(String desc) {
        Type[] typeArray;
        Type[] parameters = ((Type)(desc = Type.getType((String)desc))).getArgumentTypes();
        int n = parameters.length;
        if (n < 2) {
            return false;
        }
        int n2 = ComposeUtils.getComposerIndex(typeArray);
        return n2 != -1;
    }

    /*
     * WARNING - void declaration
     */
    static int getComposerIndex(Type[] parameters) {
        Type[] typeArray;
        int i = parameters.length - 1;
        if (i < 0) {
            return -1;
        }
        while (i >= 0 && "I".equals(parameters[i].getDescriptor())) {
            --i;
        }
        if (i < 0 || i == parameters.length - 1) {
            return -1;
        }
        if ("Landroidx/compose/runtime/Composer;".equals(typeArray[i].getDescriptor())) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }
}

