/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.util.ClassListSection;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class UncoveredBranchesSection
extends ClassListSection {
    @Override
    public int getId() {
        return 1;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isEngaged(ProjectData projectData, InstrumentationOptions options) {
        return options.isBranchCoverage;
    }

    @Override
    protected void loadClass(DataInputStream in, ClassData classData, int version) throws IOException {
        for (Object object : classData.getLines()) {
            LineData line = (LineData)object;
            if (line == null || line.getHits() > 0) continue;
            int jumpsNumber = CoverageIOUtil.readINT(in);
            for (int jumpId = 0; jumpId < jumpsNumber; ++jumpId) {
                line.addJump(jumpId);
            }
            int switchesNumber = CoverageIOUtil.readINT(in);
            for (int switchId = 0; switchId < switchesNumber; ++switchId) {
                int keysLength = CoverageIOUtil.readINT(in);
                try {
                    int[] keys = new int[keysLength];
                    int k = 0;
                    while (k < keysLength) {
                        int n = k++;
                        keys[n] = n;
                    }
                    line.addSwitch(switchId, keys);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    ErrorReporter.error("OOM during " + classData + " class loading from report, cannot create switch with " + keysLength + " keys");
                    throw e;
                }
            }
            line.fillArrays();
        }
    }

    @Override
    protected void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        LineData lineData;
        int line;
        LineData[] lines = (LineData[])classData.getLines();
        if (lines == null) {
            return;
        }
        for (line = 0; line < lines.length && ((lineData = lines[line]) == null || lineData.getHits() != 0); ++line) {
        }
        if (line == lines.length) {
            return;
        }
        CoverageIOUtil.writeINT(out, index);
        while (line < lines.length) {
            lineData = lines[line];
            if (lineData != null && lineData.getHits() <= 0) {
                CoverageIOUtil.writeINT(out, lineData.jumpsCount());
                CoverageIOUtil.writeINT(out, lineData.switchesCount());
                for (int i = 0; i < lineData.switchesCount(); ++i) {
                    CoverageIOUtil.writeINT(out, lineData.getSwitchData(i).getHits().length);
                }
            }
            ++line;
        }
    }
}

