/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.connection;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.connection.DockerConnectionConfigurator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.ContainerManagementTool;
import com.intellij.docker.settings.DockerToolKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator;", "Lcom/intellij/docker/connection/DockerConnectionConfigurator;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "label", "getLabel", "createEditors", "Lcom/intellij/docker/connection/DockerConnectionConfigurator$ContributedEditors;", "context", "Lcom/intellij/docker/connection/DockerConnectionConfigurator$ConfiguratorContext;", "(Lcom/intellij/docker/connection/DockerConnectionConfigurator$ConfiguratorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContainerManagementTool", "Lcom/intellij/docker/settings/ContainerManagementTool;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "isEditorModified", "", "editor", "Lcom/intellij/openapi/options/SettingsEditor;", "baseline", "isShouldBeSelected", "Companion", "MyEditor", "intellij.clouds.docker"})
public final class DockerTcpConnectionConfigurator
implements DockerConnectionConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String label;
    @NotNull
    public static final String ID = "DockerTcpConnectionConfigurator";

    public DockerTcpConnectionConfigurator() {
        this.id = ID;
        String string = DockerBundle.message((String)"DockerCloudConfigurable.tcp.socket.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.label = string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public Object createEditors(@NotNull DockerConnectionConfigurator.ConfiguratorContext context, @NotNull Continuation<? super DockerConnectionConfigurator.ContributedEditors> $completion) {
        if (context.getContainerManagementTool() != null && !Intrinsics.areEqual((Object)context.getContainerManagementTool(), (Object)DockerToolKt.getDockerTool())) {
            return null;
        }
        return new DockerConnectionConfigurator.ContributedEditors(new MyEditor(), null, 2, null);
    }

    @Override
    @Nullable
    public ContainerManagementTool getContainerManagementTool(@NotNull DockerCloudConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return DockerToolKt.getDockerTool();
    }

    @Override
    public boolean isEditorModified(@NotNull SettingsEditor<DockerCloudConfiguration> editor, @NotNull DockerCloudConfiguration baseline) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        MyEditor myEditor = editor instanceof MyEditor ? (MyEditor)editor : null;
        return myEditor != null ? myEditor.isModified(baseline) : true;
    }

    @Override
    public boolean isShouldBeSelected(@NotNull DockerCloudConfiguration config2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return DockerConnectionConfigurator.super.isShouldBeSelected(config2) || config2.getCustomConfiguratorId() == null && !StringsKt.isBlank((CharSequence)config2.getApiUrl()) && !((charSequence = (CharSequence)config2.getCertificatesPath()) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator$Companion;", "", "<init>", "()V", "ID", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator$MyEditor;", "Lcom/intellij/docker/connection/DockerConnectionConfigurator$ContributedEditor;", "<init>", "(Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator;)V", "myApiUrlTextField", "Ljavax/swing/JTextField;", "myCertificatesPathTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "isModified", "", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "resetEditorFrom", "", "s", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "intellij.clouds.docker"})
    private final class MyEditor
    extends DockerConnectionConfigurator.ContributedEditor {
        private JTextField myApiUrlTextField;
        private TextFieldWithBrowseButton myCertificatesPathTextField;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isModified(@NotNull DockerCloudConfiguration config2) {
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            JTextField jTextField = this.myApiUrlTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                jTextField = null;
            }
            if (!Intrinsics.areEqual((Object)InternalUtilsKt.safeTrim(jTextField.getText()), (Object)InternalUtilsKt.safeTrim(config2.getApiUrl()))) return true;
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                textFieldWithBrowseButton = null;
            }
            if (Intrinsics.areEqual((Object)textFieldWithBrowseButton.getText(), (Object)config2.getCertificatesPath())) return false;
            return true;
        }

        protected void resetEditorFrom(@NotNull DockerCloudConfiguration s) {
            Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
            if (Intrinsics.areEqual((Object)s.getCustomConfiguratorId(), (Object)DockerTcpConnectionConfigurator.this.getId())) {
                String string;
                JTextField jTextField = this.myApiUrlTextField;
                if (jTextField == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                    jTextField = null;
                }
                jTextField.setText(s.getApiUrl());
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                    textFieldWithBrowseButton = null;
                }
                if ((string = s.getCertificatesPath()) == null) {
                    string = "";
                }
                textFieldWithBrowseButton.setText(string);
            }
        }

        protected void applyEditorTo(@NotNull DockerCloudConfiguration s) {
            String certificatesPath;
            String apiUrl;
            Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
            JTextField jTextField = this.myApiUrlTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                jTextField = null;
            }
            if (StringUtil.isEmpty((String)(apiUrl = InternalUtilsKt.safeTrim(jTextField.getText())))) {
                throw new RuntimeConfigurationError(DockerBundle.message((String)"DockerCloudConfigurable.error.apiUrlRequired", (Object[])new Object[0]));
            }
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                textFieldWithBrowseButton = null;
            }
            if (!StringUtil.isEmpty((String)(certificatesPath = InternalUtilsKt.safeTrim(textFieldWithBrowseButton.getText()))) && !new File(certificatesPath).exists()) {
                Object[] objectArray = new Object[]{certificatesPath};
                throw new RuntimeConfigurationError(DockerBundle.message((String)"DockerCloudConfigurable.error.certificatesFolder.missing", (Object[])objectArray));
            }
            s.setApiUrl(apiUrl);
            s.setCertificatesPath(certificatesPath);
        }

        @NotNull
        protected JComponent createEditor() {
            return (JComponent)BuilderKt.panel(arg_0 -> MyEditor.createEditor$lambda$0(this, arg_0));
        }

        private static final Unit createEditor$lambda$0$0(MyEditor this$0, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = DockerBundle.message((String)"DockerCloudConfigurable.engine.url.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$row.label(string);
            Cell it = cell = $this$row.textField();
            boolean bl = false;
            this$0.myApiUrlTextField = (JTextField)it.getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0$1(MyEditor this$0, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = DockerBundle.message((String)"DockerCloudConfigurable.certificates.folder.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$row.label(string);
            Cell it = cell = Row.textFieldWithBrowseButton$default((Row)$this$row, null, null, (int)3, null);
            boolean bl = false;
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DockerBundle.message((String)"DockerCloudConfigurable.chooser.certificates.title", (Object[])new Object[0]));
            ((TextFieldWithBrowseButton)it.getComponent()).addBrowseFolderListener(null, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            this$0.myCertificatesPathTextField = (TextFieldWithBrowseButton)it.getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0(MyEditor this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MyEditor.createEditor$lambda$0$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MyEditor.createEditor$lambda$0$1(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }
    }
}

