/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.splitApi.registry.DockerRegistryDtoConvertersKt;
import com.intellij.docker.splitApi.registry.DockerRegistryEventCollector;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u0004"}, d2={"refreshDockerRegistry", "", "model", "Lcom/intellij/docker/registry/DockerRepositoryModel;", "intellij.clouds.docker"})
public final class PushImageToRegistryUtilsKt {
    @ApiStatus.Internal
    public static final void refreshDockerRegistry(@NotNull DockerRepositoryModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DockerRegistryConfiguration dockerRegistryConfiguration = model.getRegistry();
        if (dockerRegistryConfiguration == null) {
            return;
        }
        DockerRegistryConfiguration registry = dockerRegistryConfiguration;
        DockerRegistryProvider provider = DockerRegistryProvider.Companion.getProvider(registry);
        Object object = provider.getRegistryRoot(registry);
        if (object == null || (object = ((DockerRegistryRoot)object).getRegistryId()) == null) {
            return;
        }
        Object staleRegistryId = object;
        provider.refresh(registry);
        DockerRegistryRoot dockerRegistryRoot = provider.getRegistryRoot(registry);
        if (dockerRegistryRoot == null) {
            return;
        }
        DockerRegistryRoot freshRegistry = dockerRegistryRoot;
        DockerRegistryEventCollector.Companion.getInstance().fireTagPushed((String)staleRegistryId, DockerRegistryDtoConvertersKt.toRegistryDto(freshRegistry));
    }
}

