/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetterFactory;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByNodeFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.impl.VcsActivityKey;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.CommitCountStageKt;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcs.log.visible.filters.VcsLogParentFilterImplKt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogCommandParameters;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogDiffHandler;
import git4idea.log.GitLogIndexer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 b2\u00020\u00012\u00020\u0002:\u0001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\\\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020&0%H\u0016J.\u0010'\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020)0%H\u0016J.\u0010*\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0%H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010-\u001a\u00020.H\u0002J\u001e\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0012092\u0006\u0010:\u001a\u00020;H\u0016J.\u0010<\u001a\b\u0012\u0004\u0012\u00020&0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J8\u0010<\u001a\b\u0012\u0004\u0012\u00020&0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020 092\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010I\u001a\u00020JH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010P\u001a\u0004\u0018\u00010J2\u0006\u0010Q\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010R\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020UH\u0016J#\u0010V\u001a\u0004\u0018\u0001HW\"\u0004\b\u0000\u0010W2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HW0YH\u0016\u00a2\u0006\u0002\u0010ZJ\b\u0010[\u001a\u00020\\H\u0016J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010^\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010_\u001a\u00020B2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020 09H\u0002J\u0012\u0010a\u001a\u0004\u0018\u00010.2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u0010L\u001a\u00020M8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010O\u00a8\u0006c"}, d2={"Lgit4idea/log/GitLogProvider;", "Lcom/intellij/vcs/log/VcsLogProvider;", "Lcom/intellij/vcs/log/impl/VcsIndexableLogProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "refSorter", "Lcom/intellij/vcs/log/VcsLogRefManager;", "vcsObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "tracer", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "readFirstBlock", "Lcom/intellij/vcs/log/VcsLogProvider$DetailedLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "requirements", "Lcom/intellij/vcs/log/VcsLogProvider$Requirements;", "validateDataAndReportError", "", "allRefs", "", "Lcom/intellij/vcs/log/VcsRef;", "sortedCommits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "firstBlockSyncData", "manuallyReadBranches", "currentTagNames", "", "commitsFromTags", "readAllHashes", "Lcom/intellij/vcs/log/VcsLogProvider$LogData;", "commitConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/vcs/log/TimedVcsCommit;", "readFullDetails", "hashes", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "readMetadata", "consumer", "readBranches", "repository", "Lgit4idea/repo/GitRepository;", "supportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getSupportedVcs", "()Lcom/intellij/openapi/vcs/VcsKey;", "referenceManager", "getReferenceManager", "()Lcom/intellij/vcs/log/VcsLogRefManager;", "subscribeToRootRefreshEvents", "Lcom/intellij/openapi/Disposable;", "roots", "", "refresher", "Lcom/intellij/vcs/log/VcsLogRefresher;", "getCommitsMatchingFilter", "filterCollection", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "graphOptions", "Lcom/intellij/vcs/log/graph/PermanentGraph$Options;", "maxCount", "", "range", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "options", "getCurrentUser", "Lcom/intellij/vcs/log/VcsUser;", "getContainingBranches", "commitHash", "Lcom/intellij/vcs/log/Hash;", "getCurrentBranch", "diffHandler", "Lcom/intellij/vcs/log/VcsLogDiffHandler;", "getDiffHandler", "()Lcom/intellij/vcs/log/VcsLogDiffHandler;", "resolveReference", "ref", "getVcsRoot", "detectedRoot", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getPropertyValue", "T", "property", "Lcom/intellij/vcs/log/VcsLogProperties$VcsLogProperty;", "(Lcom/intellij/vcs/log/VcsLogProperties$VcsLogProperty;)Ljava/lang/Object;", "getIndexer", "Lcom/intellij/vcs/log/impl/VcsLogIndexer;", "readCurrentTagNames", "loadSomeCommitsOnTaggedBranches", "commitCount", "unmatchedTags", "getRepository", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLogProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogProvider.kt\ngit4idea/log/GitLogProvider\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,657:1\n27#2:658\n87#2,2:659\n28#2,3:661\n98#2:664\n90#2,6:665\n27#2:671\n87#2,2:672\n28#2,3:674\n98#2:677\n90#2,6:678\n27#2:684\n87#2,2:685\n28#2,3:687\n98#2:690\n90#2,6:691\n27#2:697\n87#2,2:698\n28#2,3:700\n98#2:703\n90#2,6:704\n27#2:710\n87#2,2:711\n28#2,3:713\n98#2:716\n90#2,6:717\n13#3:723\n*S KotlinDebug\n*F\n+ 1 GitLogProvider.kt\ngit4idea/log/GitLogProvider\n*L\n119#1:658\n119#1:659,2\n119#1:661,3\n119#1:664\n119#1:665,6\n140#1:671\n140#1:672,2\n140#1:674,3\n140#1:677\n140#1:678,6\n198#1:684\n198#1:685,2\n198#1:687,3\n198#1:690\n198#1:691,6\n341#1:697\n341#1:698,2\n341#1:700,3\n341#1:703\n341#1:704,6\n352#1:710\n352#1:711,2\n352#1:713,3\n352#1:716\n352#1:717,6\n374#1:723\n*E\n"})
public final class GitLogProvider
implements VcsLogProvider,
VcsIndexableLogProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogRefManager refSorter;
    @NotNull
    private final VcsLogObjectsFactory vcsObjectsFactory;
    @NotNull
    private final IJTracer tracer;
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final Hash.Strategy<VcsRef> DONT_CONSIDER_SHA;

    public GitLogProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        this.repositoryManager = gitRepositoryManager;
        this.refSorter = new GitRefManager(this.project, (RepositoryManager<GitRepository>)((RepositoryManager)this.repositoryManager));
        Object object = this.project.getService(VcsLogObjectsFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.vcsObjectsFactory = (VcsLogObjectsFactory)object;
        this.tracer = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        List list;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        GitRepository gitRepository = this.getRepository(root);
        if (gitRepository == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            Intrinsics.checkNotNullExpressionValue((Object)logDataImpl, (String)"empty(...)");
            return (VcsLogProvider.DetailedLogData)logDataImpl;
        }
        GitRepository repository2 = gitRepository;
        int commitCount = requirements.getCommitCount() * 2;
        String[] stringArray = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        String[] params = stringArray;
        boolean refresh = false;
        boolean isRefreshRefs = false;
        if (requirements instanceof VcsLogProviderRequirementsEx) {
            refresh = ((VcsLogProviderRequirementsEx)requirements).isRefresh();
            isRefreshRefs = ((VcsLogProviderRequirementsEx)requirements).isRefreshRefs();
        }
        VcsLogProvider.DetailedLogData detailedLogData = GitLogUtil.collectMetadata(this.project, root, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)detailedLogData, (String)"collectMetadata(...)");
        VcsLogProvider.DetailedLogData data2 = detailedLogData;
        Set safeRefs = data2.getRefs();
        Set allRefs = (Set)new ObjectOpenCustomHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches = SetsKt.emptySet();
        if (isRefreshRefs) {
            branches = this.readBranches(repository2);
            GitLogProvider.Companion.addNewElements(allRefs, branches);
        }
        Collection allDetails = null;
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh || !isRefreshRefs) {
            allDetails = CollectionsKt.toMutableList((Collection)data2.getCommits());
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            Collection collection = rex.getPreviousRefs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPreviousRefs(...)");
            GitLogProvider.Companion.addOldStillExistingTags(allRefs, currentTagNames, collection);
            allDetails = new HashSet(data2.getCommits());
            Collection collection2 = rex.getPreviousRefs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPreviousRefs(...)");
            Set previousTags = GitLogProvider.Companion.getTagNames(collection2);
            Set safeTags = GitLogProvider.Companion.getTagNames(safeRefs);
            Set[] setArray = new Set[]{previousTags, safeTags};
            Set newUnmatchedTags = GitLogProvider.Companion.remove(currentTagNames, setArray);
            if (!((Collection)newUnmatchedTags).isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.Companion.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.Companion.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SortingCommits").setAttribute("rootName", root.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            List list2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                List list3 = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"sortByDateTopoOrder(...)");
                List commits = list3;
                list2 = ContainerUtil.getFirstItems((List)commits, (int)requirements.getCommitCount());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List list4 = list2;
            list = list4;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"use(...)");
        List sortedCommits = list;
        if (LOG.isDebugEnabled()) {
            this.validateDataAndReportError(root, allRefs, sortedCommits, data2, branches, currentTagNames, commitsFromTags);
        }
        return (VcsLogProvider.DetailedLogData)new LogDataImpl(allRefs, sortedCommits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateDataAndReportError(VirtualFile root, Set<? extends VcsRef> allRefs, List<? extends VcsCommitMetadata> sortedCommits, VcsLogProvider.DetailedLogData firstBlockSyncData, Set<? extends VcsRef> manuallyReadBranches, Set<String> currentTagNames, VcsLogProvider.DetailedLogData commitsFromTags) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ValidatingData").setAttribute("rootName", root.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            PermanentGraphImpl permanentGraphImpl;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                Set set = ContainerUtil.map2Set((Collection)allRefs, arg_0 -> GitLogProvider.validateDataAndReportError$lambda$0$1(GitLogProvider::validateDataAndReportError$lambda$0$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map2Set(...)");
                Set refs = set;
                permanentGraphImpl = PermanentGraphImpl.Companion.newInstance(sortedCommits, (GraphColorGetterFactory)new GraphColorGetterByNodeFactory(GitLogProvider::validateDataAndReportError$lambda$0$2), (arg_0, arg_1) -> GitLogProvider.validateDataAndReportError$lambda$0$3(refs, root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags, arg_0, arg_1), refs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            PermanentGraphImpl permanentGraphImpl2 = permanentGraphImpl;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        if (this.getRepository(root) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            Intrinsics.checkNotNullExpressionValue((Object)logDataImpl, (String)"empty(...)");
            return (VcsLogProvider.LogData)logDataImpl;
        }
        ArrayList<String> parameters = new ArrayList<String>((Collection)GitLogUtil.LOG_ALL);
        parameters.add("--date-order");
        HashSet userRegistry = new HashSet();
        HashSet refs = new HashSet();
        GitLogUtil.readTimedCommits(this.project, root, (List<String>)parameters, (java.util.function.Consumer)new CollectConsumer((Collection)userRegistry), (java.util.function.Consumer)new CollectConsumer((Collection)refs), arg_0 -> GitLogProvider.readAllHashes$lambda$0((Function1)new Function1<Object, Unit>(commitConsumer){

            public final void invoke(Object p0) {
                ((Consumer)this.receiver).consume(p0);
            }
        }, arg_0));
        return (VcsLogProvider.LogData)new LogDataImpl((Set)refs, (Set)userRegistry);
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = this.getRepository(root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitCommitRequirements requirements = new GitCommitRequirements(Companion.shouldIncludeRootChanges$intellij_vcs_git(repository2), GitCommitRequirements.DiffRenames.Limit.Default.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
        GitLogUtil.readFullDetailsForHashes(this.project, root, hashes, requirements, commitConsumer);
    }

    public void readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GitLogUtil.collectMetadata(this.project, root, hashes, arg_0 -> GitLogProvider.readMetadata$lambda$0((Function1)new Function1<Object, Unit>(consumer){

            public final void invoke(Object p0) {
                ((Consumer)this.receiver).consume(p0);
            }
        }, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<VcsRef> readBranches(GitRepository repository2) {
        HashSet<VcsRef> hashSet;
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ReadingBranches").setAttribute("rootName", repository2.getRoot().getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            HashSet<VcsRef> hashSet2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Hash hash;
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                VirtualFile virtualFile = repository2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                VirtualFile root = virtualFile;
                repository2.update();
                GitBranchesCollection gitBranchesCollection = repository2.getBranches();
                Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"getBranches(...)");
                GitBranchesCollection branches = gitBranchesCollection;
                Collection<GitLocalBranch> collection = branches.getLocalBranches();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalBranches(...)");
                Collection<GitLocalBranch> localBranches = collection;
                Collection<GitRemoteBranch> collection2 = branches.getRemoteBranches();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getRemoteBranches(...)");
                Collection<GitRemoteBranch> remoteBranches = collection2;
                HashSet<VcsRef> refs = new HashSet<VcsRef>(localBranches.size() + remoteBranches.size());
                for (GitLocalBranch localBranch : localBranches) {
                    hash = branches.getHash((GitBranch)localBranch);
                    if (hash == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    refs.add(this.vcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
                }
                for (GitRemoteBranch remoteBranch : remoteBranches) {
                    hash = branches.getHash((GitBranch)remoteBranch);
                    if (hash == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    refs.add(this.vcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
                }
                String currentRevision = repository2.getCurrentRevision();
                if (currentRevision != null) {
                    refs.add(this.vcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
                }
                hashSet2 = refs;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            hashSet = hashSet2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return hashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        return this.refSorter;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> roots, @NotNull VcsLogRefresher refresher) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        MessageBusConnection connection = this.project.getMessageBus().connect();
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitLogProvider.subscribeToRootRefreshEvents$lambda$0(this, roots, refresher, arg_0));
        return (Disposable)connection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @NotNull PermanentGraph.Options graphOptions, int maxCount) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filterCollection, (String)"filterCollection");
        Intrinsics.checkNotNullParameter((Object)graphOptions, (String)"graphOptions");
        VcsLogRangeFilter rangeFilter = (VcsLogRangeFilter)filterCollection.get(VcsLogFilterCollection.RANGE_FILTER);
        if (rangeFilter == null) {
            return this.getCommitsMatchingFilter(root, filterCollection, null, graphOptions, maxCount);
        }
        LinkedHashSet commits = new LinkedHashSet();
        VcsLogFilterCollection modifiedFilterCollection = filterCollection;
        if (filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER) != null || filterCollection.get(VcsLogFilterCollection.REVISION_FILTER) != null) {
            commits.addAll(this.getCommitsMatchingFilter(root, filterCollection, null, graphOptions, maxCount));
            VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.BRANCH_FILTER;
            Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"BRANCH_FILTER");
            VcsLogFilterCollection vcsLogFilterCollection = VcsLogFiltersKt.without((VcsLogFilterCollection)filterCollection, (VcsLogFilterCollection.FilterKey)filterKey);
            VcsLogFilterCollection.FilterKey filterKey2 = VcsLogFilterCollection.REVISION_FILTER;
            Intrinsics.checkNotNullExpressionValue((Object)filterKey2, (String)"REVISION_FILTER");
            modifiedFilterCollection = VcsLogFiltersKt.without((VcsLogFilterCollection)vcsLogFilterCollection, (VcsLogFilterCollection.FilterKey)filterKey2);
        }
        for (VcsLogRangeFilter.RefRange range : rangeFilter.getRanges()) {
            commits.addAll(this.getCommitsMatchingFilter(root, modifiedFilterCollection, range, graphOptions, maxCount));
        }
        return new ArrayList(commits);
    }

    private final List<TimedVcsCommit> getCommitsMatchingFilter(VirtualFile root, VcsLogFilterCollection filterCollection, VcsLogRangeFilter.RefRange range, PermanentGraph.Options options2, int maxCount) throws VcsException {
        GitLogCommandParameters gitLogCommandParameters = Companion.getGitLogParameters$intellij_vcs_git(this.project, root, filterCollection, range, options2, maxCount);
        if (gitLogCommandParameters == null) {
            return CollectionsKt.emptyList();
        }
        GitLogCommandParameters parameters = gitLogCommandParameters;
        ArrayList commits = new ArrayList();
        GitLogUtil.readTimedCommits(this.project, root, parameters.getConfigParameters(), parameters.getFilterParameters(), null, null, (java.util.function.Consumer)new CollectConsumer((Collection)commits));
        return commits;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return GitUserRegistry.getInstance(this.project).getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        Collection<String> collection = GitBranchUtil.getBranches(this.project, root, true, true, commitHash.asString());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getBranches(...)");
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitRepository gitRepository = (GitRepository)this.repositoryManager.getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        String currentBranchName = repository2.getCurrentBranchName();
        if (currentBranchName == null && repository2.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @NotNull
    public VcsLogDiffHandler getDiffHandler() {
        return new GitLogDiffHandler(this.project);
    }

    @Nullable
    public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitRepository gitRepository = (GitRepository)this.repositoryManager.getRepositoryForRoot(root);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        return Git.getInstance().resolveReference(repository2, ref);
    }

    @NotNull
    public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detectedRoot, (String)"detectedRoot");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return Companion.getCorrectedVcsRoot$intellij_vcs_git(this.repositoryManager, detectedRoot, filePath);
    }

    @Nullable
    public <T> T getPropertyValue(@NotNull VcsLogProperties.VcsLogProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        VcsLogProperties.VcsLogProperty<T> vcsLogProperty = property;
        return (T)(Intrinsics.areEqual(vcsLogProperty, (Object)VcsLogProperties.LIGHTWEIGHT_BRANCHES) ? (Object)true : (Intrinsics.areEqual(vcsLogProperty, (Object)VcsLogProperties.SUPPORTS_INDEXING) ? (Object)true : (Intrinsics.areEqual(vcsLogProperty, (Object)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY) ? (Object)true : (Intrinsics.areEqual(vcsLogProperty, (Object)VcsLogProperties.HAS_COMMITTER) ? (Object)true : null))));
    }

    @NotNull
    public VcsLogIndexer getIndexer() {
        return new GitLogIndexer(this.project, this.repositoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> readCurrentTagNames(VirtualFile root) throws VcsException {
        HashSet hashSet;
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ReadingTags").setAttribute("rootName", root.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            HashSet hashSet2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                hashSet2 = new HashSet(GitBranchUtil.getAllTags(this.project, root));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            hashSet = hashSet2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(VirtualFile root, int commitCount, Collection<String> unmatchedTags) throws VcsException {
        LogDataImpl logDataImpl;
        SpanBuilder spanBuilder = this.tracer.spanBuilder("LoadingCommitsOnTaggedBranch").setAttribute("rootName", root.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            LogDataImpl logDataImpl2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                ArrayList<CallSite> params = new ArrayList<CallSite>();
                params.add((CallSite)((Object)("--max-count=" + commitCount)));
                HashSet refs = new HashSet();
                HashSet commits = new HashSet();
                VcsFileUtil.foreachChunk((List)new ArrayList<String>(unmatchedTags), (int)1, arg_0 -> GitLogProvider.loadSomeCommitsOnTaggedBranches$lambda$0$1(arg_0 -> GitLogProvider.loadSomeCommitsOnTaggedBranches$lambda$0$0(params, this, root, refs, commits, arg_0), arg_0));
                logDataImpl2 = new LogDataImpl((Set)refs, (List)new ArrayList(commits));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            logDataImpl = logDataImpl2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return (VcsLogProvider.DetailedLogData)logDataImpl;
    }

    private final GitRepository getRepository(VirtualFile root) {
        return Companion.getRepository$intellij_vcs_git(this.repositoryManager, root);
    }

    private static final Hash validateDataAndReportError$lambda$0$0(VcsRef it) {
        return it.getCommitHash();
    }

    private static final Hash validateDataAndReportError$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Hash)$tmp0.invoke(p0);
    }

    private static final int validateDataAndReportError$lambda$0$2(Hash hash, int n) {
        return 0;
    }

    private static final int validateDataAndReportError$lambda$0$3(Set $refs, VirtualFile $root, Set $allRefs, List $sortedCommits, VcsLogProvider.DetailedLogData $firstBlockSyncData, Set $manuallyReadBranches, Set $currentTagNames, VcsLogProvider.DetailedLogData $commitsFromTags, Hash head1, Hash head2) {
        if (!$refs.contains(head1) || !$refs.contains(head2)) {
            Attachment attachment = new Attachment("error-details.txt", GitLogProvider.Companion.printErrorDetails($root, $allRefs, $sortedCommits, $firstBlockSyncData, $manuallyReadBranches, $currentTagNames, $commitsFromTags));
            Attachment[] attachmentArray = new Attachment[]{attachment};
            LOG.error("GitLogProvider returned inconsistent data", attachmentArray);
        }
        return 0;
    }

    private static final void readAllHashes$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void readMetadata$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit subscribeToRootRefreshEvents$lambda$0$0(GitRepository $repository, Collection $roots, VcsLogRefresher $refresher) {
        VirtualFile virtualFile = $repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        if ($roots.contains(root)) {
            $refresher.refresh(root);
        }
        return Unit.INSTANCE;
    }

    private static final void subscribeToRootRefreshEvents$lambda$0(GitLogProvider this$0, Collection $roots, VcsLogRefresher $refresher, GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        TrackingUtil.trackActivityBlocking((Project)this$0.project, (ActivityKey)((ActivityKey)VcsActivityKey.INSTANCE), () -> GitLogProvider.subscribeToRootRefreshEvents$lambda$0$0(repository2, $roots, $refresher));
    }

    private static final Unit loadSomeCommitsOnTaggedBranches$lambda$0$0(ArrayList $params, GitLogProvider this$0, VirtualFile $root, HashSet $refs, HashSet $commits, List tagsChunk) {
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)ContainerUtil.concat((List)$params, (List)tagsChunk));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        String[] parameters = stringArray;
        VcsLogProvider.DetailedLogData detailedLogData = GitLogUtil.collectMetadata(this$0.project, $root, Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)detailedLogData, (String)"collectMetadata(...)");
        VcsLogProvider.DetailedLogData logData = detailedLogData;
        $refs.addAll(logData.getRefs());
        $commits.addAll(logData.getCommits());
        return Unit.INSTANCE;
    }

    private static final void loadSomeCommitsOnTaggedBranches$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitLogProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DONT_CONSIDER_SHA = (Hash.Strategy)new Hash.Strategy<VcsRef>(){

            public int hashCode(VcsRef ref) {
                if (ref == null) {
                    return 0;
                }
                return 31 * ref.getName().hashCode() + ref.getType().hashCode();
            }

            public boolean equals(VcsRef ref1, VcsRef ref2) {
                if (ref1 == ref2) {
                    return true;
                }
                return ref1 != null && ref2 != null && Intrinsics.areEqual((Object)ref1.getName(), (Object)ref2.getName()) && Intrinsics.areEqual((Object)ref1.getType(), (Object)ref2.getType());
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J%\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019JA\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J-\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b*J2\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u000e\u00100\u001a\n\u0012\u0006\b\u0000\u0012\u00020)01H\u0002J\u0018\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020)H\u0002J\\\u00105\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b072\f\u00108\u001a\b\u0012\u0004\u0012\u0002090(2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\b072\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020)\u0018\u0001072\b\u0010>\u001a\u0004\u0018\u00010;H\u0002J\u0010\u0010?\u001a\u00020)2\u0006\u0010:\u001a\u00020;H\u0002J\u0016\u0010@\u001a\u00020)2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002090(H\u0002J\u0016\u0010B\u001a\u00020)2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\b07H\u0002J4\u0010D\u001a\u00020,2\u000e\u00106\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020)072\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\b0HH\u0002JG\u0010I\u001a\b\u0012\u0004\u0012\u0002HJ07\"\u0004\b\u0000\u0010J2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ072\u001e\u0010L\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HJ070M\"\b\u0012\u0004\u0012\u0002HJ07H\u0002\u00a2\u0006\u0002\u0010NJ,\u0010O\u001a\u00020,\"\u0004\b\u0000\u0010J2\u000e\u0010K\u001a\n\u0012\u0006\b\u0000\u0012\u0002HJ0P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HJ0HH\u0002J\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020)07*\b\u0012\u0004\u0012\u00020\b0HH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lgit4idea/log/GitLogProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DONT_CONSIDER_SHA", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lcom/intellij/vcs/log/VcsRef;", "shouldIncludeRootChanges", "", "repository", "Lgit4idea/repo/GitRepository;", "shouldIncludeRootChanges$intellij_vcs_git", "getRepository", "manager", "Lgit4idea/repo/GitRepositoryManager;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRepository$intellij_vcs_git", "getCorrectedVcsRoot", "repositoryManager", "detectedRoot", "path", "Lcom/intellij/openapi/vcs/FilePath;", "getCorrectedVcsRoot$intellij_vcs_git", "getGitLogParameters", "Lgit4idea/history/GitLogCommandParameters;", "project", "Lcom/intellij/openapi/project/Project;", "filterCollection", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "range", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "options", "Lcom/intellij/vcs/log/graph/PermanentGraph$Options;", "maxCount", "", "getGitLogParameters$intellij_vcs_git", "getBranchLikeFilterParameters", "", "", "getBranchLikeFilterParameters$intellij_vcs_git", "appendTextFilterParameters", "", "text", "regexp", "caseSensitive", "filterParameters", "", "prepareParameter", "paramName", "value", "printErrorDetails", "allRefs", "", "sortedCommits", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "firstBlockSyncData", "Lcom/intellij/vcs/log/VcsLogProvider$DetailedLogData;", "manuallyReadBranches", "currentTagNames", "commitsFromTags", "printLogData", "printCommits", "commits", "printRefs", "refs", "addOldStillExistingTags", "", "currentTags", "previousRefs", "", "remove", "T", "original", "toRemove", "", "(Ljava/util/Set;[Ljava/util/Set;)Ljava/util/Set;", "addNewElements", "", "toAdd", "getTagNames", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitLogProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogProvider.kt\ngit4idea/log/GitLogProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,657:1\n1#2:658\n1#2:677\n1586#3:659\n1661#3,3:660\n1586#3:663\n1661#3,3:664\n1586#3:667\n1661#3,3:668\n1586#3:671\n1661#3,3:672\n1651#3:675\n1915#3:676\n1916#3:678\n1652#3:679\n*S KotlinDebug\n*F\n+ 1 GitLogProvider.kt\ngit4idea/log/GitLogProvider$Companion\n*L\n652#1:677\n455#1:659\n455#1:660,3\n457#1:663\n457#1:664,3\n462#1:667\n462#1:668,3\n466#1:671\n466#1:672,3\n652#1:675\n652#1:676\n652#1:678\n652#1:679\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldIncludeRootChanges$intellij_vcs_git(@NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            return !repository2.getInfo().isShallow();
        }

        @Nullable
        public final GitRepository getRepository$intellij_vcs_git(@NotNull GitRepositoryManager manager2, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)((Object)manager2), (String)"manager");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            GitRepository repository2 = (GitRepository)manager2.getRepositoryForRoot(root);
            if (repository2 == null) {
                LOG.warn("Repository not found for root " + root);
                return null;
            }
            if (repository2.isFresh()) {
                LOG.info("Fresh repository: " + root);
                return null;
            }
            return repository2;
        }

        @NotNull
        public final VirtualFile getCorrectedVcsRoot$intellij_vcs_git(@NotNull GitRepositoryManager repositoryManager, @NotNull VirtualFile detectedRoot, @NotNull FilePath path) {
            GitSubmodule submodule;
            Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
            Intrinsics.checkNotNullParameter((Object)detectedRoot, (String)"detectedRoot");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.isDirectory()) {
                return detectedRoot;
            }
            GitRepository repository2 = (GitRepository)repositoryManager.getRepositoryForRootQuick(path);
            if (repository2 != null && Intrinsics.areEqual((Object)repository2.getRoot(), (Object)detectedRoot) && (submodule = GitSubmoduleKt.asSubmodule(repository2)) != null) {
                VirtualFile virtualFile = submodule.getParent().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                return virtualFile;
            }
            return detectedRoot;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final GitLogCommandParameters getGitLogParameters$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range, @NotNull PermanentGraph.Options options2, int maxCount) {
            VcsLogStructureFilter structureFilter;
            VcsLogParentFilter parentFilter;
            VcsLogTextFilter textFilter;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filterCollection, (String)"filterCollection");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
            GitRepository gitRepository = this.getRepository$intellij_vcs_git(gitRepositoryManager, root);
            if (gitRepository == null) {
                return null;
            }
            GitRepository repository2 = gitRepository;
            ArrayList<String> configParameters = new ArrayList<String>();
            List<String> branchLikeFilterParameters = this.getBranchLikeFilterParameters$intellij_vcs_git(repository2, filterCollection, range);
            if (branchLikeFilterParameters.isEmpty()) {
                return null;
            }
            ArrayList<Object> filterParameters = new ArrayList<Object>((Collection)branchLikeFilterParameters);
            VcsLogDateFilter dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER);
            if (dateFilter != null) {
                Date it;
                Date date = dateFilter.getAfter();
                if (date != null) {
                    it = date;
                    boolean bl = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    filterParameters.add(Companion.prepareParameter("after", string));
                }
                Date date2 = dateFilter.getBefore();
                if (date2 != null) {
                    it = date2;
                    boolean bl = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    filterParameters.add(Companion.prepareParameter("before", string));
                }
            }
            VcsLogTextFilter vcsLogTextFilter = textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER);
            String text2 = vcsLogTextFilter != null ? vcsLogTextFilter.getText() : null;
            boolean regexp = textFilter == null || textFilter.isRegex();
            VcsLogTextFilter vcsLogTextFilter2 = textFilter;
            boolean caseSensitive = vcsLogTextFilter2 != null ? vcsLogTextFilter2.matchesCase() : false;
            this.appendTextFilterParameters(text2, regexp, caseSensitive, (List<? super String>)filterParameters);
            VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
            if (userFilter != null) {
                Iterator it;
                Collection<String> collection;
                UserNameRegex $this$mapTo$iv$iv;
                Collection collection2 = userFilter.getUsers(root);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getUsers(...)");
                Iterable $this$map$iv = collection2;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection<String> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VcsUser vcsUser = (VcsUser)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(VcsUserUtil.toExactString((VcsUser)it));
                }
                List names = (List)destination$iv$iv;
                if (regexp) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2;
                    Iterable $i$f$map2 = names;
                    UserNameRegex userNameRegex = UserNameRegex.EXTENDED_INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)userNameRegex, (String)"EXTENDED_INSTANCE");
                    $this$mapTo$iv$iv = userNameRegex;
                    boolean $i$f$map32 = false;
                    void $i$f$mapTo2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo32 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void p0;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add($this$mapTo$iv$iv.fun((String)p0));
                    }
                    authors = (List)destination$iv$iv2;
                    if (GitVersionSpecialty.LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR.existsIn(project)) {
                        v10 = filterParameters.add(this.prepareParameter("author", CollectionsKt.joinToString$default((Iterable)authors, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)));
                    } else {
                        void $this$mapTo$iv$iv3;
                        $this$map$iv2 = authors;
                        collection = filterParameters;
                        boolean $i$f$map4 = false;
                        Iterable $i$f$map32 = $this$map$iv2;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo4 = false;
                        Iterator $i$f$mapTo32 = $this$mapTo$iv$iv3.iterator();
                        while ($i$f$mapTo32.hasNext()) {
                            void a;
                            String item$iv$iv = item$iv$iv = $i$f$mapTo32.next();
                            var30_45 = destination$iv$iv3;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)a);
                            var30_45.add(Companion.prepareParameter("author", (String)a));
                        }
                        v10 = ((ArrayList)collection).addAll((List)destination$iv$iv3);
                    }
                } else {
                    authors = names;
                    collection = filterParameters;
                    $i$f$map2 = false;
                    Iterable $i$f$map4 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        item$iv$iv = (String)item$iv$iv;
                        var30_45 = destination$iv$iv;
                        boolean bl = false;
                        String string = StringUtil.escapeBackSlashes(it);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeBackSlashes(...)");
                        var30_45.add(Companion.prepareParameter("author", string));
                    }
                    v10 = ((ArrayList)collection).addAll((List)destination$iv$iv);
                }
                configParameters.add("log.mailmap=false");
            }
            if (!CommitCountStageKt.isAll((int)maxCount)) {
                filterParameters.add(this.prepareParameter("max-count", String.valueOf(maxCount)));
            }
            if (Intrinsics.areEqual((Object)options2, (Object)PermanentGraph.Options.FirstParent.INSTANCE)) {
                filterParameters.add("--first-parent");
            }
            if ((parentFilter = (VcsLogParentFilter)filterCollection.get(VcsLogFilterCollection.PARENT_FILTER)) != null && !VcsLogParentFilterImplKt.getMatchesAll((VcsLogParentFilter)parentFilter)) {
                if (VcsLogParentFilterImplKt.getHasLowerBound((VcsLogParentFilter)parentFilter)) {
                    filterParameters.add("--min-parents=" + parentFilter.getMinParents());
                }
                if (VcsLogParentFilterImplKt.getHasUpperBound((VcsLogParentFilter)parentFilter)) {
                    filterParameters.add("--max-parents=" + parentFilter.getMaxParents());
                }
            }
            if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
                Collection collection = structureFilter.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
                Collection files = collection;
                if (!files.isEmpty()) {
                    filterParameters.add("--full-history");
                    filterParameters.add("--simplify-merges");
                    filterParameters.add("--");
                    for (FilePath file : files) {
                        filterParameters.add(VcsFileUtil.relativePath((VirtualFile)root, (FilePath)file));
                    }
                }
            }
            return new GitLogCommandParameters((List<String>)configParameters, (List<String>)filterParameters);
        }

        @NotNull
        public final List<String> getBranchLikeFilterParameters$intellij_vcs_git(@NotNull GitRepository repository2, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)filterCollection, (String)"filterCollection");
            VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
            VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filterCollection.get(VcsLogFilterCollection.REVISION_FILTER);
            if (branchFilter == null && revisionFilter == null && range == null) {
                List<String> list = GitLogUtil.LOG_ALL;
                Intrinsics.checkNotNullExpressionValue(list, (String)"LOG_ALL");
                return list;
            }
            ArrayList<Object> result2 = new ArrayList<Object>();
            if (branchFilter != null) {
                ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable)repository2.getBranches().getLocalBranches(), (Iterable)repository2.getBranches().getRemoteBranches()));
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
                ArrayList branches = arrayList;
                Collection<String> collection = GitBranchUtil.convertBranchesToNames(branches);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"convertBranchesToNames(...)");
                Collection<String> branchNames = collection;
                List predefinedNames = CollectionsKt.listOf((Object)"HEAD");
                for (String branchName : ContainerUtil.concat((Iterable)branchNames, (Iterable)predefinedNames)) {
                    if (!branchFilter.matches(branchName)) continue;
                    result2.add(branchName);
                }
            }
            if (revisionFilter != null) {
                for (CommitId commit : revisionFilter.getHeads()) {
                    if (!Intrinsics.areEqual((Object)commit.getRoot(), (Object)repository2.getRoot())) continue;
                    result2.add(commit.getHash().asString());
                }
            }
            if (range != null) {
                result2.add(range.getExclusiveRef() + ".." + range.getInclusiveRef());
            }
            return result2;
        }

        private final void appendTextFilterParameters(String text2, boolean regexp, boolean caseSensitive, List<? super String> filterParameters) {
            if (text2 != null) {
                filterParameters.add(this.prepareParameter("grep", text2));
            }
            filterParameters.add(regexp ? "--extended-regexp" : "--fixed-strings");
            if (!caseSensitive) {
                filterParameters.add("--regexp-ignore-case");
            }
        }

        private final String prepareParameter(String paramName, String value) {
            return "--" + paramName + "=" + value;
        }

        private final String printErrorDetails(VirtualFile root, Set<? extends VcsRef> allRefs, List<? extends VcsCommitMetadata> sortedCommits, VcsLogProvider.DetailedLogData firstBlockSyncData, Set<? extends VcsRef> manuallyReadBranches, Set<String> currentTagNames, VcsLogProvider.DetailedLogData commitsFromTags) {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + root.getName() + "]\n");
            sb.append("First block data from Git:\n");
            sb.append(this.printLogData(firstBlockSyncData));
            sb.append("\n\nManually read refs:\n");
            sb.append(this.printRefs(manuallyReadBranches));
            sb.append("\n\nCurrent tag names:\n");
            if (currentTagNames != null) {
                sb.append(CollectionsKt.joinToString$default((Iterable)currentTagNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                v0 = commitsFromTags != null ? sb.append(this.printLogData(commitsFromTags)) : sb.append("\n\nCommits from new tags were not read.\n");
            } else {
                v0 = sb.append("\n\nCurrent tags were not read\n");
            }
            sb.append("\n\nResult:\n");
            sb.append("\nCommits (last 100): \n");
            sb.append(this.printCommits(sortedCommits));
            sb.append("\nAll refs:\n");
            sb.append(this.printRefs(allRefs));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String printLogData(VcsLogProvider.DetailedLogData firstBlockSyncData) {
            return "Last 100 commits:\n" + this.printCommits(firstBlockSyncData.getCommits()) + "\nRefs:\n" + this.printRefs(firstBlockSyncData.getRefs());
        }

        private final String printCommits(List<? extends VcsCommitMetadata> commits) {
            StringBuilder sb = new StringBuilder();
            int n = Math.min(commits.size(), 100);
            for (int i = 0; i < n; ++i) {
                VcsCommitMetadata commit = commits.get(i);
                String string = ((Hash)commit.getId()).toShortString();
                List list = commit.getParents();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
                sb.append(string + " -> " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, Companion::printCommits$lambda$0, (int)30, null) + "\n");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String printRefs(Set<? extends VcsRef> refs) {
            return CollectionsKt.joinToString$default((Iterable)refs, (CharSequence)"\n", null, null, (int)0, null, Companion::printRefs$lambda$0, (int)30, null);
        }

        private final void addOldStillExistingTags(Set<? super VcsRef> allRefs, Set<String> currentTags, Collection<? extends VcsRef> previousRefs) {
            for (VcsRef vcsRef : previousRefs) {
                if (allRefs.contains(vcsRef) || !currentTags.contains(vcsRef.getName())) continue;
                allRefs.add((VcsRef)vcsRef);
            }
        }

        private final <T> Set<T> remove(Set<? extends T> original, Set<? extends T> ... toRemove) {
            HashSet result2 = new HashSet(original);
            for (Set<? extends T> set : toRemove) {
                result2.removeAll((Collection)set);
            }
            return result2;
        }

        private final <T> void addNewElements(Collection<? super T> original, Collection<? extends T> toAdd) {
            for (T item : toAdd) {
                if (original.contains(item)) continue;
                original.add(item);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> getTagNames(Collection<? extends VcsRef> $this$getTagNames) {
            void var3_3;
            void $this$mapNotNullTo$iv;
            Iterable iterable = $this$getTagNames;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VcsRef ref = (VcsRef)element$iv;
                boolean bl2 = false;
                if ((Intrinsics.areEqual((Object)ref.getType(), (Object)GitRefManager.TAG) ? ref.getName() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            return (Set)var3_3;
        }

        private static final CharSequence printCommits$lambda$0(Hash it) {
            String string = it.toShortString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
            return string;
        }

        private static final CharSequence printRefs$lambda$0(VcsRef it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getCommitHash().toShortString() + " : " + it.getName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

