/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.GitLocalBranch;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/push/GitPushSpecParser;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getTargetRef", "", "repository", "Lgit4idea/repo/GitRepository;", "sourceBranch", "Lgit4idea/GitLocalBranch;", "specs", "", "getTarget", "Lgit4idea/push/GitPushSpecParser$TargetRef;", "spec", "exactMatchWithSpec", "", "branch", "specSource", "getWildcardType", "Lgit4idea/push/GitPushSpecParser$WildcardType;", "source", "target", "TargetRef", "WildcardType", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPushSpecParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPushSpecParser.kt\ngit4idea/push/GitPushSpecParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n1#2:83\n23#3:84\n*S KotlinDebug\n*F\n+ 1 GitPushSpecParser.kt\ngit4idea/push/GitPushSpecParser\n*L\n12#1:84\n*E\n"})
public final class GitPushSpecParser {
    @NotNull
    public static final GitPushSpecParser INSTANCE;
    @NotNull
    private static final Logger LOG;

    private GitPushSpecParser() {
    }

    @JvmStatic
    @Nullable
    public static final String getTargetRef(@NotNull GitRepository repository2, @NotNull GitLocalBranch sourceBranch, @NotNull List<String> specs) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceBranch), (String)"sourceBranch");
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        TargetRef targetRef = null;
        for (String spec2 : specs) {
            Boolean bl;
            TargetRef target;
            TargetRef targetRef2 = target = INSTANCE.getTarget(spec2, sourceBranch);
            Boolean bl2 = bl = targetRef2 != null ? Boolean.valueOf(targetRef2.getWildcardMatch()) : null;
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                if (targetRef != null) continue;
                targetRef = target;
                continue;
            }
            if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                return target.getRef();
            }
            if (bl == null) {
                LOG.info("Push spec [" + spec2 + "] in " + repository2.getRoot() + " is invalid or doesn't match source branch " + sourceBranch.getName());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        TargetRef targetRef3 = targetRef;
        return targetRef3 != null ? targetRef3.getRef() : null;
    }

    private final TargetRef getTarget(String spec2, GitLocalBranch sourceBranch) {
        Object object = new char[]{':'};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)spec2, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = it.size() == 2 ? object : null;
        if (object2 == null) {
            return null;
        }
        Object parts = object2;
        String specSource = StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString(), (CharSequence)"+");
        String specTarget = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
        WildcardType wildcardType = this.getWildcardType(specSource, specTarget);
        return switch (WhenMappings.$EnumSwitchMapping$0[wildcardType.ordinal()]) {
            case 1 -> {
                if (this.exactMatchWithSpec(sourceBranch, specSource)) {
                    yield new TargetRef(specTarget, false);
                }
                yield null;
            }
            case 2 -> {
                char[] var9_8 = new char[]{'*'};
                String trimmedSourceSpec = StringsKt.trimEnd((String)specSource, (char[])var9_8);
                if (StringsKt.startsWith$default((String)sourceBranch.getFullName(), (String)trimmedSourceSpec, (boolean)false, (int)2, null)) {
                    String v2 = sourceBranch.getFullName().substring(trimmedSourceSpec.length());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                    String starMeaning = v2;
                    yield new TargetRef(StringsKt.replace$default((String)specTarget, (String)"*", (String)starMeaning, (boolean)false, (int)4, null), true);
                }
                yield null;
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean exactMatchWithSpec(GitLocalBranch branch, String specSource) {
        return Intrinsics.areEqual((Object)specSource, (Object)"HEAD") || Intrinsics.areEqual((Object)branch.getName(), (Object)StringsKt.removePrefix((String)specSource, (CharSequence)"refs/heads/"));
    }

    private final WildcardType getWildcardType(String source, String target) {
        int sourceStar = StringsKt.indexOf$default((CharSequence)source, (char)'*', (int)0, (boolean)false, (int)6, null);
        int targetStar = StringsKt.indexOf$default((CharSequence)target, (char)'*', (int)0, (boolean)false, (int)6, null);
        return sourceStar < 0 && targetStar < 0 ? WildcardType.NONE : (sourceStar == source.length() - 1 && targetStar == target.length() - 1 ? WildcardType.END : WildcardType.INVALID);
    }

    static {
        GitPushSpecParser $this$thisLogger$iv = INSTANCE = new GitPushSpecParser();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitPushSpecParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lgit4idea/push/GitPushSpecParser$TargetRef;", "", "ref", "", "wildcardMatch", "", "<init>", "(Ljava/lang/String;Z)V", "getRef", "()Ljava/lang/String;", "getWildcardMatch", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class TargetRef {
        @NotNull
        private final String ref;
        private final boolean wildcardMatch;

        public TargetRef(@NotNull String ref, boolean wildcardMatch) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            this.ref = ref;
            this.wildcardMatch = wildcardMatch;
        }

        @NotNull
        public final String getRef() {
            return this.ref;
        }

        public final boolean getWildcardMatch() {
            return this.wildcardMatch;
        }

        @NotNull
        public final String component1() {
            return this.ref;
        }

        public final boolean component2() {
            return this.wildcardMatch;
        }

        @NotNull
        public final TargetRef copy(@NotNull String ref, boolean wildcardMatch) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            return new TargetRef(ref, wildcardMatch);
        }

        public static /* synthetic */ TargetRef copy$default(TargetRef targetRef, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = targetRef.ref;
            }
            if ((n & 2) != 0) {
                bl = targetRef.wildcardMatch;
            }
            return targetRef.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "TargetRef(ref=" + this.ref + ", wildcardMatch=" + this.wildcardMatch + ")";
        }

        public int hashCode() {
            int result2 = this.ref.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.wildcardMatch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetRef)) {
                return false;
            }
            TargetRef targetRef = (TargetRef)other;
            if (!Intrinsics.areEqual((Object)this.ref, (Object)targetRef.ref)) {
                return false;
            }
            return this.wildcardMatch == targetRef.wildcardMatch;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WildcardType.values().length];
            try {
                nArray[WildcardType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WildcardType.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WildcardType.INVALID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/push/GitPushSpecParser$WildcardType;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "END", "INVALID", "intellij.vcs.git"})
    private static final class WildcardType
    extends Enum<WildcardType> {
        public static final /* enum */ WildcardType NONE = new WildcardType();
        public static final /* enum */ WildcardType END = new WildcardType();
        public static final /* enum */ WildcardType INVALID = new WildcardType();
        private static final /* synthetic */ WildcardType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WildcardType[] values() {
            return (WildcardType[])$VALUES.clone();
        }

        public static WildcardType valueOf(String value) {
            return Enum.valueOf(WildcardType.class, value);
        }

        @NotNull
        public static EnumEntries<WildcardType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = wildcardTypeArray = new WildcardType[]{WildcardType.NONE, WildcardType.END, WildcardType.INVALID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

