/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote.hosting.action;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitRevisionNumber;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0007\bJ\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lgit4idea/remote/hosting/action/HostedGitRepositoryReference;", "", "getName", "", "Lorg/jetbrains/annotations/Nls;", "buildWebURI", "Ljava/net/URI;", "WebURI", "File", "intellij.vcs.git"})
public interface HostedGitRepositoryReference {
    @NotNull
    public String getName();

    @Nullable
    public URI buildWebURI();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0095\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012b\u0010\f\u001a^\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00070\t\u00a2\u0006\u0002\b\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c2\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003Je\u0010\u001c\u001a^\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\rH\u00c2\u0003J\u00a3\u0001\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2d\b\u0002\u0010\f\u001a^\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020\tH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\f\u001a^\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/remote/hosting/action/HostedGitRepositoryReference$File;", "Lgit4idea/remote/hosting/action/HostedGitRepositoryReference;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Ljava/net/URI;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "relativePath", "", "lineRange", "Lkotlin/ranges/IntRange;", "uriProducer", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "revisionHash", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/net/URI;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;Lkotlin/ranges/IntRange;Lkotlin/jvm/functions/Function4;)V", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "buildWebURI", "getCurrentFileRevisionHash", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class File
    implements HostedGitRepositoryReference {
        @NotNull
        private final Project project;
        @NotNull
        private final URI repository;
        @NotNull
        private final FilePath filePath;
        @NotNull
        private final String relativePath;
        @Nullable
        private final IntRange lineRange;
        @NotNull
        private final Function4<URI, String, String, IntRange, URI> uriProducer;

        public File(@NotNull Project project, @NotNull URI repository2, @NotNull FilePath filePath, @NotNull String relativePath, @Nullable IntRange lineRange, @NotNull Function4<? super URI, ? super String, ? super String, ? super IntRange, URI> uriProducer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter(uriProducer, (String)"uriProducer");
            this.project = project;
            this.repository = repository2;
            this.filePath = filePath;
            this.relativePath = relativePath;
            this.lineRange = lineRange;
            this.uriProducer = uriProducer;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.repository.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.replace$default((String)string, (char)'_', (char)' ', (boolean)false, (int)4, null);
        }

        @Override
        @Nullable
        public URI buildWebURI() {
            String hash = this.getCurrentFileRevisionHash(this.project, this.filePath);
            if (hash == null) {
                VcsNotifier.getInstance((Project)this.project).notifyError("git.open.in.browser.error", GitBundle.message((String)"open.in.browser.error", (Object[])new Object[0]), GitBundle.message((String)"open.in.browser.getting.revision.error", (Object[])new Object[0]));
                return null;
            }
            return (URI)this.uriProducer.invoke((Object)this.repository, (Object)hash, (Object)this.relativePath, (Object)this.lineRange);
        }

        private final String getCurrentFileRevisionHash(Project project, FilePath filePath) {
            GitRevisionNumber revision;
            GitRevisionNumber gitRevisionNumber;
            try {
                gitRevisionNumber = (GitRevisionNumber)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> File.getCurrentFileRevisionHash$lambda$0(project, filePath), GitBundle.message((String)"open.in.browser.getting.revision", (Object[])new Object[0]), true, project);
            }
            catch (Exception e) {
                gitRevisionNumber = null;
            }
            GitRevisionNumber gitRevisionNumber2 = revision = gitRevisionNumber;
            return gitRevisionNumber2 != null ? gitRevisionNumber2.getRev() : null;
        }

        private final Project component1() {
            return this.project;
        }

        private final URI component2() {
            return this.repository;
        }

        private final FilePath component3() {
            return this.filePath;
        }

        private final String component4() {
            return this.relativePath;
        }

        private final IntRange component5() {
            return this.lineRange;
        }

        private final Function4<URI, String, String, IntRange, URI> component6() {
            return this.uriProducer;
        }

        @NotNull
        public final File copy(@NotNull Project project, @NotNull URI repository2, @NotNull FilePath filePath, @NotNull String relativePath, @Nullable IntRange lineRange, @NotNull Function4<? super URI, ? super String, ? super String, ? super IntRange, URI> uriProducer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter(uriProducer, (String)"uriProducer");
            return new File(project, repository2, filePath, relativePath, lineRange, uriProducer);
        }

        public static /* synthetic */ File copy$default(File file, Project project, URI uRI, FilePath filePath, String string, IntRange intRange, Function4 function4, int n, Object object) {
            if ((n & 1) != 0) {
                project = file.project;
            }
            if ((n & 2) != 0) {
                uRI = file.repository;
            }
            if ((n & 4) != 0) {
                filePath = file.filePath;
            }
            if ((n & 8) != 0) {
                string = file.relativePath;
            }
            if ((n & 0x10) != 0) {
                intRange = file.lineRange;
            }
            if ((n & 0x20) != 0) {
                function4 = file.uriProducer;
            }
            return file.copy(project, uRI, filePath, string, intRange, function4);
        }

        @NotNull
        public String toString() {
            return "File(project=" + this.project + ", repository=" + this.repository + ", filePath=" + this.filePath + ", relativePath=" + this.relativePath + ", lineRange=" + this.lineRange + ", uriProducer=" + this.uriProducer + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            result2 = result2 * 31 + this.filePath.hashCode();
            result2 = result2 * 31 + this.relativePath.hashCode();
            result2 = result2 * 31 + (this.lineRange == null ? 0 : this.lineRange.hashCode());
            result2 = result2 * 31 + this.uriProducer.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof File)) {
                return false;
            }
            File file = (File)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)file.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repository, (Object)file.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)file.filePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.relativePath, (Object)file.relativePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lineRange, (Object)file.lineRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.uriProducer, file.uriProducer);
        }

        private static final GitRevisionNumber getCurrentFileRevisionHash$lambda$0(Project $project, FilePath $filePath) {
            return (GitRevisionNumber)GitHistoryUtils.getCurrentRevision($project, $filePath, "HEAD");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0007H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/remote/hosting/action/HostedGitRepositoryReference$WebURI;", "Lgit4idea/remote/hosting/action/HostedGitRepositoryReference;", "uri", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "buildWebURI", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class WebURI
    implements HostedGitRepositoryReference {
        @NotNull
        private final URI uri;

        public WebURI(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.replace$default((String)string, (char)'_', (char)' ', (boolean)false, (int)4, null);
        }

        @Override
        @NotNull
        public URI buildWebURI() {
            return this.uri;
        }

        private final URI component1() {
            return this.uri;
        }

        @NotNull
        public final WebURI copy(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return new WebURI(uri);
        }

        public static /* synthetic */ WebURI copy$default(WebURI webURI, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = webURI.uri;
            }
            return webURI.copy(uRI);
        }

        @NotNull
        public String toString() {
            return "WebURI(uri=" + this.uri + ")";
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WebURI)) {
                return false;
            }
            WebURI webURI = (WebURI)other;
            return Intrinsics.areEqual((Object)this.uri, (Object)webURI.uri);
        }
    }
}

