/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.javascript;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.javascript.NpmProjectDependenciesModel;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.packageChecker.model.impl.AbstractBuildFileProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00190\u00172\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/intellij/packageChecker/javascript/NpmBuildFileProvider;", "Lcom/intellij/packageChecker/model/impl/AbstractBuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "projectDependenciesModelClass", "Ljava/lang/Class;", "Lcom/intellij/packageChecker/javascript/NpmProjectDependenciesModel;", "getProjectDependenciesModelClass", "()Ljava/lang/Class;", "moduleScript", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "supports", "", "file", "getRoots", "", "Lcom/intellij/packageChecker/model/Package;", "", "pkgs", "", "updatePackageDeclaration", "", "pkg", "version", "importedPackages", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "intellij.packageChecker.javascript"})
@SourceDebugExtension(value={"SMAP\nNpmBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmBuildFileProvider.kt\ncom/intellij/packageChecker/javascript/NpmBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n777#2:57\n873#2,2:58\n1915#2,2:60\n*S KotlinDebug\n*F\n+ 1 NpmBuildFileProvider.kt\ncom/intellij/packageChecker/javascript/NpmBuildFileProvider\n*L\n42#1:57\n42#1:58,2\n43#1:60,2\n*E\n"})
public final class NpmBuildFileProvider
extends AbstractBuildFileProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private final Class<NpmProjectDependenciesModel> projectDependenciesModelClass;

    public NpmBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.id = "npm";
        this.projectDependenciesModelClass = NpmProjectDependenciesModel.class;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    protected Class<NpmProjectDependenciesModel> getProjectDependenciesModelClass() {
        return this.projectDependenciesModelClass;
    }

    @Nullable
    public final PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualFile != null) {
            VirtualFile moduleRootDir = virtualFile;
            boolean bl = false;
            VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)moduleRootDir);
            if (virtualFile2 != null) {
                VirtualFile moduleScriptVirtualFile = virtualFile2;
                boolean bl2 = false;
                psiFile = this.project.isDisposed() || !moduleScriptVirtualFile.isValid() ? null : (PsiFile)ReadAction.compute(() -> NpmBuildFileProvider.moduleScript$lambda$0$0$0(moduleScriptVirtualFile, this));
            } else {
                psiFile = null;
            }
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return PackageJsonCommonUtil.isPackageJsonFile((PsiFile)file);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.moduleScript(module) != null;
    }

    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        return ((NpmProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(NpmProjectDependenciesModel.class, (AreaInstance)this.project)).getRoots(file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file, @NotNull Package pkg, @NotNull String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JsonFile jsonFile = PackageJsonCommonUtil.asPackageJsonFile((PsiFile)file);
        if (jsonFile == null) {
            return;
        }
        JsonFile packageJsonFile = jsonFile;
        List list = PackageJsonCommonUtil.getAllDependencies((JsonFile)packageJsonFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllDependencies(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonProperty it = (JsonProperty)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)pkg.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dependencyJsonProperties = (List)destination$iv$iv;
        Iterable $this$forEach$iv = dependencyJsonProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonProperty jsonProperty = (JsonProperty)element$iv;
            boolean bl = false;
            JsonElementGenerator generator = new JsonElementGenerator(jsonProperty.getProject());
            JsonProperty jsonProperty2 = jsonProperty;
            if (jsonProperty2 == null || (jsonProperty2 = jsonProperty2.getValue()) == null) continue;
            jsonProperty2.replace((PsiElement)generator.createStringLiteral(version));
        }
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CollectionsKt.emptyList();
    }

    private static final PsiFile moduleScript$lambda$0$0$0(VirtualFile $moduleScriptVirtualFile, NpmBuildFileProvider this$0) {
        if (!$moduleScriptVirtualFile.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this$0.project).findFile($moduleScriptVirtualFile);
    }
}

