/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.packageChecker.model.Severity;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.model.Vulnerability;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.MaliciousPackage;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/service/Malicious;", "Lcom/intellij/packageChecker/service/Checked;", "maliciousPackage", "Lcom/intellij/packageChecker/service/MaliciousPackage;", "checkTime", "Ljava/util/Date;", "<init>", "(Lcom/intellij/packageChecker/service/MaliciousPackage;Ljava/util/Date;)V", "getMaliciousPackage", "()Lcom/intellij/packageChecker/service/MaliciousPackage;", "getCheckTime", "()Ljava/util/Date;", "maxSeverity", "Lcom/intellij/packageChecker/model/Severity;", "getMaxSeverity", "()Lcom/intellij/packageChecker/model/Severity;", "maxSeverity$delegate", "Lkotlin/Lazy;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemHighlightType$delegate", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageStatus.kt\ncom/intellij/packageChecker/service/Malicious\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class Malicious
extends Checked {
    @NotNull
    private final MaliciousPackage maliciousPackage;
    @NotNull
    private final Date checkTime;
    @NotNull
    private final Lazy maxSeverity$delegate;
    @NotNull
    private final Lazy problemHighlightType$delegate;

    public Malicious(@NotNull MaliciousPackage maliciousPackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)maliciousPackage, (String)"maliciousPackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        super(maliciousPackage.getVulnerablePackage().getPkg(), checkTime, null);
        this.maliciousPackage = maliciousPackage;
        this.checkTime = checkTime;
        this.maxSeverity$delegate = LazyKt.lazy(() -> Malicious.maxSeverity_delegate$lambda$0(this));
        this.problemHighlightType$delegate = LazyKt.lazy(() -> Malicious.problemHighlightType_delegate$lambda$0(this));
    }

    @NotNull
    public final MaliciousPackage getMaliciousPackage() {
        return this.maliciousPackage;
    }

    @Override
    @NotNull
    public Date getCheckTime() {
        return this.checkTime;
    }

    @NotNull
    public final Severity getMaxSeverity() {
        Lazy lazy = this.maxSeverity$delegate;
        return (Severity)lazy.getValue();
    }

    @NotNull
    public final ProblemHighlightType getProblemHighlightType() {
        Lazy lazy = this.problemHighlightType$delegate;
        return (ProblemHighlightType)lazy.getValue();
    }

    @NotNull
    public final MaliciousPackage component1() {
        return this.maliciousPackage;
    }

    @NotNull
    public final Date component2() {
        return this.checkTime;
    }

    @NotNull
    public final Malicious copy(@NotNull MaliciousPackage maliciousPackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)maliciousPackage, (String)"maliciousPackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        return new Malicious(maliciousPackage, checkTime);
    }

    public static /* synthetic */ Malicious copy$default(Malicious malicious, MaliciousPackage maliciousPackage, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            maliciousPackage = malicious.maliciousPackage;
        }
        if ((n & 2) != 0) {
            date = malicious.checkTime;
        }
        return malicious.copy(maliciousPackage, date);
    }

    @NotNull
    public String toString() {
        return "Malicious(maliciousPackage=" + this.maliciousPackage + ", checkTime=" + this.checkTime + ")";
    }

    public int hashCode() {
        int result = this.maliciousPackage.hashCode();
        result = result * 31 + this.checkTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Malicious)) {
            return false;
        }
        Malicious malicious = (Malicious)other;
        if (!Intrinsics.areEqual((Object)this.maliciousPackage, (Object)malicious.maliciousPackage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checkTime, (Object)malicious.checkTime);
    }

    private static final Severity maxSeverity_delegate$lambda$0(Malicious this$0) {
        Iterator iterator = ((Iterable)this$0.maliciousPackage.getVulnerablePackage().getVulnerabilities()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vulnerability it = (Vulnerability)iterator.next();
        boolean bl = false;
        float f = it.getCvssScore();
        while (iterator.hasNext()) {
            Vulnerability it2 = (Vulnerability)iterator.next();
            $i$a$-maxOf-Malicious$maxSeverity$2$maxScore$1 = false;
            float f2 = it2.getCvssScore();
            f = Math.max(f, f2);
        }
        float maxScore = f;
        return SeverityFactory.Companion.fromScore(maxScore);
    }

    private static final ProblemHighlightType problemHighlightType_delegate$lambda$0(Malicious this$0) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this$0.getMaxSeverity().getType().ordinal()]) {
            case 1 -> ProblemHighlightType.WEAK_WARNING;
            case 2 -> ProblemHighlightType.WEAK_WARNING;
            case 3 -> ProblemHighlightType.WARNING;
            case 4 -> ProblemHighlightType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.Type.values().length];
            try {
                nArray[Severity.Type.Low.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Medium.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.High.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Critical.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

