/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.JspFileTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class AbstractTagUtil {
    private static final String HTML_TAG_NAME = "html";
    private static final String HEAD_TAG_NAME = "head";
    private static final String BODY_TAG_NAME = "body";
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private static final String STYLE_TYPE_ATTRIBUTE = "type";
    private static final String CSS_STYLE_TYPE_ATTRIBUTE_VALUE = "text/css";

    @Nullable
    public static XmlTag addCssStyleTag(XmlDocument document, boolean styleCouldBeInsertedInRoot) {
        DocumentWindow window;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag newStyleTag = XmlElementFactory.getInstance((Project)document.getProject()).createTagFromText((CharSequence)"<style></style>");
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        XmlTag result = null;
        if (headTag != null) {
            result = headTag.addSubTag(newStyleTag, false);
        } else if (htmlTag != null) {
            XmlTag newHeadTag = XmlElementFactory.getInstance((Project)document.getProject()).createTagFromText((CharSequence)"<head></head>");
            newHeadTag = htmlTag.addSubTag(newHeadTag, true);
            result = newHeadTag.addSubTag(newStyleTag, true);
        } else if (styleCouldBeInsertedInRoot) {
            result = (XmlTag)document.addBefore((PsiElement)newStyleTag, (PsiElement)rootTag);
        }
        if (result != null && (window = InjectedLanguageUtil.getDocumentWindow((PsiElement)result)) != null && window.isOneLine()) {
            result = (XmlTag)ObjectUtils.tryCast((Object)result.replace((PsiElement)XmlElementFactory.getInstance((Project)document.getProject()).createTagFromText((CharSequence)result.getText().replaceAll("\n", ""))), XmlTag.class);
        }
        return result;
    }

    @Nullable
    public static XmlTag findGenericHtmlTag(@NotNull XmlDocument document) {
        XmlTag rootTag;
        if (document == null) {
            AbstractTagUtil.$$$reportNull$$$0(0);
        }
        if ((rootTag = AbstractTagUtil.getRealRootTag(document)) == null) {
            return null;
        }
        boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
        return AbstractTagUtil.compareTagName(rootTag, HTML_TAG_NAME, caseSensitive) ? rootTag : AbstractTagUtil.findNonRootTag(rootTag, caseSensitive, HTML_TAG_NAME);
    }

    @Nullable
    public static XmlTag findGenericHeadTag(@NotNull XmlDocument document) {
        XmlTag htmlTag;
        if (document == null) {
            AbstractTagUtil.$$$reportNull$$$0(1);
        }
        return AbstractTagUtil.findSubTagWithName((htmlTag = AbstractTagUtil.findGenericHtmlTag(document)) != null ? htmlTag : AbstractTagUtil.getRealRootTag(document), HEAD_TAG_NAME, AbstractTagUtil.isCaseSensitive(document));
    }

    @Nullable
    public static XmlTag findGenericBodyTag(@NotNull XmlDocument document) {
        if (document == null) {
            AbstractTagUtil.$$$reportNull$$$0(2);
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
        if (htmlTag != null) {
            return AbstractTagUtil.findSubTagWithName(htmlTag, BODY_TAG_NAME, caseSensitive);
        }
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        if (rootTag != null) {
            XmlTag bodyTag = AbstractTagUtil.compareTagName(rootTag, BODY_TAG_NAME, caseSensitive) ? rootTag : AbstractTagUtil.findNonRootTag(rootTag, caseSensitive, BODY_TAG_NAME);
            return bodyTag != null ? bodyTag : AbstractTagUtil.findSubTagWithName(rootTag, BODY_TAG_NAME, caseSensitive);
        }
        return null;
    }

    public static boolean isCaseSensitive(FileType fileType) {
        return fileType == XHtmlFileType.INSTANCE || JspFileTypeUtil.isJspX((FileType)fileType);
    }

    @Nullable
    public static XmlTag findStyleTag(@Nullable XmlDocument document) {
        return (XmlTag)ContainerUtil.getFirstItem(AbstractTagUtil.findStyleTags(document), null);
    }

    @NotNull
    public static Collection<XmlTag> findStyleTags(@Nullable XmlDocument document) {
        if (document == null) {
            List<XmlTag> list = Collections.emptyList();
            if (list == null) {
                AbstractTagUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        if (htmlTag != null) {
            ArrayList<XmlTag> styleTags = new ArrayList<XmlTag>(AbstractTagUtil.filterCssStyles(htmlTag.findSubTags("style")));
            XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
            if (headTag != null) {
                styleTags.addAll(AbstractTagUtil.filterCssStyles(headTag.findSubTags("style")));
            }
            ArrayList<XmlTag> arrayList = styleTags;
            if (arrayList == null) {
                AbstractTagUtil.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        if (rootTag != null) {
            boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
            Collection<XmlTag> result = AbstractTagUtil.findTagSiblingsWithName(rootTag, caseSensitive, "style");
            if (!result.isEmpty()) {
                Collection<XmlTag> collection = result;
                if (collection == null) {
                    AbstractTagUtil.$$$reportNull$$$0(5);
                }
                return collection;
            }
            XmlTag[] subTags = rootTag.getSubTags();
            if (subTags.length > 0) {
                Collection<XmlTag> collection = AbstractTagUtil.findTagSiblingsWithName(subTags[0], caseSensitive, "style");
                if (collection == null) {
                    AbstractTagUtil.$$$reportNull$$$0(6);
                }
                return collection;
            }
        }
        List<XmlTag> list = Collections.emptyList();
        if (list == null) {
            AbstractTagUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static XmlTag findInjectionHostTagByCssElement(@NotNull CssElement cssElement) {
        PsiLanguageInjectionHost injectionHost;
        if (cssElement == null) {
            AbstractTagUtil.$$$reportNull$$$0(8);
        }
        return (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)((injectionHost = InjectedLanguageManager.getInstance((Project)cssElement.getProject()).getInjectionHost((PsiElement)cssElement)) instanceof XmlElement ? injectionHost : cssElement), (Class[])new Class[]{XmlTag.class});
    }

    @NotNull
    public static List<String> getPossibleSelectorsForTag(@Nullable XmlTag tag) {
        ArrayList<String> possibleCandidates = new ArrayList<String>(1);
        if (tag != null) {
            XmlAttribute[] attributes = tag.getAttributes();
            String tagName = tag.getName();
            boolean unqualifiedTag = tagName.indexOf(58) == -1;
            for (XmlAttribute attribute : attributes) {
                PsiReference[] references;
                XmlAttributeValue valueElement;
                @NonNls String name = attribute.getName();
                String value = Strings.notNullize((String)attribute.getValue());
                if (name.contains("id")) {
                    possibleCandidates.add("#" + value.trim());
                    if (!unqualifiedTag) continue;
                    possibleCandidates.add(tagName + "#" + value.trim());
                    continue;
                }
                if (!name.contains("class") || (valueElement = attribute.getValueElement()) == null) continue;
                for (PsiReference reference : references = valueElement.getReferences()) {
                    if (!(reference instanceof HtmlCssClassOrIdReference)) continue;
                    String className = reference.getRangeInElement().substring(valueElement.getText());
                    possibleCandidates.add("." + className);
                    if (!unqualifiedTag) continue;
                    possibleCandidates.add(tagName + "." + className);
                }
            }
            if (unqualifiedTag) {
                possibleCandidates.add(tagName);
            }
        }
        ArrayList<String> arrayList = possibleCandidates;
        if (arrayList == null) {
            AbstractTagUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static void addCssLinkToContextFileIfNeeded(@NotNull PsiFile contextFile, @NotNull StylesheetFile targetFile) {
        if (contextFile == null) {
            AbstractTagUtil.$$$reportNull$$$0(10);
        }
        if (targetFile == null) {
            AbstractTagUtil.$$$reportNull$$$0(11);
        }
        if (contextFile instanceof XmlFile && !AbstractTagUtil.fileAlreadyHasLinkToGivenFile((XmlFile)contextFile, targetFile)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!FileModificationService.getInstance().prepareFileForWrite(contextFile)) {
                return;
            }
            Project project = contextFile.getProject();
            XmlTag parentTagForLink = AbstractTagUtil.findParentTagForLink((XmlFile)contextFile);
            if (parentTagForLink != null) {
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
                VirtualFile targetVirtualFile = targetFile.getVirtualFile();
                if (targetVirtualFile != null) {
                    XmlAttributeValue hrefAttributeValue;
                    String relativePath = VfsUtilCore.findRelativePath((VirtualFile)contextFile.getVirtualFile(), (VirtualFile)targetVirtualFile, (char)'/');
                    String path = relativePath != null ? relativePath : targetVirtualFile.getPath();
                    String quote = XmlEditUtil.getAttributeQuote((PsiFile)contextFile);
                    XmlTag linkTag = elementFactory.createTagFromText((CharSequence)("<link rel=" + quote + "stylesheet" + quote + " type=" + quote + CSS_STYLE_TYPE_ATTRIBUTE_VALUE + quote + " href=" + quote + path + quote + "/>"));
                    if ((linkTag = parentTagForLink.addSubTag(linkTag, true)) != null && (hrefAttributeValue = AbstractTagUtil.getHrefAttributeValue(linkTag)) != null) {
                        CssUtil.rebindFileReference((PsiElement)linkTag, (PsiFile)targetFile);
                    }
                }
            }
        }
    }

    private static boolean fileAlreadyHasLinkToGivenFile(@NotNull XmlFile contextFile, @NotNull StylesheetFile fileToLink) {
        if (contextFile == null) {
            AbstractTagUtil.$$$reportNull$$$0(12);
        }
        if (fileToLink == null) {
            AbstractTagUtil.$$$reportNull$$$0(13);
        }
        CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
        resolver.setStrictResolveMode(true);
        Object[] stylesheetFiles = resolver.resolveStyleSheets(contextFile, null);
        return ArrayUtil.contains((Object)fileToLink, (Object[])stylesheetFiles);
    }

    @Nullable
    private static XmlAttributeValue getHrefAttributeValue(@NotNull XmlTag tag) {
        XmlAttribute hrefAttribute;
        if (tag == null) {
            AbstractTagUtil.$$$reportNull$$$0(14);
        }
        return (hrefAttribute = tag.getAttribute(HREF_ATTRIBUTE_NAME)) != null ? hrefAttribute.getValueElement() : null;
    }

    @Nullable
    private static XmlTag findParentTagForLink(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        if (headTag != null) {
            return headTag;
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        if (htmlTag != null) {
            XmlTag newHeadTag = XmlElementFactory.getInstance((Project)file.getProject()).createTagFromText((CharSequence)"<head></head>");
            return htmlTag.addSubTag(newHeadTag, true);
        }
        return null;
    }

    @NotNull
    private static @Unmodifiable Collection<XmlTag> filterCssStyles(XmlTag @NotNull [] styleTags) {
        if (styleTags == null) {
            AbstractTagUtil.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.filter((Object[])styleTags, tag -> {
            String typeAttribute = tag.getAttributeValue(STYLE_TYPE_ATTRIBUTE);
            return typeAttribute == null || CSS_STYLE_TYPE_ATTRIBUTE_VALUE.equalsIgnoreCase(typeAttribute);
        });
        if (list == null) {
            AbstractTagUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    private static XmlTag findSubTagWithName(@Nullable XmlTag parentTag, @NotNull String name, boolean caseSensitive) {
        XmlTag[] subTags;
        if (name == null) {
            AbstractTagUtil.$$$reportNull$$$0(17);
        }
        if (parentTag == null) {
            return null;
        }
        for (XmlTag subTag : subTags = parentTag.getSubTags()) {
            if (!AbstractTagUtil.compareTagName(subTag, name, caseSensitive)) continue;
            return subTag;
        }
        return null;
    }

    private static boolean compareTagName(@NotNull XmlTag tag, @NotNull @NonNls String name, boolean caseSensitive) {
        if (tag == null) {
            AbstractTagUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            AbstractTagUtil.$$$reportNull$$$0(19);
        }
        String tagName = tag.getLocalName();
        return caseSensitive ? name.equals(tagName) : name.equalsIgnoreCase(tagName);
    }

    @Nullable
    private static XmlTag getRealRootTag(@Nullable XmlDocument document) {
        XmlDocument realDocument = HtmlUtil.getRealXmlDocument((XmlDocument)document);
        return realDocument != null ? realDocument.getRootTag() : null;
    }

    @Nullable
    private static XmlTag findNonRootTag(@NotNull XmlTag rootTag, boolean caseSensitive, String tagName) {
        XmlTag subTagWithName;
        if (rootTag == null) {
            AbstractTagUtil.$$$reportNull$$$0(20);
        }
        return (subTagWithName = AbstractTagUtil.findSubTagWithName(rootTag, tagName, caseSensitive)) != null ? subTagWithName : (XmlTag)ContainerUtil.getFirstItem(AbstractTagUtil.findTagSiblingsWithName(rootTag, caseSensitive, tagName), null);
    }

    private static Collection<XmlTag> findTagSiblingsWithName(@NotNull XmlTag xmlTag, boolean caseSensitive, String name) {
        if (xmlTag == null) {
            AbstractTagUtil.$$$reportNull$$$0(21);
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag element = xmlTag; element != null; element = element.getNextSibling()) {
            XmlTag tag;
            if (!(element instanceof XmlTag) || !AbstractTagUtil.compareTagName(tag = element, name, caseSensitive)) continue;
            result.add(tag);
        }
        return result;
    }

    private static boolean isCaseSensitive(XmlDocument document) {
        return AbstractTagUtil.isCaseSensitive(document.getContainingFile().getFileType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 9, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/util/AbstractTagUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssElement";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLink";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleTags";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/util/AbstractTagUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findStyleTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleSelectorsForTag";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCssStyles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGenericHtmlTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findGenericHeadTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGenericBodyTag";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInjectionHostTagByCssElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCssLinkToContextFileIfNeeded";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fileAlreadyHasLinkToGivenFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHrefAttributeValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterCssStyles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSubTagWithName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "compareTagName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNonRootTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findTagSiblingsWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 9, 16 -> new IllegalStateException(string);
        };
    }
}

