/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewDnDWithShelvesSupport;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewDnDSupport;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "canHandleDropEvent", "", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "dropNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "drop", "", "intellij.platform.vcs.impl"})
final class ChangesViewDnDWithShelvesSupport
extends ChangesViewDnDSupport {
    public ChangesViewDnDWithShelvesSupport(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super(tree);
    }

    protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @Nullable ChangesBrowserNode<?> dropNode) {
        Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
        Object attached = aEvent.getAttachedObject();
        return attached instanceof ShelvedChangeListDragBean && (dropNode == null || dropNode instanceof ChangesBrowserChangeListNode) || super.canHandleDropEvent(aEvent, dropNode);
    }

    public void drop(@NotNull DnDEvent aEvent) {
        LocalChangeList localChangeList;
        Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
        Object attached = aEvent.getAttachedObject();
        if (!(attached instanceof ShelvedChangeListDragBean)) {
            super.drop(aEvent);
            return;
        }
        ChangesBrowserNode dropRootNode = ChangesTreeDnDSupport.getDropRootNode((ChangesTree)this.myTree, (DnDEvent)aEvent);
        Project project = this.myTree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (dropRootNode != null) {
            localChangeList = (LocalChangeList)TreeUtil.getUserObject(LocalChangeList.class, (Object)dropRootNode);
        } else {
            List<ShelvedChangeList> list = ((ShelvedChangeListDragBean)attached).getShelvedChangelists();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getShelvedChangelists(...)");
            ShelvedChangeList changeList = (ShelvedChangeList)CollectionsKt.firstOrNull(list);
            Object object = changeList;
            if (object == null || (object = ((ShelvedChangeList)object).getName()) == null) {
                String string = VcsBundle.message((String)"changes.new.changelist", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            Object suggestedName = object;
            String listName = ChangeListUtil.createNameForChangeList(project2, (String)suggestedName);
            localChangeList = ChangeListManager.getInstance((Project)project2).addChangeList(listName, null);
        }
        LocalChangeList targetChangeList = localChangeList;
        ShelveChangesManager.unshelveSilentlyWithDnd(project2, (ShelvedChangeListDragBean)attached, targetChangeList, !ChangesTreeDnDSupport.isCopyAction((DnDEvent)aEvent));
    }
}

