/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import org.jrubyparser.BlockStaticScope;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.VCallNode;

public class LocalStaticScope
extends StaticScope {
    private static final long serialVersionUID = 2204064248888411628L;
    private static final String[] NO_NAMES = new String[0];

    public LocalStaticScope(StaticScope enclosingScope) {
        this(enclosingScope, NO_NAMES);
    }

    public LocalStaticScope(StaticScope enclosingScope, String[] names) {
        super(enclosingScope, names);
        this.setArgumentScope(true);
    }

    public StaticScope getLocalScope() {
        return this;
    }

    public int isDefined(String name, int depth) {
        return depth << 16 | this.exists(name);
    }

    public String[] getAllNamesInScope() {
        return this.getVariables();
    }

    public AssignableNode assign(SourcePosition position, String name, Node value, StaticScope topScope, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalAsgnNode(position, name, depth << 16 | slot, value);
        }
        if (topScope == this) {
            slot = this.addVariable(name);
            return new LocalAsgnNode(position, name, slot, value);
        }
        return ((BlockStaticScope)topScope).addAssign(position, name, value);
    }

    public Node declare(SourcePosition position, String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalVarNode(position, depth << 16 | slot, name);
        }
        return new VCallNode(position, name);
    }

    public String toString() {
        return "LocalScope: " + super.toString();
    }
}

