/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.ui.HorizontalLayoutPanel;
import com.intellij.jpa.jpb.model.ui.VerticalLayoutPanel;
import com.intellij.liquibase.orm.config.LiquibaseChange;
import com.intellij.liquibase.orm.gui.ChangeLogPreviewDialog;
import com.intellij.liquibase.orm.gui.ChangeLogTree;
import com.intellij.liquibase.orm.gui.ChangeModel;
import com.intellij.liquibase.orm.gui.ChooseUnnecessaryChangesDialog;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H&J \u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0004J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0004J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0005H\u0004J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0004J\u0016\u0010(\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/liquibase/orm/gui/AbstractMergePanel;", "Lcom/intellij/jpa/jpb/model/ui/VerticalLayoutPanel;", "dialog", "Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;", "targetNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "<init>", "(Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "getDialog", "()Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;", "getTargetNode", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "tree", "Lcom/intellij/liquibase/orm/gui/ChangeLogTree;", "getTree", "()Lcom/intellij/liquibase/orm/gui/ChangeLogTree;", "changeModelCreator", "Lcom/intellij/liquibase/orm/gui/AbstractMergePanel$ChangeModelCreator;", "getChangeModelCreator", "()Lcom/intellij/liquibase/orm/gui/AbstractMergePanel$ChangeModelCreator;", "setChangeModelCreator", "(Lcom/intellij/liquibase/orm/gui/AbstractMergePanel$ChangeModelCreator;)V", "getDropDownCaption", "", "isCreateChange", "", "updateXmlTag", "", "selectedNode", "replaceDropTag", "addNode", "dropTag", "Lcom/intellij/psi/xml/XmlTag;", "newTagSource", "removeDropAndSelectAdd", "dropNode", "removeNode", "addMergeComponent", "mergeComponent", "Ljava/awt/Component;", "showUnnecessaryDialog", "dependsChanges", "", "ChangeModelCreator", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nAbstractMergePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMergePanel.kt\ncom/intellij/liquibase/orm/gui/AbstractMergePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1915#2,2:85\n*S KotlinDebug\n*F\n+ 1 AbstractMergePanel.kt\ncom/intellij/liquibase/orm/gui/AbstractMergePanel\n*L\n74#1:85,2\n*E\n"})
public abstract class AbstractMergePanel
extends VerticalLayoutPanel {
    @NotNull
    private final ChangeLogPreviewDialog dialog;
    @NotNull
    private final DefaultMutableTreeNode targetNode;
    @NotNull
    private final ChangeLogTree tree;
    @NotNull
    private ChangeModelCreator changeModelCreator;

    public AbstractMergePanel(@NotNull ChangeLogPreviewDialog dialog, @NotNull DefaultMutableTreeNode targetNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog), (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)targetNode, (String)"targetNode");
        super(0, 1, null);
        this.dialog = dialog;
        this.targetNode = targetNode;
        this.tree = this.dialog.getTree();
        this.changeModelCreator = new ChangeModelCreator(){};
    }

    @NotNull
    public final ChangeLogPreviewDialog getDialog() {
        return this.dialog;
    }

    @NotNull
    public final DefaultMutableTreeNode getTargetNode() {
        return this.targetNode;
    }

    @NotNull
    public final ChangeLogTree getTree() {
        return this.tree;
    }

    @NotNull
    public final ChangeModelCreator getChangeModelCreator() {
        return this.changeModelCreator;
    }

    public final void setChangeModelCreator(@NotNull ChangeModelCreator changeModelCreator2) {
        Intrinsics.checkNotNullParameter((Object)changeModelCreator2, (String)"<set-?>");
        this.changeModelCreator = changeModelCreator2;
    }

    @NotNull
    public abstract String getDropDownCaption();

    public abstract boolean isCreateChange();

    public abstract void updateXmlTag(@NotNull DefaultMutableTreeNode var1);

    protected final void replaceDropTag(@NotNull DefaultMutableTreeNode addNode, @NotNull XmlTag dropTag, @NotNull String newTagSource) {
        Intrinsics.checkNotNullParameter((Object)addNode, (String)"addNode");
        Intrinsics.checkNotNullParameter((Object)dropTag, (String)"dropTag");
        Intrinsics.checkNotNullParameter((Object)newTagSource, (String)"newTagSource");
        Project project = this.dialog.getProject();
        XmlElementFactory xmlElementFactory = XmlElementFactory.getInstance((Project)project);
        XmlTag xmlTag = xmlElementFactory.createTagFromText((CharSequence)newTagSource);
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"createTagFromText(...)");
        XmlTag newTag = xmlTag;
        XmlTag replacedNewTag = (XmlTag)WriteCommandAction.runWriteCommandAction((Project)project, () -> AbstractMergePanel.replaceDropTag$lambda$0(dropTag, newTag));
        Intrinsics.checkNotNull((Object)replacedNewTag);
        addNode.setUserObject(this.changeModelCreator.create(replacedNewTag));
    }

    protected final void removeDropAndSelectAdd(@NotNull DefaultMutableTreeNode dropNode, @NotNull DefaultMutableTreeNode addNode) {
        Intrinsics.checkNotNullParameter((Object)dropNode, (String)"dropNode");
        Intrinsics.checkNotNullParameter((Object)addNode, (String)"addNode");
        this.removeNode(dropNode);
        this.tree.setSelectionPath(null);
        TreeUtil.selectNode((JTree)((JTree)((Object)this.tree)), (TreeNode)addNode);
    }

    protected final void removeNode(@NotNull DefaultMutableTreeNode dropNode) {
        Intrinsics.checkNotNullParameter((Object)dropNode, (String)"dropNode");
        TreeNode parentDropColumnNode = dropNode.getParent();
        this.tree.getMyTreeModel().removeNodeFromParent(dropNode);
        if (parentDropColumnNode instanceof MutableTreeNode && ((MutableTreeNode)parentDropColumnNode).getChildCount() == 0) {
            this.tree.getMyTreeModel().removeNodeFromParent((MutableTreeNode)parentDropColumnNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void addMergeComponent(@NotNull Component mergeComponent) {
        void $this$addMergeComponent_u24lambda_u240_u240;
        void $this$addMergeComponent_u24lambda_u240;
        JBLabel jBLabel;
        HorizontalLayoutPanel horizontalLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)mergeComponent, (String)"mergeComponent");
        HorizontalLayoutPanel horizontalLayoutPanel2 = horizontalLayoutPanel = new HorizontalLayoutPanel(6);
        AbstractMergePanel abstractMergePanel = this;
        boolean bl = false;
        JBLabel jBLabel2 = jBLabel = new JBLabel();
        void var7_8 = $this$addMergeComponent_u24lambda_u240;
        boolean bl2 = false;
        $this$addMergeComponent_u24lambda_u240_u240.setIcon(AllIcons.Actions.IntentionBulb);
        var7_8.add((Component)jBLabel);
        $this$addMergeComponent_u24lambda_u240.add(mergeComponent);
        abstractMergePanel.add((Component)horizontalLayoutPanel);
    }

    protected final void showUnnecessaryDialog(@NotNull List<? extends DefaultMutableTreeNode> dependsChanges) {
        Intrinsics.checkNotNullParameter(dependsChanges, (String)"dependsChanges");
        if (dependsChanges.isEmpty()) {
            return;
        }
        ChooseUnnecessaryChangesDialog chooseChangeNodesDialog = new ChooseUnnecessaryChangesDialog(this.dialog.getProject(), dependsChanges);
        if (chooseChangeNodesDialog.showAndGet()) {
            Iterable $this$forEach$iv = chooseChangeNodesDialog.getUnnecessaryChangeNodes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                this.removeNode(it);
            }
        }
    }

    private static final XmlTag replaceDropTag$lambda$0(XmlTag $dropTag, XmlTag $newTag) {
        PsiElement psiElement = $dropTag.replace((PsiElement)$newTag);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
        return (XmlTag)psiElement;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/orm/gui/AbstractMergePanel$ChangeModelCreator;", "", "<init>", "()V", "create", "Lcom/intellij/liquibase/orm/gui/ChangeModel;", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "intellij.liquibase.orm"})
    public static abstract class ChangeModelCreator {
        @NotNull
        public ChangeModel create(@NotNull XmlTag xmlTag) {
            Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"xmlTag");
            return new ChangeModel(xmlTag, LiquibaseChange.DangerLevel.SAFE);
        }
    }
}

