/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.liquibase.orm.LiquibaseModelObjectFactory;
import com.intellij.liquibase.orm.config.DatabaseMigrationConfig;
import com.intellij.liquibase.orm.ddl.LiquibaseGenerator;
import com.intellij.liquibase.orm.ddl.model.JForeignKey;
import com.intellij.liquibase.orm.ddl.model.JTable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.RandomStringUtils;

public class ForeignKeySnapshotGenerator
extends IntellijSnapshotGenerator {
    public ForeignKeySnapshotGenerator() {
        super(ForeignKey.class, new Class[]{Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        List<JForeignKey> foreignKeys;
        if (!snapshot.getSnapshotControl().shouldInclude(ForeignKey.class)) {
            return;
        }
        if (!(foundObject instanceof Table)) {
            return;
        }
        Table table = (Table)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        OrmEntity entity = this.findOrmEntity(foundObject, snapshot);
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        if (entity == null) {
            foreignKeys = ForeignKeySnapshotGenerator.generateForeignKeysByTableName(liquibaseGenerator, database, table.getName());
            if (foreignKeys.isEmpty()) {
                return;
            }
        } else {
            foreignKeys = liquibaseGenerator.generateForeignKeysConstraints(entity);
        }
        Project project = database.getProject();
        for (JForeignKey foreignKey : foreignKeys) {
            ForeignKey fk = new ForeignKey();
            fk.setName(ForeignKeySnapshotGenerator.makeUniqueFkName(project, table.getSchema(), foreignKey.getName()));
            JTable jPrimaryKeyTable = foreignKey.getPrimaryKeyTable();
            Table primaryKeyTable = null;
            for (Table otherTables : table.getSchema().getDatabaseObjects(Table.class)) {
                if (!otherTables.getName().equals(jPrimaryKeyTable.getName())) continue;
                primaryKeyTable = otherTables;
                break;
            }
            if (primaryKeyTable == null) {
                primaryKeyTable = dbObjectFactory.createTable(jPrimaryKeyTable.getName());
                primaryKeyTable.setSchema(jPrimaryKeyTable.getCatalog(), jPrimaryKeyTable.getSchema());
            }
            fk.setPrimaryKeyTable(primaryKeyTable);
            fk.setForeignKeyTable(table);
            foreignKey.getForeignKeyColumns().forEach(s -> {
                if (s == null) {
                    throw new IllegalArgumentException("Foreign key column is null, fkname = " + fk.getName() + "; pktable = " + table.getName() + "; fktable = " + table.getName());
                }
                fk.addForeignKeyColumn(dbObjectFactory.createColumn((String)s));
            });
            foreignKey.getPrimaryKeyColumns().forEach(s -> fk.addPrimaryKeyColumn(dbObjectFactory.createColumn((String)s)));
            if (foreignKey.getOnDeleteAction() != null && foreignKey.getOnDeleteAction() != ForeignKeyConstraintType.importedKeyNoAction) {
                fk.setDeleteRule(foreignKey.getOnDeleteAction());
            }
            table.getOutgoingForeignKeys().add(fk);
            table.getSchema().addDatabaseObject((DatabaseObject)fk);
        }
    }

    private static String makeUniqueFkName(Project project, Schema schema, String fkName) {
        List existsFks = schema.getDatabaseObjects(ForeignKey.class);
        if (existsFks.stream().noneMatch(foreignKey -> StringUtil.equalsIgnoreCase((CharSequence)foreignKey.getName(), (CharSequence)fkName))) {
            return fkName;
        }
        Integer maxIdentifierLength = DatabaseMigrationConfig.getInstance(project).getState().getMaxIdentifierLength();
        if (maxIdentifierLength == null || maxIdentifierLength == -1) {
            return fkName;
        }
        int maxLength = maxIdentifierLength - 6;
        String shortFkName = fkName.substring(0, Math.min(maxLength, fkName.length()));
        String randomStr = RandomStringUtils.randomAlphanumeric((int)6);
        return shortFkName + randomStr;
    }

    private static List<JForeignKey> generateForeignKeysByTableName(LiquibaseGenerator liquibaseGenerator, IntellijDatabase database, String tableName) {
        JoinTableAttribute joinTableAttribute = liquibaseGenerator.findJoinTableAttribute(tableName, database.getOrmEntitiesToProcess());
        if (joinTableAttribute != null) {
            return liquibaseGenerator.generateJoinTableConstraints(joinTableAttribute.getEntity(), joinTableAttribute.getAttribute());
        }
        CollectionTableAttribute collectionTableAttribute = liquibaseGenerator.findCollectionTableAttribute(tableName, database.getOrmEntitiesToProcess());
        if (collectionTableAttribute != null) {
            return liquibaseGenerator.generateCollectionTableConstraints(collectionTableAttribute.getEntity(), collectionTableAttribute.getAttribute());
        }
        return Collections.emptyList();
    }
}

